/*     */ package org.quartz.impl.jdbcjobstore;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Date;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.quartz.Calendar;
/*     */ import org.quartz.CronTrigger;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.SimpleTrigger;
/*     */ import org.quartz.Trigger;
/*     */ import org.quartz.utils.Key;
/*     */ 
/*     */ public class DB2v8Delegate extends StdJDBCDelegate
/*     */ {
/*     */   public DB2v8Delegate(Log logger, String tablePrefix, String instanceId)
/*     */   {
/*  47 */     super(logger, tablePrefix, instanceId);
/*     */   }
/*     */ 
/*     */   public DB2v8Delegate(Log log, String tablePrefix, String instanceId, Boolean useProperties)
/*     */   {
/*  52 */     super(log, tablePrefix, instanceId, useProperties);
/*     */   }
/*     */ 
/*     */   public Trigger[] selectTriggersForRecoveringJobs(Connection conn) throws SQLException, IOException, ClassNotFoundException
/*     */   {
/*  57 */     PreparedStatement ps = null;
/*  58 */     ResultSet rs = null;
/*     */     try
/*     */     {
/*  61 */       ps = conn.prepareStatement(rtp("SELECT * FROM {0}FIRED_TRIGGERS WHERE INSTANCE_NAME = ? AND REQUESTS_RECOVERY = ?"));
/*     */ 
/*  63 */       ps.setString(1, this.instanceId);
/*  64 */       ps.setInt(2, 1);
/*     */ 
/*  66 */       rs = ps.executeQuery();
/*     */ 
/*  68 */       long dumId = System.currentTimeMillis();
/*  69 */       ArrayList list = new ArrayList();
/*  70 */       while (rs.next()) {
/*  71 */         String jobName = rs.getString("JOB_NAME");
/*  72 */         String jobGroup = rs.getString("JOB_GROUP");
/*  73 */         trigName = rs.getString("TRIGGER_NAME");
/*  74 */         String trigGroup = rs.getString("TRIGGER_GROUP");
/*  75 */         long firedTime = rs.getLong("FIRED_TIME");
/*  76 */         SimpleTrigger rcvryTrig = new SimpleTrigger("recover_" + this.instanceId + "_" + String.valueOf(dumId++), "RECOVERING_JOBS", new Date(firedTime));
/*     */ 
/*  79 */         rcvryTrig.setJobName(jobName);
/*  80 */         rcvryTrig.setJobGroup(jobGroup);
/*  81 */         rcvryTrig.setMisfireInstruction(1);
/*     */ 
/*  84 */         JobDataMap jd = selectTriggerJobDataMap(conn, trigName, trigGroup);
/*  85 */         jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME", trigName);
/*  86 */         jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP", trigGroup);
/*  87 */         jd.put("QRTZ_FAILED_JOB_ORIG_TRIGGER_FIRETIME_IN_MILLISECONDS_AS_STRING", String.valueOf(firedTime));
/*  88 */         rcvryTrig.setJobDataMap(jd);
/*     */ 
/*  90 */         list.add(rcvryTrig);
/*     */       }
/*  92 */       Object[] oArr = list.toArray();
/*  93 */       Trigger[] tArr = new Trigger[oArr.length];
/*  94 */       System.arraycopy(oArr, 0, tArr, 0, oArr.length);
/*  95 */       trigName = tArr;
/*     */     }
/*     */     finally
/*     */     {
/*     */       String trigName;
/*  97 */       if (null != rs)
/*     */         try {
/*  99 */           rs.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/* 103 */       if (null != ps)
/*     */         try {
/* 105 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int insertJobDetail(Connection conn, JobDetail job) throws IOException, SQLException {
/* 114 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/*     */ 
/* 116 */     PreparedStatement ps = null;
/*     */ 
/* 118 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 122 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}JOB_DETAILS (JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 123 */       ps.setString(1, job.getName());
/* 124 */       ps.setString(2, job.getGroup());
/* 125 */       ps.setString(3, job.getDescription());
/* 126 */       ps.setString(4, job.getJobClass().getName());
/* 127 */       ps.setInt(5, toBooleanInt(job.isDurable()));
/* 128 */       ps.setInt(6, toBooleanInt(job.isVolatile()));
/* 129 */       ps.setInt(7, toBooleanInt(job.isStateful()));
/* 130 */       ps.setInt(8, toBooleanInt(job.requestsRecovery()));
/*     */ 
/* 135 */       ps.setBytes(9, baos.toByteArray());
/*     */ 
/* 138 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 140 */       if (null != ps)
/*     */         try {
/* 142 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 148 */     if (insertResult > 0) {
/* 149 */       String[] jobListeners = job.getJobListenerNames();
/* 150 */       for (int i = 0; (jobListeners != null) && (i < jobListeners.length); i++) {
/* 151 */         insertJobListener(conn, job, jobListeners[i]);
/*     */       }
/*     */     }
/* 154 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int updateJobDetail(Connection conn, JobDetail job) throws IOException, SQLException
/*     */   {
/* 159 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/*     */ 
/* 161 */     PreparedStatement ps = null;
/*     */ 
/* 163 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 166 */       ps = conn.prepareStatement(rtp("UPDATE {0}JOB_DETAILS SET DESCRIPTION = ?, JOB_CLASS_NAME = ?, IS_DURABLE = ?, IS_VOLATILE = ?, IS_STATEFUL = ?, REQUESTS_RECOVERY = ?, JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 167 */       ps.setString(1, job.getDescription());
/* 168 */       ps.setString(2, job.getJobClass().getName());
/* 169 */       ps.setInt(3, toBooleanInt(job.isDurable()));
/* 170 */       ps.setInt(4, toBooleanInt(job.isVolatile()));
/* 171 */       ps.setInt(5, toBooleanInt(job.isStateful()));
/* 172 */       ps.setInt(6, toBooleanInt(job.requestsRecovery()));
/*     */ 
/* 177 */       ps.setBytes(7, baos.toByteArray());
/*     */ 
/* 179 */       ps.setString(8, job.getName());
/* 180 */       ps.setString(9, job.getGroup());
/*     */ 
/* 182 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 184 */       if (null != ps)
/*     */         try {
/* 186 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 192 */     if (insertResult > 0) {
/* 193 */       deleteJobListeners(conn, job.getName(), job.getGroup());
/*     */ 
/* 195 */       String[] jobListeners = job.getJobListenerNames();
/* 196 */       for (int i = 0; (jobListeners != null) && (i < jobListeners.length); i++) {
/* 197 */         insertJobListener(conn, job, jobListeners[i]);
/*     */       }
/*     */     }
/* 200 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int insertTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException
/*     */   {
/* 205 */     ByteArrayOutputStream baos = serializeJobData(trigger.getJobDataMap());
/*     */ 
/* 207 */     PreparedStatement ps = null;
/*     */ 
/* 209 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 212 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, IS_VOLATILE, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 213 */       ps.setString(1, trigger.getName());
/* 214 */       ps.setString(2, trigger.getGroup());
/* 215 */       ps.setString(3, trigger.getJobName());
/* 216 */       ps.setString(4, trigger.getJobGroup());
/* 217 */       ps.setInt(5, toBooleanInt(trigger.isVolatile()));
/*     */ 
/* 219 */       ps.setString(6, trigger.getDescription());
/* 220 */       ps.setBigDecimal(7, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
/*     */ 
/* 222 */       long prevFireTime = -1L;
/* 223 */       if (trigger.getPreviousFireTime() != null) {
/* 224 */         prevFireTime = trigger.getPreviousFireTime().getTime();
/*     */       }
/* 226 */       ps.setBigDecimal(8, new BigDecimal(String.valueOf(prevFireTime)));
/* 227 */       ps.setString(9, state);
/* 228 */       if ((trigger instanceof SimpleTrigger))
/* 229 */         ps.setString(10, "SIMPLE");
/* 230 */       else if ((trigger instanceof CronTrigger))
/* 231 */         ps.setString(10, "CRON");
/*     */       else {
/* 233 */         ps.setString(10, "BLOB");
/*     */       }
/* 235 */       ps.setBigDecimal(11, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
/*     */ 
/* 237 */       long endTime = 0L;
/* 238 */       if (trigger.getEndTime() != null) {
/* 239 */         endTime = trigger.getEndTime().getTime();
/*     */       }
/* 241 */       ps.setBigDecimal(12, new BigDecimal(String.valueOf(endTime)));
/* 242 */       ps.setString(13, trigger.getCalendarName());
/* 243 */       ps.setInt(14, trigger.getMisfireInstruction());
/* 244 */       ps.setBytes(15, baos.toByteArray());
/*     */ 
/* 246 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 248 */       if (null != ps)
/*     */         try {
/* 250 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 256 */     if (insertResult > 0) {
/* 257 */       String[] trigListeners = trigger.getTriggerListenerNames();
/* 258 */       for (int i = 0; (trigListeners != null) && (i < trigListeners.length); i++) {
/* 259 */         insertTriggerListener(conn, trigger, trigListeners[i]);
/*     */       }
/*     */     }
/* 262 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int updateTrigger(Connection conn, Trigger trigger, String state, JobDetail jobDetail) throws SQLException, IOException
/*     */   {
/* 267 */     ByteArrayOutputStream baos = serializeJobData(trigger.getJobDataMap());
/*     */ 
/* 269 */     PreparedStatement ps = null;
/*     */ 
/* 271 */     int insertResult = 0;
/*     */     try
/*     */     {
/* 274 */       ps = conn.prepareStatement(rtp("UPDATE {0}TRIGGERS SET JOB_NAME = ?, JOB_GROUP = ?, IS_VOLATILE = ?, DESCRIPTION = ?, NEXT_FIRE_TIME = ?, PREV_FIRE_TIME = ?, TRIGGER_STATE = ?, TRIGGER_TYPE = ?, START_TIME = ?, END_TIME = ?, CALENDAR_NAME = ?, MISFIRE_INSTR = ?, JOB_DATA = ? WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?"));
/* 275 */       ps.setString(1, trigger.getJobName());
/* 276 */       ps.setString(2, trigger.getJobGroup());
/* 277 */       ps.setInt(3, toBooleanInt(trigger.isVolatile()));
/*     */ 
/* 279 */       ps.setString(4, trigger.getDescription());
/* 280 */       long nextFireTime = -1L;
/* 281 */       if (trigger.getNextFireTime() != null) {
/* 282 */         nextFireTime = trigger.getNextFireTime().getTime();
/*     */       }
/* 284 */       ps.setBigDecimal(5, new BigDecimal(String.valueOf(nextFireTime)));
/* 285 */       long prevFireTime = -1L;
/* 286 */       if (trigger.getPreviousFireTime() != null) {
/* 287 */         prevFireTime = trigger.getPreviousFireTime().getTime();
/*     */       }
/* 289 */       ps.setBigDecimal(6, new BigDecimal(String.valueOf(prevFireTime)));
/* 290 */       ps.setString(7, state);
/* 291 */       if ((trigger instanceof SimpleTrigger))
/*     */       {
/* 293 */         ps.setString(8, "SIMPLE");
/* 294 */       } else if ((trigger instanceof CronTrigger))
/*     */       {
/* 296 */         ps.setString(8, "CRON");
/*     */       }
/*     */       else {
/* 299 */         ps.setString(8, "BLOB");
/*     */       }
/* 301 */       ps.setBigDecimal(9, new BigDecimal(String.valueOf(trigger.getStartTime().getTime())));
/*     */ 
/* 303 */       long endTime = 0L;
/* 304 */       if (trigger.getEndTime() != null) {
/* 305 */         endTime = trigger.getEndTime().getTime();
/*     */       }
/* 307 */       ps.setBigDecimal(10, new BigDecimal(String.valueOf(endTime)));
/* 308 */       ps.setString(11, trigger.getCalendarName());
/* 309 */       ps.setInt(12, trigger.getMisfireInstruction());
/* 310 */       ps.setBytes(13, baos.toByteArray());
/* 311 */       ps.setString(14, trigger.getName());
/* 312 */       ps.setString(15, trigger.getGroup());
/*     */ 
/* 314 */       insertResult = ps.executeUpdate();
/*     */     } finally {
/* 316 */       if (null != ps)
/*     */         try {
/* 318 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/* 324 */     if (insertResult > 0) {
/* 325 */       deleteTriggerListeners(conn, trigger.getName(), trigger.getGroup());
/*     */ 
/* 327 */       String[] trigListeners = trigger.getTriggerListenerNames();
/* 328 */       for (int i = 0; (trigListeners != null) && (i < trigListeners.length); i++) {
/* 329 */         insertTriggerListener(conn, trigger, trigListeners[i]);
/*     */       }
/*     */     }
/* 332 */     return insertResult;
/*     */   }
/*     */ 
/*     */   public int insertFiredTrigger(Connection conn, Trigger trigger, String state, JobDetail job) throws SQLException
/*     */   {
/* 337 */     PreparedStatement ps = null;
/*     */     try {
/* 339 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}FIRED_TRIGGERS (ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, IS_VOLATILE, INSTANCE_NAME, FIRED_TIME, STATE, JOB_NAME, JOB_GROUP, IS_STATEFUL, REQUESTS_RECOVERY) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"));
/* 340 */       ps.setString(1, trigger.getFireInstanceId());
/* 341 */       ps.setString(2, trigger.getName());
/* 342 */       ps.setString(3, trigger.getGroup());
/* 343 */       ps.setInt(4, toBooleanInt(trigger.isVolatile()));
/*     */ 
/* 345 */       ps.setString(5, this.instanceId);
/* 346 */       ps.setBigDecimal(6, new BigDecimal(String.valueOf(trigger.getNextFireTime().getTime())));
/*     */ 
/* 348 */       ps.setString(7, state);
/* 349 */       if (job != null) {
/* 350 */         ps.setString(8, trigger.getJobName());
/* 351 */         ps.setString(9, trigger.getJobGroup());
/* 352 */         ps.setInt(10, toBooleanInt(job.isStateful()));
/* 353 */         ps.setInt(11, toBooleanInt(job.requestsRecovery()));
/*     */       }
/*     */       else
/*     */       {
/* 357 */         ps.setString(8, null);
/* 358 */         ps.setString(9, null);
/* 359 */         ps.setInt(10, 0);
/* 360 */         ps.setInt(11, 0);
/*     */       }
/*     */ 
/* 365 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 367 */       if (null != ps)
/*     */         try {
/* 369 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int updateJobData(Connection conn, JobDetail job) throws IOException, SQLException {
/* 378 */     ByteArrayOutputStream baos = serializeJobData(job.getJobDataMap());
/*     */ 
/* 380 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 383 */       ps = conn.prepareStatement(rtp("UPDATE {0}JOB_DETAILS SET JOB_DATA = ?  WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/* 384 */       ps.setBytes(1, baos.toByteArray());
/*     */ 
/* 386 */       ps.setString(2, job.getName());
/* 387 */       ps.setString(3, job.getGroup());
/*     */ 
/* 389 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 391 */       if (null != ps)
/*     */         try {
/* 393 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int insertCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
/* 402 */     ByteArrayOutputStream baos = serializeObject(calendar);
/*     */ 
/* 404 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 407 */       ps = conn.prepareStatement(rtp("INSERT INTO {0}CALENDARS (CALENDAR_NAME, CALENDAR)  VALUES(?, ?)"));
/* 408 */       ps.setString(1, calendarName);
/* 409 */       ps.setBytes(2, baos.toByteArray());
/*     */ 
/* 412 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 414 */       if (null != ps)
/*     */         try {
/* 416 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int updateCalendar(Connection conn, String calendarName, Calendar calendar) throws IOException, SQLException {
/* 425 */     ByteArrayOutputStream baos = serializeObject(calendar);
/*     */ 
/* 427 */     PreparedStatement ps = null;
/*     */     try
/*     */     {
/* 430 */       ps = conn.prepareStatement(rtp("UPDATE {0}CALENDARS SET CALENDAR = ?  WHERE CALENDAR_NAME = ?"));
/* 431 */       ps.setBytes(1, baos.toByteArray());
/* 432 */       ps.setString(2, calendarName);
/*     */ 
/* 435 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 437 */       if (null != ps)
/*     */         try {
/* 439 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int deleteVolatileFiredTriggers(Connection conn) throws SQLException {
/* 447 */     PreparedStatement ps = null;
/*     */     try {
/* 449 */       ps = conn.prepareStatement(rtp("DELETE FROM {0}FIRED_TRIGGERS WHERE IS_VOLATILE = ?"));
/* 450 */       ps.setInt(1, 1);
/*     */ 
/* 453 */       i = ps.executeUpdate();
/*     */     }
/*     */     finally
/*     */     {
/*     */       int i;
/* 455 */       if (null != ps)
/*     */         try {
/* 457 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Key[] selectVolatileTriggers(Connection conn) throws SQLException {
/* 465 */     PreparedStatement ps = null;
/* 466 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 469 */       ps = conn.prepareStatement(rtp("SELECT TRIGGER_NAME, TRIGGER_GROUP FROM {0}TRIGGERS WHERE IS_VOLATILE = ?"));
/* 470 */       ps.setInt(1, 1);
/*     */ 
/* 472 */       rs = ps.executeQuery();
/*     */ 
/* 474 */       ArrayList list = new ArrayList();
/* 475 */       while (rs.next()) {
/* 476 */         String triggerName = rs.getString("TRIGGER_NAME");
/* 477 */         String groupName = rs.getString("TRIGGER_GROUP");
/* 478 */         list.add(new Key(triggerName, groupName));
/*     */       }
/* 480 */       Object[] oArr = list.toArray();
/* 481 */       Key[] kArr = new Key[oArr.length];
/* 482 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/* 483 */       arrayOfKey1 = kArr;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Key[] arrayOfKey1;
/* 485 */       if (null != rs)
/*     */         try {
/* 487 */           rs.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/* 491 */       if (null != ps)
/*     */         try {
/* 493 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public Key[] selectVolatileJobs(Connection conn) throws SQLException {
/* 501 */     PreparedStatement ps = null;
/* 502 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 505 */       ps = conn.prepareStatement(rtp("SELECT JOB_NAME, JOB_GROUP FROM {0}JOB_DETAILS WHERE IS_VOLATILE = ?"));
/* 506 */       ps.setInt(1, 1);
/*     */ 
/* 508 */       rs = ps.executeQuery();
/*     */ 
/* 510 */       ArrayList list = new ArrayList();
/* 511 */       while (rs.next()) {
/* 512 */         String triggerName = rs.getString("JOB_NAME");
/* 513 */         String groupName = rs.getString("JOB_GROUP");
/* 514 */         list.add(new Key(triggerName, groupName));
/*     */       }
/* 516 */       Object[] oArr = list.toArray();
/* 517 */       Key[] kArr = new Key[oArr.length];
/* 518 */       System.arraycopy(oArr, 0, kArr, 0, oArr.length);
/* 519 */       arrayOfKey1 = kArr;
/*     */     }
/*     */     finally
/*     */     {
/*     */       Key[] arrayOfKey1;
/* 521 */       if (null != rs)
/*     */         try {
/* 523 */           rs.close();
/*     */         }
/*     */         catch (SQLException ignore) {
/*     */         }
/* 527 */       if (null != ps)
/*     */         try {
/* 529 */           ps.close();
/*     */         }
/*     */         catch (SQLException ignore)
/*     */         {
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static int toBooleanInt(boolean theBoolean)
/*     */   {
/* 545 */     if (String.valueOf(theBoolean).equals("true")) {
/* 546 */       return 1;
/*     */     }
/* 548 */     return 0;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.DB2v8Delegate
 * JD-Core Version:    0.6.0
 */