/*     */ package org.quartz.impl.jdbcjobstore;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import org.apache.commons.logging.Log;
/*     */ 
/*     */ public class DB2v6Delegate extends StdJDBCDelegate
/*     */ {
/*     */   public static final String SELECT_NUM_JOBS = "SELECT COUNT(*) FROM {0}JOB_DETAILS";
/*     */   public static final String SELECT_NUM_TRIGGERS_FOR_JOB = "SELECT COUNT(*) FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?";
/*     */   public static final String SELECT_NUM_TRIGGERS = "SELECT COUNT(*) FROM {0}TRIGGERS";
/*     */   public static final String SELECT_NUM_CALENDARS = "SELECT COUNT(*) FROM {0}CALENDARS";
/*     */ 
/*     */   public DB2v6Delegate(Log logger, String tablePrefix, String instanceId)
/*     */   {
/*  56 */     super(logger, tablePrefix, instanceId);
/*     */   }
/*     */ 
/*     */   public DB2v6Delegate(Log logger, String tablePrefix, String instanceId, Boolean useProperties)
/*     */   {
/*  61 */     super(logger, tablePrefix, instanceId, useProperties);
/*     */   }
/*     */ 
/*     */   public int selectNumJobs(Connection conn) throws SQLException {
/*  65 */     PreparedStatement ps = null;
/*  66 */     ResultSet rs = null;
/*     */     try
/*     */     {
/*  69 */       int count = 0;
/*  70 */       ps = conn.prepareStatement(rtp("SELECT COUNT(*) FROM {0}JOB_DETAILS"));
/*  71 */       rs = ps.executeQuery();
/*     */ 
/*  73 */       if (rs.next()) {
/*  74 */         count = rs.getInt(1);
/*     */       }
/*     */ 
/*  77 */       int i = count;
/*     */       return i; } finally { close(ps); } throw localObject;
/*     */   }
/*     */ 
/*     */   public int selectNumTriggersForJob(Connection conn, String jobName, String groupName)
/*     */     throws SQLException
/*     */   {
/*  85 */     PreparedStatement ps = null;
/*  86 */     ResultSet rs = null;
/*     */     try
/*     */     {
/*  89 */       ps = conn.prepareStatement(rtp("SELECT COUNT(*) FROM {0}TRIGGERS WHERE JOB_NAME = ? AND JOB_GROUP = ?"));
/*  90 */       ps.setString(1, jobName);
/*  91 */       ps.setString(2, groupName);
/*  92 */       rs = ps.executeQuery();
/*     */ 
/*  94 */       if (rs.next()) {
/*  95 */         i = rs.getInt(1);
/*     */         return i;
/*     */       }
/*  97 */       int i = 0;
/*     */       return i; } finally { close(ps); } throw localObject;
/*     */   }
/*     */ 
/*     */   public int selectNumTriggers(Connection conn) throws SQLException
/*     */   {
/* 105 */     PreparedStatement ps = null;
/* 106 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 109 */       int count = 0;
/* 110 */       ps = conn.prepareStatement(rtp("SELECT COUNT(*) FROM {0}TRIGGERS"));
/* 111 */       rs = ps.executeQuery();
/*     */ 
/* 113 */       if (rs.next()) {
/* 114 */         count = rs.getInt(1);
/*     */       }
/*     */ 
/* 117 */       int i = count;
/*     */       return i; } finally { close(ps); } throw localObject;
/*     */   }
/*     */ 
/*     */   public int selectNumCalendars(Connection conn) throws SQLException
/*     */   {
/* 124 */     PreparedStatement ps = null;
/* 125 */     ResultSet rs = null;
/*     */     try
/*     */     {
/* 128 */       int count = 0;
/* 129 */       ps = conn.prepareStatement(rtp("SELECT COUNT(*) FROM {0}CALENDARS"));
/* 130 */       rs = ps.executeQuery();
/*     */ 
/* 132 */       if (rs.next()) {
/* 133 */         count = rs.getInt(1);
/*     */       }
/*     */ 
/* 136 */       int i = count;
/*     */       return i; } finally { close(ps); } throw localObject;
/*     */   }
/*     */ 
/*     */   private void close(Statement stmt)
/*     */   {
/* 143 */     if (stmt != null)
/*     */       try {
/* 145 */         stmt.close();
/*     */       }
/*     */       catch (SQLException ignore)
/*     */       {
/*     */       }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.DB2v6Delegate
 * JD-Core Version:    0.6.0
 */