/*     */ package org.quartz.impl.calendar;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Date;
/*     */ 
/*     */ public class MonthlyCalendar extends BaseCalendar
/*     */   implements org.quartz.Calendar, Serializable
/*     */ {
/*  47 */   private boolean[] excludeDays = new boolean[31];
/*     */ 
/*  50 */   private boolean excludeAll = false;
/*     */ 
/*     */   public MonthlyCalendar()
/*     */   {
/*  59 */     init();
/*     */   }
/*     */ 
/*     */   public MonthlyCalendar(org.quartz.Calendar baseCalendar)
/*     */   {
/*  68 */     super(baseCalendar);
/*  69 */     init();
/*     */   }
/*     */ 
/*     */   private void init()
/*     */   {
/*  79 */     this.excludeAll = areAllDaysExcluded();
/*     */   }
/*     */ 
/*     */   public boolean[] getDaysExcluded()
/*     */   {
/*  88 */     return this.excludeDays;
/*     */   }
/*     */ 
/*     */   public boolean isDayExcluded(int day)
/*     */   {
/*  97 */     return this.excludeDays[(day - 1)];
/*     */   }
/*     */ 
/*     */   public void setDaysExcluded(boolean[] days)
/*     */   {
/* 107 */     if (days == null) return;
/*     */ 
/* 109 */     this.excludeDays = days;
/* 110 */     this.excludeAll = areAllDaysExcluded();
/*     */   }
/*     */ 
/*     */   public void setDayExcluded(int day, boolean exclude)
/*     */   {
/* 120 */     this.excludeDays[day] = exclude;
/* 121 */     this.excludeAll = areAllDaysExcluded();
/*     */   }
/*     */ 
/*     */   public boolean areAllDaysExcluded()
/*     */   {
/* 132 */     for (int i = 1; i <= 31; i++) {
/* 133 */       if (!isDayExcluded(i)) return false;
/*     */     }
/*     */ 
/* 136 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isTimeIncluded(long timeStamp)
/*     */   {
/* 150 */     if (this.excludeAll == true) return false;
/*     */ 
/* 154 */     if (!super.isTimeIncluded(timeStamp)) return false;
/*     */ 
/* 156 */     java.util.Calendar cl = java.util.Calendar.getInstance();
/* 157 */     cl.setTime(new Date(timeStamp));
/* 158 */     int day = cl.get(5);
/*     */ 
/* 160 */     return !isDayExcluded(day);
/*     */   }
/*     */ 
/*     */   public long getNextIncludedTime(long timeStamp)
/*     */   {
/* 175 */     if (this.excludeAll == true) return 0L;
/*     */ 
/* 178 */     long baseTime = super.getNextIncludedTime(timeStamp);
/* 179 */     if ((baseTime > 0L) && (baseTime > timeStamp)) timeStamp = baseTime;
/*     */ 
/* 182 */     long newTimeStamp = buildHoliday(timeStamp);
/*     */ 
/* 184 */     java.util.Calendar cl = getJavaCalendar(newTimeStamp);
/* 185 */     int day = cl.get(5);
/*     */ 
/* 187 */     if (!isDayExcluded(day)) return timeStamp;
/*     */ 
/* 189 */     while (isDayExcluded(day) == true) {
/* 190 */       cl.add(5, 1);
/* 191 */       day = cl.get(7);
/*     */     }
/*     */ 
/* 194 */     return cl.getTime().getTime();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.calendar.MonthlyCalendar
 * JD-Core Version:    0.6.0
 */