/*      */ package org.quartz.impl;
/*      */ 
/*      */ import java.beans.BeanInfo;
/*      */ import java.beans.IntrospectionException;
/*      */ import java.beans.Introspector;
/*      */ import java.beans.PropertyDescriptor;
/*      */ import java.io.BufferedInputStream;
/*      */ import java.io.File;
/*      */ import java.io.FileInputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.lang.reflect.Method;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Collection;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Iterator;
/*      */ import java.util.Locale;
/*      */ import java.util.Properties;
/*      */ import java.util.Set;
/*      */ import org.apache.commons.logging.Log;
/*      */ import org.apache.commons.logging.LogFactory;
/*      */ import org.quartz.JobListener;
/*      */ import org.quartz.Scheduler;
/*      */ import org.quartz.SchedulerConfigException;
/*      */ import org.quartz.SchedulerContext;
/*      */ import org.quartz.SchedulerException;
/*      */ import org.quartz.SchedulerFactory;
/*      */ import org.quartz.TriggerListener;
/*      */ import org.quartz.core.JobRunShellFactory;
/*      */ import org.quartz.core.QuartzScheduler;
/*      */ import org.quartz.core.QuartzSchedulerResources;
/*      */ import org.quartz.core.SchedulingContext;
/*      */ import org.quartz.ee.jta.JTAJobRunShellFactory;
/*      */ import org.quartz.ee.jta.UserTransactionHelper;
/*      */ import org.quartz.impl.jdbcjobstore.JobStoreSupport;
/*      */ import org.quartz.simpl.RAMJobStore;
/*      */ import org.quartz.simpl.SimpleThreadPool;
/*      */ import org.quartz.spi.ClassLoadHelper;
/*      */ import org.quartz.spi.InstanceIdGenerator;
/*      */ import org.quartz.spi.JobFactory;
/*      */ import org.quartz.spi.JobStore;
/*      */ import org.quartz.spi.SchedulerPlugin;
/*      */ import org.quartz.spi.ThreadPool;
/*      */ import org.quartz.utils.ConnectionProvider;
/*      */ import org.quartz.utils.DBConnectionManager;
/*      */ import org.quartz.utils.JNDIConnectionProvider;
/*      */ import org.quartz.utils.PoolingConnectionProvider;
/*      */ import org.quartz.utils.PropertiesParser;
/*      */ 
/*      */ public class StdSchedulerFactory
/*      */   implements SchedulerFactory
/*      */ {
/*      */   public static final String PROPERTIES_FILE = "org.quartz.properties";
/*      */   public static final String PROP_SCHED_INSTANCE_NAME = "org.quartz.scheduler.instanceName";
/*      */   public static final String PROP_SCHED_INSTANCE_ID = "org.quartz.scheduler.instanceId";
/*      */   public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS = "org.quartz.scheduler.instanceIdGenerator.class";
/*      */   public static final String PROP_SCHED_THREAD_NAME = "org.quartz.scheduler.threadName";
/*      */   public static final String PROP_SCHED_RMI_EXPORT = "org.quartz.scheduler.rmi.export";
/*      */   public static final String PROP_SCHED_RMI_PROXY = "org.quartz.scheduler.rmi.proxy";
/*      */   public static final String PROP_SCHED_RMI_HOST = "org.quartz.scheduler.rmi.registryHost";
/*      */   public static final String PROP_SCHED_RMI_PORT = "org.quartz.scheduler.rmi.registryPort";
/*      */   public static final String PROP_SCHED_RMI_SERVER_PORT = "org.quartz.scheduler.rmi.serverPort";
/*      */   public static final String PROP_SCHED_RMI_CREATE_REGISTRY = "org.quartz.scheduler.rmi.createRegistry";
/*      */   public static final String PROP_SCHED_WRAP_JOB_IN_USER_TX = "org.quartz.scheduler.wrapJobExecutionInUserTransaction";
/*      */   public static final String PROP_SCHED_USER_TX_URL = "org.quartz.scheduler.userTransactionURL";
/*      */   public static final String PROP_SCHED_IDLE_WAIT_TIME = "org.quartz.scheduler.idleWaitTime";
/*      */   public static final String PROP_SCHED_DB_FAILURE_RETRY_INTERVAL = "org.quartz.scheduler.dbFailureRetryInterval";
/*      */   public static final String PROP_SCHED_CLASS_LOAD_HELPER_CLASS = "org.quartz.scheduler.classLoadHelper.class";
/*      */   public static final String PROP_SCHED_JOB_FACTORY_CLASS = "org.quartz.scheduler.jobFactory.class";
/*      */   public static final String PROP_SCHED_JOB_FACTORY_PREFIX = "org.quartz.scheduler.jobFactory";
/*      */   public static final String PROP_SCHED_CONTEXT_PREFIX = "org.quartz.context.key";
/*      */   public static final String PROP_THREAD_POOL_PREFIX = "org.quartz.threadPool";
/*      */   public static final String PROP_THREAD_POOL_CLASS = "org.quartz.threadPool.class";
/*      */   public static final String PROP_JOB_STORE_PREFIX = "org.quartz.jobStore";
/*      */   public static final String PROP_JOB_STORE_CLASS = "org.quartz.jobStore.class";
/*      */   public static final String PROP_JOB_STORE_USE_PROP = "org.quartz.jobStore.useProperties";
/*      */   public static final String PROP_DATASOURCE_PREFIX = "org.quartz.dataSource";
/*      */   public static final String PROP_CONNECTION_PROVIDER_CLASS = "connectionProvider.class";
/*      */   public static final String PROP_DATASOURCE_DRIVER = "driver";
/*      */   public static final String PROP_DATASOURCE_URL = "URL";
/*      */   public static final String PROP_DATASOURCE_USER = "user";
/*      */   public static final String PROP_DATASOURCE_PASSWORD = "password";
/*      */   public static final String PROP_DATASOURCE_MAX_CONNECTIONS = "maxConnections";
/*      */   public static final String PROP_DATASOURCE_VALIDATION_QUERY = "validationQuery";
/*      */   public static final String PROP_DATASOURCE_JNDI_URL = "jndiURL";
/*      */   public static final String PROP_DATASOURCE_JNDI_ALWAYS_LOOKUP = "jndiAlwaysLookup";
/*      */   public static final String PROP_DATASOURCE_JNDI_INITIAL = "java.naming.factory.initial";
/*      */   public static final String PROP_DATASOURCE_JNDI_PROVDER = "java.naming.provider.url";
/*      */   public static final String PROP_DATASOURCE_JNDI_PRINCIPAL = "java.naming.security.principal";
/*      */   public static final String PROP_DATASOURCE_JNDI_CREDENTIALS = "java.naming.security.credentials";
/*      */   public static final String PROP_PLUGIN_PREFIX = "org.quartz.plugin";
/*      */   public static final String PROP_PLUGIN_CLASS = "class";
/*      */   public static final String PROP_JOB_LISTENER_PREFIX = "org.quartz.jobListener";
/*      */   public static final String PROP_TRIGGER_LISTENER_PREFIX = "org.quartz.triggerListener";
/*      */   public static final String PROP_LISTENER_CLASS = "class";
/*      */   public static final String DEFAULT_INSTANCE_ID = "NON_CLUSTERED";
/*      */   public static final String AUTO_GENERATE_INSTANCE_ID = "AUTO";
/*  217 */   private SchedulerException initException = null;
/*      */ 
/*  219 */   private String propSrc = null;
/*      */   private PropertiesParser cfg;
/*      */ 
/*      */   public StdSchedulerFactory()
/*      */   {
/*      */   }
/*      */ 
/*      */   public StdSchedulerFactory(Properties props)
/*      */     throws SchedulerException
/*      */   {
/*  237 */     initialize(props);
/*      */   }
/*      */ 
/*      */   public StdSchedulerFactory(String fileName) throws SchedulerException {
/*  241 */     initialize(fileName);
/*      */   }
/*      */ 
/*      */   public static Log getLog()
/*      */   {
/*  253 */     return LogFactory.getLog(StdSchedulerFactory.class);
/*      */   }
/*      */ 
/*      */   public void initialize()
/*      */     throws SchedulerException
/*      */   {
/*  279 */     if (this.cfg != null) return;
/*  280 */     if (this.initException != null) throw this.initException;
/*      */ 
/*  282 */     String requestedFile = System.getProperty("org.quartz.properties");
/*  283 */     String propFileName = requestedFile != null ? requestedFile : "quartz.properties";
/*      */ 
/*  285 */     File propFile = new File(propFileName);
/*      */ 
/*  287 */     Properties props = new Properties();
/*      */ 
/*  289 */     if (propFile.exists()) {
/*      */       try {
/*  291 */         if (requestedFile != null) this.propSrc = ("specified file: '" + requestedFile + "'");
/*      */         else
/*      */         {
/*  294 */           this.propSrc = "default file in current working dir: 'quartz.properties'";
/*      */         }
/*  296 */         props.load(new BufferedInputStream(new FileInputStream(propFileName)));
/*      */ 
/*  299 */         initialize(overRideWithSysProps(props));
/*      */       } catch (IOException ioe) {
/*  301 */         this.initException = new SchedulerException("Properties file: '" + propFileName + "' could not be read.", ioe);
/*      */ 
/*  303 */         throw this.initException;
/*      */       }
/*  305 */     } else if (requestedFile != null) {
/*  306 */       InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(requestedFile);
/*      */ 
/*  309 */       if (in == null) {
/*  310 */         this.initException = new SchedulerException("Properties file: '" + requestedFile + "' could not be found.");
/*      */ 
/*  312 */         throw this.initException;
/*      */       }
/*      */ 
/*  315 */       this.propSrc = ("specified file: '" + requestedFile + "' in the class resource path.");
/*      */       try
/*      */       {
/*  318 */         props.load(new BufferedInputStream(in));
/*  319 */         initialize(overRideWithSysProps(props));
/*      */       } catch (IOException ioe) {
/*  321 */         this.initException = new SchedulerException("Properties file: '" + requestedFile + "' could not be read.", ioe);
/*      */ 
/*  323 */         throw this.initException;
/*      */       }
/*      */     }
/*      */     else {
/*  327 */       this.propSrc = "default resource file in Quartz package: 'quartz.properties'";
/*      */ 
/*  329 */       InputStream in = getClass().getClassLoader().getResourceAsStream("quartz.properties");
/*      */ 
/*  332 */       if (in == null) {
/*  333 */         in = getClass().getClassLoader().getResourceAsStream("/quartz.properties");
/*      */       }
/*  335 */       if (in == null) {
/*  336 */         in = getClass().getClassLoader().getResourceAsStream("org/quartz/quartz.properties");
/*      */       }
/*  338 */       if (in == null) {
/*  339 */         this.initException = new SchedulerException("Default quartz.properties not found in class path");
/*      */ 
/*  341 */         throw this.initException;
/*      */       }
/*      */       try {
/*  344 */         props.load(in);
/*      */       } catch (IOException ioe) {
/*  346 */         this.initException = new SchedulerException("Resource properties file: 'org/quartz/quartz.properties' could not be read from the classpath.", ioe);
/*      */ 
/*  349 */         throw this.initException;
/*      */       }
/*      */ 
/*  352 */       initialize(overRideWithSysProps(props));
/*      */     }
/*      */   }
/*      */ 
/*      */   private Properties overRideWithSysProps(Properties props)
/*      */   {
/*  358 */     Properties sysProps = System.getProperties();
/*  359 */     props.putAll(sysProps);
/*      */ 
/*  361 */     return props;
/*      */   }
/*      */ 
/*      */   public void initialize(String filename)
/*      */     throws SchedulerException
/*      */   {
/*  373 */     if (this.cfg != null) return;
/*  374 */     if (this.initException != null) throw this.initException;
/*      */ 
/*  376 */     InputStream is = null;
/*  377 */     Properties props = new Properties();
/*      */ 
/*  379 */     is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);
/*      */     try
/*      */     {
/*  382 */       if (is != null) {
/*  383 */         is = new BufferedInputStream(is);
/*  384 */         this.propSrc = ("the specified file : '" + filename + "' from the class resource path.");
/*      */       }
/*      */       else {
/*  387 */         is = new BufferedInputStream(new FileInputStream(filename));
/*  388 */         this.propSrc = ("the specified file : '" + filename + "'");
/*      */       }
/*  390 */       props.load(is);
/*      */     } catch (IOException ioe) {
/*  392 */       this.initException = new SchedulerException("Properties file: '" + filename + "' could not be read.", ioe);
/*      */ 
/*  394 */       throw this.initException;
/*      */     }
/*      */ 
/*  397 */     initialize(props);
/*      */   }
/*      */ 
/*      */   public void initialize(InputStream propertiesStream)
/*      */     throws SchedulerException
/*      */   {
/*  410 */     if (this.cfg != null) return;
/*  411 */     if (this.initException != null) throw this.initException;
/*      */ 
/*  413 */     Properties props = new Properties();
/*      */ 
/*  415 */     if (propertiesStream != null) {
/*      */       try {
/*  417 */         props.load(propertiesStream);
/*  418 */         this.propSrc = "an externally opened InputStream.";
/*      */       } catch (IOException e) {
/*  420 */         this.initException = new SchedulerException("Error loading property data from InputStream", e);
/*      */ 
/*  422 */         throw this.initException;
/*      */       }
/*      */     } else {
/*  425 */       this.initException = new SchedulerException("Error loading property data from InputStream - InputStream is null.");
/*      */ 
/*  427 */       throw this.initException;
/*      */     }
/*      */ 
/*  430 */     initialize(props);
/*      */   }
/*      */ 
/*      */   public void initialize(Properties props)
/*      */     throws SchedulerException
/*      */   {
/*  440 */     if (this.propSrc == null) {
/*  441 */       this.propSrc = "an externally provided properties instance.";
/*      */     }
/*  443 */     this.cfg = new PropertiesParser(props);
/*      */   }
/*      */ 
/*      */   private Scheduler instantiate()
/*      */     throws SchedulerException
/*      */   {
/*  450 */     if (this.cfg == null) initialize();
/*      */ 
/*  452 */     if (this.initException != null) throw this.initException;
/*      */ 
/*  454 */     JobStore js = null;
/*  455 */     ThreadPool tp = null;
/*  456 */     QuartzScheduler qs = null;
/*  457 */     SchedulingContext schedCtxt = null;
/*  458 */     DBConnectionManager dbMgr = null;
/*  459 */     String instanceIdGeneratorClass = null;
/*  460 */     Properties tProps = null;
/*  461 */     String userTXLocation = null;
/*  462 */     boolean wrapJobInTx = false;
/*  463 */     boolean autoId = false;
/*  464 */     long idleWaitTime = -1L;
/*  465 */     long dbFailureRetry = -1L;
/*      */ 
/*  469 */     SchedulerRepository schedRep = SchedulerRepository.getInstance();
/*      */ 
/*  474 */     String schedName = this.cfg.getStringProperty("org.quartz.scheduler.instanceName", "QuartzScheduler");
/*      */ 
/*  477 */     String threadName = this.cfg.getStringProperty("org.quartz.scheduler.threadName", schedName + "_QuartzSchedulerThread");
/*      */ 
/*  480 */     String schedInstId = this.cfg.getStringProperty("org.quartz.scheduler.instanceId", "NON_CLUSTERED");
/*      */ 
/*  483 */     if (schedInstId.equals("AUTO")) {
/*  484 */       autoId = true;
/*  485 */       instanceIdGeneratorClass = this.cfg.getStringProperty("org.quartz.scheduler.instanceIdGenerator.class", "org.quartz.simpl.SimpleInstanceIdGenerator");
/*      */     }
/*      */ 
/*  490 */     userTXLocation = this.cfg.getStringProperty("org.quartz.scheduler.userTransactionURL", userTXLocation);
/*      */ 
/*  492 */     if ((userTXLocation != null) && (userTXLocation.trim().length() == 0)) {
/*  493 */       userTXLocation = null;
/*      */     }
/*  495 */     String classLoadHelperClass = this.cfg.getStringProperty("org.quartz.scheduler.classLoadHelper.class", "org.quartz.simpl.CascadingClassLoadHelper");
/*      */ 
/*  498 */     wrapJobInTx = this.cfg.getBooleanProperty("org.quartz.scheduler.wrapJobExecutionInUserTransaction", wrapJobInTx);
/*      */ 
/*  501 */     String jobFactoryClass = this.cfg.getStringProperty("org.quartz.scheduler.jobFactory.class", null);
/*      */ 
/*  504 */     idleWaitTime = this.cfg.getLongProperty("org.quartz.scheduler.idleWaitTime", idleWaitTime);
/*      */ 
/*  506 */     dbFailureRetry = this.cfg.getLongProperty("org.quartz.scheduler.dbFailureRetryInterval", dbFailureRetry);
/*      */ 
/*  509 */     boolean rmiExport = this.cfg.getBooleanProperty("org.quartz.scheduler.rmi.export", false);
/*      */ 
/*  511 */     boolean rmiProxy = this.cfg.getBooleanProperty("org.quartz.scheduler.rmi.proxy", false);
/*  512 */     String rmiHost = this.cfg.getStringProperty("org.quartz.scheduler.rmi.registryHost", "localhost");
/*      */ 
/*  514 */     int rmiPort = this.cfg.getIntProperty("org.quartz.scheduler.rmi.registryPort", 1099);
/*  515 */     int rmiServerPort = this.cfg.getIntProperty("org.quartz.scheduler.rmi.serverPort", -1);
/*  516 */     String rmiCreateRegistry = this.cfg.getStringProperty("org.quartz.scheduler.rmi.createRegistry", "never");
/*      */ 
/*  520 */     Properties schedCtxtProps = this.cfg.getPropertyGroup("org.quartz.context.key", true);
/*      */ 
/*  524 */     if (rmiProxy)
/*      */     {
/*  526 */       if (autoId) {
/*  527 */         schedInstId = "NON_CLUSTERED";
/*      */       }
/*  529 */       schedCtxt = new SchedulingContext();
/*  530 */       schedCtxt.setInstanceId(schedInstId);
/*      */ 
/*  532 */       String uid = QuartzSchedulerResources.getUniqueIdentifier(schedName, schedInstId);
/*      */ 
/*  535 */       RemoteScheduler remoteScheduler = new RemoteScheduler(schedCtxt, uid, rmiHost, rmiPort);
/*      */ 
/*  538 */       schedRep.bind(remoteScheduler);
/*      */ 
/*  540 */       return remoteScheduler;
/*      */     }
/*      */ 
/*  544 */     ClassLoadHelper loadHelper = null;
/*      */     try {
/*  546 */       loadHelper = (ClassLoadHelper)loadClass(classLoadHelperClass).newInstance();
/*      */     }
/*      */     catch (Exception e) {
/*  549 */       throw new SchedulerConfigException("Unable to instantiate class load helper class: " + e.getMessage(), e);
/*      */     }
/*      */ 
/*  553 */     loadHelper.initialize();
/*      */ 
/*  555 */     JobFactory jobFactory = null;
/*  556 */     if (jobFactoryClass != null) {
/*      */       try {
/*  558 */         jobFactory = (JobFactory)loadHelper.loadClass(jobFactoryClass).newInstance();
/*      */       }
/*      */       catch (Exception e) {
/*  561 */         throw new SchedulerConfigException("Unable to instantiate JobFactory class: " + e.getMessage(), e);
/*      */       }
/*      */ 
/*  566 */       tProps = this.cfg.getPropertyGroup("org.quartz.scheduler.jobFactory", true);
/*      */       try {
/*  568 */         setBeanProps(jobFactory, tProps);
/*      */       } catch (Exception e) {
/*  570 */         this.initException = new SchedulerException("JobFactory class '" + jobFactoryClass + "' props could not be configured.", e);
/*      */ 
/*  572 */         this.initException.setErrorCode(50);
/*      */ 
/*  574 */         throw this.initException;
/*      */       }
/*      */     }
/*      */ 
/*  578 */     InstanceIdGenerator instanceIdGenerator = null;
/*  579 */     if (instanceIdGeneratorClass != null) {
/*      */       try {
/*  581 */         instanceIdGenerator = (InstanceIdGenerator)loadHelper.loadClass(instanceIdGeneratorClass).newInstance();
/*      */       }
/*      */       catch (Exception e) {
/*  584 */         throw new SchedulerConfigException("Unable to instantiate InstanceIdGenerator class: " + e.getMessage(), e);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  593 */     String tpClass = this.cfg.getStringProperty("org.quartz.threadPool.class", null);
/*      */ 
/*  595 */     if (tpClass == null) {
/*  596 */       this.initException = new SchedulerException("ThreadPool class not specified. ", 50);
/*      */ 
/*  599 */       throw this.initException;
/*      */     }
/*      */     try
/*      */     {
/*  603 */       tp = (ThreadPool)loadHelper.loadClass(tpClass).newInstance();
/*      */     } catch (Exception e) {
/*  605 */       this.initException = new SchedulerException("ThreadPool class '" + tpClass + "' could not be instantiated.", e);
/*      */ 
/*  607 */       this.initException.setErrorCode(50);
/*      */ 
/*  609 */       throw this.initException;
/*      */     }
/*  611 */     tProps = this.cfg.getPropertyGroup("org.quartz.threadPool", true);
/*      */     try {
/*  613 */       setBeanProps(tp, tProps);
/*      */     } catch (Exception e) {
/*  615 */       this.initException = new SchedulerException("ThreadPool class '" + tpClass + "' props could not be configured.", e);
/*      */ 
/*  617 */       this.initException.setErrorCode(50);
/*      */ 
/*  619 */       throw this.initException;
/*      */     }
/*      */ 
/*  625 */     String jsClass = this.cfg.getStringProperty("org.quartz.jobStore.class", RAMJobStore.class.getName());
/*      */ 
/*  628 */     if (jsClass == null) {
/*  629 */       this.initException = new SchedulerException("JobStore class not specified. ", 50);
/*      */ 
/*  632 */       throw this.initException;
/*      */     }
/*      */     try
/*      */     {
/*  636 */       js = (JobStore)loadHelper.loadClass(jsClass).newInstance();
/*      */     } catch (Exception e) {
/*  638 */       this.initException = new SchedulerException("JobStore class '" + jsClass + "' could not be instantiated.", e);
/*      */ 
/*  640 */       this.initException.setErrorCode(50);
/*      */ 
/*  642 */       throw this.initException;
/*      */     }
/*  644 */     tProps = this.cfg.getPropertyGroup("org.quartz.jobStore", true);
/*      */     try {
/*  646 */       setBeanProps(js, tProps);
/*      */     } catch (Exception e) {
/*  648 */       this.initException = new SchedulerException("JobStore class '" + jsClass + "' props could not be configured.", e);
/*      */ 
/*  650 */       this.initException.setErrorCode(50);
/*      */ 
/*  652 */       throw this.initException;
/*      */     }
/*      */ 
/*  655 */     if ((js instanceof JobStoreSupport)) {
/*  656 */       ((JobStoreSupport)js).setInstanceId(schedInstId);
/*      */ 
/*  658 */       ((JobStoreSupport)js).setInstanceName(schedName);
/*      */     }
/*      */ 
/*  665 */     String[] dsNames = this.cfg.getPropertyGroups("org.quartz.dataSource");
/*  666 */     for (int i = 0; i < dsNames.length; i++) {
/*  667 */       PropertiesParser pp = new PropertiesParser(this.cfg.getPropertyGroup("org.quartz.dataSource." + dsNames[i], true));
/*      */ 
/*  670 */       String cpClass = pp.getStringProperty("connectionProvider.class", null);
/*      */ 
/*  673 */       if (cpClass != null) {
/*  674 */         ConnectionProvider cp = null;
/*      */         try {
/*  676 */           cp = (ConnectionProvider)loadHelper.loadClass(cpClass).newInstance();
/*      */         } catch (Exception e) {
/*  678 */           this.initException = new SchedulerException("ConnectionProvider class '" + cpClass + "' could not be instantiated.", e);
/*      */ 
/*  680 */           this.initException.setErrorCode(50);
/*      */ 
/*  682 */           throw this.initException;
/*      */         }
/*      */ 
/*      */         try
/*      */         {
/*  687 */           pp.getUnderlyingProperties().remove("connectionProvider.class");
/*      */ 
/*  690 */           setBeanProps(cp, pp.getUnderlyingProperties());
/*      */         } catch (Exception e) {
/*  692 */           this.initException = new SchedulerException("ConnectionProvider class '" + cpClass + "' props could not be configured.", e);
/*      */ 
/*  694 */           this.initException.setErrorCode(50);
/*      */ 
/*  696 */           throw this.initException;
/*      */         }
/*      */ 
/*  699 */         dbMgr = DBConnectionManager.getInstance();
/*  700 */         dbMgr.addConnectionProvider(dsNames[i], cp);
/*      */       }
/*      */       else {
/*  703 */         String dsDriver = pp.getStringProperty("driver", null);
/*      */ 
/*  705 */         String dsURL = pp.getStringProperty("URL", null);
/*  706 */         boolean dsAlwaysLookup = pp.getBooleanProperty("jndiAlwaysLookup", false);
/*      */ 
/*  708 */         String dsUser = pp.getStringProperty("user", "");
/*  709 */         String dsPass = pp.getStringProperty("password", "");
/*  710 */         int dsCnt = pp.getIntProperty("maxConnections", 10);
/*  711 */         String dsJndi = pp.getStringProperty("jndiURL", null);
/*      */ 
/*  713 */         String dsJndiInitial = pp.getStringProperty("java.naming.factory.initial", null);
/*      */ 
/*  715 */         String dsJndiProvider = pp.getStringProperty("java.naming.provider.url", null);
/*      */ 
/*  717 */         String dsJndiPrincipal = pp.getStringProperty("java.naming.security.principal", null);
/*      */ 
/*  719 */         String dsJndiCredentials = pp.getStringProperty("java.naming.security.credentials", null);
/*      */ 
/*  721 */         String dsValidation = pp.getStringProperty("validationQuery", null);
/*      */ 
/*  724 */         if (dsJndi != null) {
/*  725 */           Properties props = null;
/*  726 */           if ((null != dsJndiInitial) || (null != dsJndiProvider) || (null != dsJndiPrincipal) || (null != dsJndiCredentials))
/*      */           {
/*  728 */             props = new Properties();
/*  729 */             if (dsJndiInitial != null) {
/*  730 */               props.put("java.naming.factory.initial", dsJndiInitial);
/*      */             }
/*  732 */             if (dsJndiProvider != null) {
/*  733 */               props.put("java.naming.provider.url", dsJndiProvider);
/*      */             }
/*  735 */             if (dsJndiPrincipal != null) {
/*  736 */               props.put("java.naming.security.principal", dsJndiPrincipal);
/*      */             }
/*  738 */             if (dsJndiCredentials != null) {
/*  739 */               props.put("java.naming.security.credentials", dsJndiCredentials);
/*      */             }
/*      */           }
/*  742 */           JNDIConnectionProvider cp = new JNDIConnectionProvider(dsJndi, props, dsAlwaysLookup);
/*      */ 
/*  744 */           dbMgr = DBConnectionManager.getInstance();
/*  745 */           dbMgr.addConnectionProvider(dsNames[i], cp);
/*      */         } else {
/*  747 */           if (dsDriver == null) {
/*  748 */             this.initException = new SchedulerException("Driver not specified for DataSource: " + dsNames[i]);
/*      */ 
/*  751 */             throw this.initException;
/*      */           }
/*  753 */           if (dsURL == null) {
/*  754 */             this.initException = new SchedulerException("DB URL not specified for DataSource: " + dsNames[i]);
/*      */ 
/*  757 */             throw this.initException;
/*      */           }
/*      */           try {
/*  760 */             PoolingConnectionProvider cp = new PoolingConnectionProvider(dsDriver, dsURL, dsUser, dsPass, dsCnt, dsValidation);
/*      */ 
/*  763 */             dbMgr = DBConnectionManager.getInstance();
/*  764 */             dbMgr.addConnectionProvider(dsNames[i], cp);
/*      */           } catch (SQLException sqle) {
/*  766 */             this.initException = new SchedulerException("Could not initialize DataSource: " + dsNames[i], sqle);
/*      */ 
/*  769 */             throw this.initException;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  780 */     String[] pluginNames = this.cfg.getPropertyGroups("org.quartz.plugin");
/*  781 */     SchedulerPlugin[] plugins = new SchedulerPlugin[pluginNames.length];
/*  782 */     for (int i = 0; i < pluginNames.length; i++) {
/*  783 */       Properties pp = this.cfg.getPropertyGroup("org.quartz.plugin." + pluginNames[i], true);
/*      */ 
/*  786 */       String plugInClass = pp.getProperty("class", null);
/*      */ 
/*  788 */       if (plugInClass == null) {
/*  789 */         this.initException = new SchedulerException("SchedulerPlugin class not specified for plugin '" + pluginNames[i] + "'", 50);
/*      */ 
/*  793 */         throw this.initException;
/*      */       }
/*  795 */       SchedulerPlugin plugin = null;
/*      */       try {
/*  797 */         plugin = (SchedulerPlugin)loadHelper.loadClass(plugInClass).newInstance();
/*      */       }
/*      */       catch (Exception e) {
/*  800 */         this.initException = new SchedulerException("SchedulerPlugin class '" + plugInClass + "' could not be instantiated.", e);
/*      */ 
/*  803 */         this.initException.setErrorCode(50);
/*      */ 
/*  805 */         throw this.initException;
/*      */       }
/*      */       try {
/*  808 */         setBeanProps(plugin, pp);
/*      */       } catch (Exception e) {
/*  810 */         this.initException = new SchedulerException("JobStore SchedulerPlugin '" + plugInClass + "' props could not be configured.", e);
/*      */ 
/*  813 */         this.initException.setErrorCode(50);
/*      */ 
/*  815 */         throw this.initException;
/*      */       }
/*  817 */       plugins[i] = plugin;
/*      */     }
/*      */ 
/*  823 */     Class[] strArg = { String.class };
/*  824 */     String[] jobListenerNames = this.cfg.getPropertyGroups("org.quartz.jobListener");
/*  825 */     JobListener[] jobListeners = new JobListener[jobListenerNames.length];
/*  826 */     for (int i = 0; i < jobListenerNames.length; i++) {
/*  827 */       Properties lp = this.cfg.getPropertyGroup("org.quartz.jobListener." + jobListenerNames[i], true);
/*      */ 
/*  830 */       String listenerClass = lp.getProperty("class", null);
/*      */ 
/*  832 */       if (listenerClass == null) {
/*  833 */         this.initException = new SchedulerException("JobListener class not specified for listener '" + jobListenerNames[i] + "'", 50);
/*      */ 
/*  837 */         throw this.initException;
/*      */       }
/*  839 */       JobListener listener = null;
/*      */       try {
/*  841 */         listener = (JobListener)loadHelper.loadClass(listenerClass).newInstance();
/*      */       }
/*      */       catch (Exception e) {
/*  844 */         this.initException = new SchedulerException("JobListener class '" + listenerClass + "' could not be instantiated.", e);
/*      */ 
/*  847 */         this.initException.setErrorCode(50);
/*      */ 
/*  849 */         throw this.initException;
/*      */       }
/*      */       try {
/*  852 */         Method nameSetter = listener.getClass().getMethod("setName", strArg);
/*  853 */         if (nameSetter != null)
/*  854 */           nameSetter.invoke(listener, new Object[] { jobListenerNames[i] });
/*  855 */         setBeanProps(listener, lp);
/*      */       } catch (Exception e) {
/*  857 */         this.initException = new SchedulerException("JobListener '" + listenerClass + "' props could not be configured.", e);
/*      */ 
/*  860 */         this.initException.setErrorCode(50);
/*      */ 
/*  862 */         throw this.initException;
/*      */       }
/*  864 */       jobListeners[i] = listener;
/*      */     }
/*      */ 
/*  870 */     String[] triggerListenerNames = this.cfg.getPropertyGroups("org.quartz.triggerListener");
/*  871 */     TriggerListener[] triggerListeners = new TriggerListener[triggerListenerNames.length];
/*  872 */     for (int i = 0; i < triggerListenerNames.length; i++) {
/*  873 */       Properties lp = this.cfg.getPropertyGroup("org.quartz.triggerListener." + triggerListenerNames[i], true);
/*      */ 
/*  876 */       String listenerClass = lp.getProperty("class", null);
/*      */ 
/*  878 */       if (listenerClass == null) {
/*  879 */         this.initException = new SchedulerException("TriggerListener class not specified for listener '" + triggerListenerNames[i] + "'", 50);
/*      */ 
/*  883 */         throw this.initException;
/*      */       }
/*  885 */       TriggerListener listener = null;
/*      */       try {
/*  887 */         listener = (TriggerListener)loadHelper.loadClass(listenerClass).newInstance();
/*      */       }
/*      */       catch (Exception e) {
/*  890 */         this.initException = new SchedulerException("TriggerListener class '" + listenerClass + "' could not be instantiated.", e);
/*      */ 
/*  893 */         this.initException.setErrorCode(50);
/*      */ 
/*  895 */         throw this.initException;
/*      */       }
/*      */       try {
/*  898 */         Method nameSetter = listener.getClass().getMethod("setName", strArg);
/*  899 */         if (nameSetter != null)
/*  900 */           nameSetter.invoke(listener, new Object[] { triggerListenerNames[i] });
/*  901 */         setBeanProps(listener, lp);
/*      */       } catch (Exception e) {
/*  903 */         this.initException = new SchedulerException("TriggerListener '" + listenerClass + "' props could not be configured.", e);
/*      */ 
/*  906 */         this.initException.setErrorCode(50);
/*      */ 
/*  908 */         throw this.initException;
/*      */       }
/*  910 */       triggerListeners[i] = listener;
/*      */     }
/*      */ 
/*  917 */     JobRunShellFactory jrsf = null;
/*  918 */     UserTransactionHelper userTxHelper = null;
/*      */ 
/*  920 */     if (wrapJobInTx) {
/*  921 */       userTxHelper = new UserTransactionHelper(userTXLocation);
/*      */     }
/*  923 */     if (wrapJobInTx) jrsf = new JTAJobRunShellFactory(userTxHelper);
/*      */     else {
/*  925 */       jrsf = new StdJobRunShellFactory();
/*      */     }
/*  927 */     if (autoId) {
/*      */       try {
/*  929 */         schedInstId = "NON_CLUSTERED";
/*  930 */         if (((js instanceof JobStoreSupport)) && 
/*  931 */           (((JobStoreSupport)js).isClustered()))
/*      */         {
/*  933 */           schedInstId = instanceIdGenerator.generateInstanceId();
/*      */         }
/*      */       }
/*      */       catch (Exception e) {
/*  937 */         getLog().error("Couldn't generate instance Id!", e);
/*  938 */         throw new IllegalStateException("Cannot run without an instance id.");
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  943 */     if ((js instanceof JobStoreSupport)) {
/*  944 */       JobStoreSupport jjs = (JobStoreSupport)js;
/*  945 */       jjs.setInstanceId(schedInstId);
/*  946 */       jjs.setDbRetryInterval(dbFailureRetry);
/*      */     }
/*      */ 
/*  949 */     QuartzSchedulerResources rsrcs = new QuartzSchedulerResources();
/*  950 */     rsrcs.setName(schedName);
/*  951 */     rsrcs.setThreadName(threadName);
/*  952 */     rsrcs.setInstanceId(schedInstId);
/*  953 */     rsrcs.setJobRunShellFactory(jrsf);
/*      */ 
/*  955 */     if (rmiExport) {
/*  956 */       rsrcs.setRMIRegistryHost(rmiHost);
/*  957 */       rsrcs.setRMIRegistryPort(rmiPort);
/*  958 */       rsrcs.setRMIServerPort(rmiServerPort);
/*  959 */       rsrcs.setRMICreateRegistryStrategy(rmiCreateRegistry);
/*      */     }
/*      */ 
/*  962 */     rsrcs.setThreadPool(tp);
/*  963 */     if ((tp instanceof SimpleThreadPool))
/*  964 */       ((SimpleThreadPool)tp).setThreadNamePrefix(schedName + "_Worker");
/*  965 */     tp.initialize();
/*      */ 
/*  967 */     rsrcs.setJobStore(js);
/*      */ 
/*  969 */     schedCtxt = new SchedulingContext();
/*  970 */     schedCtxt.setInstanceId(rsrcs.getInstanceId());
/*      */ 
/*  972 */     qs = new QuartzScheduler(rsrcs, schedCtxt, idleWaitTime, dbFailureRetry);
/*      */ 
/*  979 */     Scheduler scheduler = instantiate(rsrcs, qs);
/*      */ 
/*  982 */     if (jobFactory != null) {
/*  983 */       qs.setJobFactory(jobFactory);
/*      */     }
/*      */ 
/*  986 */     for (int i = 0; i < plugins.length; i++) {
/*  987 */       plugins[i].initialize(pluginNames[i], scheduler);
/*  988 */       qs.addSchedulerPlugin(plugins[i]);
/*      */     }
/*      */ 
/*  992 */     for (int i = 0; i < jobListeners.length; i++) {
/*  993 */       qs.addGlobalJobListener(jobListeners[i]);
/*      */     }
/*  995 */     for (int i = 0; i < triggerListeners.length; i++) {
/*  996 */       qs.addGlobalTriggerListener(triggerListeners[i]);
/*      */     }
/*      */ 
/* 1000 */     Iterator itr = schedCtxtProps.keySet().iterator();
/* 1001 */     while (itr.hasNext()) {
/* 1002 */       String key = (String)itr.next();
/* 1003 */       String val = schedCtxtProps.getProperty(key);
/*      */ 
/* 1005 */       scheduler.getContext().put(key, val);
/*      */     }
/*      */ 
/* 1010 */     js.initialize(loadHelper, qs.getSchedulerSignaler());
/*      */ 
/* 1012 */     jrsf.initialize(scheduler, schedCtxt);
/*      */ 
/* 1014 */     getLog().info("Quartz scheduler '" + scheduler.getSchedulerName() + "' initialized from " + this.propSrc);
/*      */ 
/* 1018 */     getLog().info("Quartz scheduler version: " + qs.getVersion());
/*      */ 
/* 1021 */     qs.addNoGCObject(schedRep);
/*      */ 
/* 1023 */     if (dbMgr != null) qs.addNoGCObject(dbMgr);
/*      */ 
/* 1025 */     schedRep.bind(scheduler);
/*      */ 
/* 1027 */     return scheduler;
/*      */   }
/*      */ 
/*      */   protected Scheduler instantiate(QuartzSchedulerResources rsrcs, QuartzScheduler qs) {
/* 1031 */     SchedulingContext schedCtxt = new SchedulingContext();
/* 1032 */     schedCtxt.setInstanceId(rsrcs.getInstanceId());
/*      */ 
/* 1034 */     Scheduler scheduler = new StdScheduler(qs, schedCtxt);
/* 1035 */     return scheduler;
/*      */   }
/*      */ 
/*      */   private void setBeanProps(Object obj, Properties props)
/*      */     throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IntrospectionException, SchedulerConfigException
/*      */   {
/* 1043 */     props.remove("class");
/*      */ 
/* 1045 */     BeanInfo bi = Introspector.getBeanInfo(obj.getClass());
/* 1046 */     PropertyDescriptor[] propDescs = bi.getPropertyDescriptors();
/* 1047 */     PropertiesParser pp = new PropertiesParser(props);
/*      */ 
/* 1049 */     Enumeration keys = props.keys();
/* 1050 */     while (keys.hasMoreElements()) {
/* 1051 */       String name = (String)keys.nextElement();
/* 1052 */       String c = name.substring(0, 1).toUpperCase(Locale.US);
/* 1053 */       String methName = "set" + c + name.substring(1);
/*      */ 
/* 1055 */       Method setMeth = getSetMethod(methName, propDescs);
/*      */       try
/*      */       {
/* 1058 */         if (setMeth == null) {
/* 1059 */           throw new NoSuchMethodException("No setter for property '" + name + "'");
/*      */         }
/*      */ 
/* 1062 */         Class[] params = setMeth.getParameterTypes();
/* 1063 */         if (params.length != 1) {
/* 1064 */           throw new NoSuchMethodException("No 1-argument setter for property '" + name + "'");
/*      */         }
/*      */ 
/* 1068 */         if (params[0].equals(Integer.TYPE)) {
/* 1069 */           setMeth.invoke(obj, new Object[] { new Integer(pp.getIntProperty(name)) });
/*      */         }
/* 1071 */         else if (params[0].equals(Long.TYPE)) {
/* 1072 */           setMeth.invoke(obj, new Object[] { new Long(pp.getLongProperty(name)) });
/*      */         }
/* 1074 */         else if (params[0].equals(Float.TYPE)) {
/* 1075 */           setMeth.invoke(obj, new Object[] { new Float(pp.getFloatProperty(name)) });
/*      */         }
/* 1077 */         else if (params[0].equals(Double.TYPE)) {
/* 1078 */           setMeth.invoke(obj, new Object[] { new Double(pp.getDoubleProperty(name)) });
/*      */         }
/* 1080 */         else if (params[0].equals(Boolean.TYPE)) {
/* 1081 */           setMeth.invoke(obj, new Object[] { new Boolean(pp.getBooleanProperty(name)) });
/*      */         }
/* 1083 */         else if (params[0].equals(String.class)) {
/* 1084 */           setMeth.invoke(obj, new Object[] { pp.getStringProperty(name) });
/*      */         }
/*      */         else
/* 1087 */           throw new NoSuchMethodException("No primitive-type setter for property '" + name + "'");
/*      */       }
/*      */       catch (NumberFormatException nfe)
/*      */       {
/* 1091 */         throw new SchedulerConfigException("Could not parse property '" + name + "' into correct data type: " + nfe.toString());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private Method getSetMethod(String name, PropertyDescriptor[] props)
/*      */   {
/* 1099 */     for (int i = 0; i < props.length; i++) {
/* 1100 */       Method wMeth = props[i].getWriteMethod();
/*      */ 
/* 1102 */       if ((wMeth != null) && (wMeth.getName().equals(name))) return wMeth;
/*      */     }
/*      */ 
/* 1105 */     return null;
/*      */   }
/*      */ 
/*      */   private Class loadClass(String className) throws ClassNotFoundException
/*      */   {
/*      */     try {
/* 1111 */       return Thread.currentThread().getContextClassLoader().loadClass(className);
/*      */     } catch (ClassNotFoundException e) {
/*      */     }
/* 1114 */     return getClass().getClassLoader().loadClass(className);
/*      */   }
/*      */ 
/*      */   private String getSchedulerName()
/*      */   {
/* 1119 */     return this.cfg.getStringProperty("org.quartz.scheduler.instanceName", "QuartzScheduler");
/*      */   }
/*      */ 
/*      */   private String getSchedulerInstId()
/*      */   {
/* 1124 */     return this.cfg.getStringProperty("org.quartz.scheduler.instanceId", "NON_CLUSTERED");
/*      */   }
/*      */ 
/*      */   public Scheduler getScheduler()
/*      */     throws SchedulerException
/*      */   {
/* 1140 */     if (this.cfg == null) initialize();
/*      */ 
/* 1142 */     SchedulerRepository schedRep = SchedulerRepository.getInstance();
/*      */ 
/* 1144 */     Scheduler sched = schedRep.lookup(getSchedulerName());
/*      */ 
/* 1146 */     if (sched != null) {
/* 1147 */       if (sched.isShutdown()) schedRep.remove(getSchedulerName());
/*      */       else {
/* 1149 */         return sched;
/*      */       }
/*      */     }
/* 1152 */     sched = instantiate();
/*      */ 
/* 1154 */     return sched;
/*      */   }
/*      */ 
/*      */   public static Scheduler getDefaultScheduler()
/*      */     throws SchedulerException
/*      */   {
/* 1166 */     StdSchedulerFactory fact = new StdSchedulerFactory();
/*      */ 
/* 1168 */     return fact.getScheduler();
/*      */   }
/*      */ 
/*      */   public Scheduler getScheduler(String schedName)
/*      */     throws SchedulerException
/*      */   {
/* 1178 */     return SchedulerRepository.getInstance().lookup(schedName);
/*      */   }
/*      */ 
/*      */   public Collection getAllSchedulers()
/*      */     throws SchedulerException
/*      */   {
/* 1188 */     return SchedulerRepository.getInstance().lookupAll();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.StdSchedulerFactory
 * JD-Core Version:    0.6.0
 */