/*      */ package org.quartz.impl;
/*      */ 
/*      */ import java.rmi.RemoteException;
/*      */ import java.rmi.registry.LocateRegistry;
/*      */ import java.rmi.registry.Registry;
/*      */ import java.util.Date;
/*      */ import java.util.List;
/*      */ import java.util.Set;
/*      */ import org.quartz.Calendar;
/*      */ import org.quartz.JobDataMap;
/*      */ import org.quartz.JobDetail;
/*      */ import org.quartz.JobListener;
/*      */ import org.quartz.Scheduler;
/*      */ import org.quartz.SchedulerContext;
/*      */ import org.quartz.SchedulerException;
/*      */ import org.quartz.SchedulerListener;
/*      */ import org.quartz.SchedulerMetaData;
/*      */ import org.quartz.Trigger;
/*      */ import org.quartz.TriggerListener;
/*      */ import org.quartz.UnableToInterruptJobException;
/*      */ import org.quartz.core.RemotableQuartzScheduler;
/*      */ import org.quartz.core.SchedulingContext;
/*      */ import org.quartz.spi.JobFactory;
/*      */ 
/*      */ public class RemoteScheduler
/*      */   implements Scheduler
/*      */ {
/*      */   private RemotableQuartzScheduler rsched;
/*      */   private SchedulingContext schedCtxt;
/*      */   private String schedId;
/*      */   private String rmiHost;
/*      */   private int rmiPort;
/*      */ 
/*      */   public RemoteScheduler(SchedulingContext schedCtxt, String schedId, String host, int port)
/*      */   {
/*   97 */     this.schedCtxt = schedCtxt;
/*   98 */     this.schedId = schedId;
/*   99 */     this.rmiHost = host;
/*  100 */     this.rmiPort = port;
/*      */   }
/*      */ 
/*      */   protected RemotableQuartzScheduler getRemoteScheduler()
/*      */     throws SchedulerException
/*      */   {
/*  113 */     if (this.rsched != null) return this.rsched;
/*      */     try
/*      */     {
/*  116 */       Registry registry = LocateRegistry.getRegistry(this.rmiHost, this.rmiPort);
/*      */ 
/*  118 */       this.rsched = ((RemotableQuartzScheduler)registry.lookup(this.schedId));
/*      */     }
/*      */     catch (Exception e) {
/*  121 */       SchedulerException initException = new SchedulerException("Could not get handle to remote scheduler: " + e.getMessage(), e);
/*      */ 
/*  124 */       initException.setErrorCode(200);
/*      */ 
/*  126 */       throw initException;
/*      */     }
/*      */ 
/*  129 */     return this.rsched;
/*      */   }
/*      */ 
/*      */   protected SchedulerException invalidateHandleCreateException(String msg, Exception cause)
/*      */   {
/*  134 */     this.rsched = null;
/*  135 */     SchedulerException ex = new SchedulerException(msg, cause);
/*  136 */     ex.setErrorCode(200);
/*  137 */     return ex;
/*      */   }
/*      */ 
/*      */   public String getSchedulerName()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  147 */       return getRemoteScheduler().getSchedulerName(); } catch (RemoteException re) {
/*      */     }
/*  149 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public String getSchedulerInstanceId()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  161 */       return getRemoteScheduler().getSchedulerInstanceId(); } catch (RemoteException re) {
/*      */     }
/*  163 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public SchedulerMetaData getMetaData() throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  170 */       RemotableQuartzScheduler sched = getRemoteScheduler();
/*  171 */       return new SchedulerMetaData(getSchedulerName(), getSchedulerInstanceId(), getClass(), true, sched.runningSince() != null, isPaused(), isShutdown(), sched.runningSince(), sched.numJobsExecuted(), sched.getJobStoreClass(), sched.supportsPersistence(), sched.getThreadPoolClass(), sched.getThreadPoolSize(), sched.getVersion());
/*      */     }
/*      */     catch (RemoteException re)
/*      */     {
/*      */     }
/*      */ 
/*  180 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public SchedulerContext getContext()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  193 */       return getRemoteScheduler().getSchedulerContext(); } catch (RemoteException re) {
/*      */     }
/*  195 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public void start()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  213 */       getRemoteScheduler().start();
/*      */     } catch (RemoteException re) {
/*  215 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void standby()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  227 */       getRemoteScheduler().standby();
/*      */     } catch (RemoteException re) {
/*  229 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public void pause()
/*      */     throws SchedulerException
/*      */   {
/*  239 */     standby();
/*      */   }
/*      */ 
/*      */   public boolean isInStandbyMode()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  249 */       return getRemoteScheduler().isInStandbyMode(); } catch (RemoteException re) {
/*      */     }
/*  251 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public boolean isPaused()
/*      */     throws SchedulerException
/*      */   {
/*  257 */     return isInStandbyMode();
/*      */   }
/*      */ 
/*      */   public void shutdown()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  266 */       getRemoteScheduler().shutdown();
/*      */     } catch (RemoteException re) {
/*  268 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void shutdown(boolean waitForJobsToComplete)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  281 */       getRemoteScheduler().shutdown(waitForJobsToComplete);
/*      */     } catch (RemoteException re) {
/*  283 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean isShutdown()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  295 */       return getRemoteScheduler().isShutdown(); } catch (RemoteException re) {
/*      */     }
/*  297 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public List getCurrentlyExecutingJobs()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  309 */       return getRemoteScheduler().getCurrentlyExecutingJobs(); } catch (RemoteException re) {
/*      */     }
/*  311 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public Date scheduleJob(JobDetail jobDetail, Trigger trigger)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  332 */       return getRemoteScheduler().scheduleJob(this.schedCtxt, jobDetail, trigger);
/*      */     } catch (RemoteException re) {
/*      */     }
/*  335 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public Date scheduleJob(Trigger trigger)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  349 */       return getRemoteScheduler().scheduleJob(this.schedCtxt, trigger); } catch (RemoteException re) {
/*      */     }
/*  351 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public void addJob(JobDetail jobDetail, boolean replace)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  366 */       getRemoteScheduler().addJob(this.schedCtxt, jobDetail, replace);
/*      */     } catch (RemoteException re) {
/*  368 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean deleteJob(String jobName, String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  383 */       return getRemoteScheduler().deleteJob(this.schedCtxt, jobName, groupName);
/*      */     } catch (RemoteException re) {
/*      */     }
/*  386 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public boolean unscheduleJob(String triggerName, String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  401 */       return getRemoteScheduler().unscheduleJob(this.schedCtxt, triggerName, groupName);
/*      */     } catch (RemoteException re) {
/*      */     }
/*  404 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public Date rescheduleJob(String triggerName, String groupName, Trigger newTrigger)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  419 */       return getRemoteScheduler().rescheduleJob(this.schedCtxt, triggerName, groupName, newTrigger);
/*      */     } catch (RemoteException re) {
/*      */     }
/*  422 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public void triggerJob(String jobName, String groupName)
/*      */     throws SchedulerException
/*      */   {
/*  437 */     triggerJob(jobName, groupName, null);
/*      */   }
/*      */ 
/*      */   public void triggerJob(String jobName, String groupName, JobDataMap data)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  450 */       getRemoteScheduler().triggerJob(this.schedCtxt, jobName, groupName, data);
/*      */     } catch (RemoteException re) {
/*  452 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void triggerJobWithVolatileTrigger(String jobName, String groupName)
/*      */     throws SchedulerException
/*      */   {
/*  466 */     triggerJobWithVolatileTrigger(jobName, groupName, null);
/*      */   }
/*      */ 
/*      */   public void triggerJobWithVolatileTrigger(String jobName, String groupName, JobDataMap data)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  479 */       getRemoteScheduler().triggerJobWithVolatileTrigger(this.schedCtxt, jobName, groupName, data);
/*      */     }
/*      */     catch (RemoteException re) {
/*  482 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseTrigger(String triggerName, String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  497 */       getRemoteScheduler().pauseTrigger(this.schedCtxt, triggerName, groupName);
/*      */     }
/*      */     catch (RemoteException re) {
/*  500 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseTriggerGroup(String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  514 */       getRemoteScheduler().pauseTriggerGroup(this.schedCtxt, groupName);
/*      */     } catch (RemoteException re) {
/*  516 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseJob(String jobName, String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  531 */       getRemoteScheduler().pauseJob(this.schedCtxt, jobName, groupName);
/*      */     } catch (RemoteException re) {
/*  533 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseJobGroup(String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  547 */       getRemoteScheduler().pauseJobGroup(this.schedCtxt, groupName);
/*      */     } catch (RemoteException re) {
/*  549 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeTrigger(String triggerName, String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  564 */       getRemoteScheduler().resumeTrigger(this.schedCtxt, triggerName, groupName);
/*      */     }
/*      */     catch (RemoteException re) {
/*  567 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeTriggerGroup(String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  581 */       getRemoteScheduler().resumeTriggerGroup(this.schedCtxt, groupName);
/*      */     } catch (RemoteException re) {
/*  583 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeJob(String jobName, String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  598 */       getRemoteScheduler().resumeJob(this.schedCtxt, jobName, groupName);
/*      */     } catch (RemoteException re) {
/*  600 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeJobGroup(String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  614 */       getRemoteScheduler().resumeJobGroup(this.schedCtxt, groupName);
/*      */     } catch (RemoteException re) {
/*  616 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void pauseAll()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  630 */       getRemoteScheduler().pauseAll(this.schedCtxt);
/*      */     } catch (RemoteException re) {
/*  632 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void resumeAll()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  646 */       getRemoteScheduler().resumeAll(this.schedCtxt);
/*      */     } catch (RemoteException re) {
/*  648 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String[] getJobGroupNames()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  662 */       return getRemoteScheduler().getJobGroupNames(this.schedCtxt); } catch (RemoteException re) {
/*      */     }
/*  664 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public String[] getJobNames(String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  678 */       return getRemoteScheduler().getJobNames(this.schedCtxt, groupName); } catch (RemoteException re) {
/*      */     }
/*  680 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public Trigger[] getTriggersOfJob(String jobName, String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  695 */       return getRemoteScheduler().getTriggersOfJob(this.schedCtxt, jobName, groupName);
/*      */     } catch (RemoteException re) {
/*      */     }
/*  698 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public String[] getTriggerGroupNames()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  712 */       return getRemoteScheduler().getTriggerGroupNames(this.schedCtxt); } catch (RemoteException re) {
/*      */     }
/*  714 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public String[] getTriggerNames(String groupName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  728 */       return getRemoteScheduler().getTriggerNames(this.schedCtxt, groupName); } catch (RemoteException re) {
/*      */     }
/*  730 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public JobDetail getJobDetail(String jobName, String jobGroup)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  745 */       return getRemoteScheduler().getJobDetail(this.schedCtxt, jobName, jobGroup);
/*      */     } catch (RemoteException re) {
/*      */     }
/*  748 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public Trigger getTrigger(String triggerName, String triggerGroup)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  763 */       return getRemoteScheduler().getTrigger(this.schedCtxt, triggerName, triggerGroup);
/*      */     } catch (RemoteException re) {
/*      */     }
/*  766 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public int getTriggerState(String triggerName, String triggerGroup)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  781 */       return getRemoteScheduler().getTriggerState(this.schedCtxt, triggerName, triggerGroup);
/*      */     } catch (RemoteException re) {
/*      */     }
/*  784 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public void addCalendar(String calName, Calendar calendar, boolean replace, boolean updateTriggers)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  799 */       getRemoteScheduler().addCalendar(this.schedCtxt, calName, calendar, replace, updateTriggers);
/*      */     }
/*      */     catch (RemoteException re) {
/*  802 */       throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean deleteCalendar(String calName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  816 */       return getRemoteScheduler().deleteCalendar(this.schedCtxt, calName); } catch (RemoteException re) {
/*      */     }
/*  818 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public Calendar getCalendar(String calName)
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  832 */       return getRemoteScheduler().getCalendar(this.schedCtxt, calName); } catch (RemoteException re) {
/*      */     }
/*  834 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public String[] getCalendarNames()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/*  848 */       return getRemoteScheduler().getCalendarNames(this.schedCtxt); } catch (RemoteException re) {
/*      */     }
/*  850 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public void addGlobalJobListener(JobListener jobListener)
/*      */     throws SchedulerException
/*      */   {
/*  868 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public void addJobListener(JobListener jobListener)
/*      */     throws SchedulerException
/*      */   {
/*  880 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public boolean removeGlobalJobListener(JobListener jobListener)
/*      */     throws SchedulerException
/*      */   {
/*  892 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public boolean removeJobListener(String name)
/*      */     throws SchedulerException
/*      */   {
/*  903 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public List getGlobalJobListeners()
/*      */     throws SchedulerException
/*      */   {
/*  914 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public Set getJobListenerNames()
/*      */     throws SchedulerException
/*      */   {
/*  925 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public JobListener getJobListener(String name)
/*      */     throws SchedulerException
/*      */   {
/*  936 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public void addGlobalTriggerListener(TriggerListener triggerListener)
/*      */     throws SchedulerException
/*      */   {
/*  948 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public void addTriggerListener(TriggerListener triggerListener)
/*      */     throws SchedulerException
/*      */   {
/*  960 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public boolean removeGlobalTriggerListener(TriggerListener triggerListener)
/*      */     throws SchedulerException
/*      */   {
/*  972 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public boolean removeTriggerListener(String name)
/*      */     throws SchedulerException
/*      */   {
/*  983 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public List getGlobalTriggerListeners()
/*      */     throws SchedulerException
/*      */   {
/*  994 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public Set getTriggerListenerNames()
/*      */     throws SchedulerException
/*      */   {
/* 1005 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public TriggerListener getTriggerListener(String name)
/*      */     throws SchedulerException
/*      */   {
/* 1017 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public void addSchedulerListener(SchedulerListener schedulerListener)
/*      */     throws SchedulerException
/*      */   {
/* 1029 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public boolean removeSchedulerListener(SchedulerListener schedulerListener)
/*      */     throws SchedulerException
/*      */   {
/* 1041 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public List getSchedulerListeners()
/*      */     throws SchedulerException
/*      */   {
/* 1052 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ 
/*      */   public Set getPausedTriggerGroups()
/*      */     throws SchedulerException
/*      */   {
/*      */     try
/*      */     {
/* 1062 */       return getRemoteScheduler().getPausedTriggerGroups(this.schedCtxt); } catch (RemoteException re) {
/*      */     }
/* 1064 */     throw invalidateHandleCreateException("Error communicating with remote scheduler.", re);
/*      */   }
/*      */ 
/*      */   public boolean interrupt(String jobName, String groupName)
/*      */     throws UnableToInterruptJobException
/*      */   {
/*      */     try
/*      */     {
/* 1074 */       return getRemoteScheduler().interrupt(this.schedCtxt, jobName, groupName);
/*      */     } catch (RemoteException re) {
/* 1076 */       throw new UnableToInterruptJobException(invalidateHandleCreateException("Error communicating with remote scheduler.", re));
/*      */     } catch (SchedulerException se) {
/*      */     }
/* 1079 */     throw new UnableToInterruptJobException(se);
/*      */   }
/*      */ 
/*      */   public void setJobFactory(JobFactory factory)
/*      */     throws SchedulerException
/*      */   {
/* 1087 */     throw new SchedulerException("Operation not supported for remote schedulers.", 210);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.RemoteScheduler
 * JD-Core Version:    0.6.0
 */