/*      */ package org.quartz;
/*      */ 
/*      */ import java.io.PrintStream;
/*      */ import java.text.ParseException;
/*      */ import java.util.Date;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import java.util.SortedSet;
/*      */ import java.util.TimeZone;
/*      */ import java.util.TreeSet;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class UICronTrigger extends Trigger
/*      */ {
/*      */   public static final int MISFIRE_INSTRUCTION_FIRE_ONCE_NOW = 1;
/*      */   public static final int MISFIRE_INSTRUCTION_DO_NOTHING = 2;
/*      */   private static final int ALL_SPEC_INT = 99;
/*      */   private static final int NO_SPEC_INT = 98;
/*  188 */   private static final Integer ALL_SPEC = new Integer(99);
/*      */ 
/*  190 */   private static final Integer NO_SPEC = new Integer(98);
/*      */ 
/*  192 */   private static Map monthMap = new HashMap(20);
/*      */ 
/*  194 */   private static Map dayMap = new HashMap(60);
/*      */ 
/*  219 */   private Date startTime = null;
/*      */ 
/*  221 */   private Date endTime = null;
/*      */ 
/*  223 */   private Date nextFireTime = null;
/*      */ 
/*  225 */   private TimeZone timeZone = null;
/*      */ 
/*  227 */   private Date previousFireTime = null;
/*      */ 
/*  229 */   private TreeSet seconds = null;
/*      */ 
/*  231 */   private TreeSet minutes = null;
/*      */ 
/*  233 */   private TreeSet hours = null;
/*      */ 
/*  235 */   private TreeSet daysOfMonth = null;
/*      */ 
/*  237 */   private TreeSet months = null;
/*      */ 
/*  239 */   private TreeSet daysOfWeek = null;
/*      */ 
/*  241 */   private TreeSet years = null;
/*      */ 
/*  243 */   private transient boolean lastdayOfWeek = false;
/*      */ 
/*  245 */   private transient int nthdayOfWeek = 0;
/*      */ 
/*  247 */   private transient boolean lastdayOfMonth = false;
/*      */ 
/*  249 */   private transient boolean calendardayOfWeek = false;
/*      */ 
/*  251 */   private transient boolean calendardayOfMonth = false;
/*      */ 
/*      */   public void reset()
/*      */   {
/*  262 */     this.seconds = new TreeSet();
/*  263 */     this.minutes = new TreeSet();
/*  264 */     this.hours = new TreeSet();
/*  265 */     this.daysOfMonth = new TreeSet();
/*  266 */     this.months = new TreeSet();
/*  267 */     this.daysOfWeek = new TreeSet();
/*  268 */     this.years = new TreeSet();
/*      */ 
/*  271 */     this.seconds.add(new Integer(0));
/*      */ 
/*  273 */     this.minutes.add(ALL_SPEC);
/*  274 */     for (int i = 0; i < 60; i++) {
/*  275 */       this.minutes.add(new Integer(i));
/*      */     }
/*  277 */     this.hours.add(ALL_SPEC);
/*  278 */     for (int i = 0; i < 24; i++) {
/*  279 */       this.hours.add(new Integer(i));
/*      */     }
/*  281 */     this.daysOfMonth.add(ALL_SPEC);
/*  282 */     for (int i = 1; i <= 31; i++) {
/*  283 */       this.daysOfMonth.add(new Integer(i));
/*      */     }
/*  285 */     this.months.add(ALL_SPEC);
/*  286 */     for (int i = 1; i <= 12; i++) {
/*  287 */       this.months.add(new Integer(i));
/*      */     }
/*  289 */     this.daysOfWeek.add(NO_SPEC);
/*      */ 
/*  291 */     this.years.add(ALL_SPEC);
/*  292 */     for (int i = 1970; i <= 2099; i++) {
/*  293 */       this.years.add(new Integer(i));
/*      */     }
/*  295 */     this.startTime = new Date();
/*  296 */     setStartTime(this.startTime);
/*  297 */     setTimeZone(TimeZone.getDefault());
/*      */   }
/*      */ 
/*      */   public UICronTrigger()
/*      */   {
/*  307 */     reset();
/*      */   }
/*      */ 
/*      */   public UICronTrigger(String name, String group)
/*      */   {
/*  316 */     super(name, group);
/*  317 */     reset();
/*      */   }
/*      */ 
/*      */   public UICronTrigger(String name, String group, String jobName, String jobGroup)
/*      */   {
/*  328 */     super(name, group, jobName, jobGroup);
/*  329 */     reset();
/*      */   }
/*      */ 
/*      */   public Date getStartTime()
/*      */   {
/*  346 */     return this.startTime;
/*      */   }
/*      */ 
/*      */   public void setStartTime(Date startTime) {
/*  350 */     if (startTime == null) {
/*  351 */       throw new IllegalArgumentException("Start time cannot be null");
/*      */     }
/*  353 */     Date eTime = getEndTime();
/*  354 */     if ((eTime != null) && (startTime != null) && (eTime.before(startTime))) {
/*  355 */       throw new IllegalArgumentException("End time cannot be before start time");
/*      */     }
/*      */ 
/*  363 */     java.util.Calendar cl = java.util.Calendar.getInstance();
/*  364 */     cl.setTime(startTime);
/*  365 */     cl.set(14, 0);
/*      */ 
/*  367 */     this.startTime = cl.getTime();
/*      */   }
/*      */ 
/*      */   public Date getEndTime()
/*      */   {
/*  379 */     return this.endTime;
/*      */   }
/*      */ 
/*      */   public void setEndTime(Date endTime) {
/*  383 */     Date sTime = getStartTime();
/*  384 */     if ((sTime != null) && (endTime != null) && (sTime.after(endTime))) {
/*  385 */       throw new IllegalArgumentException("End time cannot be before start time");
/*      */     }
/*      */ 
/*  388 */     this.endTime = endTime;
/*      */   }
/*      */ 
/*      */   public Date getNextFireTime()
/*      */   {
/*  400 */     return this.nextFireTime;
/*      */   }
/*      */ 
/*      */   public void updateAfterMisfire(Calendar cal) {
/*  404 */     int instr = getMisfireInstruction();
/*      */ 
/*  406 */     if (instr == 0) {
/*  407 */       instr = 2;
/*      */     }
/*  409 */     if (instr == 2) {
/*  410 */       Date newFireTime = getFireTimeAfter(new Date());
/*      */ 
/*  412 */       while ((newFireTime != null) && (cal != null) && (!cal.isTimeIncluded(newFireTime.getTime()))) {
/*  413 */         newFireTime = getFireTimeAfter(newFireTime);
/*      */       }
/*      */ 
/*  416 */       setNextFireTime(newFireTime);
/*      */     }
/*  418 */     else if (instr == 1) {
/*  419 */       setNextFireTime(new Date());
/*      */     }
/*      */   }
/*      */ 
/*      */   public Date getPreviousFireTime() {
/*  424 */     return this.previousFireTime;
/*      */   }
/*      */ 
/*      */   public void setPreviousFireTime(Date previousFireTime)
/*      */   {
/*  437 */     this.previousFireTime = previousFireTime;
/*      */   }
/*      */ 
/*      */   public void setNextFireTime(Date nextFireTime)
/*      */   {
/*  447 */     this.nextFireTime = nextFireTime;
/*      */   }
/*      */ 
/*      */   public TimeZone getTimeZone()
/*      */   {
/*  457 */     return this.timeZone;
/*      */   }
/*      */ 
/*      */   public void setTimeZone(TimeZone timeZone)
/*      */   {
/*  467 */     this.timeZone = timeZone;
/*      */   }
/*      */ 
/*      */   public Date getFireTimeAfter(Date afterTime)
/*      */   {
/*  483 */     if (afterTime == null) afterTime = new Date();
/*      */ 
/*  485 */     if (this.startTime.after(afterTime)) {
/*  486 */       afterTime = new Date(this.startTime.getTime() - 1000L);
/*      */     }
/*  488 */     Date pot = getTimeAfter(afterTime);
/*  489 */     if ((this.endTime != null) && (pot != null) && (pot.after(this.endTime))) return null;
/*      */ 
/*  491 */     return pot;
/*      */   }
/*      */ 
/*      */   public Date getFinalFireTime()
/*      */   {
/*  506 */     if (this.endTime != null) return getTimeBefore(this.endTime);
/*      */ 
/*  508 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean mayFireAgain()
/*      */   {
/*  518 */     return getNextFireTime() != null;
/*      */   }
/*      */ 
/*      */   protected boolean validateMisfireInstruction(int misfireInstruction) {
/*  522 */     if (misfireInstruction < 0) {
/*  523 */       return false;
/*      */     }
/*  525 */     return misfireInstruction <= 2;
/*      */   }
/*      */ 
/*      */   public void updateAfterMisfire()
/*      */   {
/*  546 */     int instr = getMisfireInstruction();
/*      */ 
/*  548 */     if (instr == 0) {
/*  549 */       instr = 2;
/*      */     }
/*  551 */     if (instr == 2)
/*  552 */       setNextFireTime(getFireTimeAfter(new Date()));
/*  553 */     else if (instr == 1)
/*  554 */       setNextFireTime(new Date());
/*      */   }
/*      */ 
/*      */   public boolean willFireOn(java.util.Calendar test)
/*      */   {
/*  570 */     Integer second = new Integer(test.get(13));
/*  571 */     Integer minute = new Integer(test.get(12));
/*  572 */     Integer hour = new Integer(test.get(11));
/*  573 */     Integer day = new Integer(test.get(5));
/*  574 */     Integer month = new Integer(test.get(2));
/*      */ 
/*  582 */     return ((this.seconds.contains(second)) || (this.seconds.contains(ALL_SPEC))) && ((this.minutes.contains(minute)) || (this.minutes.contains(ALL_SPEC))) && ((this.hours.contains(hour)) || (this.hours.contains(ALL_SPEC))) && ((this.daysOfMonth.contains(day)) || (this.daysOfMonth.contains(ALL_SPEC))) && ((this.months.contains(month)) || (this.months.contains(ALL_SPEC)));
/*      */   }
/*      */ 
/*      */   public int executionComplete(JobExecutionContext context, JobExecutionException result)
/*      */   {
/*  610 */     if ((result != null) && (result.refireImmediately())) {
/*  611 */       return 1;
/*      */     }
/*  613 */     if ((result != null) && (result.refireImmediately())) {
/*  614 */       return 1;
/*      */     }
/*  616 */     if ((result != null) && (result.unscheduleFiringTrigger())) {
/*  617 */       return 2;
/*      */     }
/*  619 */     if ((result != null) && (result.unscheduleAllTriggers())) {
/*  620 */       return 4;
/*      */     }
/*  622 */     if (!mayFireAgain()) return 3;
/*      */ 
/*  624 */     return 0;
/*      */   }
/*      */ 
/*      */   public void triggered(Calendar calendar)
/*      */   {
/*  638 */     this.previousFireTime = this.nextFireTime;
/*  639 */     this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*      */ 
/*  642 */     while ((this.nextFireTime != null) && (calendar != null) && (!calendar.isTimeIncluded(this.nextFireTime.getTime())))
/*  643 */       this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*      */   }
/*      */ 
/*      */   public void updateWithNewCalendar(Calendar calendar, long misfireThreshold)
/*      */   {
/*  653 */     this.nextFireTime = getFireTimeAfter(this.previousFireTime);
/*      */ 
/*  655 */     Date now = new Date();
/*      */ 
/*  658 */     while ((this.nextFireTime != null) && (calendar != null) && (!calendar.isTimeIncluded(this.nextFireTime.getTime()))) {
/*  659 */       this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*      */     }
/*      */ 
/*  662 */     if ((this.nextFireTime != null) && (this.nextFireTime.before(now))) {
/*  663 */       long diff = now.getTime() - this.nextFireTime.getTime();
/*  664 */       if (diff >= misfireThreshold)
/*  665 */         this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Date computeFirstFireTime(Calendar calendar)
/*      */   {
/*  690 */     this.nextFireTime = getFireTimeAfter(new Date(this.startTime.getTime() - 1000L));
/*      */ 
/*  693 */     while ((this.nextFireTime != null) && (calendar != null) && (!calendar.isTimeIncluded(this.nextFireTime.getTime()))) {
/*  694 */       this.nextFireTime = getFireTimeAfter(this.nextFireTime);
/*      */     }
/*      */ 
/*  697 */     return this.nextFireTime;
/*      */   }
/*      */ 
/*      */   public String getExpressionSummary() {
/*  701 */     StringBuffer buf = new StringBuffer();
/*      */ 
/*  703 */     buf.append("seconds: ");
/*  704 */     buf.append(getExpressionSetSummary(this.seconds));
/*  705 */     buf.append("\n");
/*  706 */     buf.append("minutes: ");
/*  707 */     buf.append(getExpressionSetSummary(this.minutes));
/*  708 */     buf.append("\n");
/*  709 */     buf.append("hours: ");
/*  710 */     buf.append(getExpressionSetSummary(this.hours));
/*  711 */     buf.append("\n");
/*  712 */     buf.append("daysOfMonth: ");
/*  713 */     buf.append(getExpressionSetSummary(this.daysOfMonth));
/*  714 */     buf.append("\n");
/*  715 */     buf.append("months: ");
/*  716 */     buf.append(getExpressionSetSummary(this.months));
/*  717 */     buf.append("\n");
/*  718 */     buf.append("daysOfWeek: ");
/*  719 */     buf.append(getExpressionSetSummary(this.daysOfWeek));
/*  720 */     buf.append("\n");
/*  721 */     buf.append("lastdayOfWeek: ");
/*  722 */     buf.append(this.lastdayOfWeek);
/*  723 */     buf.append("\n");
/*  724 */     buf.append("lastdayOfMonth: ");
/*  725 */     buf.append(this.lastdayOfMonth);
/*  726 */     buf.append("\n");
/*  727 */     buf.append("calendardayOfWeek: ");
/*  728 */     buf.append(this.calendardayOfWeek);
/*  729 */     buf.append("\n");
/*  730 */     buf.append("calendardayOfMonth: ");
/*  731 */     buf.append(this.calendardayOfMonth);
/*  732 */     buf.append("\n");
/*  733 */     buf.append("years: ");
/*  734 */     buf.append(getExpressionSetSummary(this.years));
/*  735 */     buf.append("\n");
/*      */ 
/*  737 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   private String getExpressionSetSummary(Set set)
/*      */   {
/*  742 */     if (set.contains(NO_SPEC)) return "?";
/*  743 */     if (set.contains(ALL_SPEC)) return "*";
/*      */ 
/*  745 */     StringBuffer buf = new StringBuffer();
/*      */ 
/*  747 */     Iterator itr = set.iterator();
/*  748 */     boolean first = true;
/*  749 */     while (itr.hasNext()) {
/*  750 */       Integer iVal = (Integer)itr.next();
/*  751 */       String val = iVal.toString();
/*  752 */       if (!first) buf.append(",");
/*  753 */       buf.append(val);
/*  754 */       first = false;
/*      */     }
/*      */ 
/*  757 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   private Date getTimeAfter(Date afterTime)
/*      */   {
/*  767 */     java.util.Calendar cl = java.util.Calendar.getInstance(this.timeZone);
/*      */ 
/*  771 */     afterTime = new Date(afterTime.getTime() + 1000L);
/*      */ 
/*  773 */     cl.setTime(afterTime);
/*  774 */     cl.set(14, 0);
/*      */ 
/*  776 */     boolean gotOne = false;
/*      */ 
/*  779 */     while (!gotOne)
/*      */     {
/*  781 */       if ((this.endTime != null) && (cl.getTime().after(this.endTime))) return null;
/*      */ 
/*  783 */       SortedSet st = null;
/*  784 */       int t = 0;
/*      */ 
/*  786 */       int sec = cl.get(13);
/*  787 */       int min = cl.get(12);
/*      */ 
/*  790 */       st = this.seconds.tailSet(new Integer(sec));
/*  791 */       if ((st != null) && (st.size() != 0)) {
/*  792 */         sec = ((Integer)st.first()).intValue();
/*      */       } else {
/*  794 */         sec = ((Integer)this.seconds.first()).intValue();
/*  795 */         min++;
/*  796 */         cl.set(12, min);
/*      */       }
/*  798 */       cl.set(13, sec);
/*      */ 
/*  800 */       min = cl.get(12);
/*  801 */       int hr = cl.get(11);
/*  802 */       t = -1;
/*      */ 
/*  805 */       st = this.minutes.tailSet(new Integer(min));
/*  806 */       if ((st != null) && (st.size() != 0)) {
/*  807 */         t = min;
/*  808 */         min = ((Integer)st.first()).intValue();
/*      */       } else {
/*  810 */         min = ((Integer)this.minutes.first()).intValue();
/*  811 */         hr++;
/*      */       }
/*  813 */       if (min != t) {
/*  814 */         cl.set(13, 0);
/*  815 */         cl.set(12, min);
/*  816 */         cl.set(11, hr);
/*  817 */         continue;
/*      */       }
/*  819 */       cl.set(12, min);
/*      */ 
/*  821 */       hr = cl.get(11);
/*  822 */       int day = cl.get(5);
/*  823 */       t = -1;
/*      */ 
/*  826 */       st = this.hours.tailSet(new Integer(hr));
/*  827 */       if ((st != null) && (st.size() != 0)) {
/*  828 */         t = hr;
/*  829 */         hr = ((Integer)st.first()).intValue();
/*      */       } else {
/*  831 */         hr = ((Integer)this.hours.first()).intValue();
/*  832 */         day++;
/*      */       }
/*  834 */       if (hr != t) {
/*  835 */         cl.set(13, 0);
/*  836 */         cl.set(12, 0);
/*  837 */         cl.set(11, hr);
/*  838 */         cl.set(5, day);
/*  839 */         continue;
/*      */       }
/*  841 */       cl.set(11, hr);
/*      */ 
/*  843 */       day = cl.get(5);
/*  844 */       int mon = cl.get(2) + 1;
/*      */ 
/*  847 */       t = -1;
/*      */ 
/*  850 */       boolean dayOfMSpec = !this.daysOfMonth.contains(NO_SPEC);
/*  851 */       boolean dayOfWSpec = !this.daysOfWeek.contains(NO_SPEC);
/*  852 */       if ((dayOfMSpec) && (!dayOfWSpec))
/*      */       {
/*  854 */         st = this.daysOfMonth.tailSet(new Integer(day));
/*  855 */         if (this.lastdayOfMonth) {
/*  856 */           t = day;
/*  857 */           day = getLastDayOfMonth(mon);
/*  858 */         } else if ((st != null) && (st.size() != 0)) {
/*  859 */           t = day;
/*  860 */           day = ((Integer)st.first()).intValue();
/*      */         } else {
/*  862 */           day = ((Integer)this.daysOfMonth.first()).intValue();
/*  863 */           mon++;
/*      */         }
/*  865 */         if (day != t) {
/*  866 */           cl.set(13, 0);
/*  867 */           cl.set(12, 0);
/*  868 */           cl.set(11, 0);
/*  869 */           cl.set(5, day);
/*  870 */           cl.set(2, mon - 1);
/*      */ 
/*  874 */           continue;
/*      */         }
/*  876 */       } else if ((dayOfWSpec) && (!dayOfMSpec))
/*      */       {
/*  878 */         if (this.lastdayOfWeek)
/*      */         {
/*  880 */           int dow = ((Integer)this.daysOfWeek.first()).intValue();
/*      */ 
/*  882 */           int cDow = cl.get(7);
/*  883 */           int daysToAdd = 0;
/*  884 */           if (cDow < dow) daysToAdd = dow - cDow;
/*  885 */           if (cDow > dow) daysToAdd = dow + (7 - cDow);
/*      */ 
/*  887 */           int lDay = getLastDayOfMonth(mon);
/*      */ 
/*  889 */           if (day + daysToAdd > lDay)
/*      */           {
/*  891 */             cl.set(13, 0);
/*  892 */             cl.set(12, 0);
/*  893 */             cl.set(11, 0);
/*  894 */             cl.set(5, 1);
/*  895 */             cl.set(2, mon);
/*      */ 
/*  898 */             continue;
/*      */           }
/*      */ 
/*  902 */           while (day + daysToAdd + 7 <= lDay) {
/*  903 */             daysToAdd += 7;
/*      */           }
/*  905 */           day += daysToAdd;
/*  906 */         } else if (this.nthdayOfWeek != 0)
/*      */         {
/*  908 */           int dow = ((Integer)this.daysOfWeek.first()).intValue();
/*      */ 
/*  910 */           int cDow = cl.get(7);
/*  911 */           int daysToAdd = 0;
/*  912 */           if (cDow < dow) daysToAdd = dow - cDow;
/*  913 */           else if (cDow > dow) daysToAdd = dow + (7 - cDow);
/*      */ 
/*  915 */           day += daysToAdd;
/*  916 */           int weekOfMonth = day / 7;
/*  917 */           if (day % 7 > 0) weekOfMonth++;
/*      */ 
/*  919 */           daysToAdd = (this.nthdayOfWeek - weekOfMonth) * 7;
/*  920 */           day += daysToAdd;
/*  921 */           if ((daysToAdd < 0) || (day > getLastDayOfMonth(mon))) {
/*  922 */             cl.set(13, 0);
/*  923 */             cl.set(12, 0);
/*  924 */             cl.set(11, 0);
/*  925 */             cl.set(5, 1);
/*  926 */             cl.set(2, mon);
/*      */ 
/*  929 */             continue;
/*      */           }
/*      */         } else {
/*  932 */           int cDow = cl.get(7);
/*  933 */           int dow = ((Integer)this.daysOfWeek.first()).intValue();
/*      */ 
/*  935 */           st = this.daysOfWeek.tailSet(new Integer(cDow));
/*  936 */           if ((st != null) && (st.size() > 0)) {
/*  937 */             dow = ((Integer)st.first()).intValue();
/*      */           }
/*      */ 
/*  940 */           int daysToAdd = 0;
/*  941 */           if (cDow < dow) daysToAdd = dow - cDow;
/*  942 */           if (cDow > dow) daysToAdd = dow + (7 - cDow);
/*      */ 
/*  944 */           int lDay = getLastDayOfMonth(mon);
/*      */ 
/*  946 */           if (day + daysToAdd > lDay)
/*      */           {
/*  948 */             cl.set(13, 0);
/*  949 */             cl.set(12, 0);
/*  950 */             cl.set(11, 0);
/*  951 */             cl.set(5, 1);
/*  952 */             cl.set(2, mon);
/*      */ 
/*  955 */             continue;
/*  956 */           }if (daysToAdd > 0) {
/*  957 */             cl.set(13, 0);
/*  958 */             cl.set(12, 0);
/*  959 */             cl.set(11, 0);
/*  960 */             cl.set(5, day + daysToAdd);
/*  961 */             cl.set(2, mon - 1);
/*      */ 
/*  965 */             continue;
/*      */           }
/*      */         }
/*      */       } else {
/*  969 */         throw new UnsupportedOperationException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.");
/*      */       }
/*      */ 
/*  972 */       cl.set(5, day);
/*      */ 
/*  974 */       mon = cl.get(2) + 1;
/*      */ 
/*  977 */       int year = cl.get(1);
/*  978 */       t = -1;
/*      */ 
/*  981 */       st = this.months.tailSet(new Integer(mon));
/*  982 */       if ((st != null) && (st.size() != 0)) {
/*  983 */         t = mon;
/*  984 */         mon = ((Integer)st.first()).intValue();
/*      */       } else {
/*  986 */         mon = ((Integer)this.months.first()).intValue();
/*  987 */         year++;
/*      */       }
/*  989 */       if (mon != t) {
/*  990 */         cl.set(13, 0);
/*  991 */         cl.set(12, 0);
/*  992 */         cl.set(11, 0);
/*  993 */         cl.set(5, 1);
/*  994 */         cl.set(2, mon - 1);
/*      */ 
/*  997 */         cl.set(1, year);
/*  998 */         continue;
/*      */       }
/* 1000 */       cl.set(2, mon - 1);
/*      */ 
/* 1004 */       year = cl.get(1);
/* 1005 */       t = -1;
/*      */ 
/* 1008 */       st = this.years.tailSet(new Integer(year));
/* 1009 */       if ((st != null) && (st.size() != 0)) {
/* 1010 */         t = year;
/* 1011 */         year = ((Integer)st.first()).intValue();
/*      */       } else {
/* 1013 */         return null;
/*      */       }
/* 1015 */       if (year != t) {
/* 1016 */         cl.set(13, 0);
/* 1017 */         cl.set(12, 0);
/* 1018 */         cl.set(11, 0);
/* 1019 */         cl.set(5, 1);
/* 1020 */         cl.set(2, mon - 1);
/*      */ 
/* 1023 */         cl.set(1, year);
/* 1024 */         continue;
/*      */       }
/* 1026 */       cl.set(1, year);
/*      */ 
/* 1028 */       gotOne = true;
/*      */     }
/*      */ 
/* 1031 */     return cl.getTime();
/*      */   }
/*      */ 
/*      */   private Date getTimeBefore(Date endTime)
/*      */   {
/* 1036 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean isLeapYear() {
/* 1040 */     java.util.Calendar cl = java.util.Calendar.getInstance(this.timeZone);
/* 1041 */     int year = cl.get(1);
/*      */ 
/* 1043 */     return ((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0);
/*      */   }
/*      */ 
/*      */   public int getLastDayOfMonth(int monthNum)
/*      */   {
/* 1050 */     switch (monthNum) {
/*      */     case 1:
/* 1052 */       return 31;
/*      */     case 2:
/* 1054 */       return isLeapYear() ? 29 : 28;
/*      */     case 3:
/* 1056 */       return 31;
/*      */     case 4:
/* 1058 */       return 30;
/*      */     case 5:
/* 1060 */       return 31;
/*      */     case 6:
/* 1062 */       return 30;
/*      */     case 7:
/* 1064 */       return 31;
/*      */     case 8:
/* 1066 */       return 31;
/*      */     case 9:
/* 1068 */       return 30;
/*      */     case 10:
/* 1070 */       return 31;
/*      */     case 11:
/* 1072 */       return 30;
/*      */     case 12:
/* 1074 */       return 31;
/*      */     }
/* 1076 */     throw new IllegalArgumentException("Illegal month number: " + monthNum);
/*      */   }
/*      */ 
/*      */   public Integer[] getSecondsValues()
/*      */   {
/* 1082 */     Integer[] list = new Integer[60];
/* 1083 */     for (int i = 0; i < 60; i++) {
/* 1084 */       list[i] = new Integer(i);
/*      */     }
/*      */ 
/* 1087 */     return list;
/*      */   }
/*      */ 
/*      */   public Integer[] getSecondsLabels() {
/* 1091 */     return getSecondsValues();
/*      */   }
/*      */ 
/*      */   public Integer[] getSeconds() {
/* 1095 */     Integer[] list = new Integer[this.seconds.size()];
/* 1096 */     if (this.seconds != null) {
/* 1097 */       int i = 0;
/* 1098 */       for (Iterator it = this.seconds.iterator(); it.hasNext(); i++) {
/* 1099 */         list[i] = ((Integer)it.next());
/*      */       }
/*      */     }
/* 1102 */     return list;
/*      */   }
/*      */ 
/*      */   public void setSeconds(Integer[] val) {
/* 1106 */     if (this.seconds != null) this.seconds.clear();
/*      */     else {
/* 1108 */       this.seconds = new TreeSet();
/*      */     }
/* 1110 */     for (int i = 0; i < val.length; i++)
/* 1111 */       this.seconds.add(val[i]);
/*      */   }
/*      */ 
/*      */   public Integer[] getMinutesValues()
/*      */   {
/* 1116 */     Integer[] list = new Integer[60];
/* 1117 */     for (int i = 0; i < 60; i++) {
/* 1118 */       list[i] = new Integer(i);
/*      */     }
/*      */ 
/* 1121 */     return list;
/*      */   }
/*      */ 
/*      */   public Integer[] getMinutesLabels() {
/* 1125 */     return getMinutesValues();
/*      */   }
/*      */ 
/*      */   public Integer[] getMinutes() {
/* 1129 */     Integer[] list = new Integer[this.minutes.size()];
/* 1130 */     if (this.minutes != null) {
/* 1131 */       int i = 0;
/* 1132 */       for (Iterator it = this.minutes.iterator(); it.hasNext(); i++) {
/* 1133 */         list[i] = ((Integer)it.next());
/*      */       }
/*      */     }
/* 1136 */     return list;
/*      */   }
/*      */ 
/*      */   public void setMinutes(Integer[] val) {
/* 1140 */     if (this.minutes != null) this.minutes.clear();
/*      */     else {
/* 1142 */       this.minutes = new TreeSet();
/*      */     }
/* 1144 */     for (int i = 0; i < val.length; i++)
/* 1145 */       this.minutes.add(val[i]);
/*      */   }
/*      */ 
/*      */   public Integer[] getHoursValues()
/*      */   {
/* 1150 */     Integer[] list = new Integer[24];
/* 1151 */     for (int i = 0; i < 24; i++) {
/* 1152 */       list[i] = new Integer(i);
/*      */     }
/*      */ 
/* 1155 */     return list;
/*      */   }
/*      */ 
/*      */   public String[] getHoursLabels() {
/* 1159 */     String[] vals = { "12AM (Midnight)", "1AM", "2AM", "3AM", "4AM", "5AM", "6AM", "7AM", "8AM", "9AM", "10AM", "11AM", "12PM (Noon)", "1PM", "2PM", "3PM", "4PM", "5PM", "6PM", "7PM", "8PM", "9PM", "10PM", "11PM" };
/*      */ 
/* 1163 */     return vals;
/*      */   }
/*      */ 
/*      */   public Integer[] getHours() {
/* 1167 */     Integer[] list = new Integer[this.hours.size()];
/* 1168 */     if (this.hours != null) {
/* 1169 */       int i = 0;
/* 1170 */       for (Iterator it = this.hours.iterator(); it.hasNext(); i++) {
/* 1171 */         list[i] = ((Integer)it.next());
/*      */       }
/*      */     }
/* 1174 */     return list;
/*      */   }
/*      */ 
/*      */   public void setHours(Integer[] val) {
/* 1178 */     if (this.hours != null) this.hours.clear();
/*      */     else {
/* 1180 */       this.hours = new TreeSet();
/*      */     }
/* 1182 */     for (int i = 0; i < val.length; i++)
/* 1183 */       this.hours.add(val[i]);
/*      */   }
/*      */ 
/*      */   public Integer[] getDaysOfMonthValues()
/*      */   {
/* 1188 */     Integer[] list = new Integer[31];
/* 1189 */     for (int i = 0; i < 31; i++) {
/* 1190 */       list[i] = new Integer(i + 1);
/*      */     }
/*      */ 
/* 1193 */     return list;
/*      */   }
/*      */ 
/*      */   public Integer[] getDaysOfMonthLabels() {
/* 1197 */     return getDaysOfMonthValues();
/*      */   }
/*      */ 
/*      */   public Integer[] getDaysOfMonth() {
/* 1201 */     Integer[] list = new Integer[this.daysOfMonth.size()];
/* 1202 */     if (this.daysOfMonth != null) {
/* 1203 */       int i = 0;
/* 1204 */       for (Iterator it = this.daysOfMonth.iterator(); it.hasNext(); i++) {
/* 1205 */         list[i] = ((Integer)it.next());
/*      */       }
/*      */     }
/* 1208 */     return list;
/*      */   }
/*      */ 
/*      */   public void setDaysOfMonth(Integer[] val) {
/* 1212 */     if (this.daysOfMonth != null) this.daysOfMonth.clear();
/*      */     else {
/* 1214 */       this.daysOfMonth = new TreeSet();
/*      */     }
/* 1216 */     for (int i = 0; i < val.length; i++) {
/* 1217 */       this.daysOfMonth.add(val[i]);
/*      */     }
/* 1219 */     this.daysOfWeek.clear();
/* 1220 */     this.daysOfWeek.add(NO_SPEC);
/*      */   }
/*      */ 
/*      */   public Integer[] getMonthsValues() {
/* 1224 */     Integer[] list = new Integer[12];
/* 1225 */     for (int i = 0; i < 12; i++) {
/* 1226 */       list[i] = new Integer(i + 1);
/*      */     }
/*      */ 
/* 1229 */     return list;
/*      */   }
/*      */ 
/*      */   public String[] getMonthsLabels() {
/* 1233 */     String[] vals = { "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" };
/*      */ 
/* 1236 */     return vals;
/*      */   }
/*      */ 
/*      */   public Integer[] getMonths() {
/* 1240 */     Integer[] list = new Integer[this.months.size()];
/* 1241 */     if (this.months != null) {
/* 1242 */       int i = 0;
/* 1243 */       for (Iterator it = this.months.iterator(); it.hasNext(); i++) {
/* 1244 */         list[i] = ((Integer)it.next());
/*      */       }
/*      */     }
/* 1247 */     return list;
/*      */   }
/*      */ 
/*      */   public void setMonths(Integer[] val) {
/* 1251 */     if (this.months != null) this.months.clear();
/*      */     else {
/* 1253 */       this.months = new TreeSet();
/*      */     }
/* 1255 */     for (int i = 0; i < val.length; i++)
/* 1256 */       this.months.add(val[i]);
/*      */   }
/*      */ 
/*      */   public String[] getDaysOfWeekLabels()
/*      */   {
/* 1261 */     String[] list = { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" };
/*      */ 
/* 1263 */     return list;
/*      */   }
/*      */ 
/*      */   public Integer[] getDaysOfWeekValues() {
/* 1267 */     Integer[] list = new Integer[7];
/* 1268 */     for (int i = 0; i < 7; i++)
/* 1269 */       list[i] = new Integer(i + 1);
/* 1270 */     return list;
/*      */   }
/*      */ 
/*      */   public Integer[] getDaysOfWeek() {
/* 1274 */     Integer[] list = new Integer[this.daysOfWeek.size()];
/* 1275 */     if (this.daysOfWeek != null) {
/* 1276 */       int i = 0;
/* 1277 */       for (Iterator it = this.daysOfWeek.iterator(); it.hasNext(); i++) {
/* 1278 */         list[i] = ((Integer)it.next());
/*      */       }
/*      */     }
/* 1281 */     return list;
/*      */   }
/*      */ 
/*      */   public void setDaysOfWeek(Integer[] val) {
/* 1285 */     if (this.daysOfWeek != null) this.daysOfWeek.clear();
/*      */     else {
/* 1287 */       this.daysOfWeek = new TreeSet();
/*      */     }
/* 1289 */     for (int i = 0; i < val.length; i++) {
/* 1290 */       this.daysOfWeek.add(val[i]);
/*      */     }
/*      */ 
/* 1293 */     this.daysOfMonth.clear();
/* 1294 */     this.daysOfMonth.add(NO_SPEC);
/*      */   }
/*      */ 
/*      */   public Integer[] getYearsValues() {
/* 1298 */     Integer[] list = new Integer[20];
/* 1299 */     java.util.Calendar now = java.util.Calendar.getInstance();
/* 1300 */     int year = now.get(1);
/* 1301 */     for (int i = 0; i < 20; i++) {
/* 1302 */       list[i] = new Integer(i + year);
/*      */     }
/*      */ 
/* 1305 */     return list;
/*      */   }
/*      */ 
/*      */   public Integer[] getYearsLabels() {
/* 1309 */     return getYearsValues();
/*      */   }
/*      */ 
/*      */   public Integer[] getYears() {
/* 1313 */     Integer[] list = new Integer[this.years.size()];
/* 1314 */     if (this.years != null) {
/* 1315 */       int i = 0;
/* 1316 */       for (Iterator it = this.years.iterator(); it.hasNext(); i++) {
/* 1317 */         list[i] = ((Integer)it.next());
/*      */       }
/*      */     }
/* 1320 */     return list;
/*      */   }
/*      */ 
/*      */   public void setYears(Integer[] val) {
/* 1324 */     if (this.years != null) this.years.clear();
/*      */     else {
/* 1326 */       this.years = new TreeSet();
/*      */     }
/* 1328 */     for (int i = 0; i < val.length; i++)
/* 1329 */       this.years.add(val[i]);
/*      */   }
/*      */ 
/*      */   public static void main(String[] argv)
/*      */   {
/* 1334 */     CronTrigger ct = new CronTrigger("a", "a");
/*      */     try {
/* 1336 */       ct.setCronExpression("0 * * * * ? *");
/*      */     }
/*      */     catch (ParseException e) {
/*      */     }
/* 1340 */     ct.setStartTime(new Date());
/* 1341 */     ct.setTimeZone(TimeZone.getDefault());
/* 1342 */     System.out.println(ct.getExpressionSummary());
/* 1343 */     ct.computeFirstFireTime(null);
/*      */ 
/* 1345 */     UICronTrigger uict = new UICronTrigger("a", "a");
/* 1346 */     Integer[] set = new Integer[1];
/* 1347 */     set[0] = new Integer(1);
/* 1348 */     uict.setSeconds(set);
/* 1349 */     System.out.println(ct.getExpressionSummary());
/* 1350 */     uict.computeFirstFireTime(null);
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  197 */     monthMap.put("JAN", new Integer(0));
/*  198 */     monthMap.put("FEB", new Integer(1));
/*  199 */     monthMap.put("MAR", new Integer(2));
/*  200 */     monthMap.put("APR", new Integer(3));
/*  201 */     monthMap.put("MAY", new Integer(4));
/*  202 */     monthMap.put("JUN", new Integer(5));
/*  203 */     monthMap.put("JUL", new Integer(6));
/*  204 */     monthMap.put("AUG", new Integer(7));
/*  205 */     monthMap.put("SEP", new Integer(8));
/*  206 */     monthMap.put("OCT", new Integer(9));
/*  207 */     monthMap.put("NOV", new Integer(10));
/*  208 */     monthMap.put("DEC", new Integer(11));
/*      */ 
/*  210 */     dayMap.put("SUN", new Integer(1));
/*  211 */     dayMap.put("MON", new Integer(2));
/*  212 */     dayMap.put("TUE", new Integer(3));
/*  213 */     dayMap.put("WED", new Integer(4));
/*  214 */     dayMap.put("THU", new Integer(5));
/*  215 */     dayMap.put("FRI", new Integer(6));
/*  216 */     dayMap.put("SAT", new Integer(7));
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.UICronTrigger
 * JD-Core Version:    0.6.0
 */