/*     */ package org.quartz;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class SchedulerException extends Exception
/*     */ {
/*     */   public static final int ERR_UNSPECIFIED = 0;
/*     */   public static final int ERR_BAD_CONFIGURATION = 50;
/*     */   public static final int ERR_TIME_BROKER_FAILURE = 70;
/*     */   public static final int ERR_CLIENT_ERROR = 100;
/*     */   public static final int ERR_COMMUNICATION_FAILURE = 200;
/*     */   public static final int ERR_UNSUPPORTED_FUNCTION_IN_THIS_CONFIGURATION = 210;
/*     */   public static final int ERR_PERSISTENCE = 400;
/*     */   public static final int ERR_PERSISTENCE_JOB_DOES_NOT_EXIST = 410;
/*     */   public static final int ERR_PERSISTENCE_CALENDAR_DOES_NOT_EXIST = 420;
/*     */   public static final int ERR_PERSISTENCE_TRIGGER_DOES_NOT_EXIST = 430;
/*     */   public static final int ERR_PERSISTENCE_CRITICAL_FAILURE = 499;
/*     */   public static final int ERR_THREAD_POOL = 500;
/*     */   public static final int ERR_THREAD_POOL_EXHAUSTED = 510;
/*     */   public static final int ERR_THREAD_POOL_CRITICAL_FAILURE = 599;
/*     */   public static final int ERR_JOB_LISTENER = 600;
/*     */   public static final int ERR_JOB_LISTENER_NOT_FOUND = 610;
/*     */   public static final int ERR_TRIGGER_LISTENER = 700;
/*     */   public static final int ERR_TRIGGER_LISTENER_NOT_FOUND = 710;
/*     */   public static final int ERR_JOB_EXECUTION_THREW_EXCEPTION = 800;
/*     */   public static final int ERR_TRIGGER_THREW_EXCEPTION = 850;
/*     */   private Exception cause;
/*  99 */   private int errorCode = 0;
/*     */ 
/*     */   public SchedulerException()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SchedulerException(String msg)
/*     */   {
/* 114 */     super(msg);
/*     */   }
/*     */ 
/*     */   public SchedulerException(String msg, int errorCode) {
/* 118 */     super(msg);
/* 119 */     setErrorCode(errorCode);
/*     */   }
/*     */ 
/*     */   public SchedulerException(Exception cause) {
/* 123 */     super(cause.toString());
/* 124 */     this.cause = cause;
/*     */   }
/*     */ 
/*     */   public SchedulerException(String msg, Exception cause) {
/* 128 */     super(msg);
/* 129 */     this.cause = cause;
/*     */   }
/*     */ 
/*     */   public SchedulerException(String msg, Exception cause, int errorCode) {
/* 133 */     super(msg);
/* 134 */     this.cause = cause;
/* 135 */     setErrorCode(errorCode);
/*     */   }
/*     */ 
/*     */   public Throwable getUnderlyingException()
/*     */   {
/* 159 */     return this.cause;
/*     */   }
/*     */ 
/*     */   public int getErrorCode()
/*     */   {
/* 174 */     return this.errorCode;
/*     */   }
/*     */ 
/*     */   public void setErrorCode(int errorCode)
/*     */   {
/* 190 */     this.errorCode = errorCode;
/*     */   }
/*     */ 
/*     */   public boolean isPersistenceError()
/*     */   {
/* 200 */     return (this.errorCode >= 400) && (this.errorCode <= 499);
/*     */   }
/*     */ 
/*     */   public boolean isThreadPoolError()
/*     */   {
/* 210 */     return (this.errorCode >= 500) && (this.errorCode <= 599);
/*     */   }
/*     */ 
/*     */   public boolean isJobListenerError()
/*     */   {
/* 220 */     return (this.errorCode >= 600) && (this.errorCode <= 699);
/*     */   }
/*     */ 
/*     */   public boolean isTriggerListenerError()
/*     */   {
/* 230 */     return (this.errorCode >= 700) && (this.errorCode <= 799);
/*     */   }
/*     */ 
/*     */   public boolean isClientError()
/*     */   {
/* 240 */     return (this.errorCode >= 100) && (this.errorCode <= 199);
/*     */   }
/*     */ 
/*     */   public boolean isConfigurationError()
/*     */   {
/* 250 */     return (this.errorCode >= 50) && (this.errorCode <= 99);
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 254 */     if (this.cause == null) return super.toString();
/*     */ 
/* 256 */     return super.toString() + " [See nested exception: " + this.cause.toString() + "]";
/*     */   }
/*     */ 
/*     */   public void printStackTrace()
/*     */   {
/* 271 */     printStackTrace(System.err);
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintStream out)
/*     */   {
/* 288 */     super.printStackTrace(out);
/* 289 */     if (this.cause != null)
/* 290 */       synchronized (out) {
/* 291 */         out.println("* Nested Exception (Underlying Cause) ---------------");
/*     */ 
/* 293 */         this.cause.printStackTrace(out);
/*     */       }
/*     */   }
/*     */ 
/*     */   public void printStackTrace(PrintWriter out)
/*     */   {
/* 312 */     super.printStackTrace(out);
/* 313 */     if (this.cause != null)
/* 314 */       synchronized (out) {
/* 315 */         out.println("* Nested Exception (Underlying Cause) ---------------");
/*     */ 
/* 317 */         this.cause.printStackTrace(out);
/*     */       }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.SchedulerException
 * JD-Core Version:    0.6.0
 */