/*     */ package org.quartz;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import org.quartz.spi.TriggerFiredBundle;
/*     */ 
/*     */ public class JobExecutionContext
/*     */   implements Serializable
/*     */ {
/*     */   private transient Scheduler scheduler;
/*     */   private Trigger trigger;
/*     */   private JobDetail jobDetail;
/*     */   private JobDataMap jobDataMap;
/*     */   private transient Job job;
/*     */   private Calendar calendar;
/*  93 */   private boolean recovering = false;
/*     */ 
/*  95 */   private int numRefires = 0;
/*     */   private Date fireTime;
/*     */   private Date scheduledFireTime;
/*     */   private Date prevFireTime;
/*     */   private Date nextFireTime;
/* 105 */   private long jobRunTime = -1L;
/*     */   private Object result;
/* 109 */   private HashMap data = new HashMap();
/*     */ 
/*     */   public JobExecutionContext(Scheduler scheduler, TriggerFiredBundle firedBundle, Job job)
/*     */   {
/* 126 */     this.scheduler = scheduler;
/* 127 */     this.trigger = firedBundle.getTrigger();
/* 128 */     this.calendar = firedBundle.getCalendar();
/* 129 */     this.jobDetail = firedBundle.getJobDetail();
/* 130 */     this.job = job;
/* 131 */     this.recovering = firedBundle.isRecovering();
/* 132 */     this.fireTime = firedBundle.getFireTime();
/* 133 */     this.scheduledFireTime = firedBundle.getScheduledFireTime();
/* 134 */     this.prevFireTime = firedBundle.getPrevFireTime();
/* 135 */     this.nextFireTime = firedBundle.getNextFireTime();
/*     */ 
/* 137 */     this.jobDataMap = new JobDataMap();
/* 138 */     this.jobDataMap.putAll(this.jobDetail.getJobDataMap());
/* 139 */     this.jobDataMap.putAll(this.trigger.getJobDataMap());
/*     */ 
/* 141 */     this.jobDataMap.setMutable(false);
/* 142 */     this.trigger.getJobDataMap().setMutable(false);
/*     */   }
/*     */ 
/*     */   public Scheduler getScheduler()
/*     */   {
/* 160 */     return this.scheduler;
/*     */   }
/*     */ 
/*     */   public Trigger getTrigger()
/*     */   {
/* 170 */     return this.trigger;
/*     */   }
/*     */ 
/*     */   public Calendar getCalendar()
/*     */   {
/* 180 */     return this.calendar;
/*     */   }
/*     */ 
/*     */   public boolean isRecovering()
/*     */   {
/* 190 */     return this.recovering;
/*     */   }
/*     */ 
/*     */   public void incrementRefireCount() {
/* 194 */     this.numRefires += 1;
/*     */   }
/*     */ 
/*     */   public int getRefireCount() {
/* 198 */     return this.numRefires;
/*     */   }
/*     */ 
/*     */   public JobDataMap getMergedJobDataMap()
/*     */   {
/* 227 */     return this.jobDataMap;
/*     */   }
/*     */ 
/*     */   public JobDetail getJobDetail()
/*     */   {
/* 236 */     return this.jobDetail;
/*     */   }
/*     */ 
/*     */   public Job getJobInstance()
/*     */   {
/* 251 */     return this.job;
/*     */   }
/*     */ 
/*     */   public Date getFireTime()
/*     */   {
/* 263 */     return this.fireTime;
/*     */   }
/*     */ 
/*     */   public Date getScheduledFireTime()
/*     */   {
/* 275 */     return this.scheduledFireTime;
/*     */   }
/*     */ 
/*     */   public Date getPreviousFireTime() {
/* 279 */     return this.prevFireTime;
/*     */   }
/*     */ 
/*     */   public Date getNextFireTime() {
/* 283 */     return this.nextFireTime;
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 287 */     return "JobExecutionContext: trigger: '" + getTrigger().getFullName() + " job: " + getJobDetail().getFullName() + " fireTime: '" + getFireTime() + " scheduledFireTime: " + getScheduledFireTime() + " previousFireTime: '" + getPreviousFireTime() + " nextFireTime: " + getNextFireTime() + " isRecovering: " + isRecovering() + " refireCount: " + getRefireCount();
/*     */   }
/*     */ 
/*     */   public Object getResult()
/*     */   {
/* 311 */     return this.result;
/*     */   }
/*     */ 
/*     */   public void setResult(Object result)
/*     */   {
/* 328 */     this.result = result;
/*     */   }
/*     */ 
/*     */   public long getJobRunTime()
/*     */   {
/* 340 */     return this.jobRunTime;
/*     */   }
/*     */ 
/*     */   public void setJobRunTime(long jobRunTime)
/*     */   {
/* 347 */     this.jobRunTime = jobRunTime;
/*     */   }
/*     */ 
/*     */   public void put(Object key, Object value)
/*     */   {
/* 362 */     this.data.put(key, value);
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 371 */     return this.data.get(key);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.JobExecutionContext
 * JD-Core Version:    0.6.0
 */