package org.hsqldb.types;

import java.io.Serializable;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.InOutUtil;

public class JavaObject
{
  private byte[] data;

  public JavaObject(byte[] paramArrayOfByte)
  {
    this.data = paramArrayOfByte;
  }

  public JavaObject(Serializable paramSerializable)
    throws HsqlException
  {
    try
    {
      this.data = InOutUtil.serialize(paramSerializable);
    }
    catch (Exception localException)
    {
      throw Trace.error(18, localException.getMessage());
    }
  }

  public byte[] getBytes()
  {
    return this.data;
  }

  public int getBytesLength()
  {
    return this.data.length;
  }

  public Serializable getObject()
    throws HsqlException
  {
    try
    {
      return InOutUtil.deserialize(this.data);
    }
    catch (Exception localException)
    {
    }
    throw Trace.error(18, localException.getMessage());
  }

  public String toString()
  {
    return super.toString();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.types.JavaObject
 * JD-Core Version:    0.6.0
 */