package org.hsqldb.types;

import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;

public class Binary
{
  private byte[] data;
  int hash;

  public Binary(byte[] paramArrayOfByte, boolean paramBoolean)
  {
    if (paramBoolean)
      paramArrayOfByte = (byte[])ArrayUtil.duplicateArray(paramArrayOfByte);
    this.data = paramArrayOfByte;
  }

  public byte[] getBytes()
  {
    return this.data;
  }

  public byte[] getClonedBytes()
  {
    return (byte[])this.data.clone();
  }

  public int getBytesLength()
  {
    return this.data.length;
  }

  public boolean equals(Object paramObject)
  {
    if (paramObject == this)
      return true;
    if (!(paramObject instanceof Binary))
      return false;
    if (this.data.length != ((Binary)paramObject).data.length)
      return false;
    return ArrayUtil.containsAt(this.data, 0, ((Binary)paramObject).data);
  }

  public int hashCode()
  {
    int i = 0;
    if (this.hash == 0)
    {
      for (int j = 0; j < this.data.length; j++)
        i = 31 * i + this.data[j];
      this.hash = i;
    }
    return this.hash;
  }

  public String toString()
  {
    return StringConverter.byteToHex(this.data);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.types.Binary
 * JD-Core Version:    0.6.0
 */