package org.hsqldb.store;

import java.math.BigDecimal;
import java.sql.Date;

public class ValuePool
{
  static ValuePoolHashMap intPool;
  static ValuePoolHashMap longPool;
  static ValuePoolHashMap doublePool;
  static ValuePoolHashMap bigdecimalPool;
  static ValuePoolHashMap stringPool;
  static ValuePoolHashMap datePool;
  static final int DEFAULT_VALUE_POOL_SIZE = 10000;
  static final int[] defaultPoolLookupSize = { 10000, 10000, 10000, 10000, 10000, 10000 };
  static final int POOLS_COUNT = defaultPoolLookupSize.length;
  static final int defaultSizeFactor = 2;
  static final int defaultMaxStringLength = 16;
  static ValuePoolHashMap[] poolList;
  static int maxStringLength;

  private static void initPool()
  {
    int[] arrayOfInt = defaultPoolLookupSize;
    int i = 2;
    synchronized (ValuePool.class)
    {
      maxStringLength = 16;
      poolList = new ValuePoolHashMap[POOLS_COUNT];
      for (int j = 0; j < POOLS_COUNT; j++)
      {
        int k = arrayOfInt[j];
        poolList[j] = new ValuePoolHashMap(k, k * i, 2);
      }
      intPool = poolList[0];
      longPool = poolList[1];
      doublePool = poolList[2];
      bigdecimalPool = poolList[3];
      stringPool = poolList[4];
      datePool = poolList[5];
    }
  }

  public static void resetPool(int[] paramArrayOfInt, int paramInt)
  {
    synchronized (ValuePool.class)
    {
      for (int i = 0; i < POOLS_COUNT; i++)
        poolList[i].resetCapacity(paramArrayOfInt[i] * paramInt, 2);
    }
  }

  public static void resetPool()
  {
    synchronized (ValuePool.class)
    {
      resetPool(defaultPoolLookupSize, 2);
    }
  }

  public static void clearPool()
  {
    synchronized (ValuePool.class)
    {
      for (int i = 0; i < POOLS_COUNT; i++)
        poolList[i].clear();
    }
  }

  public static Integer getInt(int paramInt)
  {
    synchronized (intPool)
    {
      return intPool.getOrAddInteger(paramInt);
    }
  }

  public static Long getLong(long paramLong)
  {
    synchronized (longPool)
    {
      return longPool.getOrAddLong(paramLong);
    }
  }

  public static Double getDouble(long paramLong)
  {
    synchronized (doublePool)
    {
      return doublePool.getOrAddDouble(paramLong);
    }
  }

  public static String getString(String paramString)
  {
    if ((paramString == null) || (paramString.length() > maxStringLength))
      return paramString;
    synchronized (stringPool)
    {
      return stringPool.getOrAddString(paramString);
    }
  }

  public static Date getDate(long paramLong)
  {
    synchronized (datePool)
    {
      return datePool.getOrAddDate(paramLong);
    }
  }

  public static BigDecimal getBigDecimal(BigDecimal paramBigDecimal)
  {
    if (paramBigDecimal == null)
      return paramBigDecimal;
    synchronized (bigdecimalPool)
    {
      return (BigDecimal)bigdecimalPool.getOrAddObject(paramBigDecimal);
    }
  }

  public static Boolean getBoolean(boolean paramBoolean)
  {
    return paramBoolean ? Boolean.TRUE : Boolean.FALSE;
  }

  static
  {
    initPool();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.store.ValuePool
 * JD-Core Version:    0.6.0
 */