package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileAccess;

class ScriptWriterZipped extends ScriptWriterBinary
{
  private static final int bufferSize = 32768;

  ScriptWriterZipped(Database paramDatabase, String paramString, boolean paramBoolean1, boolean paramBoolean2)
    throws HsqlException
  {
    super(paramDatabase, paramString, paramBoolean1, paramBoolean2);
  }

  public void sync()
  {
  }

  protected void openFile()
    throws HsqlException
  {
    try
    {
      FileAccess localFileAccess = this.database.getFileAccess();
      OutputStream localOutputStream = localFileAccess.openOutputStreamElement(this.outFile);
      this.outDescriptor = localFileAccess.getFileSync(localOutputStream);
      this.fileStreamOut = new DeflaterOutputStream(localOutputStream, new Deflater(-1), 32768);
    }
    catch (IOException localIOException)
    {
      throw Trace.error(29, 115, new Object[] { localIOException.toString(), this.outFile });
    }
  }

  protected void finishStream()
    throws IOException
  {
    ((DeflaterOutputStream)this.fileStreamOut).finish();
    this.fileStreamOut.flush();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.scriptio.ScriptWriterZipped
 * JD-Core Version:    0.6.0
 */