package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseScript;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager.HsqlName;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileAccess.FileSync;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;

public abstract class ScriptWriterBase
  implements Runnable
{
  Database database;
  String outFile;
  OutputStream fileStreamOut;
  FileAccess.FileSync outDescriptor;
  int tableRowCount;
  HsqlNameManager.HsqlName schemaToLog;
  boolean isDump;
  boolean includeCachedData;
  long byteCount;
  volatile boolean needsSync;
  volatile boolean forceSync;
  volatile boolean busyWriting;
  private int syncCount;
  static final int INSERT = 0;
  static final int INSERT_WITH_SCHEMA = 1;
  Session currentSession;
  public static final String[] LIST_SCRIPT_FORMATS = { "TEXT", "BINARY", null, "COMPRESSED" };
  public static final int SCRIPT_TEXT_170 = 0;
  public static final int SCRIPT_BINARY_172 = 1;
  public static final int SCRIPT_ZIPPED_BINARY_172 = 3;
  private Object timerTask;
  protected volatile int writeDelay = 60000;

  public static ScriptWriterBase newScriptWriter(Database paramDatabase, String paramString, boolean paramBoolean1, boolean paramBoolean2, int paramInt)
    throws HsqlException
  {
    if (paramInt == 0)
      return new ScriptWriterText(paramDatabase, paramString, paramBoolean1, paramBoolean2, false);
    if (paramInt == 1)
      return new ScriptWriterBinary(paramDatabase, paramString, paramBoolean1, paramBoolean2);
    return new ScriptWriterZipped(paramDatabase, paramString, paramBoolean1, paramBoolean2);
  }

  ScriptWriterBase()
  {
  }

  ScriptWriterBase(Database paramDatabase, String paramString, boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3)
    throws HsqlException
  {
    this.isDump = paramBoolean3;
    initBuffers();
    boolean bool = false;
    if (paramBoolean3)
      bool = FileUtil.exists(paramString);
    else
      bool = paramDatabase.getFileAccess().isStreamElement(paramString);
    if ((bool) && (paramBoolean2))
      throw Trace.error(29, paramString);
    this.database = paramDatabase;
    this.includeCachedData = paramBoolean1;
    this.outFile = paramString;
    this.currentSession = this.database.sessionManager.getSysSession();
    this.schemaToLog = (this.currentSession.loggedSchema = this.currentSession.currentSchema);
    openFile();
  }

  public void reopen()
    throws HsqlException
  {
    openFile();
  }

  protected abstract void initBuffers();

  public synchronized void sync()
  {
    if ((this.needsSync) && (this.fileStreamOut != null))
    {
      if (this.busyWriting)
      {
        this.forceSync = true;
        return;
      }
      try
      {
        this.fileStreamOut.flush();
        this.outDescriptor.sync();
        this.syncCount += 1;
      }
      catch (IOException localIOException)
      {
        Trace.printSystemOut("flush() or sync() error: " + localIOException.toString());
      }
      this.needsSync = false;
      this.forceSync = false;
    }
  }

  public void close()
    throws HsqlException
  {
    stop();
    try
    {
      if (this.fileStreamOut != null)
      {
        this.fileStreamOut.flush();
        this.outDescriptor.sync();
        this.fileStreamOut.close();
        this.fileStreamOut = null;
      }
    }
    catch (IOException localIOException)
    {
      throw Trace.error(29);
    }
    this.byteCount = 0L;
  }

  public long size()
  {
    return this.byteCount;
  }

  public void writeAll()
    throws HsqlException
  {
    try
    {
      writeDDL();
      writeExistingData();
      finishStream();
    }
    catch (IOException localIOException)
    {
      throw Trace.error(29);
    }
  }

  protected void openFile()
    throws HsqlException
  {
    try
    {
      FileAccess localFileAccess = this.isDump ? FileUtil.getDefaultInstance() : this.database.getFileAccess();
      OutputStream localOutputStream = localFileAccess.openOutputStreamElement(this.outFile);
      this.outDescriptor = localFileAccess.getFileSync(localOutputStream);
      this.fileStreamOut = new BufferedOutputStream(localOutputStream, 8192);
    }
    catch (IOException localIOException)
    {
      throw Trace.error(29, 115, new Object[] { localIOException.toString(), this.outFile });
    }
  }

  protected void finishStream()
    throws IOException
  {
  }

  protected void writeDDL()
    throws IOException, HsqlException
  {
    Result localResult = DatabaseScript.getScript(this.database, !this.includeCachedData);
    writeSingleColumnResult(localResult);
  }

  protected void writeExistingData()
    throws HsqlException, IOException
  {
    this.currentSession.loggedSchema = null;
    Iterator localIterator1 = this.database.schemaManager.userSchemaNameIterator();
    if (localIterator1.hasNext())
    {
      String str = (String)localIterator1.next();
      Iterator localIterator2 = this.database.schemaManager.tablesIterator(str);
      while (localIterator2.hasNext())
      {
        Table localTable = (Table)localIterator2.next();
        boolean bool = false;
        switch (localTable.getTableType())
        {
        case 3:
          bool = true;
          break;
        case 4:
          bool = this.includeCachedData;
          break;
        case 6:
          bool = (this.includeCachedData) && (!localTable.isReadOnly());
        case 5:
        }
        try
        {
          if (bool)
          {
            this.schemaToLog = localTable.getName().schema;
            writeTableInit(localTable);
            RowIterator localRowIterator = localTable.rowIterator(this.currentSession);
            while (localRowIterator.hasNext())
              writeRow(this.currentSession, localTable, localRowIterator.next().getData());
            writeTableTerm(localTable);
          }
        }
        catch (Exception localException)
        {
          throw Trace.error(38, localException.toString());
        }
      }
    }
    writeDataTerm();
  }

  protected void writeTableInit(Table paramTable)
    throws HsqlException, IOException
  {
  }

  protected void writeTableTerm(Table paramTable)
    throws HsqlException, IOException
  {
    if ((paramTable.isDataReadOnly()) && (!paramTable.isTemp()) && (!paramTable.isText()))
    {
      StringBuffer localStringBuffer = new StringBuffer("SET TABLE ");
      localStringBuffer.append(paramTable.getName().statementName);
      localStringBuffer.append(" READONLY TRUE");
      writeLogStatement(this.currentSession, localStringBuffer.toString());
    }
  }

  protected void writeSingleColumnResult(Result paramResult)
    throws HsqlException, IOException
  {
    Iterator localIterator = paramResult.iterator();
    while (localIterator.hasNext())
    {
      Object[] arrayOfObject = (Object[])localIterator.next();
      writeLogStatement(this.currentSession, (String)arrayOfObject[0]);
    }
  }

  abstract void writeRow(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException, IOException;

  protected abstract void writeDataTerm()
    throws IOException;

  protected abstract void addSessionId(Session paramSession)
    throws IOException;

  public abstract void writeLogStatement(Session paramSession, String paramString)
    throws IOException, HsqlException;

  public abstract void writeInsertStatement(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException, IOException;

  public abstract void writeDeleteStatement(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException, IOException;

  public abstract void writeSequenceStatement(Session paramSession, NumberSequence paramNumberSequence)
    throws HsqlException, IOException;

  public abstract void writeCommitStatement(Session paramSession)
    throws HsqlException, IOException;

  public void run()
  {
    try
    {
      if (this.writeDelay != 0)
        sync();
    }
    catch (Exception localException)
    {
      if (Trace.TRACE)
        Trace.printSystemOut(localException.toString());
    }
  }

  public void setWriteDelay(int paramInt)
  {
    this.writeDelay = paramInt;
    int i = this.writeDelay == 0 ? 1000 : this.writeDelay;
    HsqlTimer.setPeriod(this.timerTask, i);
  }

  public void start()
  {
    int i = this.writeDelay == 0 ? 1000 : this.writeDelay;
    this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, i, this, false);
  }

  public void stop()
  {
    if (this.timerTask != null)
    {
      HsqlTimer.cancel(this.timerTask);
      this.timerTask = null;
    }
  }

  public int getWriteDelay()
  {
    return this.writeDelay;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.scriptio.ScriptWriterBase
 * JD-Core Version:    0.6.0
 */