package org.hsqldb.rowio;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.TextCache;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputText extends RowOutputBase
{
  protected String fieldSep;
  protected String varSep;
  protected String longvarSep;
  private boolean fieldSepEnd;
  private boolean varSepEnd;
  private boolean longvarSepEnd;
  private String nextSep = "";
  private boolean nextSepEnd;
  protected boolean allQuoted;
  private String encoding;

  public RowOutputText(String paramString1, String paramString2, String paramString3, boolean paramBoolean, String paramString4)
  {
    initTextDatabaseRowOutput(paramString1, paramString2, paramString3, paramBoolean, paramString4);
  }

  private void initTextDatabaseRowOutput(String paramString1, String paramString2, String paramString3, boolean paramBoolean, String paramString4)
  {
    if (paramString1.endsWith("\n"))
    {
      this.fieldSepEnd = true;
      paramString1 = paramString1.substring(0, paramString1.length() - 1);
    }
    if (paramString2.endsWith("\n"))
    {
      this.varSepEnd = true;
      paramString2 = paramString2.substring(0, paramString2.length() - 1);
    }
    if (paramString3.endsWith("\n"))
    {
      this.longvarSepEnd = true;
      paramString3 = paramString3.substring(0, paramString3.length() - 1);
    }
    this.fieldSep = paramString1;
    this.varSep = paramString2;
    this.longvarSep = paramString3;
    this.allQuoted = paramBoolean;
    this.encoding = paramString4;
  }

  public void writeEnd()
  {
    if (this.nextSepEnd)
      writeBytes(this.nextSep);
    writeBytes(TextCache.NL);
  }

  public void writeSize(int paramInt)
  {
    this.nextSep = "";
    this.nextSepEnd = false;
  }

  public void writeType(int paramInt)
  {
  }

  public void writeString(String paramString)
  {
    paramString = checkConvertString(paramString, this.fieldSep);
    if (paramString == null)
      return;
    byte[] arrayOfByte = getBytes(paramString);
    write(arrayOfByte, 0, arrayOfByte.length);
    this.nextSep = this.fieldSep;
    this.nextSepEnd = this.fieldSepEnd;
  }

  protected void writeVarString(String paramString)
  {
    paramString = checkConvertString(paramString, this.varSep);
    if (paramString == null)
      return;
    byte[] arrayOfByte = getBytes(paramString);
    write(arrayOfByte, 0, arrayOfByte.length);
    this.nextSep = this.varSep;
    this.nextSepEnd = this.varSepEnd;
  }

  protected void writeLongVarString(String paramString)
  {
    paramString = checkConvertString(paramString, this.longvarSep);
    if (paramString == null)
      return;
    byte[] arrayOfByte = getBytes(paramString);
    write(arrayOfByte, 0, arrayOfByte.length);
    this.nextSep = this.longvarSep;
    this.nextSepEnd = this.longvarSepEnd;
  }

  protected String checkConvertString(String paramString1, String paramString2)
  {
    if ((paramString1.indexOf('\n') != -1) || (paramString1.indexOf('\r') != -1))
      throw new IllegalArgumentException(Trace.getMessage(145));
    if (paramString1.indexOf(paramString2) != -1)
      return null;
    return paramString1;
  }

  private byte[] getBytes(String paramString)
  {
    byte[] arrayOfByte = null;
    try
    {
      arrayOfByte = paramString.getBytes(this.encoding);
    }
    catch (UnsupportedEncodingException localUnsupportedEncodingException)
    {
      arrayOfByte = paramString.getBytes();
    }
    return arrayOfByte;
  }

  protected void writeByteArray(byte[] paramArrayOfByte)
  {
    ensureRoom(paramArrayOfByte.length * 2);
    StringConverter.writeHex(getBuffer(), this.count, paramArrayOfByte);
    this.count += paramArrayOfByte.length * 2;
  }

  public void writeShortData(short paramShort)
  {
    writeIntData(paramShort);
  }

  public void writeIntData(int paramInt)
  {
    writeBytes(Integer.toString(paramInt));
    this.nextSep = this.fieldSep;
    this.nextSepEnd = this.fieldSepEnd;
  }

  public void writeIntData(int paramInt1, int paramInt2)
  {
    throw Trace.runtimeError(201, "RowInputText");
  }

  public void writeLongData(long paramLong)
  {
    throw Trace.runtimeError(201, "RowInputText");
  }

  protected void writeFieldType(int paramInt)
  {
    writeBytes(this.nextSep);
    switch (paramInt)
    {
    case 12:
    case 100:
      this.nextSep = this.varSep;
      this.nextSepEnd = this.varSepEnd;
      break;
    case -1:
      this.nextSep = this.longvarSep;
      this.nextSepEnd = this.longvarSepEnd;
      break;
    default:
      this.nextSep = this.fieldSep;
      this.nextSepEnd = this.fieldSepEnd;
    }
  }

  protected void writeNull(int paramInt)
  {
    writeFieldType(paramInt);
  }

  protected void writeChar(String paramString, int paramInt)
  {
    switch (paramInt)
    {
    case 1:
      writeString(paramString);
      return;
    case 12:
    case 100:
      writeVarString(paramString);
      return;
    case -1:
    }
    writeLongVarString(paramString);
  }

  protected void writeSmallint(Number paramNumber)
  {
    writeString(paramNumber.toString());
  }

  protected void writeInteger(Number paramNumber)
  {
    writeString(paramNumber.toString());
  }

  protected void writeBigint(Number paramNumber)
  {
    writeString(paramNumber.toString());
  }

  protected void writeReal(Double paramDouble, int paramInt)
  {
    writeString(paramDouble.toString());
  }

  protected void writeDecimal(BigDecimal paramBigDecimal)
  {
    writeString(paramBigDecimal.toString());
  }

  protected void writeBit(Boolean paramBoolean)
  {
    writeString(paramBoolean.toString());
  }

  protected void writeDate(Date paramDate)
  {
    writeString(paramDate.toString());
  }

  protected void writeTime(Time paramTime)
  {
    writeString(paramTime.toString());
  }

  protected void writeTimestamp(Timestamp paramTimestamp)
  {
    writeString(paramTimestamp.toString());
  }

  protected void writeOther(JavaObject paramJavaObject)
  {
    byte[] arrayOfByte = paramJavaObject.getBytes();
    writeByteArray(arrayOfByte);
  }

  protected void writeBinary(Binary paramBinary, int paramInt)
  {
    writeByteArray(paramBinary.getBytes());
  }

  public int getSize(CachedRow paramCachedRow)
  {
    reset();
    try
    {
      writeSize(0);
      writeData(paramCachedRow.getData(), paramCachedRow.getTable());
      writeEnd();
    }
    catch (Exception localException)
    {
      reset();
    }
    int i = size();
    reset();
    return i;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.rowio.RowOutputText
 * JD-Core Version:    0.6.0
 */