package org.hsqldb.persist;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Storage;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowInputText;
import org.hsqldb.rowio.RowInputTextQuoted;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.rowio.RowOutputText;
import org.hsqldb.rowio.RowOutputTextQuoted;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.store.ObjectCacheHashMap;

public class TextCache extends DataFileCache
{
  public static final String NL = System.getProperty("line.separator");
  public String fs;
  public String vs;
  public String lvs;
  public String stringEncoding;
  public boolean isQuoted;
  public boolean isAllQuoted;
  public boolean ignoreFirst;
  protected String header;
  protected Table table;
  private ObjectCacheHashMap uncommittedCache;
  static final char DOUBLE_QUOTE_CHAR = '"';
  static final char BACKSLASH_CHAR = '\\';
  static final char LF_CHAR = '\n';
  static final char CR_CHAR = '\r';

  TextCache(Table paramTable, String paramString)
    throws HsqlException
  {
    super(paramTable.database, paramString);
    this.table = paramTable;
    this.uncommittedCache = new ObjectCacheHashMap(5);
  }

  protected void initParams(Database paramDatabase, String paramString)
    throws HsqlException
  {
    this.fileName = paramString;
    this.database = paramDatabase;
    this.fa = FileUtil.getDefaultInstance();
    HsqlProperties localHsqlProperties = HsqlProperties.delimitedArgPairsToProps(this.fileName, "=", ";", null);
    switch (localHsqlProperties.errorCodes.length)
    {
    case 0:
      throw Trace.error(75, 172);
    case 1:
      this.fileName = localHsqlProperties.errorKeys[0].trim();
      break;
    default:
      throw Trace.error(75, 173, localHsqlProperties.errorKeys[1]);
    }
    HsqlDatabaseProperties localHsqlDatabaseProperties = paramDatabase.getProperties();
    this.fs = translateSep(localHsqlProperties.getProperty("fs", localHsqlDatabaseProperties.getProperty("textdb.fs", ",")));
    this.vs = translateSep(localHsqlProperties.getProperty("vs", localHsqlDatabaseProperties.getProperty("textdb.vs", this.fs)));
    this.lvs = translateSep(localHsqlProperties.getProperty("lvs", localHsqlDatabaseProperties.getProperty("textdb.lvs", this.fs)));
    if ((this.fs.length() == 0) || (this.vs.length() == 0) || (this.lvs.length() == 0))
      throw Trace.error(75, 174);
    this.ignoreFirst = localHsqlProperties.isPropertyTrue("ignore_first", localHsqlDatabaseProperties.isPropertyTrue("textdb.ignore_first", false));
    this.isQuoted = localHsqlProperties.isPropertyTrue("quoted", localHsqlDatabaseProperties.isPropertyTrue("textdb.quoted", true));
    this.isAllQuoted = localHsqlProperties.isPropertyTrue("all_quoted", localHsqlDatabaseProperties.isPropertyTrue("textdb.all_quoted", false));
    this.stringEncoding = translateSep(localHsqlProperties.getProperty("encoding", localHsqlDatabaseProperties.getProperty("textdb.encoding", "ASCII")));
    int i = localHsqlProperties.getIntegerProperty("cache_scale", localHsqlDatabaseProperties.getIntegerProperty("textdb.cache_scale", 10, 8, 16));
    int j = localHsqlProperties.getIntegerProperty("cache_size_scale", localHsqlDatabaseProperties.getIntegerProperty("textdb.cache_size_scale", 10, 8, 20));
    int k = 1 << i;
    int m = 1 << j;
    this.maxCacheSize = (k * 3);
    this.maxCacheBytes = (this.maxCacheSize * m);
    this.maxDataFileSize = 2147483647L;
    this.cachedRowPadding = 1;
    this.cacheFileScale = 1;
  }

  protected void initBuffers()
  {
    if ((this.isQuoted) || (this.isAllQuoted))
    {
      this.rowIn = new RowInputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted);
      this.rowOut = new RowOutputTextQuoted(this.fs, this.vs, this.lvs, this.isAllQuoted, this.stringEncoding);
    }
    else
    {
      this.rowIn = new RowInputText(this.fs, this.vs, this.lvs, false);
      this.rowOut = new RowOutputText(this.fs, this.vs, this.lvs, false, this.stringEncoding);
    }
  }

  private String translateSep(String paramString)
  {
    return translateSep(paramString, false);
  }

  private String translateSep(String paramString, boolean paramBoolean)
  {
    if (paramString == null)
      return null;
    int i = 0;
    if ((i = paramString.indexOf('\\')) != -1)
    {
      int j = 0;
      char[] arrayOfChar = paramString.toCharArray();
      int k = 0;
      int m = paramString.length();
      StringBuffer localStringBuffer = new StringBuffer(m);
      do
      {
        localStringBuffer.append(arrayOfChar, j, i - j);
        i++;
        j = i;
        if (i >= m)
        {
          localStringBuffer.append('\\');
          break;
        }
        if (!paramBoolean)
          k = arrayOfChar[i];
        if (k == 110)
        {
          localStringBuffer.append('\n');
          j++;
        }
        else if (k == 114)
        {
          localStringBuffer.append('\r');
          j++;
        }
        else if (k == 116)
        {
          localStringBuffer.append('\t');
          j++;
        }
        else if (k == 92)
        {
          localStringBuffer.append('\\');
          j++;
        }
        else if (k == 117)
        {
          j++;
          localStringBuffer.append((char)Integer.parseInt(paramString.substring(j, j + 4), 16));
          j += 4;
        }
        else if (paramString.startsWith("semi", i))
        {
          localStringBuffer.append(';');
          j += 4;
        }
        else if (paramString.startsWith("space", i))
        {
          localStringBuffer.append(' ');
          j += 5;
        }
        else if (paramString.startsWith("quote", i))
        {
          localStringBuffer.append('"');
          j += 5;
        }
        else if (paramString.startsWith("apos", i))
        {
          localStringBuffer.append('\'');
          j += 4;
        }
        else
        {
          localStringBuffer.append('\\');
          localStringBuffer.append(arrayOfChar[i]);
          j++;
        }
      }
      while ((i = paramString.indexOf('\\', j)) != -1);
      localStringBuffer.append(arrayOfChar, j, m - j);
      paramString = localStringBuffer.toString();
    }
    return paramString;
  }

  public void open(boolean paramBoolean)
    throws HsqlException
  {
    this.fileFreePosition = 0L;
    try
    {
      this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.fileName, paramBoolean, 0, null, null);
      this.fileFreePosition = this.dataFile.length();
      if (this.fileFreePosition > 2147483647L)
        throw new IOException();
      initBuffers();
    }
    catch (Exception localException)
    {
      throw Trace.error(29, 188, new Object[] { this.fileName, localException });
    }
    this.cacheReadonly = paramBoolean;
  }

  void reopen()
    throws HsqlException
  {
    open(this.cacheReadonly);
  }

  public void close(boolean paramBoolean)
    throws HsqlException
  {
    if (this.dataFile == null)
      return;
    try
    {
      this.cache.saveAll();
      int i = this.dataFile.length() <= NL.length() ? 1 : 0;
      this.dataFile.close();
      this.dataFile = null;
      if ((i != 0) && (!this.cacheReadonly))
        FileUtil.delete(this.fileName);
    }
    catch (Exception localException)
    {
      throw Trace.error(29, 189, new Object[] { this.fileName, localException });
    }
  }

  void purge()
    throws HsqlException
  {
    this.uncommittedCache.clear();
    try
    {
      if (this.cacheReadonly)
      {
        close(false);
      }
      else
      {
        if (this.dataFile != null)
        {
          this.dataFile.close();
          this.dataFile = null;
        }
        FileUtil.delete(this.fileName);
      }
    }
    catch (Exception localException)
    {
      throw Trace.error(29, 190, new Object[] { this.fileName, localException });
    }
  }

  public synchronized void remove(int paramInt, PersistentStore paramPersistentStore)
    throws IOException
  {
    CachedObject localCachedObject = (CachedObject)this.uncommittedCache.remove(paramInt);
    if (localCachedObject != null)
      return;
    localCachedObject = this.cache.release(paramInt);
    clearRowImage(localCachedObject);
    release(paramInt);
  }

  private void clearRowImage(CachedObject paramCachedObject)
    throws IOException
  {
    int i = paramCachedObject.getStorageSize() - ScriptWriterText.BYTES_LINE_SEP.length;
    this.rowOut.reset();
    HsqlByteArrayOutputStream localHsqlByteArrayOutputStream = this.rowOut.getOutputStream();
    localHsqlByteArrayOutputStream.fill(32, i);
    localHsqlByteArrayOutputStream.write(ScriptWriterText.BYTES_LINE_SEP);
    this.dataFile.seek(paramCachedObject.getPos());
    this.dataFile.write(localHsqlByteArrayOutputStream.getBuffer(), 0, localHsqlByteArrayOutputStream.size());
  }

  public synchronized void removePersistence(int paramInt, PersistentStore paramPersistentStore)
    throws IOException
  {
    CachedObject localCachedObject = (CachedObject)this.uncommittedCache.get(paramInt);
    if (localCachedObject != null)
      return;
    localCachedObject = this.cache.get(paramInt);
    clearRowImage(localCachedObject);
  }

  protected synchronized RowInputInterface readObject(int paramInt)
    throws IOException
  {
    ByteArray localByteArray = new ByteArray(80);
    int i = 0;
    int j = 0;
    int m = 0;
    int n = 0;
    paramInt = findNextUsedLinePos(paramInt);
    if (paramInt == -1)
      return null;
    this.dataFile.seek(paramInt);
    while (i == 0)
    {
      n = 0;
      int k = this.dataFile.read();
      if (k == -1)
      {
        if (localByteArray.length() == 0)
          return null;
        i = 1;
        if ((j != 0) || (this.cacheReadonly))
          break;
        this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
        break;
      }
      switch (k)
      {
      case 34:
        n = 1;
        i = j;
        j = 0;
        if (!this.isQuoted)
          break;
        m = m == 0 ? 1 : 0;
        break;
      case 13:
        j = m == 0 ? 1 : 0;
        break;
      case 10:
        i = m == 0 ? 1 : 0;
        break;
      default:
        n = 1;
        i = j;
        j = 0;
      }
      localByteArray.append(k);
    }
    if (i != 0)
    {
      int i1 = (int)this.dataFile.getFilePointer() - paramInt;
      if (n != 0)
        i1--;
      ((RowInputText)this.rowIn).setSource(localByteArray.toString(), paramInt, i1);
      return this.rowIn;
    }
    return null;
  }

  public int readHeaderLine()
    throws HsqlException
  {
    int i = 0;
    int j = 0;
    int k = 0;
    ByteArray localByteArray = new ByteArray(80);
    int m;
    while (i == 0)
    {
      k = 0;
      try
      {
        m = this.dataFile.read();
        if (m == -1)
        {
          if (localByteArray.length() == 0)
            return 0;
          i = 1;
          if (!this.cacheReadonly)
            this.dataFile.write(ScriptWriterText.BYTES_LINE_SEP, 0, ScriptWriterText.BYTES_LINE_SEP.length);
          break;
        }
      }
      catch (IOException localIOException2)
      {
        throw Trace.error(76);
      }
      switch (m)
      {
      case 13:
        j = 1;
        break;
      case 10:
        i = 1;
        break;
      default:
        k = 1;
        i = j;
        j = 0;
      }
      localByteArray.append(m);
    }
    this.header = localByteArray.toString();
    try
    {
      m = (int)this.dataFile.getFilePointer();
      if (k != 0)
        m--;
      return m;
    }
    catch (IOException localIOException1)
    {
    }
    throw Trace.error(76);
  }

  int findNextUsedLinePos(int paramInt)
    throws IOException
  {
    int i = paramInt;
    int j = paramInt;
    int k = 0;
    this.dataFile.seek(paramInt);
    while (true)
    {
      int m = this.dataFile.read();
      j++;
      switch (m)
      {
      case 13:
        k = 1;
        break;
      case 10:
        k = 0;
        ((RowInputText)this.rowIn).skippedLine();
        i = j;
        break;
      case 32:
        if (k == 0)
          continue;
        k = 0;
        ((RowInputText)this.rowIn).skippedLine();
      case -1:
      }
    }
    return -1;
    return i;
  }

  public synchronized void add(CachedObject paramCachedObject)
    throws IOException
  {
    super.add(paramCachedObject);
    clearRowImage(paramCachedObject);
  }

  public synchronized CachedObject get(int paramInt, PersistentStore paramPersistentStore, boolean paramBoolean)
    throws HsqlException
  {
    if (paramInt < 0)
      return null;
    CachedObject localCachedObject = (CachedObject)this.uncommittedCache.get(paramInt);
    if (localCachedObject == null)
      localCachedObject = super.get(paramInt, paramPersistentStore, paramBoolean);
    return localCachedObject;
  }

  protected synchronized void saveRows(CachedObject[] paramArrayOfCachedObject, int paramInt1, int paramInt2)
    throws IOException
  {
    if (paramInt2 == 0)
      return;
    for (int i = paramInt1; i < paramInt1 + paramInt2; i++)
    {
      CachedObject localCachedObject = paramArrayOfCachedObject[i];
      this.uncommittedCache.put(localCachedObject.getPos(), localCachedObject);
      paramArrayOfCachedObject[i] = null;
    }
  }

  public synchronized void saveRow(CachedObject paramCachedObject)
    throws IOException
  {
    this.uncommittedCache.remove(paramCachedObject.getPos());
    super.saveRow(paramCachedObject);
  }

  public String getHeader()
  {
    return this.header;
  }

  public void setHeader(String paramString)
    throws HsqlException
  {
    if ((this.ignoreFirst) && (this.fileFreePosition == 0L))
    {
      try
      {
        writeHeader(paramString);
        this.header = paramString;
      }
      catch (IOException localIOException)
      {
        throw new HsqlException(localIOException, Trace.getMessage(98), 98);
      }
      return;
    }
    throw Trace.error(150);
  }

  private void writeHeader(String paramString)
    throws IOException
  {
    byte[] arrayOfByte = null;
    String str = paramString + NL;
    try
    {
      arrayOfByte = str.getBytes(this.stringEncoding);
    }
    catch (UnsupportedEncodingException localUnsupportedEncodingException)
    {
      arrayOfByte = str.getBytes();
    }
    this.dataFile.write(arrayOfByte, 0, arrayOfByte.length);
    this.fileFreePosition = arrayOfByte.length;
  }

  public int getLineNumber()
  {
    return ((RowInputText)this.rowIn).getLineNumber();
  }

  protected void setFileModified()
    throws IOException
  {
    this.fileModified = true;
  }

  private class ByteArray
  {
    private byte[] buffer;
    private int buflen;

    public ByteArray(int arg2)
    {
      int i;
      this.buffer = new byte[i];
      this.buflen = 0;
    }

    public void append(int paramInt)
    {
      if (this.buflen >= this.buffer.length)
      {
        byte[] arrayOfByte = new byte[this.buflen + 80];
        System.arraycopy(this.buffer, 0, arrayOfByte, 0, this.buflen);
        this.buffer = arrayOfByte;
      }
      this.buffer[this.buflen] = (byte)paramInt;
      this.buflen += 1;
    }

    public int length()
    {
      return this.buflen;
    }

    public void setLength(int paramInt)
    {
      this.buflen = paramInt;
    }

    public String toString()
    {
      try
      {
        return new String(this.buffer, 0, this.buflen, TextCache.this.stringEncoding);
      }
      catch (UnsupportedEncodingException localUnsupportedEncodingException)
      {
      }
      return new String(this.buffer, 0, this.buflen);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.TextCache
 * JD-Core Version:    0.6.0
 */