package org.hsqldb.persist;

import java.io.EOFException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.scriptio.ScriptReaderBase;

public class ScriptRunner
{
  public static void runScript(Database paramDatabase, String paramString, int paramInt)
    throws HsqlException
  {
    IntKeyHashMap localIntKeyHashMap = new IntKeyHashMap();
    Session localSession1 = paramDatabase.getSessionManager().getSysSession();
    Session localSession2 = localSession1;
    int i = 0;
    paramDatabase.setReferentialIntegrity(false);
    ScriptReaderBase localScriptReaderBase = null;
    try
    {
      StopWatch localStopWatch = new StopWatch();
      localScriptReaderBase = ScriptReaderBase.newScriptReader(paramDatabase, paramString, paramInt);
      while (localScriptReaderBase.readLoggedStatement(localSession2))
      {
        int j = localScriptReaderBase.getSessionNumber();
        if (i != j)
        {
          i = j;
          localSession2 = (Session)localIntKeyHashMap.get(i);
          if (localSession2 == null)
          {
            localSession2 = paramDatabase.getSessionManager().newSession(paramDatabase, localSession1.getUser(), false, true);
            localIntKeyHashMap.put(i, localSession2);
          }
        }
        if (localSession2.isClosed())
        {
          localIntKeyHashMap.remove(i);
          continue;
        }
        Result localResult = null;
        Object[] arrayOfObject;
        switch (localScriptReaderBase.getStatementType())
        {
        case 1:
          localResult = localSession2.sqlExecuteDirectNoPreChecks(localScriptReaderBase.getLoggedStatement());
          if ((localResult == null) || (!localResult.isError()))
            break;
          if (localResult.getException() != null)
            throw localResult.getException();
          throw Trace.error(localResult);
        case 4:
          localScriptReaderBase.getCurrentSequence().reset(localScriptReaderBase.getSequenceValue());
          break;
        case 5:
          localSession2.commit();
          break;
        case 3:
          arrayOfObject = localScriptReaderBase.getData();
          localScriptReaderBase.getCurrentTable().insertNoCheckFromLog(localSession2, arrayOfObject);
          break;
        case 2:
          arrayOfObject = localScriptReaderBase.getData();
          localScriptReaderBase.getCurrentTable().deleteNoCheckFromLog(localSession2, arrayOfObject);
          break;
        case 7:
          localSession2.setSchema(localScriptReaderBase.getCurrentSchema());
        case 6:
        }
        if (!localSession2.isClosed())
          continue;
        localIntKeyHashMap.remove(i);
      }
    }
    catch (Throwable localThrowable)
    {
      if (!(localThrowable instanceof EOFException))
      {
        if ((localThrowable instanceof OutOfMemoryError))
        {
          str = "out of memory processing " + paramString + " line: " + localScriptReaderBase.getLineNumber();
          paramDatabase.logger.appLog.logContext(SimpleLog.LOG_ERROR, str);
          throw Trace.error(72);
        }
        String str = paramString + " line: " + localScriptReaderBase.getLineNumber() + " " + localThrowable.toString();
        paramDatabase.logger.appLog.logContext(SimpleLog.LOG_ERROR, str);
      }
    }
    finally
    {
      if (localScriptReaderBase != null)
        localScriptReaderBase.close();
      paramDatabase.getSessionManager().closeAllSessions();
      paramDatabase.setReferentialIntegrity(true);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.ScriptRunner
 * JD-Core Version:    0.6.0
 */