package org.hsqldb.persist;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileChannel.MapMode;
import org.hsqldb.Database;
import org.hsqldb.Trace;
import org.hsqldb.lib.SimpleLog;

class ScaledRAFileNIO
  implements ScaledRAInterface
{
  private final boolean readOnly;
  private final long bufferLength;
  private RandomAccessFile file;
  private MappedByteBuffer buffer;
  private FileChannel channel;
  private boolean bufferModified;
  private SimpleLog appLog;
  private static final String JVM_ERROR = "JVM threw unsupported Exception";

  ScaledRAFileNIO(Database paramDatabase, String paramString, boolean paramBoolean, int paramInt)
    throws Throwable
  {
    if (paramInt < 262144)
      paramInt = 262144;
    try
    {
      this.file = new RandomAccessFile(paramString, paramBoolean ? "r" : "rw");
    }
    catch (Throwable localThrowable1)
    {
      throw localThrowable1;
    }
    long l1;
    try
    {
      l1 = this.file.length();
    }
    catch (Throwable localThrowable2)
    {
      this.file.close();
      throw localThrowable2;
    }
    if (l1 > 268435456L)
    {
      this.file.close();
      throw new IOException("length exceeds nio limit");
    }
    if (paramInt < l1)
      paramInt = (int)l1;
    paramInt = newNIOBufferSize(paramInt);
    if (paramBoolean)
      paramInt = (int)l1;
    if (l1 < paramInt)
      try
      {
        this.file.seek(paramInt - 1);
        this.file.writeByte(0);
        this.file.getFD().sync();
        this.file.close();
        this.file = new RandomAccessFile(paramString, paramBoolean ? "r" : "rw");
      }
      catch (Throwable localThrowable3)
      {
        this.file.close();
        throw localThrowable3;
      }
    this.appLog = paramDatabase.logger.appLog;
    this.readOnly = paramBoolean;
    this.bufferLength = paramInt;
    this.channel = this.file.getChannel();
    try
    {
      this.buffer = this.channel.map(paramBoolean ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, paramInt);
      Trace.printSystemOut("NIO file instance created. mode: " + paramBoolean);
      if (!paramBoolean)
      {
        long l2 = paramInt - l1;
        if (l2 > 262144L)
          l2 = 262144L;
        byte[] arrayOfByte = new byte[(int)l2];
        try
        {
          long l3 = l1;
          while (l3 < paramInt - l2)
          {
            this.buffer.position((int)l3);
            this.buffer.put(arrayOfByte, 0, arrayOfByte.length);
            l3 += l2;
          }
          this.buffer.position((int)l3);
          this.buffer.put(arrayOfByte, 0, (int)(paramInt - l3));
          this.buffer.force();
        }
        catch (Throwable localThrowable5)
        {
          this.appLog.logContext(localThrowable5, "JVM threw unsupported Exception length: " + paramInt);
        }
        this.buffer.position(0);
      }
    }
    catch (Throwable localThrowable4)
    {
      Trace.printSystemOut("NIO constructor failed:  " + paramInt);
      this.buffer = null;
      this.channel = null;
      this.file.close();
      System.gc();
      throw localThrowable4;
    }
  }

  public long length()
    throws IOException
  {
    try
    {
      return this.file.length();
    }
    catch (IOException localIOException)
    {
      this.appLog.logContext(localIOException, "nio");
      throw localIOException;
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
    }
    throw new IOException(localThrowable.toString());
  }

  public void seek(long paramLong)
    throws IOException
  {
    try
    {
      this.buffer.position((int)paramLong);
    }
    catch (IllegalArgumentException localIllegalArgumentException)
    {
      this.appLog.logContext(localIllegalArgumentException, "nio");
      throw new IOException(localIllegalArgumentException.toString());
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
      throw new IOException(localThrowable.toString());
    }
  }

  public long getFilePointer()
    throws IOException
  {
    try
    {
      return this.buffer.position();
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
    }
    throw new IOException(localThrowable.toString());
  }

  public int read()
    throws IOException
  {
    try
    {
      return this.buffer.get();
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
    }
    throw new IOException(localThrowable.toString());
  }

  public void read(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
    throws IOException
  {
    try
    {
      this.buffer.get(paramArrayOfByte, paramInt1, paramInt2);
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
      throw new IOException(localThrowable.toString());
    }
  }

  public int readInt()
    throws IOException
  {
    try
    {
      return this.buffer.getInt();
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
    }
    throw new IOException(localThrowable.toString());
  }

  public long readLong()
    throws IOException
  {
    try
    {
      return this.buffer.getLong();
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
    }
    throw new IOException(localThrowable.toString());
  }

  public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
    throws IOException
  {
    try
    {
      this.bufferModified = true;
      this.buffer.put(paramArrayOfByte, paramInt1, paramInt2);
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
      throw new IOException(localThrowable.toString());
    }
  }

  public void writeInt(int paramInt)
    throws IOException
  {
    try
    {
      this.bufferModified = true;
      this.buffer.putInt(paramInt);
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
      throw new IOException(localThrowable.toString());
    }
  }

  public void writeLong(long paramLong)
    throws IOException
  {
    try
    {
      this.bufferModified = true;
      this.buffer.putLong(paramLong);
    }
    catch (Throwable localThrowable)
    {
      this.appLog.logContext(localThrowable, "JVM threw unsupported Exception");
      throw new IOException(localThrowable.toString());
    }
  }

  public void close()
    throws IOException
  {
    try
    {
      Trace.printSystemOut("NIO close() start - fileLength = " + this.bufferLength);
      if ((this.buffer != null) && (this.bufferModified))
        try
        {
          this.buffer.force();
        }
        catch (Throwable localThrowable1)
        {
          try
          {
            this.buffer.force();
          }
          catch (Throwable localThrowable3)
          {
            this.appLog.logContext(localThrowable1, "JVM threw unsupported Exception length: " + this.bufferLength);
          }
        }
      this.buffer = null;
      this.channel = null;
      this.file.close();
      System.gc();
    }
    catch (Throwable localThrowable2)
    {
      this.appLog.logContext(localThrowable2, "length: " + this.bufferLength);
      throw new IOException(localThrowable2.toString());
    }
  }

  public boolean isReadOnly()
  {
    return this.readOnly;
  }

  public boolean wasNio()
  {
    return true;
  }

  public boolean canAccess(int paramInt)
  {
    return this.buffer.position() + paramInt <= this.bufferLength;
  }

  public boolean canSeek(long paramLong)
  {
    return paramLong <= this.bufferLength;
  }

  public Database getDatabase()
  {
    return null;
  }

  static int newNIOBufferSize(int paramInt)
  {
    int i = 0;
    for (int j = 20; j < 30; j++)
    {
      i = 1 << j;
      if (i >= paramInt)
        break;
    }
    return i;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.ScaledRAFileNIO
 * JD-Core Version:    0.6.0
 */