package org.hsqldb.persist;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

final class NIOLockFile extends LockFile
{
  static final long MAX_NFS_LOCK_REGION = 1073741824L;
  static final long MIN_LOCK_REGION = MAGIC.length + 8;
  private FileChannel fc;
  private FileLock fl;

  protected boolean lockImpl()
    throws Exception
  {
    if ((this.fl != null) && (this.fl.isValid()))
      return true;
    trace("lockImpl(): fc = raf.getChannel()");
    this.fc = this.raf.getChannel();
    trace("lockImpl(): fl = fc.tryLock()");
    this.fl = null;
    try
    {
      this.fl = this.fc.tryLock(0L, MIN_LOCK_REGION, false);
      trace("lockImpl(): fl = " + this.fl);
    }
    catch (Exception localException)
    {
      trace(localException.toString());
    }
    trace("lockImpl(): f.deleteOnExit()");
    this.f.deleteOnExit();
    boolean bool = (this.fl != null) && (this.fl.isValid());
    trace("lockImpl():isValid(): " + bool);
    return bool;
  }

  protected boolean releaseImpl()
    throws Exception
  {
    trace("releaseImpl(): fl = " + this.fl);
    if (this.fl != null)
    {
      trace("releaseImpl(): fl.release()");
      this.fl.release();
      trace("tryRelease(): fl = " + this.fl);
      this.fl = null;
    }
    trace("releaseImpl(): fc = " + this.fc);
    if (this.fc != null)
    {
      trace("releaseImpl(): fc.close()");
      this.fc.close();
      this.fc = null;
    }
    return true;
  }

  public boolean isValid()
  {
    return (super.isValid()) && (this.fl != null) && (this.fl.isValid());
  }

  protected String toStringImpl()
  {
    return "fl =" + this.fl;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.NIOLockFile
 * JD-Core Version:    0.6.0
 */