package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.java.JavaSystem;

public class HsqlProperties
{
  public static final int NO_VALUE_FOR_KEY = 1;
  protected String fileName;
  protected Properties stringProps;
  protected int[] errorCodes = new int[0];
  protected String[] errorKeys = new String[0];
  protected boolean resource = false;
  protected FileAccess fa;

  public HsqlProperties()
  {
    this.stringProps = new Properties();
    this.fileName = null;
  }

  public HsqlProperties(String paramString)
  {
    this.stringProps = new Properties();
    this.fileName = paramString;
    this.fa = FileUtil.getDefaultInstance();
  }

  public HsqlProperties(String paramString, FileAccess paramFileAccess, boolean paramBoolean)
  {
    this.stringProps = new Properties();
    this.fileName = paramString;
    this.resource = paramBoolean;
    this.fa = paramFileAccess;
  }

  public HsqlProperties(Properties paramProperties)
  {
    this.stringProps = paramProperties;
  }

  public void setFileName(String paramString)
  {
    this.fileName = paramString;
  }

  public String setProperty(String paramString, int paramInt)
  {
    return setProperty(paramString, Integer.toString(paramInt));
  }

  public String setProperty(String paramString, boolean paramBoolean)
  {
    return setProperty(paramString, String.valueOf(paramBoolean));
  }

  public String setProperty(String paramString1, String paramString2)
  {
    return (String)this.stringProps.put(paramString1, paramString2);
  }

  public String setPropertyIfNotExists(String paramString1, String paramString2)
  {
    paramString2 = getProperty(paramString1, paramString2);
    return setProperty(paramString1, paramString2);
  }

  public Properties getProperties()
  {
    return this.stringProps;
  }

  public String getProperty(String paramString)
  {
    return this.stringProps.getProperty(paramString);
  }

  public String getProperty(String paramString1, String paramString2)
  {
    return this.stringProps.getProperty(paramString1, paramString2);
  }

  public int getIntegerProperty(String paramString, int paramInt)
  {
    String str = getProperty(paramString);
    try
    {
      if (str != null)
        paramInt = Integer.parseInt(str);
    }
    catch (NumberFormatException localNumberFormatException)
    {
    }
    return paramInt;
  }

  public int getIntegerProperty(String paramString, int paramInt1, int paramInt2, int paramInt3)
  {
    String str = getProperty(paramString);
    int i = 0;
    try
    {
      paramInt1 = Integer.parseInt(str);
    }
    catch (NumberFormatException localNumberFormatException)
    {
    }
    if (paramInt1 < paramInt2)
    {
      paramInt1 = paramInt2;
      i = 1;
    }
    else if (paramInt1 > paramInt3)
    {
      paramInt1 = paramInt3;
      i = 1;
    }
    return paramInt1;
  }

  public int getIntegerProperty(String paramString, int paramInt, int[] paramArrayOfInt)
  {
    String str = getProperty(paramString);
    int i = paramInt;
    try
    {
      if (str != null)
        i = Integer.parseInt(str);
    }
    catch (NumberFormatException localNumberFormatException)
    {
    }
    if (ArrayUtil.find(paramArrayOfInt, i) == -1)
      return paramInt;
    return i;
  }

  public boolean isPropertyTrue(String paramString)
  {
    return isPropertyTrue(paramString, false);
  }

  public boolean isPropertyTrue(String paramString, boolean paramBoolean)
  {
    String str = this.stringProps.getProperty(paramString);
    if (str == null)
      return paramBoolean;
    return str.toLowerCase().equals("true");
  }

  public void removeProperty(String paramString)
  {
    this.stringProps.remove(paramString);
  }

  public void addProperties(Properties paramProperties)
  {
    if (paramProperties == null)
      return;
    Enumeration localEnumeration = paramProperties.keys();
    while (localEnumeration.hasMoreElements())
    {
      Object localObject = localEnumeration.nextElement();
      this.stringProps.put(localObject, paramProperties.get(localObject));
    }
  }

  public void addProperties(HsqlProperties paramHsqlProperties)
  {
    if (paramHsqlProperties == null)
      return;
    addProperties(paramHsqlProperties.stringProps);
  }

  public boolean checkFileExists()
    throws IOException
  {
    String str = this.fileName + ".properties";
    return this.fa.isStreamElement(str);
  }

  public boolean load()
    throws Exception
  {
    if (!checkFileExists())
      return false;
    if ((this.fileName == null) || (this.fileName.length() == 0))
      throw new FileNotFoundException(Trace.getMessage(135));
    InputStream localInputStream = null;
    String str = this.fileName + ".properties";
    try
    {
      localInputStream = this.resource ? getClass().getResourceAsStream(str) : this.fa.openInputStreamElement(str);
      this.stringProps.load(localInputStream);
    }
    finally
    {
      if (localInputStream != null)
        localInputStream.close();
    }
    return true;
  }

  public void save()
    throws Exception
  {
    if ((this.fileName == null) || (this.fileName.length() == 0))
      throw new FileNotFoundException(Trace.getMessage(135));
    String str = this.fileName + ".properties";
    save(str);
  }

  public void save(String paramString)
    throws Exception
  {
    this.fa.createParentDirs(paramString);
    OutputStream localOutputStream = this.fa.openOutputStreamElement(paramString);
    JavaSystem.saveProperties(this.stringProps, "HSQL Database Engine 1.8.0.8", localOutputStream);
    localOutputStream.close();
  }

  private void addError(int paramInt, String paramString)
  {
    this.errorCodes = ((int[])ArrayUtil.resizeArray(this.errorCodes, this.errorCodes.length + 1));
    this.errorKeys = ((String[])ArrayUtil.resizeArray(this.errorKeys, this.errorKeys.length + 1));
    this.errorCodes[(this.errorCodes.length - 1)] = paramInt;
    this.errorKeys[(this.errorKeys.length - 1)] = paramString;
  }

  public static HsqlProperties argArrayToProps(String[] paramArrayOfString, String paramString)
  {
    HsqlProperties localHsqlProperties = new HsqlProperties();
    for (int i = 0; i < paramArrayOfString.length; i++)
    {
      String str = paramArrayOfString[i];
      if (str.startsWith("-?"))
      {
        localHsqlProperties.addError(1, str.substring(1));
      }
      else
      {
        if (str.charAt(0) != '-')
          continue;
        localHsqlProperties.setProperty(paramString + "." + str.substring(1), paramArrayOfString[(i + 1)]);
        i++;
      }
    }
    return localHsqlProperties;
  }

  public static HsqlProperties delimitedArgPairsToProps(String paramString1, String paramString2, String paramString3, String paramString4)
  {
    HsqlProperties localHsqlProperties = new HsqlProperties();
    int j;
    for (int i = 0; ; i = j + paramString3.length())
    {
      j = paramString1.indexOf(paramString3, i);
      if (j == -1)
        j = paramString1.length();
      int k = paramString1.substring(0, j).indexOf(paramString2, i);
      if (k == -1)
      {
        localHsqlProperties.addError(1, paramString1.substring(i, j).trim());
      }
      else
      {
        String str1 = paramString1.substring(i, k).trim();
        String str2 = paramString1.substring(k + paramString2.length(), j).trim();
        if (paramString4 != null)
          str1 = paramString4 + "." + str1;
        localHsqlProperties.setProperty(str1, str2);
      }
      if (j == paramString1.length())
        break;
    }
    return localHsqlProperties;
  }

  public Enumeration propertyNames()
  {
    return this.stringProps.propertyNames();
  }

  public boolean isEmpty()
  {
    return this.stringProps.isEmpty();
  }

  public String[] getErrorKeys()
  {
    return this.errorKeys;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.HsqlProperties
 * JD-Core Version:    0.6.0
 */