package org.hsqldb.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.hsqldb.HsqlDateTime;

public class SimpleLog
{
  public static int LOG_NONE = 0;
  public static int LOG_ERROR = 1;
  public static int LOG_NORMAL = 2;
  private PrintWriter writer;
  private int level;

  public SimpleLog(String paramString, int paramInt, boolean paramBoolean)
  {
    this.level = paramInt;
    if (paramInt != LOG_NONE)
      if (paramBoolean)
      {
        File localFile = new File(paramString);
        makeLog(localFile);
      }
      else
      {
        this.writer = new PrintWriter(System.out);
      }
  }

  private void makeLog(File paramFile)
  {
    try
    {
      FileUtil.makeParentDirectories(paramFile);
      this.writer = new PrintWriter(new FileWriter(paramFile.getPath(), true), true);
    }
    catch (Exception localException)
    {
      this.writer = new PrintWriter(System.out);
    }
  }

  public int getLevel()
  {
    return this.level;
  }

  public PrintWriter getPrintWriter()
  {
    return this.writer;
  }

  public synchronized void sendLine(int paramInt, String paramString)
  {
    if (this.level >= paramInt)
      this.writer.println(HsqlDateTime.getSytemTimeString() + " " + paramString);
  }

  public synchronized void logContext(int paramInt, String paramString)
  {
    if (this.level < paramInt)
      return;
    String str = HsqlDateTime.getSytemTimeString();
    Throwable localThrowable = new Throwable();
    StackTraceElement[] arrayOfStackTraceElement = localThrowable.getStackTrace();
    if (arrayOfStackTraceElement.length > 1)
      str = str + " " + arrayOfStackTraceElement[1].getClassName() + "." + arrayOfStackTraceElement[1].getMethodName();
    this.writer.println(str + " " + paramString);
  }

  public synchronized void logContext(Throwable paramThrowable, String paramString)
  {
    if (this.level == LOG_NONE)
      return;
    String str = HsqlDateTime.getSytemTimeString();
    Throwable localThrowable = new Throwable();
    StackTraceElement[] arrayOfStackTraceElement = localThrowable.getStackTrace();
    if (arrayOfStackTraceElement.length > 1)
      str = str + " " + arrayOfStackTraceElement[1].getClassName() + "." + arrayOfStackTraceElement[1].getMethodName();
    arrayOfStackTraceElement = paramThrowable.getStackTrace();
    if (arrayOfStackTraceElement.length > 0)
      str = str + " " + arrayOfStackTraceElement[0].getClassName() + "." + arrayOfStackTraceElement[0].getMethodName();
    if (paramString == null)
      paramString = "";
    this.writer.println(str + " " + paramThrowable.toString() + " " + paramString);
  }

  public void flush()
  {
    if (this.writer != null)
      this.writer.flush();
  }

  public void close()
  {
    if (this.writer != null)
      this.writer.close();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.SimpleLog
 * JD-Core Version:    0.6.0
 */