package org.hsqldb.lib;

import org.hsqldb.store.BaseHashMap;
import org.hsqldb.store.BaseHashMap.BaseHashIterator;

public class HashSet extends BaseHashMap
  implements Set
{
  public HashSet()
  {
    this(16, 0.75F);
  }

  public HashSet(int paramInt)
    throws IllegalArgumentException
  {
    this(paramInt, 0.75F);
  }

  public HashSet(int paramInt, float paramFloat)
    throws IllegalArgumentException
  {
    super(paramInt, paramFloat, 3, 0, false);
  }

  public boolean contains(Object paramObject)
  {
    return super.containsKey(paramObject);
  }

  public Object get(Object paramObject)
  {
    int i = getLookup(paramObject, paramObject.hashCode());
    if (i < 0)
      return null;
    return this.objectKeyTable[i];
  }

  public boolean add(Object paramObject)
  {
    int i = size();
    super.addOrRemove(0L, 0L, paramObject, null, false);
    return i != size();
  }

  public boolean addAll(Collection paramCollection)
  {
    int i = size();
    Iterator localIterator = paramCollection.iterator();
    while (localIterator.hasNext())
      add(localIterator.next());
    return i != size();
  }

  public boolean addAll(Object[] paramArrayOfObject)
  {
    int i = 0;
    for (int j = 0; j < paramArrayOfObject.length; j++)
    {
      if (!add(paramArrayOfObject[j]))
        continue;
      i = 1;
    }
    return i;
  }

  public boolean remove(Object paramObject)
  {
    int i = size();
    super.removeObject(paramObject);
    return i != size();
  }

  public Object[] toArray(Object[] paramArrayOfObject)
  {
    if ((paramArrayOfObject == null) || (paramArrayOfObject.length < size()))
      paramArrayOfObject = new Object[size()];
    Iterator localIterator = iterator();
    for (int i = 0; localIterator.hasNext(); i++)
      paramArrayOfObject[i] = localIterator.next();
    return paramArrayOfObject;
  }

  public Iterator iterator()
  {
    return new BaseHashMap.BaseHashIterator(this, true);
  }

  public String toString()
  {
    Iterator localIterator = iterator();
    StringBuffer localStringBuffer = new StringBuffer();
    while (localIterator.hasNext())
    {
      if (localStringBuffer.length() > 0)
        localStringBuffer.append(", ");
      else
        localStringBuffer.append('[');
      localStringBuffer.append(localIterator.next());
    }
    return localStringBuffer.toString() + ']';
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.HashSet
 * JD-Core Version:    0.6.0
 */