package org.hsqldb.lib;

import java.lang.reflect.Array;

public class ArrayUtil
{
  public static final int CLASS_CODE_BYTE = 66;
  public static final int CLASS_CODE_CHAR = 67;
  public static final int CLASS_CODE_DOUBLE = 68;
  public static final int CLASS_CODE_FLOAT = 70;
  public static final int CLASS_CODE_INT = 73;
  public static final int CLASS_CODE_LONG = 74;
  public static final int CLASS_CODE_OBJECT = 76;
  public static final int CLASS_CODE_SHORT = 83;
  public static final int CLASS_CODE_BOOLEAN = 90;
  private static IntValueHashMap classCodeMap = new IntValueHashMap();

  static int getClassCode(Class paramClass)
  {
    if (!paramClass.isPrimitive())
      return 76;
    return classCodeMap.get(paramClass, -1);
  }

  public static void clearArray(int paramInt1, Object paramObject, int paramInt2, int paramInt3)
  {
    switch (paramInt1)
    {
    case 66:
      localObject = (byte[])paramObject;
      while (true)
      {
        paramInt3--;
        if (paramInt3 < paramInt2)
          break;
        localObject[paramInt3] = 0;
      }
      return;
    case 67:
      localObject = (byte[])paramObject;
      while (true)
      {
        paramInt3--;
        if (paramInt3 < paramInt2)
          break;
        localObject[paramInt3] = 0;
      }
      return;
    case 83:
      localObject = (short[])paramObject;
      while (true)
      {
        paramInt3--;
        if (paramInt3 < paramInt2)
          break;
        localObject[paramInt3] = 0;
      }
      return;
    case 73:
      localObject = (int[])paramObject;
      while (true)
      {
        paramInt3--;
        if (paramInt3 < paramInt2)
          break;
        localObject[paramInt3] = 0;
      }
      return;
    case 74:
      localObject = (long[])paramObject;
      while (true)
      {
        paramInt3--;
        if (paramInt3 < paramInt2)
          break;
        localObject[paramInt3] = 0L;
      }
      return;
    case 70:
      localObject = (float[])paramObject;
      while (true)
      {
        paramInt3--;
        if (paramInt3 < paramInt2)
          break;
        localObject[paramInt3] = 0.0F;
      }
      return;
    case 68:
      localObject = (double[])paramObject;
      while (true)
      {
        paramInt3--;
        if (paramInt3 < paramInt2)
          break;
        localObject[paramInt3] = 0.0D;
      }
      return;
    case 90:
      localObject = (boolean[])paramObject;
      while (true)
      {
        paramInt3--;
        if (paramInt3 < paramInt2)
          break;
        localObject[paramInt3] = 0;
      }
      return;
    case 69:
    case 71:
    case 72:
    case 75:
    case 76:
    case 77:
    case 78:
    case 79:
    case 80:
    case 81:
    case 82:
    case 84:
    case 85:
    case 86:
    case 87:
    case 88:
    case 89:
    }
    Object localObject = (Object[])paramObject;
    while (true)
    {
      paramInt3--;
      if (paramInt3 < paramInt2)
        break;
      localObject[paramInt3] = null;
    }
  }

  public static void adjustArray(int paramInt1, Object paramObject, int paramInt2, int paramInt3, int paramInt4)
  {
    if (paramInt3 >= paramInt2)
      return;
    int i = paramInt2 + paramInt4;
    int j;
    int k;
    int m;
    if (paramInt4 >= 0)
    {
      j = paramInt3;
      k = paramInt3 + paramInt4;
      m = paramInt2 - paramInt3;
    }
    else
    {
      j = paramInt3 - paramInt4;
      k = paramInt3;
      m = paramInt2 - paramInt3 + paramInt4;
    }
    if (m > 0)
      System.arraycopy(paramObject, j, paramObject, k, m);
    if (paramInt4 < 0)
      clearArray(paramInt1, paramObject, i, paramInt2);
  }

  public static void sortArray(int[] paramArrayOfInt)
  {
    int i;
    do
    {
      i = 0;
      for (int j = 0; j < paramArrayOfInt.length - 1; j++)
      {
        if (paramArrayOfInt[j] <= paramArrayOfInt[(j + 1)])
          continue;
        int k = paramArrayOfInt[(j + 1)];
        paramArrayOfInt[(j + 1)] = paramArrayOfInt[j];
        paramArrayOfInt[j] = k;
        i = 1;
      }
    }
    while (i != 0);
  }

  public static int find(Object[] paramArrayOfObject, Object paramObject)
  {
    for (int i = 0; i < paramArrayOfObject.length; i++)
    {
      if (paramArrayOfObject[i] == paramObject)
        return i;
      if ((paramObject != null) && (paramObject.equals(paramArrayOfObject[i])))
        return i;
    }
    return -1;
  }

  public static int find(int[] paramArrayOfInt, int paramInt)
  {
    for (int i = 0; i < paramArrayOfInt.length; i++)
      if (paramArrayOfInt[i] == paramInt)
        return i;
    return -1;
  }

  public static int findNot(int[] paramArrayOfInt, int paramInt)
  {
    for (int i = 0; i < paramArrayOfInt.length; i++)
      if (paramArrayOfInt[i] != paramInt)
        return i;
    return -1;
  }

  public static boolean areEqualSets(int[] paramArrayOfInt1, int[] paramArrayOfInt2)
  {
    return (paramArrayOfInt1.length == paramArrayOfInt2.length) && (haveEqualSets(paramArrayOfInt1, paramArrayOfInt2, paramArrayOfInt1.length));
  }

  public static boolean areEqual(int[] paramArrayOfInt1, int[] paramArrayOfInt2, int paramInt, boolean paramBoolean)
  {
    if (haveEqualArrays(paramArrayOfInt1, paramArrayOfInt2, paramInt))
    {
      if (paramBoolean)
        return (paramArrayOfInt1.length == paramArrayOfInt2.length) && (paramInt == paramArrayOfInt1.length);
      return true;
    }
    return false;
  }

  public static boolean haveEqualSets(int[] paramArrayOfInt1, int[] paramArrayOfInt2, int paramInt)
  {
    if ((paramInt > paramArrayOfInt1.length) || (paramInt > paramArrayOfInt2.length))
      return false;
    if (paramInt == 1)
      return paramArrayOfInt1[0] == paramArrayOfInt2[0];
    int[] arrayOfInt1 = (int[])resizeArray(paramArrayOfInt1, paramInt);
    int[] arrayOfInt2 = (int[])resizeArray(paramArrayOfInt2, paramInt);
    sortArray(arrayOfInt1);
    sortArray(arrayOfInt2);
    for (int i = 0; i < paramInt; i++)
      if (arrayOfInt1[i] != arrayOfInt2[i])
        return false;
    return true;
  }

  public static boolean haveEqualArrays(int[] paramArrayOfInt1, int[] paramArrayOfInt2, int paramInt)
  {
    if ((paramInt > paramArrayOfInt1.length) || (paramInt > paramArrayOfInt2.length))
      return false;
    for (int i = 0; i < paramInt; i++)
      if (paramArrayOfInt1[i] != paramArrayOfInt2[i])
        return false;
    return true;
  }

  public static boolean haveEqualArrays(Object[] paramArrayOfObject1, Object[] paramArrayOfObject2, int paramInt)
  {
    if ((paramInt > paramArrayOfObject1.length) || (paramInt > paramArrayOfObject2.length))
      return false;
    for (int i = 0; i < paramInt; i++)
      if ((paramArrayOfObject1[i] != paramArrayOfObject2[i]) && ((paramArrayOfObject1[i] == null) || (!paramArrayOfObject1[i].equals(paramArrayOfObject2[i]))))
        return false;
    return true;
  }

  public static boolean haveCommonElement(int[] paramArrayOfInt1, int[] paramArrayOfInt2, int paramInt)
  {
    for (int i = 0; i < paramArrayOfInt1.length; i++)
    {
      int j = paramArrayOfInt1[i];
      for (int k = 0; k < paramInt; k++)
        if (j == paramArrayOfInt2[k])
          return true;
    }
    return false;
  }

  public static int[] commonElements(int[] paramArrayOfInt1, int[] paramArrayOfInt2)
  {
    int[] arrayOfInt = null;
    int i = countCommonElements(paramArrayOfInt1, paramArrayOfInt2);
    if (i > 0)
    {
      arrayOfInt = new int[i];
      int j = 0;
      for (int k = 0; k < paramArrayOfInt1.length; k++)
        for (int m = 0; m < paramArrayOfInt2.length; m++)
        {
          if (paramArrayOfInt1[k] != paramArrayOfInt2[m])
            continue;
          arrayOfInt[(j++)] = paramArrayOfInt1[k];
        }
    }
    return arrayOfInt;
  }

  public static int countCommonElements(int[] paramArrayOfInt1, int[] paramArrayOfInt2)
  {
    int i = 0;
    for (int j = 0; j < paramArrayOfInt1.length; j++)
      for (int k = 0; k < paramArrayOfInt2.length; k++)
      {
        if (paramArrayOfInt1[j] != paramArrayOfInt2[k])
          continue;
        i++;
      }
    return i;
  }

  public static int countSameElements(byte[] paramArrayOfByte1, int paramInt, byte[] paramArrayOfByte2)
  {
    int i = 0;
    int j = paramArrayOfByte1.length - paramInt;
    if (j > paramArrayOfByte2.length)
      j = paramArrayOfByte2.length;
    for (int k = 0; (k < j) && (paramArrayOfByte1[(k + paramInt)] == paramArrayOfByte2[k]); k++)
      i++;
    return i;
  }

  public static int find(byte[] paramArrayOfByte1, int paramInt1, int paramInt2, byte[] paramArrayOfByte2)
  {
    int i = 0;
    paramInt2 = paramInt2 - paramArrayOfByte2.length + 1;
    int j = paramArrayOfByte2[0];
    while (i < paramInt2)
    {
      if (paramArrayOfByte1[i] == j)
      {
        if (paramArrayOfByte2.length == 1)
          return i;
        if (containsAt(paramArrayOfByte1, i, paramArrayOfByte2))
          return i;
      }
      i++;
    }
    return -1;
  }

  public static int findNotIn(byte[] paramArrayOfByte1, int paramInt1, int paramInt2, byte[] paramArrayOfByte2)
  {
    int i = 0;
    if (i < paramInt2)
    {
      for (int j = 0; j < paramArrayOfByte2.length; j++)
        if (paramArrayOfByte1[i] != paramArrayOfByte2[j])
          continue;
      return i;
    }
    return -1;
  }

  public static int findIn(byte[] paramArrayOfByte1, int paramInt1, int paramInt2, byte[] paramArrayOfByte2)
  {
    for (int i = 0; i < paramInt2; i++)
      for (int j = 0; j < paramArrayOfByte2.length; j++)
        if (paramArrayOfByte1[i] == paramArrayOfByte2[j])
          return i;
    return -1;
  }

  public static int find(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
  {
    for (int i = 0; i < paramInt2; i++)
      if ((paramArrayOfByte[i] == paramInt3) || (paramArrayOfByte[i] == paramInt4))
        return i;
    return -1;
  }

  public static void intIndexesToBooleanArray(int[] paramArrayOfInt, boolean[] paramArrayOfBoolean)
  {
    int i = 0;
    for (int j = 0; j < paramArrayOfInt.length; j++)
    {
      if (paramArrayOfInt[j] >= paramArrayOfBoolean.length)
        continue;
      paramArrayOfBoolean[paramArrayOfInt[j]] = true;
    }
  }

  public static boolean containsAllTrueElements(boolean[] paramArrayOfBoolean1, boolean[] paramArrayOfBoolean2)
  {
    for (int i = 0; i < paramArrayOfBoolean1.length; i++)
      if ((paramArrayOfBoolean2[i] != 0) && (paramArrayOfBoolean1[i] == 0))
        return false;
    return true;
  }

  public static boolean containsAt(byte[] paramArrayOfByte1, int paramInt, byte[] paramArrayOfByte2)
  {
    return countSameElements(paramArrayOfByte1, paramInt, paramArrayOfByte2) == paramArrayOfByte2.length;
  }

  public static int countStartElementsAt(byte[] paramArrayOfByte1, int paramInt, byte[] paramArrayOfByte2)
  {
    int i = 0;
    for (int j = paramInt; j < paramArrayOfByte1.length; j++)
      for (int k = 0; ; k++)
      {
        if (k >= paramArrayOfByte2.length)
          break label51;
        if (paramArrayOfByte1[j] != paramArrayOfByte2[k])
          continue;
        i++;
        break;
      }
    label51: return i;
  }

  public static int countNonStartElementsAt(byte[] paramArrayOfByte1, int paramInt, byte[] paramArrayOfByte2)
  {
    int i = 0;
    for (int j = paramInt; j < paramArrayOfByte1.length; j++)
    {
      for (int k = 0; k < paramArrayOfByte2.length; k++)
        if (paramArrayOfByte1[j] == paramArrayOfByte2[k])
          break label51;
      i++;
    }
    label51: return i;
  }

  public static void copyArray(Object paramObject1, Object paramObject2, int paramInt)
  {
    System.arraycopy(paramObject1, 0, paramObject2, 0, paramInt);
  }

  public static int[] arraySlice(int[] paramArrayOfInt, int paramInt1, int paramInt2)
  {
    int[] arrayOfInt = new int[paramInt2];
    System.arraycopy(paramArrayOfInt, paramInt1, arrayOfInt, 0, paramInt2);
    return arrayOfInt;
  }

  public static void fillArray(Object[] paramArrayOfObject, Object paramObject)
  {
    int i = paramArrayOfObject.length;
    while (true)
    {
      i--;
      if (i < 0)
        break;
      paramArrayOfObject[i] = paramObject;
    }
  }

  public static void fillArray(int[] paramArrayOfInt, int paramInt)
  {
    int i = paramArrayOfInt.length;
    while (true)
    {
      i--;
      if (i < 0)
        break;
      paramArrayOfInt[i] = paramInt;
    }
  }

  public static Object duplicateArray(Object paramObject)
  {
    int i = Array.getLength(paramObject);
    Object localObject = Array.newInstance(paramObject.getClass().getComponentType(), i);
    System.arraycopy(paramObject, 0, localObject, 0, i);
    return localObject;
  }

  public static Object resizeArrayIfDifferent(Object paramObject, int paramInt)
  {
    int i = Array.getLength(paramObject);
    if (i == paramInt)
      return paramObject;
    Object localObject = Array.newInstance(paramObject.getClass().getComponentType(), paramInt);
    if (i < paramInt)
      paramInt = i;
    System.arraycopy(paramObject, 0, localObject, 0, paramInt);
    return localObject;
  }

  public static Object resizeArray(Object paramObject, int paramInt)
  {
    Object localObject = Array.newInstance(paramObject.getClass().getComponentType(), paramInt);
    int i = Array.getLength(paramObject);
    if (i < paramInt)
      paramInt = i;
    System.arraycopy(paramObject, 0, localObject, 0, paramInt);
    return localObject;
  }

  public static Object toAdjustedArray(Object paramObject1, Object paramObject2, int paramInt1, int paramInt2)
  {
    int i = Array.getLength(paramObject1) + paramInt2;
    Object localObject = Array.newInstance(paramObject1.getClass().getComponentType(), i);
    copyAdjustArray(paramObject1, localObject, paramObject2, paramInt1, paramInt2);
    return localObject;
  }

  public static void copyAdjustArray(Object paramObject1, Object paramObject2, Object paramObject3, int paramInt1, int paramInt2)
  {
    int i = Array.getLength(paramObject1);
    if (paramInt1 < 0)
    {
      System.arraycopy(paramObject1, 0, paramObject2, 0, i);
      return;
    }
    System.arraycopy(paramObject1, 0, paramObject2, 0, paramInt1);
    int j;
    if (paramInt2 == 0)
    {
      j = i - paramInt1 - 1;
      Array.set(paramObject2, paramInt1, paramObject3);
      if (j > 0)
        System.arraycopy(paramObject1, paramInt1 + 1, paramObject2, paramInt1 + 1, j);
    }
    else if (paramInt2 < 0)
    {
      j = i - paramInt1 - 1;
      if (j > 0)
        System.arraycopy(paramObject1, paramInt1 + 1, paramObject2, paramInt1, j);
    }
    else
    {
      j = i - paramInt1;
      Array.set(paramObject2, paramInt1, paramObject3);
      if (j > 0)
        System.arraycopy(paramObject1, paramInt1, paramObject2, paramInt1 + 1, j);
    }
  }

  public static int[] toAdjustedColumnArray(int[] paramArrayOfInt, int paramInt1, int paramInt2)
  {
    if (paramArrayOfInt == null)
      return null;
    int[] arrayOfInt1 = new int[paramArrayOfInt.length];
    int i = 0;
    for (int j = 0; j < paramArrayOfInt.length; j++)
      if (paramArrayOfInt[j] > paramInt1)
      {
        paramArrayOfInt[j] += paramInt2;
        i++;
      }
      else if (paramArrayOfInt[j] == paramInt1)
      {
        if (paramInt2 < 0)
          continue;
        paramArrayOfInt[j] += paramInt2;
        i++;
      }
      else
      {
        arrayOfInt1[i] = paramArrayOfInt[j];
        i++;
      }
    if (paramArrayOfInt.length != i)
    {
      int[] arrayOfInt2 = new int[i];
      copyArray(arrayOfInt1, arrayOfInt2, i);
      return arrayOfInt2;
    }
    return arrayOfInt1;
  }

  public static void copyColumnValues(Object[] paramArrayOfObject1, int[] paramArrayOfInt, Object[] paramArrayOfObject2)
  {
    for (int i = 0; i < paramArrayOfInt.length; i++)
      paramArrayOfObject2[i] = paramArrayOfObject1[paramArrayOfInt[i]];
  }

  public static void copyColumnValues(int[] paramArrayOfInt1, int[] paramArrayOfInt2, int[] paramArrayOfInt3)
  {
    for (int i = 0; i < paramArrayOfInt2.length; i++)
      paramArrayOfInt3[i] = paramArrayOfInt1[paramArrayOfInt2[i]];
  }

  public static void fillSequence(int[] paramArrayOfInt)
  {
    for (int i = 0; i < paramArrayOfInt.length; i++)
      paramArrayOfInt[i] = i;
  }

  static
  {
    classCodeMap.put(Byte.TYPE, 66);
    classCodeMap.put(Character.TYPE, 83);
    classCodeMap.put(Short.TYPE, 83);
    classCodeMap.put(Integer.TYPE, 73);
    classCodeMap.put(Long.TYPE, 74);
    classCodeMap.put(Float.TYPE, 70);
    classCodeMap.put(Double.TYPE, 68);
    classCodeMap.put(Boolean.TYPE, 90);
    classCodeMap.put(Object.class, 76);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.ArrayUtil
 * JD-Core Version:    0.6.0
 */