package org.hsqldb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Result.ResultMetaData;
import org.hsqldb.Types;
import org.hsqldb.persist.HsqlProperties;

public class jdbcResultSetMetaData
  implements ResultSetMetaData
{
  private jdbcColumnMetaData[] columnMetaData;
  private int columnCount;
  private boolean useColumnName;
  private static final boolean TRACE = false;

  jdbcResultSetMetaData(jdbcResultSet paramjdbcResultSet, HsqlProperties paramHsqlProperties)
    throws SQLException
  {
    init(paramjdbcResultSet, paramHsqlProperties);
  }

  jdbcResultSetMetaData(Result paramResult, HsqlProperties paramHsqlProperties)
    throws SQLException
  {
    init(paramResult, paramHsqlProperties);
  }

  void init(jdbcResultSet paramjdbcResultSet, HsqlProperties paramHsqlProperties)
    throws SQLException
  {
    if (paramjdbcResultSet == null)
      throw Util.sqlException(40, 119, null);
    init(paramjdbcResultSet.rResult, paramHsqlProperties);
  }

  void init(Result paramResult, HsqlProperties paramHsqlProperties)
    throws SQLException
  {
    if (paramResult == null)
      throw Util.sqlException(40, 120, null);
    if (!paramResult.isData())
      return;
    this.columnCount = paramResult.getColumnCount();
    this.useColumnName = (paramHsqlProperties == null ? true : paramHsqlProperties.isPropertyTrue("get_column_name"));
    this.columnMetaData = new jdbcColumnMetaData[this.columnCount];
    Result.ResultMetaData localResultMetaData = paramResult.metaData;
    for (int j = 0; j < this.columnCount; j++)
    {
      jdbcColumnMetaData localjdbcColumnMetaData = new jdbcColumnMetaData();
      this.columnMetaData[j] = localjdbcColumnMetaData;
      localjdbcColumnMetaData.catalogName = (localResultMetaData.catalogNames[j] == null ? "" : localResultMetaData.catalogNames[j]);
      localjdbcColumnMetaData.schemaName = (localResultMetaData.schemaNames[j] == null ? "" : localResultMetaData.schemaNames[j]);
      localjdbcColumnMetaData.tableName = (localResultMetaData.tableNames[j] == null ? "" : localResultMetaData.tableNames[j]);
      localjdbcColumnMetaData.columnName = (localResultMetaData.colNames[j] == null ? "" : localResultMetaData.colNames[j]);
      localjdbcColumnMetaData.columnLabel = (localResultMetaData.colLabels[j] == null ? "" : localResultMetaData.colLabels[j]);
      localjdbcColumnMetaData.columnType = localResultMetaData.colTypes[j];
      localjdbcColumnMetaData.columnTypeName = Types.getTypeString(localjdbcColumnMetaData.columnType);
      localjdbcColumnMetaData.isWritable = localResultMetaData.isWritable[j];
      localjdbcColumnMetaData.isReadOnly = (!localjdbcColumnMetaData.isWritable);
      localjdbcColumnMetaData.isAutoIncrement = localResultMetaData.isIdentity[j];
      localjdbcColumnMetaData.isNullable = localResultMetaData.colNullable[j];
      int i = localjdbcColumnMetaData.columnType;
      localjdbcColumnMetaData.columnClassName = localResultMetaData.classNames[j];
      if ((localjdbcColumnMetaData.columnClassName == null) || (localjdbcColumnMetaData.columnClassName.length() == 0))
        localjdbcColumnMetaData.columnClassName = Types.getColStClsName(i);
      if (Types.acceptsPrecisionCreateParam(i))
      {
        if (localResultMetaData.colSizes[j] == 0)
        {
          localjdbcColumnMetaData.columnDisplaySize = Types.getMaxDisplaySize(i);
        }
        else
        {
          localjdbcColumnMetaData.columnDisplaySize = localResultMetaData.colSizes[j];
          if ((Types.acceptsScaleCreateParam(i)) && (localResultMetaData.colScales[j] != 0))
            localjdbcColumnMetaData.columnDisplaySize += 1 + localResultMetaData.colScales[j];
        }
      }
      else
        localjdbcColumnMetaData.columnDisplaySize = Types.getMaxDisplaySize(i);
      if ((Types.isNumberType(i)) && (Types.acceptsPrecisionCreateParam(i)))
      {
        localjdbcColumnMetaData.precision = localResultMetaData.colSizes[j];
        if (localjdbcColumnMetaData.precision == 0)
          localjdbcColumnMetaData.precision = Types.getPrecision(i);
      }
      else
      {
        localjdbcColumnMetaData.precision = Types.getPrecision(i);
      }
      if (Types.acceptsScaleCreateParam(i))
        localjdbcColumnMetaData.scale = localResultMetaData.colScales[j];
      Boolean localBoolean1 = Types.isUnsignedAttribute(i);
      localjdbcColumnMetaData.isSigned = ((localBoolean1 != null) && (!localBoolean1.booleanValue()));
      Boolean localBoolean2 = Types.isCaseSensitive(i);
      localjdbcColumnMetaData.isCaseSensitive = ((localBoolean2 != null) && (localBoolean2.booleanValue()));
      localjdbcColumnMetaData.isSearchable = Types.isSearchable(i);
    }
  }

  public int getColumnCount()
    throws SQLException
  {
    return this.columnCount;
  }

  public boolean isAutoIncrement(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].isAutoIncrement;
  }

  public boolean isCaseSensitive(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].isCaseSensitive;
  }

  public boolean isSearchable(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].isSearchable;
  }

  public boolean isCurrency(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].isCurrency;
  }

  public int isNullable(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].isNullable;
  }

  public boolean isSigned(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].isSigned;
  }

  public int getColumnDisplaySize(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].columnDisplaySize;
  }

  public String getColumnLabel(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].columnLabel;
  }

  public String getColumnName(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.useColumnName ? this.columnMetaData[paramInt].columnName : this.columnMetaData[paramInt].columnLabel;
  }

  public String getSchemaName(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].schemaName;
  }

  public int getPrecision(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].precision;
  }

  public int getScale(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].scale;
  }

  public String getTableName(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].tableName;
  }

  public String getCatalogName(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].catalogName;
  }

  public int getColumnType(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    int i = this.columnMetaData[paramInt].columnType;
    return i == 100 ? 12 : i;
  }

  public String getColumnTypeName(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].columnTypeName;
  }

  public boolean isReadOnly(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].isReadOnly;
  }

  public boolean isWritable(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].isWritable;
  }

  public boolean isDefinitelyWritable(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].isDefinitelyWritable;
  }

  public String getColumnClassName(int paramInt)
    throws SQLException
  {
    checkColumn(paramInt);
    paramInt--;
    return this.columnMetaData[paramInt].columnClassName;
  }

  public String toString()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append(super.toString());
    if (this.columnCount == 0)
    {
      localStringBuffer.append("[columnCount=0]");
      return localStringBuffer.toString();
    }
    localStringBuffer.append('[');
    for (int i = 0; i < this.columnCount; i++)
    {
      localStringBuffer.append('\n');
      localStringBuffer.append("   column_");
      localStringBuffer.append(i + 1);
      localStringBuffer.append('=');
      localStringBuffer.append(this.columnMetaData[i]);
      if (i + 1 >= this.columnCount)
        continue;
      localStringBuffer.append(',');
      localStringBuffer.append(' ');
    }
    localStringBuffer.append('\n');
    localStringBuffer.append(']');
    return localStringBuffer.toString();
  }

  private void checkColumn(int paramInt)
    throws SQLException
  {
    if ((paramInt < 1) || (paramInt > this.columnCount))
      throw Util.sqlException(28, String.valueOf(paramInt));
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcResultSetMetaData
 * JD-Core Version:    0.6.0
 */