package org.hsqldb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.Column;
import org.hsqldb.Library;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

public class jdbcDatabaseMetaData
  implements DatabaseMetaData
{
  static final Integer INT_COLUMNS_NO_NULLS = new Integer(0);
  private jdbcConnection connection;
  private boolean useSchemaDefault;
  private static final String BRI_SESSION_SCOPE_IN_LIST = "(2)";
  private static final String BRI_TEMPORARY_SCOPE_IN_LIST = "(0,1,2)";
  private static final String BRI_TRANSACTION_SCOPE_IN_LIST = "(1,2)";
  private static final String selstar = "SELECT * FROM INFORMATION_SCHEMA.";
  private static final String whereTrue = " WHERE 1=1";

  public boolean allProceduresAreCallable()
    throws SQLException
  {
    return true;
  }

  public boolean allTablesAreSelectable()
    throws SQLException
  {
    return true;
  }

  public String getURL()
    throws SQLException
  {
    return this.connection.getURL();
  }

  public String getUserName()
    throws SQLException
  {
    ResultSet localResultSet = execute("CALL USER()");
    localResultSet.next();
    String str = localResultSet.getString(1);
    localResultSet.close();
    return str;
  }

  public boolean isReadOnly()
    throws SQLException
  {
    ResultSet localResultSet = execute("CALL \"org.hsqldb.Library.isReadOnlyDatabase\"()");
    localResultSet.next();
    boolean bool = localResultSet.getBoolean(1);
    localResultSet.close();
    return bool;
  }

  public boolean nullsAreSortedHigh()
    throws SQLException
  {
    return false;
  }

  public boolean nullsAreSortedLow()
    throws SQLException
  {
    return true;
  }

  public boolean nullsAreSortedAtStart()
    throws SQLException
  {
    return false;
  }

  public boolean nullsAreSortedAtEnd()
    throws SQLException
  {
    return false;
  }

  public String getDatabaseProductName()
    throws SQLException
  {
    ResultSet localResultSet = execute("call \"org.hsqldb.Library.getDatabaseProductName\"()");
    localResultSet.next();
    String str = localResultSet.getString(1);
    localResultSet.close();
    return str;
  }

  public String getDatabaseProductVersion()
    throws SQLException
  {
    ResultSet localResultSet = execute("call \"org.hsqldb.Library.getDatabaseProductVersion\"()");
    localResultSet.next();
    String str = localResultSet.getString(1);
    localResultSet.close();
    return str;
  }

  public String getDriverName()
    throws SQLException
  {
    return "HSQL Database Engine Driver";
  }

  public String getDriverVersion()
    throws SQLException
  {
    return "1.8.0";
  }

  public int getDriverMajorVersion()
  {
    return 1;
  }

  public int getDriverMinorVersion()
  {
    return 8;
  }

  public boolean usesLocalFiles()
    throws SQLException
  {
    return false;
  }

  public boolean usesLocalFilePerTable()
    throws SQLException
  {
    return false;
  }

  public boolean supportsMixedCaseIdentifiers()
    throws SQLException
  {
    return false;
  }

  public boolean storesUpperCaseIdentifiers()
    throws SQLException
  {
    return true;
  }

  public boolean storesLowerCaseIdentifiers()
    throws SQLException
  {
    return false;
  }

  public boolean storesMixedCaseIdentifiers()
    throws SQLException
  {
    return false;
  }

  public boolean supportsMixedCaseQuotedIdentifiers()
    throws SQLException
  {
    return true;
  }

  public boolean storesUpperCaseQuotedIdentifiers()
    throws SQLException
  {
    return false;
  }

  public boolean storesLowerCaseQuotedIdentifiers()
    throws SQLException
  {
    return false;
  }

  public boolean storesMixedCaseQuotedIdentifiers()
    throws SQLException
  {
    return false;
  }

  public String getIdentifierQuoteString()
    throws SQLException
  {
    return "\"";
  }

  public String getSQLKeywords()
    throws SQLException
  {
    return "BEFORE,BIGINT,BINARY,CACHED,DATETIME,LIMIT,LONGVARBINARY,LONGVARCHAR,OBJECT,OTHER,SAVEPOINT,TEMP,TEXT,TOP,TRIGGER,TINYINT,VARBINARY,VARCHAR_IGNORECASE";
  }

  public String getNumericFunctions()
    throws SQLException
  {
    return StringUtil.getList(Library.sNumeric, ",", "");
  }

  public String getStringFunctions()
    throws SQLException
  {
    return StringUtil.getList(Library.sString, ",", "");
  }

  public String getSystemFunctions()
    throws SQLException
  {
    return StringUtil.getList(Library.sSystem, ",", "");
  }

  public String getTimeDateFunctions()
    throws SQLException
  {
    return StringUtil.getList(Library.sTimeDate, ",", "");
  }

  public String getSearchStringEscape()
    throws SQLException
  {
    return "\\";
  }

  public String getExtraNameCharacters()
    throws SQLException
  {
    return "";
  }

  public boolean supportsAlterTableWithAddColumn()
    throws SQLException
  {
    return true;
  }

  public boolean supportsAlterTableWithDropColumn()
    throws SQLException
  {
    return true;
  }

  public boolean supportsColumnAliasing()
    throws SQLException
  {
    return true;
  }

  public boolean nullPlusNonNullIsNull()
    throws SQLException
  {
    return true;
  }

  public boolean supportsConvert()
    throws SQLException
  {
    return true;
  }

  public boolean supportsConvert(int paramInt1, int paramInt2)
    throws SQLException
  {
    return true;
  }

  public boolean supportsTableCorrelationNames()
    throws SQLException
  {
    return true;
  }

  public boolean supportsDifferentTableCorrelationNames()
    throws SQLException
  {
    return true;
  }

  public boolean supportsExpressionsInOrderBy()
    throws SQLException
  {
    return true;
  }

  public boolean supportsOrderByUnrelated()
    throws SQLException
  {
    return true;
  }

  public boolean supportsGroupBy()
    throws SQLException
  {
    return true;
  }

  public boolean supportsGroupByUnrelated()
    throws SQLException
  {
    return true;
  }

  public boolean supportsGroupByBeyondSelect()
    throws SQLException
  {
    return true;
  }

  public boolean supportsLikeEscapeClause()
    throws SQLException
  {
    return true;
  }

  public boolean supportsMultipleResultSets()
    throws SQLException
  {
    return false;
  }

  public boolean supportsMultipleTransactions()
    throws SQLException
  {
    return true;
  }

  public boolean supportsNonNullableColumns()
    throws SQLException
  {
    return true;
  }

  public boolean supportsMinimumSQLGrammar()
    throws SQLException
  {
    return false;
  }

  public boolean supportsCoreSQLGrammar()
    throws SQLException
  {
    return true;
  }

  public boolean supportsExtendedSQLGrammar()
    throws SQLException
  {
    return false;
  }

  public boolean supportsANSI92EntryLevelSQL()
    throws SQLException
  {
    return false;
  }

  public boolean supportsANSI92IntermediateSQL()
    throws SQLException
  {
    return false;
  }

  public boolean supportsANSI92FullSQL()
    throws SQLException
  {
    return false;
  }

  public boolean supportsIntegrityEnhancementFacility()
    throws SQLException
  {
    return true;
  }

  public boolean supportsOuterJoins()
    throws SQLException
  {
    return true;
  }

  public boolean supportsFullOuterJoins()
    throws SQLException
  {
    return false;
  }

  public boolean supportsLimitedOuterJoins()
    throws SQLException
  {
    return true;
  }

  public String getSchemaTerm()
    throws SQLException
  {
    return "SCHEMA";
  }

  public String getProcedureTerm()
    throws SQLException
  {
    return "";
  }

  public String getCatalogTerm()
    throws SQLException
  {
    return "";
  }

  public boolean isCatalogAtStart()
    throws SQLException
  {
    return false;
  }

  public String getCatalogSeparator()
    throws SQLException
  {
    return "";
  }

  public boolean supportsSchemasInDataManipulation()
    throws SQLException
  {
    return false;
  }

  public boolean supportsSchemasInProcedureCalls()
    throws SQLException
  {
    return false;
  }

  public boolean supportsSchemasInTableDefinitions()
    throws SQLException
  {
    return !this.useSchemaDefault;
  }

  public boolean supportsSchemasInIndexDefinitions()
    throws SQLException
  {
    return !this.useSchemaDefault;
  }

  public boolean supportsSchemasInPrivilegeDefinitions()
    throws SQLException
  {
    return !this.useSchemaDefault;
  }

  public boolean supportsCatalogsInDataManipulation()
    throws SQLException
  {
    return false;
  }

  public boolean supportsCatalogsInProcedureCalls()
    throws SQLException
  {
    return false;
  }

  public boolean supportsCatalogsInTableDefinitions()
    throws SQLException
  {
    return false;
  }

  public boolean supportsCatalogsInIndexDefinitions()
    throws SQLException
  {
    return false;
  }

  public boolean supportsCatalogsInPrivilegeDefinitions()
    throws SQLException
  {
    return false;
  }

  public boolean supportsPositionedDelete()
    throws SQLException
  {
    return false;
  }

  public boolean supportsPositionedUpdate()
    throws SQLException
  {
    return false;
  }

  public boolean supportsSelectForUpdate()
    throws SQLException
  {
    return false;
  }

  public boolean supportsStoredProcedures()
    throws SQLException
  {
    return true;
  }

  public boolean supportsSubqueriesInComparisons()
    throws SQLException
  {
    return true;
  }

  public boolean supportsSubqueriesInExists()
    throws SQLException
  {
    return true;
  }

  public boolean supportsSubqueriesInIns()
    throws SQLException
  {
    return true;
  }

  public boolean supportsSubqueriesInQuantifieds()
    throws SQLException
  {
    return true;
  }

  public boolean supportsCorrelatedSubqueries()
    throws SQLException
  {
    return true;
  }

  public boolean supportsUnion()
    throws SQLException
  {
    return true;
  }

  public boolean supportsUnionAll()
    throws SQLException
  {
    return true;
  }

  public boolean supportsOpenCursorsAcrossCommit()
    throws SQLException
  {
    return false;
  }

  public boolean supportsOpenCursorsAcrossRollback()
    throws SQLException
  {
    return false;
  }

  public boolean supportsOpenStatementsAcrossCommit()
    throws SQLException
  {
    return true;
  }

  public boolean supportsOpenStatementsAcrossRollback()
    throws SQLException
  {
    return true;
  }

  public int getMaxBinaryLiteralLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxCharLiteralLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxColumnNameLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxColumnsInGroupBy()
    throws SQLException
  {
    return 0;
  }

  public int getMaxColumnsInIndex()
    throws SQLException
  {
    return 0;
  }

  public int getMaxColumnsInOrderBy()
    throws SQLException
  {
    return 0;
  }

  public int getMaxColumnsInSelect()
    throws SQLException
  {
    return 0;
  }

  public int getMaxColumnsInTable()
    throws SQLException
  {
    return 0;
  }

  public int getMaxConnections()
    throws SQLException
  {
    return 0;
  }

  public int getMaxCursorNameLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxIndexLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxSchemaNameLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxProcedureNameLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxCatalogNameLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxRowSize()
    throws SQLException
  {
    return 0;
  }

  public boolean doesMaxRowSizeIncludeBlobs()
    throws SQLException
  {
    return true;
  }

  public int getMaxStatementLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxStatements()
    throws SQLException
  {
    return 0;
  }

  public int getMaxTableNameLength()
    throws SQLException
  {
    return 0;
  }

  public int getMaxTablesInSelect()
    throws SQLException
  {
    return 0;
  }

  public int getMaxUserNameLength()
    throws SQLException
  {
    return 0;
  }

  public int getDefaultTransactionIsolation()
    throws SQLException
  {
    return 1;
  }

  public boolean supportsTransactions()
    throws SQLException
  {
    return true;
  }

  public boolean supportsTransactionIsolationLevel(int paramInt)
    throws SQLException
  {
    return (paramInt == 1) || (paramInt == 2) || (paramInt == 4) || (paramInt == 8);
  }

  public boolean supportsDataDefinitionAndDataManipulationTransactions()
    throws SQLException
  {
    return false;
  }

  public boolean supportsDataManipulationTransactionsOnly()
    throws SQLException
  {
    return true;
  }

  public boolean dataDefinitionCausesTransactionCommit()
    throws SQLException
  {
    return true;
  }

  public boolean dataDefinitionIgnoredInTransactions()
    throws SQLException
  {
    return false;
  }

  public ResultSet getProcedures(String paramString1, String paramString2, String paramString3)
    throws SQLException
  {
    if (wantsIsNull(paramString3))
      return executeSelect("SYSTEM_PROCEDURES", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_PROCEDURES").append(and("PROCEDURE_CAT", "=", paramString1)).append(and("PROCEDURE_SCHEM", "LIKE", paramString2)).append(and("PROCEDURE_NAME", "LIKE", paramString3));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getProcedureColumns(String paramString1, String paramString2, String paramString3, String paramString4)
    throws SQLException
  {
    if ((wantsIsNull(paramString3)) || (wantsIsNull(paramString4)))
      return executeSelect("SYSTEM_PROCEDURECOLUMNS", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_PROCEDURECOLUMNS").append(and("PROCEDURE_CAT", "=", paramString1)).append(and("PROCEDURE_SCHEM", "LIKE", paramString2)).append(and("PROCEDURE_NAME", "LIKE", paramString3)).append(and("COLUMN_NAME", "LIKE", paramString4));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getTables(String paramString1, String paramString2, String paramString3, String[] paramArrayOfString)
    throws SQLException
  {
    if ((wantsIsNull(paramString3)) || ((paramArrayOfString != null) && (paramArrayOfString.length == 0)))
      return executeSelect("SYSTEM_TABLES", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_TABLES").append(and("TABLE_CAT", "=", paramString1)).append(and("TABLE_SCHEM", "LIKE", paramString2)).append(and("TABLE_NAME", "LIKE", paramString3));
    if (paramArrayOfString != null)
      localStringBuffer.append(" AND TABLE_TYPE IN (").append(StringUtil.getList(paramArrayOfString, ",", "'")).append(')');
    return execute(localStringBuffer.toString());
  }

  public ResultSet getSchemas()
    throws SQLException
  {
    return executeSelect("SYSTEM_SCHEMAS", null);
  }

  public ResultSet getCatalogs()
    throws SQLException
  {
    return executeSelect("SYSTEM_CATALOGS", null);
  }

  public ResultSet getTableTypes()
    throws SQLException
  {
    return executeSelect("SYSTEM_TABLETYPES", null);
  }

  public ResultSet getColumns(String paramString1, String paramString2, String paramString3, String paramString4)
    throws SQLException
  {
    if ((wantsIsNull(paramString3)) || (wantsIsNull(paramString4)))
      return executeSelect("SYSTEM_COLUMNS", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_COLUMNS").append(and("TABLE_CAT", "=", paramString1)).append(and("TABLE_SCHEM", "LIKE", paramString2)).append(and("TABLE_NAME", "LIKE", paramString3)).append(and("COLUMN_NAME", "LIKE", paramString4));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getColumnPrivileges(String paramString1, String paramString2, String paramString3, String paramString4)
    throws SQLException
  {
    if (paramString3 == null)
      Util.sqlException(62);
    if (wantsIsNull(paramString4))
      return executeSelect("SYSTEM_COLUMNPRIVILEGES", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_COLUMNPRIVILEGES").append(and("TABLE_CAT", "=", paramString1)).append(and("TABLE_SCHEM", "=", paramString2)).append(and("TABLE_NAME", "=", paramString3)).append(and("COLUMN_NAME", "LIKE", paramString4));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getTablePrivileges(String paramString1, String paramString2, String paramString3)
    throws SQLException
  {
    if (wantsIsNull(paramString3))
      return executeSelect("SYSTEM_TABLEPRIVILEGES", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_TABLEPRIVILEGES").append(and("TABLE_CAT", "=", paramString1)).append(and("TABLE_SCHEM", "LIKE", paramString2)).append(and("TABLE_NAME", "LIKE", paramString3));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getBestRowIdentifier(String paramString1, String paramString2, String paramString3, int paramInt, boolean paramBoolean)
    throws SQLException
  {
    String str;
    switch (paramInt)
    {
    case 0:
      str = "(0,1,2)";
      break;
    case 1:
      str = "(1,2)";
      break;
    case 2:
      str = "(2)";
      break;
    default:
      throw Util.sqlException(38, 118, null);
    }
    if (paramString3 == null)
      Util.sqlException(62);
    paramString2 = translateSchema(paramString2);
    Integer localInteger = paramBoolean ? null : INT_COLUMNS_NO_NULLS;
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_BESTROWIDENTIFIER").append(and("TABLE_CAT", "=", paramString1)).append(and("TABLE_SCHEM", "=", paramString2)).append(and("TABLE_NAME", "=", paramString3)).append(and("NULLABLE", "=", localInteger)).append(" AND SCOPE IN " + str);
    return execute(localStringBuffer.toString());
  }

  public ResultSet getVersionColumns(String paramString1, String paramString2, String paramString3)
    throws SQLException
  {
    if (paramString3 == null)
      Util.sqlException(62);
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_VERSIONCOLUMNS").append(and("TABLE_CAT", "=", paramString1)).append(and("TABLE_SCHEM", "=", paramString2)).append(and("TABLE_NAME", "=", paramString3));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getPrimaryKeys(String paramString1, String paramString2, String paramString3)
    throws SQLException
  {
    if (paramString3 == null)
      Util.sqlException(62);
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_PRIMARYKEYS").append(and("TABLE_CAT", "=", paramString1)).append(and("TABLE_SCHEM", "=", paramString2)).append(and("TABLE_NAME", "=", paramString3));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getImportedKeys(String paramString1, String paramString2, String paramString3)
    throws SQLException
  {
    if (paramString3 == null)
      Util.sqlException(62);
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_CROSSREFERENCE").append(and("FKTABLE_CAT", "=", paramString1)).append(and("FKTABLE_SCHEM", "=", paramString2)).append(and("FKTABLE_NAME", "=", paramString3)).append(" ORDER BY PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ");
    return execute(localStringBuffer.toString());
  }

  public ResultSet getExportedKeys(String paramString1, String paramString2, String paramString3)
    throws SQLException
  {
    if (paramString3 == null)
      Util.sqlException(62);
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_CROSSREFERENCE").append(and("PKTABLE_CAT", "=", paramString1)).append(and("PKTABLE_SCHEM", "=", paramString2)).append(and("PKTABLE_NAME", "=", paramString3));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getCrossReference(String paramString1, String paramString2, String paramString3, String paramString4, String paramString5, String paramString6)
    throws SQLException
  {
    if ((paramString3 == null) || (paramString6 == null))
      Util.sqlException(62);
    paramString2 = translateSchema(paramString2);
    paramString5 = translateSchema(paramString5);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_CROSSREFERENCE").append(and("PKTABLE_CAT", "=", paramString1)).append(and("PKTABLE_SCHEM", "=", paramString2)).append(and("PKTABLE_NAME", "=", paramString3)).append(and("FKTABLE_CAT", "=", paramString4)).append(and("FKTABLE_SCHEM", "=", paramString5)).append(and("FKTABLE_NAME", "=", paramString6));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getTypeInfo()
    throws SQLException
  {
    return executeSelect("SYSTEM_TYPEINFO", null);
  }

  public ResultSet getIndexInfo(String paramString1, String paramString2, String paramString3, boolean paramBoolean1, boolean paramBoolean2)
    throws SQLException
  {
    if (paramString3 == null)
      Util.sqlException(62);
    paramString2 = translateSchema(paramString2);
    Object localObject = paramBoolean1 ? Boolean.FALSE : null;
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_INDEXINFO").append(and("TABLE_CAT", "=", paramString1)).append(and("TABLE_SCHEM", "=", paramString2)).append(and("TABLE_NAME", "=", paramString3)).append(and("NON_UNIQUE", "=", localObject));
    return execute(localStringBuffer.toString());
  }

  public boolean supportsResultSetType(int paramInt)
    throws SQLException
  {
    return (paramInt == 1003) || (paramInt == 1004);
  }

  public boolean supportsResultSetConcurrency(int paramInt1, int paramInt2)
    throws SQLException
  {
    return (supportsResultSetType(paramInt1)) && (paramInt2 == 1007);
  }

  public boolean ownUpdatesAreVisible(int paramInt)
    throws SQLException
  {
    return false;
  }

  public boolean ownDeletesAreVisible(int paramInt)
    throws SQLException
  {
    return false;
  }

  public boolean ownInsertsAreVisible(int paramInt)
    throws SQLException
  {
    return false;
  }

  public boolean othersUpdatesAreVisible(int paramInt)
    throws SQLException
  {
    return false;
  }

  public boolean othersDeletesAreVisible(int paramInt)
    throws SQLException
  {
    return false;
  }

  public boolean othersInsertsAreVisible(int paramInt)
    throws SQLException
  {
    return false;
  }

  public boolean updatesAreDetected(int paramInt)
    throws SQLException
  {
    return false;
  }

  public boolean deletesAreDetected(int paramInt)
    throws SQLException
  {
    return false;
  }

  public boolean insertsAreDetected(int paramInt)
    throws SQLException
  {
    return false;
  }

  public boolean supportsBatchUpdates()
    throws SQLException
  {
    return true;
  }

  public ResultSet getUDTs(String paramString1, String paramString2, String paramString3, int[] paramArrayOfInt)
    throws SQLException
  {
    if ((wantsIsNull(paramString3)) || ((paramArrayOfInt != null) && (paramArrayOfInt.length == 0)))
      executeSelect("SYSTEM_UDTS", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_UDTS").append(and("TYPE_CAT", "=", paramString1)).append(and("TYPE_SCHEM", "LIKE", paramString2)).append(and("TYPE_NAME", "LIKE", paramString3));
    if (paramArrayOfInt != null)
      localStringBuffer.append(" AND DATA_TYPE IN (").append(StringUtil.getList(paramArrayOfInt, ",", "'")).append(')');
    return execute(localStringBuffer.toString());
  }

  public Connection getConnection()
    throws SQLException
  {
    return this.connection;
  }

  public boolean supportsSavepoints()
    throws SQLException
  {
    return true;
  }

  public boolean supportsNamedParameters()
    throws SQLException
  {
    return true;
  }

  public boolean supportsMultipleOpenResults()
    throws SQLException
  {
    return false;
  }

  public boolean supportsGetGeneratedKeys()
    throws SQLException
  {
    return false;
  }

  public ResultSet getSuperTypes(String paramString1, String paramString2, String paramString3)
    throws SQLException
  {
    if (wantsIsNull(paramString3))
      return executeSelect("SYSTEM_SUPERTYPES", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_SUPERTYPES").append(and("TYPE_CAT", "=", paramString1)).append(and("TYPE_SCHEM", "LIKE", paramString2)).append(and("TYPE_NAME", "LIKE", paramString3));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getSuperTables(String paramString1, String paramString2, String paramString3)
    throws SQLException
  {
    if (wantsIsNull(paramString3))
      return executeSelect("SYSTEM_SUPERTABLES", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_SUPERTABLES").append(and("TABLE_CAT", "=", paramString1)).append(and("TABLE_SCHEM", "LIKE", paramString2)).append(and("TABLE_NAME", "LIKE", paramString3));
    return execute(localStringBuffer.toString());
  }

  public ResultSet getAttributes(String paramString1, String paramString2, String paramString3, String paramString4)
    throws SQLException
  {
    if ((wantsIsNull(paramString3)) || (wantsIsNull(paramString4)))
      return executeSelect("SYSTEM_UDTATTRIBUTES", "0=1");
    paramString2 = translateSchema(paramString2);
    StringBuffer localStringBuffer = toQueryPrefix("SYSTEM_UDTATTRIBUTES").append(and("TYPE_CAT", "=", paramString1)).append(and("TYPE_SCHEM", "LIKE", paramString2)).append(and("TYPE_NAME", "LIKE", paramString3)).append(and("ATTR_NAME", "LIKE", paramString4));
    return execute(localStringBuffer.toString());
  }

  public boolean supportsResultSetHoldability(int paramInt)
    throws SQLException
  {
    return paramInt == 1;
  }

  public int getResultSetHoldability()
    throws SQLException
  {
    return 1;
  }

  public int getDatabaseMajorVersion()
    throws SQLException
  {
    ResultSet localResultSet = execute("call \"org.hsqldb.Library.getDatabaseMajorVersion\"()");
    localResultSet.next();
    int i = localResultSet.getInt(1);
    localResultSet.close();
    return i;
  }

  public int getDatabaseMinorVersion()
    throws SQLException
  {
    ResultSet localResultSet = execute("call \"org.hsqldb.Library.getDatabaseMinorVersion\"()");
    localResultSet.next();
    int i = localResultSet.getInt(1);
    localResultSet.close();
    return i;
  }

  public int getJDBCMajorVersion()
    throws SQLException
  {
    return 3;
  }

  public int getJDBCMinorVersion()
    throws SQLException
  {
    return 0;
  }

  public int getSQLStateType()
    throws SQLException
  {
    return 2;
  }

  public boolean locatorsUpdateCopy()
    throws SQLException
  {
    return false;
  }

  public boolean supportsStatementPooling()
    throws SQLException
  {
    return false;
  }

  jdbcDatabaseMetaData(jdbcConnection paramjdbcConnection)
    throws SQLException
  {
    this.connection = paramjdbcConnection;
    this.useSchemaDefault = paramjdbcConnection.connProperties.isPropertyTrue("default_schema");
  }

  private static String and(String paramString1, String paramString2, Object paramObject)
  {
    if (paramObject == null)
      return "";
    StringBuffer localStringBuffer = new StringBuffer();
    boolean bool = paramObject instanceof String;
    if ((bool) && (((String)paramObject).length() == 0))
      return " AND " + paramString1 + " IS NULL";
    String str = bool ? Column.createSQLString((String)paramObject) : String.valueOf(paramObject);
    localStringBuffer.append(" AND ").append(paramString1).append(' ');
    if ((bool) && ("LIKE".equalsIgnoreCase(paramString2)))
    {
      if ((str.indexOf('_') < 0) && (str.indexOf('%') < 0))
      {
        localStringBuffer.append("=").append(' ').append(str);
      }
      else
      {
        localStringBuffer.append("LIKE").append(' ').append(str);
        if ((str.indexOf("\\_") >= 0) || (str.indexOf("\\%") >= 0))
          localStringBuffer.append(" ESCAPE '\\'");
      }
    }
    else
      localStringBuffer.append(paramString2).append(' ').append(str);
    return localStringBuffer.toString();
  }

  private ResultSet execute(String paramString)
    throws SQLException
  {
    ResultSet localResultSet = this.connection.createStatement(1004, 1007).executeQuery(paramString);
    ((jdbcResultSet)localResultSet).autoClose = true;
    return localResultSet;
  }

  private ResultSet executeSelect(String paramString1, String paramString2)
    throws SQLException
  {
    String str = "SELECT * FROM INFORMATION_SCHEMA." + paramString1;
    if (paramString2 != null)
      str = str + " WHERE " + paramString2;
    return execute(str);
  }

  private StringBuffer toQueryPrefix(String paramString)
  {
    StringBuffer localStringBuffer = new StringBuffer(255);
    return localStringBuffer.append("SELECT * FROM INFORMATION_SCHEMA.").append(paramString).append(" WHERE 1=1");
  }

  private static boolean wantsIsNull(String paramString)
  {
    return (paramString != null) && (paramString.length() == 0);
  }

  private String translateSchema(String paramString)
    throws SQLException
  {
    if ((this.useSchemaDefault) && (paramString != null) && (paramString.length() == 0))
    {
      ResultSet localResultSet = executeSelect("SYSTEM_SCHEMAS", "IS_DEFAULT=TRUE");
      if (localResultSet.next())
        return localResultSet.getString(1);
      return paramString;
    }
    return paramString;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcDatabaseMetaData
 * JD-Core Version:    0.6.0
 */