package org.hsqldb.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HSQLClientConnection;
import org.hsqldb.HTTPClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Trace;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

public class jdbcConnection
  implements Connection
{
  HsqlProperties connProperties;
  SessionInterface sessionProxy;
  boolean isInternal;
  protected boolean isNetConn;
  boolean isClosed;
  private SQLWarning rootWarning;
  private Object rootWarning_mutex = new Object();

  public synchronized Statement createStatement()
    throws SQLException
  {
    checkClosed();
    jdbcStatement localjdbcStatement = new jdbcStatement(this, 1003);
    return localjdbcStatement;
  }

  public synchronized PreparedStatement prepareStatement(String paramString)
    throws SQLException
  {
    checkClosed();
    try
    {
      jdbcPreparedStatement localjdbcPreparedStatement = new jdbcPreparedStatement(this, paramString, 1003);
      return localjdbcPreparedStatement;
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw Util.sqlException(localHsqlException);
  }

  public synchronized CallableStatement prepareCall(String paramString)
    throws SQLException
  {
    checkClosed();
    try
    {
      jdbcCallableStatement localjdbcCallableStatement = new jdbcCallableStatement(this, paramString, 1003);
      return localjdbcCallableStatement;
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw Util.sqlException(localHsqlException);
  }

  public synchronized String nativeSQL(String paramString)
    throws SQLException
  {
    checkClosed();
    if ((paramString == null) || (paramString.length() == 0) || (paramString.indexOf('{') == -1))
      return paramString;
    int i = 0;
    int j = paramString.length();
    int k = 0;
    StringBuffer localStringBuffer = new StringBuffer(paramString.length());
    localStringBuffer.append(paramString);
    for (int m = 0; m < j; m++)
    {
      int n = localStringBuffer.charAt(m);
      switch (i)
      {
      case 0:
        if (n == 39)
        {
          i = 1;
        }
        else if (n == 34)
        {
          i = 2;
        }
        else
        {
          if (n != 123)
            continue;
          m = onStartEscapeSequence(paramString, localStringBuffer, m);
          k++;
          i = 3;
        }
        break;
      case 1:
      case 4:
        if (n != 39)
          continue;
        i--;
        break;
      case 2:
      case 5:
        if (n != 34)
          continue;
        i -= 2;
        break;
      case 3:
        if (n == 39)
        {
          i = 4;
        }
        else if (n == 34)
        {
          i = 5;
        }
        else if (n == 125)
        {
          localStringBuffer.setCharAt(m, ' ');
          k--;
          i = k == 0 ? 0 : 3;
        }
        else
        {
          if (n != 123)
            continue;
          m = onStartEscapeSequence(paramString, localStringBuffer, m);
          k++;
          i = 3;
        }
      }
    }
    return localStringBuffer.toString();
  }

  public synchronized void setAutoCommit(boolean paramBoolean)
    throws SQLException
  {
    checkClosed();
    try
    {
      this.sessionProxy.setAutoCommit(paramBoolean);
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
  }

  public synchronized boolean getAutoCommit()
    throws SQLException
  {
    checkClosed();
    try
    {
      return this.sessionProxy.isAutoCommit();
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw Util.sqlException(localHsqlException);
  }

  public synchronized void commit()
    throws SQLException
  {
    checkClosed();
    try
    {
      this.sessionProxy.commit();
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
  }

  public synchronized void rollback()
    throws SQLException
  {
    checkClosed();
    try
    {
      this.sessionProxy.rollback();
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
  }

  public synchronized void close()
    throws SQLException
  {
    if ((this.isInternal) || (this.isClosed))
      return;
    this.isClosed = true;
    if (this.sessionProxy != null)
      this.sessionProxy.close();
    this.sessionProxy = null;
    this.rootWarning = null;
    this.connProperties = null;
  }

  public synchronized boolean isClosed()
  {
    return this.isClosed;
  }

  public synchronized DatabaseMetaData getMetaData()
    throws SQLException
  {
    checkClosed();
    return new jdbcDatabaseMetaData(this);
  }

  public synchronized void setReadOnly(boolean paramBoolean)
    throws SQLException
  {
    checkClosed();
    try
    {
      this.sessionProxy.setReadOnly(paramBoolean);
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
  }

  public synchronized boolean isReadOnly()
    throws SQLException
  {
    try
    {
      return this.sessionProxy.isReadOnly();
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw Util.sqlException(localHsqlException);
  }

  public synchronized void setCatalog(String paramString)
    throws SQLException
  {
    checkClosed();
  }

  public synchronized String getCatalog()
    throws SQLException
  {
    checkClosed();
    return null;
  }

  public synchronized void setTransactionIsolation(int paramInt)
    throws SQLException
  {
    checkClosed();
    switch (paramInt)
    {
    case 1:
    case 2:
    case 4:
    case 8:
      break;
    case 3:
    case 5:
    case 6:
    case 7:
    default:
      throw Util.invalidArgument();
    }
    try
    {
      this.sessionProxy.setIsolation(paramInt);
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
  }

  public synchronized int getTransactionIsolation()
    throws SQLException
  {
    checkClosed();
    try
    {
      return this.sessionProxy.getIsolation();
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw Util.sqlException(localHsqlException);
  }

  public synchronized SQLWarning getWarnings()
    throws SQLException
  {
    checkClosed();
    synchronized (this.rootWarning_mutex)
    {
      if (!this.isNetConn)
      {
        HsqlException[] arrayOfHsqlException = ((Session)this.sessionProxy).getAndClearWarnings();
        for (int i = 0; i < arrayOfHsqlException.length; i++)
        {
          SQLWarning localSQLWarning = Util.sqlWarning(arrayOfHsqlException[i]);
          addWarning(localSQLWarning);
        }
      }
      return this.rootWarning;
    }
  }

  public synchronized void clearWarnings()
    throws SQLException
  {
    checkClosed();
    synchronized (this.rootWarning_mutex)
    {
      this.rootWarning = null;
    }
  }

  public synchronized Statement createStatement(int paramInt1, int paramInt2)
    throws SQLException
  {
    checkClosed();
    paramInt1 = xlateRSType(paramInt1);
    paramInt2 = xlateRSConcurrency(paramInt2);
    return new jdbcStatement(this, paramInt1);
  }

  public synchronized PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2)
    throws SQLException
  {
    checkClosed();
    paramInt1 = xlateRSType(paramInt1);
    paramInt2 = xlateRSConcurrency(paramInt2);
    try
    {
      return new jdbcPreparedStatement(this, paramString, paramInt1);
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw Util.sqlException(localHsqlException);
  }

  public synchronized CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2)
    throws SQLException
  {
    checkClosed();
    paramInt1 = xlateRSType(paramInt1);
    paramInt2 = xlateRSConcurrency(paramInt2);
    try
    {
      return new jdbcCallableStatement(this, paramString, paramInt1);
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw Util.sqlException(localHsqlException);
  }

  public synchronized Map getTypeMap()
    throws SQLException
  {
    checkClosed();
    throw Util.notSupported();
  }

  public synchronized void setTypeMap(Map paramMap)
    throws SQLException
  {
    checkClosed();
    throw Util.notSupported();
  }

  public synchronized void setHoldability(int paramInt)
    throws SQLException
  {
    checkClosed();
    switch (paramInt)
    {
    case 1:
      break;
    case 2:
      String str = "ResultSet holdability: " + paramInt;
      throw Util.sqlException(20, str);
    default:
      throw Util.invalidArgument();
    }
  }

  public synchronized int getHoldability()
    throws SQLException
  {
    checkClosed();
    return 1;
  }

  public synchronized Savepoint setSavepoint()
    throws SQLException
  {
    checkClosed();
    throw Util.notSupported();
  }

  public synchronized Savepoint setSavepoint(String paramString)
    throws SQLException
  {
    checkClosed();
    if (paramString == null)
    {
      String str = "name is null";
      throw Util.sqlException(62, str);
    }
    Result localResult = Result.newSetSavepointRequest(paramString);
    try
    {
      this.sessionProxy.execute(localResult);
    }
    catch (HsqlException localHsqlException)
    {
      Util.throwError(localHsqlException);
    }
    return new jdbcSavepoint(paramString, this);
  }

  public synchronized void rollback(Savepoint paramSavepoint)
    throws SQLException
  {
    checkClosed();
    String str;
    if (paramSavepoint == null)
    {
      str = "savepoint is null";
      throw Util.sqlException(62, str);
    }
    try
    {
      if (this.sessionProxy.isAutoCommit())
      {
        str = "connection is autocommit";
        throw Util.sqlException(62, str);
      }
    }
    catch (HsqlException localHsqlException1)
    {
      throw Util.sqlException(localHsqlException1);
    }
    if (!(paramSavepoint instanceof jdbcSavepoint))
      throw Util.sqlException(62);
    jdbcSavepoint localjdbcSavepoint = (jdbcSavepoint)paramSavepoint;
    if (this != localjdbcSavepoint.connection)
    {
      str = paramSavepoint + " was not issued on this connection";
      throw Util.sqlException(62, str);
    }
    Result localResult1 = Result.newRollbackToSavepointRequest(localjdbcSavepoint.name);
    try
    {
      Result localResult2 = this.sessionProxy.execute(localResult1);
      if (localResult2.isError())
        Util.throwError(localResult2);
    }
    catch (HsqlException localHsqlException2)
    {
      Util.throwError(localHsqlException2);
    }
  }

  public synchronized void releaseSavepoint(Savepoint paramSavepoint)
    throws SQLException
  {
    checkClosed();
    String str;
    if (paramSavepoint == null)
    {
      str = "savepoint is null";
      throw Util.sqlException(62, str);
    }
    if (!(paramSavepoint instanceof jdbcSavepoint))
      throw Util.sqlException(62);
    jdbcSavepoint localjdbcSavepoint = (jdbcSavepoint)paramSavepoint;
    if (this != localjdbcSavepoint.connection)
    {
      str = paramSavepoint.getSavepointName() + " was not issued on this connection";
      throw Util.sqlException(62, str);
    }
    Result localResult1 = Result.newReleaseSavepointRequest(localjdbcSavepoint.name);
    try
    {
      Result localResult2 = this.sessionProxy.execute(localResult1);
      if (localResult2.isError())
        Util.throwError(localResult2);
    }
    catch (HsqlException localHsqlException)
    {
      Util.throwError(localHsqlException);
    }
  }

  public synchronized Statement createStatement(int paramInt1, int paramInt2, int paramInt3)
    throws SQLException
  {
    checkClosed();
    paramInt1 = xlateRSType(paramInt1);
    paramInt2 = xlateRSConcurrency(paramInt2);
    paramInt3 = xlateRSHoldability(paramInt3);
    return new jdbcStatement(this, paramInt1);
  }

  public synchronized PreparedStatement prepareStatement(String paramString, int paramInt1, int paramInt2, int paramInt3)
    throws SQLException
  {
    checkClosed();
    paramInt1 = xlateRSType(paramInt1);
    paramInt2 = xlateRSConcurrency(paramInt2);
    paramInt3 = xlateRSHoldability(paramInt3);
    try
    {
      return new jdbcPreparedStatement(this, paramString, paramInt1);
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw Util.sqlException(localHsqlException);
  }

  public synchronized CallableStatement prepareCall(String paramString, int paramInt1, int paramInt2, int paramInt3)
    throws SQLException
  {
    checkClosed();
    paramInt1 = xlateRSType(paramInt1);
    paramInt2 = xlateRSConcurrency(paramInt2);
    paramInt3 = xlateRSHoldability(paramInt3);
    try
    {
      return new jdbcCallableStatement(this, paramString, paramInt1);
    }
    catch (HsqlException localHsqlException)
    {
    }
    throw Util.sqlException(localHsqlException);
  }

  public synchronized PreparedStatement prepareStatement(String paramString, int paramInt)
    throws SQLException
  {
    checkClosed();
    throw Util.notSupported();
  }

  public synchronized PreparedStatement prepareStatement(String paramString, int[] paramArrayOfInt)
    throws SQLException
  {
    checkClosed();
    throw Util.notSupported();
  }

  public synchronized PreparedStatement prepareStatement(String paramString, String[] paramArrayOfString)
    throws SQLException
  {
    checkClosed();
    throw Util.notSupported();
  }

  public jdbcConnection(HsqlProperties paramHsqlProperties)
    throws SQLException
  {
    String str1 = paramHsqlProperties.getProperty("user");
    String str2 = paramHsqlProperties.getProperty("password");
    String str3 = paramHsqlProperties.getProperty("connection_type");
    String str4 = paramHsqlProperties.getProperty("host");
    int i = paramHsqlProperties.getIntegerProperty("port", 0);
    String str5 = paramHsqlProperties.getProperty("path");
    String str6 = paramHsqlProperties.getProperty("database");
    boolean bool = (str3 == "hsqls://") || (str3 == "https://");
    if (str1 == null)
      str1 = "SA";
    if (str2 == null)
      str2 = "";
    str1 = str1.toUpperCase(Locale.ENGLISH);
    str2 = str2.toUpperCase(Locale.ENGLISH);
    try
    {
      if (DatabaseURL.isInProcessDatabaseType(str3))
      {
        this.sessionProxy = DatabaseManager.newSession(str3, str6, str1, str2, paramHsqlProperties);
      }
      else if ((str3 == "hsql://") || (str3 == "hsqls://"))
      {
        this.sessionProxy = new HSQLClientConnection(str4, i, str5, str6, bool, str1, str2);
        this.isNetConn = true;
      }
      else if ((str3 == "http://") || (str3 == "https://"))
      {
        this.sessionProxy = new HTTPClientConnection(str4, i, str5, str6, bool, str1, str2);
        this.isNetConn = true;
      }
      else
      {
        throw Util.sqlException(62);
      }
      this.connProperties = paramHsqlProperties;
    }
    catch (HsqlException localHsqlException)
    {
      throw Util.sqlException(localHsqlException);
    }
  }

  public jdbcConnection(Session paramSession)
    throws HsqlException
  {
    this.isInternal = true;
    this.sessionProxy = paramSession;
  }

  protected void finalize()
  {
    try
    {
      close();
    }
    catch (SQLException localSQLException)
    {
    }
  }

  synchronized String getURL()
    throws SQLException
  {
    checkClosed();
    if (this.isInternal)
      return ((Session)this.sessionProxy).getInternalConnectionURL();
    return this.connProperties.getProperty("url");
  }

  synchronized void checkClosed()
    throws SQLException
  {
    if (this.isClosed)
      throw Util.sqlException(2);
  }

  void addWarning(SQLWarning paramSQLWarning)
  {
    synchronized (this.rootWarning_mutex)
    {
      if (this.rootWarning == null)
        this.rootWarning = paramSQLWarning;
      else
        this.rootWarning.setNextWarning(paramSQLWarning);
    }
  }

  void clearWarningsNoCheck()
  {
    synchronized (this.rootWarning_mutex)
    {
      this.rootWarning = null;
    }
  }

  int xlateRSType(int paramInt)
    throws SQLException
  {
    switch (paramInt)
    {
    case 1003:
    case 1004:
      return paramInt;
    case 1005:
      str = "TYPE_SCROLL_SENSITIVE => TYPE_SCROLL_SENSITIVE";
      SQLWarning localSQLWarning = new SQLWarning(str, "SOO10", 62);
      addWarning(localSQLWarning);
      return 1004;
    }
    String str = "ResultSet type: " + paramInt;
    throw Util.sqlException(62, str);
  }

  int xlateRSConcurrency(int paramInt)
    throws SQLException
  {
    switch (paramInt)
    {
    case 1007:
      return paramInt;
    case 1008:
      str = "CONCUR_UPDATABLE => CONCUR_READ_ONLY";
      SQLWarning localSQLWarning = new SQLWarning(str, "SOO10", 62);
      addWarning(localSQLWarning);
      return 1007;
    }
    String str = "ResultSet concurrency: " + paramInt;
    throw Util.sqlException(62, str);
  }

  int xlateRSHoldability(int paramInt)
    throws SQLException
  {
    switch (paramInt)
    {
    case 1:
      return paramInt;
    case 2:
      str = "CLOSE_CURSORS_AT_COMMIT => HOLD_CURSORS_OVER_COMMIT";
      SQLWarning localSQLWarning = new SQLWarning(str, "SOO10", 62);
      addWarning(localSQLWarning);
      return 1;
    }
    String str = "ResultSet holdability: " + paramInt;
    throw Util.sqlException(62, str);
  }

  public void reset()
    throws SQLException
  {
    try
    {
      this.sessionProxy.resetSession();
    }
    catch (HsqlException localHsqlException)
    {
      throw new SQLException("Error resetting connection: " + localHsqlException.getMessage());
    }
  }

  private int onStartEscapeSequence(String paramString, StringBuffer paramStringBuffer, int paramInt)
    throws SQLException
  {
    paramStringBuffer.setCharAt(paramInt++, ' ');
    paramInt = StringUtil.skipSpaces(paramString, paramInt);
    if ((paramString.regionMatches(true, paramInt, "fn ", 0, 3)) || (paramString.regionMatches(true, paramInt, "oj ", 0, 3)) || (paramString.regionMatches(true, paramInt, "ts ", 0, 3)))
    {
      paramStringBuffer.setCharAt(paramInt++, ' ');
      paramStringBuffer.setCharAt(paramInt++, ' ');
    }
    else if ((paramString.regionMatches(true, paramInt, "d ", 0, 2)) || (paramString.regionMatches(true, paramInt, "t ", 0, 2)))
    {
      paramStringBuffer.setCharAt(paramInt++, ' ');
    }
    else if (paramString.regionMatches(true, paramInt, "call ", 0, 5))
    {
      paramInt += 4;
    }
    else if (paramString.regionMatches(true, paramInt, "?= call ", 0, 8))
    {
      paramStringBuffer.setCharAt(paramInt++, ' ');
      paramStringBuffer.setCharAt(paramInt++, ' ');
      paramInt += 5;
    }
    else if (paramString.regionMatches(true, paramInt, "escape ", 0, 7))
    {
      paramInt += 6;
    }
    else
    {
      paramInt--;
      throw new SQLException(Trace.getMessage(138, true, new Object[] { paramString.substring(paramInt) }), "S0010", 62);
    }
    return paramInt;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcConnection
 * JD-Core Version:    0.6.0
 */