package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class jdbcBlob
  implements Blob
{
  volatile byte[] data;

  public jdbcBlob(byte[] paramArrayOfByte)
    throws SQLException
  {
    if (paramArrayOfByte == null)
      throw Util.sqlException(62, "null");
    this.data = paramArrayOfByte;
  }

  public long length()
    throws SQLException
  {
    byte[] arrayOfByte = this.data;
    return arrayOfByte.length;
  }

  public byte[] getBytes(long paramLong, int paramInt)
    throws SQLException
  {
    byte[] arrayOfByte1 = this.data;
    int i = arrayOfByte1.length;
    paramLong -= 1L;
    if ((paramLong < 0L) || (paramLong > i))
      throw Util.sqlException(62, "pos: " + (paramLong + 1L));
    if ((paramInt < 0) || (paramInt > i - paramLong))
      throw Util.sqlException(62, "length: " + paramInt);
    byte[] arrayOfByte2 = new byte[paramInt];
    System.arraycopy(arrayOfByte1, (int)paramLong, arrayOfByte2, 0, paramInt);
    return arrayOfByte2;
  }

  public InputStream getBinaryStream()
    throws SQLException
  {
    byte[] arrayOfByte = this.data;
    return new ByteArrayInputStream(arrayOfByte);
  }

  public long position(byte[] paramArrayOfByte, long paramLong)
    throws SQLException
  {
    byte[] arrayOfByte = this.data;
    int i = arrayOfByte.length;
    if ((paramLong > i) || (paramArrayOfByte == null))
      return -1L;
    if (paramLong < 1L)
      paramLong = 0L;
    else
      paramLong -= 1L;
    int j = paramArrayOfByte.length;
    if ((j == 0) || (paramLong > i - j))
      return -1L;
    int k = i - j;
    int m = paramArrayOfByte[0];
    label153: for (int n = (int)paramLong; n <= k; n++)
    {
      if (arrayOfByte[n] != m)
        continue;
      int i1 = j;
      int i2 = n;
      int i3 = 0;
      int i4 = 1;
      while (i1-- > 0)
      {
        if (arrayOfByte[(i2++)] == paramArrayOfByte[(i3++)])
          continue;
        break label153;
      }
      return n + 1;
    }
    return -1L;
  }

  public long position(Blob paramBlob, long paramLong)
    throws SQLException
  {
    byte[] arrayOfByte1 = this.data;
    int i = arrayOfByte1.length;
    if ((paramLong > i) || (paramBlob == null))
      return -1L;
    if (paramLong < 1L)
      paramLong = 0L;
    else
      paramLong -= 1L;
    long l = paramBlob.length();
    if ((l == 0L) || (paramLong > i - l))
      return -1L;
    int j = (int)l;
    byte[] arrayOfByte2;
    if ((paramBlob instanceof jdbcBlob))
      arrayOfByte2 = ((jdbcBlob)paramBlob).data;
    else
      arrayOfByte2 = paramBlob.getBytes(1L, j);
    int k = i - j;
    int m = arrayOfByte2[0];
    label193: for (int n = (int)paramLong; n <= k; n++)
    {
      if (arrayOfByte1[n] != m)
        continue;
      int i1 = j;
      int i2 = n;
      int i3 = 0;
      while (i1-- > 0)
      {
        if (arrayOfByte1[(i2++)] == arrayOfByte2[(i3++)])
          continue;
        break label193;
      }
      return n + 1;
    }
    return -1L;
  }

  public int setBytes(long paramLong, byte[] paramArrayOfByte)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public int setBytes(long paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public OutputStream setBinaryStream(long paramLong)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void truncate(long paramLong)
    throws SQLException
  {
    byte[] arrayOfByte1 = this.data;
    if ((paramLong < 0L) || (paramLong > arrayOfByte1.length))
      throw Util.sqlException(62, Long.toString(paramLong));
    if (paramLong == arrayOfByte1.length)
      return;
    byte[] arrayOfByte2 = new byte[(int)paramLong];
    System.arraycopy(arrayOfByte1, 0, arrayOfByte2, 0, (int)paramLong);
    this.data = arrayOfByte2;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcBlob
 * JD-Core Version:    0.6.0
 */