package org.hsqldb;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

class WebServerConnection
  implements Runnable
{
  static final String ENCODING = "8859_1";
  private Socket socket;
  private WebServer server;
  private static final int REQUEST_TYPE_BAD = 0;
  private static final int REQUEST_TYPE_GET = 1;
  private static final int REQUEST_TYPE_HEAD = 2;
  private static final int REQUEST_TYPE_POST = 3;
  private static final String HEADER_OK = "HTTP/1.0 200 OK";
  private static final String HEADER_BAD_REQUEST = "HTTP/1.0 400 Bad Request";
  private static final String HEADER_NOT_FOUND = "HTTP/1.0 404 Not Found";
  private static final String HEADER_FORBIDDEN = "HTTP/1.0 403 Forbidden";
  static final int BUFFER_SIZE = 256;
  private RowOutputBinary rowOut = new RowOutputBinary(256);
  private RowInputBinary rowIn = new RowInputBinary(this.rowOut);
  static final byte[] BYTES_GET = "GET".getBytes();
  static final byte[] BYTES_HEAD = "HEAD".getBytes();
  static final byte[] BYTES_POST = "POST".getBytes();
  static final byte[] BYTES_CONTENT = "Content-Length: ".getBytes();
  static final byte[] BYTES_WHITESPACE = { 32, 9 };
  private static final int hnd_content_types = BundleHandler.getBundleHandle("content-types", null);

  WebServerConnection(Socket paramSocket, WebServer paramWebServer)
  {
    this.server = paramWebServer;
    this.socket = paramSocket;
  }

  private String getMimeTypeString(String paramString)
  {
    if (paramString == null)
      return "text/html";
    int i = paramString.lastIndexOf('.');
    String str1 = null;
    String str2 = null;
    if (i >= 0)
    {
      str1 = paramString.substring(i).toLowerCase();
      str2 = this.server.serverProperties.getProperty(str1);
    }
    if ((str2 == null) && (str1.length() > 1))
      str2 = BundleHandler.getString(hnd_content_types, str1.substring(1));
    return str2 == null ? "text/html" : str2;
  }

  public void run()
  {
    try
    {
      DataInputStream localDataInputStream = new DataInputStream(this.socket.getInputStream());
      String str = null;
      int j = 0;
      int k = -1;
      do
      {
        i = InOutUtil.readLine(localDataInputStream, this.rowOut);
        if (i != 0)
          continue;
        throw new Exception();
      }
      while (i < 2);
      byte[] arrayOfByte = this.rowOut.getBuffer();
      int m = this.rowOut.size() - i;
      if (ArrayUtil.containsAt(arrayOfByte, m, BYTES_POST))
      {
        j = 3;
        m += BYTES_POST.length;
      }
      else if (ArrayUtil.containsAt(arrayOfByte, m, BYTES_GET))
      {
        j = 1;
        m += BYTES_GET.length;
      }
      else if (ArrayUtil.containsAt(arrayOfByte, m, BYTES_HEAD))
      {
        j = 2;
        m += BYTES_HEAD.length;
      }
      else
      {
        throw new Exception();
      }
      int i = ArrayUtil.countStartElementsAt(arrayOfByte, m, BYTES_WHITESPACE);
      if (i == 0)
        throw new Exception();
      m += i;
      i = ArrayUtil.countNonStartElementsAt(arrayOfByte, m, BYTES_WHITESPACE);
      str = new String(arrayOfByte, m, i, "8859_1");
      switch (j)
      {
      case 0:
        processError(0);
        break;
      case 1:
        processGet(str, true);
        break;
      case 2:
        processGet(str, false);
        break;
      case 3:
        processPost(localDataInputStream, str);
      }
      localDataInputStream.close();
      this.socket.close();
    }
    catch (Exception localException)
    {
      this.server.printStackTrace(localException);
    }
  }

  private void processPost(InputStream paramInputStream, String paramString)
    throws HsqlException, IOException
  {
    try
    {
      InOutUtil.readLine(paramInputStream, this.rowOut);
      int i = InOutUtil.readLine(paramInputStream, this.rowOut);
      int j = this.rowOut.size() - i;
      byte[] arrayOfByte = this.rowOut.getBuffer();
      if (!ArrayUtil.containsAt(arrayOfByte, j, BYTES_CONTENT))
        throw new Exception();
      i -= BYTES_CONTENT.length;
      j += BYTES_CONTENT.length;
      String str = new String(arrayOfByte, j, i - 2);
      int k = Integer.parseInt(str);
      InOutUtil.readLine(paramInputStream, this.rowOut);
    }
    catch (Exception localException)
    {
      processError(400);
      return;
    }
    processQuery(paramInputStream);
  }

  void processQuery(InputStream paramInputStream)
  {
    try
    {
      Result localResult1 = Result.read(this.rowIn, new DataInputStream(paramInputStream));
      Result localResult2;
      if (localResult1.mode == 65543)
      {
        try
        {
          int i = this.server.getDBID(localResult1.subSubString);
          localObject = DatabaseManager.newSession(i, localResult1.getMainString(), localResult1.getSubString());
          localResult2 = new Result(1);
          localResult2.databaseID = i;
          localResult2.sessionID = ((Session)localObject).getId();
        }
        catch (HsqlException localHsqlException)
        {
          localResult2 = new Result(localHsqlException, null);
        }
        catch (RuntimeException localRuntimeException)
        {
          localResult2 = new Result(localRuntimeException, null);
        }
      }
      else
      {
        int j = localResult1.databaseID;
        localObject = DatabaseManager.getSession(j, localResult1.sessionID);
        localResult2 = localObject == null ? new Result(Trace.error(94), null) : ((Session)localObject).execute(localResult1);
      }
      this.rowOut.reset();
      localResult2.write(this.rowOut);
      OutputStream localOutputStream = this.socket.getOutputStream();
      Object localObject = getHead("HTTP/1.0 200 OK", false, "application/octet-stream", this.rowOut.size());
      localOutputStream.write(((String)localObject).getBytes("8859_1"));
      localOutputStream.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
      localOutputStream.flush();
      localOutputStream.close();
    }
    catch (Exception localException)
    {
      this.server.printStackTrace(localException);
    }
  }

  private void processGet(String paramString, boolean paramBoolean)
  {
    try
    {
      if (paramString.endsWith("/"))
        paramString = paramString + this.server.getDefaultWebPage();
      if (paramString.indexOf("..") != -1)
      {
        processError(403);
        return;
      }
      paramString = this.server.getWebRoot() + paramString;
      if (File.separatorChar != '/')
        paramString = paramString.replace('/', File.separatorChar);
      DataInputStream localDataInputStream = null;
      this.server.printWithThread("GET " + paramString);
      String str;
      try
      {
        File localFile = new File(paramString);
        localDataInputStream = new DataInputStream(new FileInputStream(localFile));
        str = getHead("HTTP/1.0 200 OK", true, getMimeTypeString(paramString), (int)localFile.length());
      }
      catch (IOException localIOException)
      {
        processError(404);
        if (localDataInputStream != null)
          localDataInputStream.close();
        return;
      }
      BufferedOutputStream localBufferedOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
      localBufferedOutputStream.write(str.getBytes("8859_1"));
      if (paramBoolean)
      {
        int i;
        while ((i = localDataInputStream.read()) != -1)
          localBufferedOutputStream.write(i);
      }
      localBufferedOutputStream.flush();
      localBufferedOutputStream.close();
      localDataInputStream.close();
    }
    catch (Exception localException)
    {
      this.server.printError("processGet: " + localException.toString());
      this.server.printStackTrace(localException);
    }
  }

  String getHead(String paramString1, boolean paramBoolean, String paramString2, int paramInt)
  {
    StringBuffer localStringBuffer = new StringBuffer(128);
    localStringBuffer.append(paramString1).append("\r\n");
    if (paramBoolean)
    {
      localStringBuffer.append("Allow: GET, HEAD, POST\nMIME-Version: 1.0\r\n");
      localStringBuffer.append("Server: ").append("HSQL Database Engine").append("\r\n");
    }
    if (paramString2 != null)
    {
      localStringBuffer.append("Content-Type: ").append(paramString2).append("\r\n");
      localStringBuffer.append("Content-Length: ").append(paramInt).append("\r\n");
    }
    localStringBuffer.append("\r\n");
    return localStringBuffer.toString();
  }

  private void processError(int paramInt)
  {
    this.server.printWithThread("processError " + paramInt);
    String str;
    switch (paramInt)
    {
    case 400:
      str = getHead("HTTP/1.0 400 Bad Request", false, null, 0);
      str = str + BundleHandler.getString(WebServer.webBundleHandle, "BAD_REQUEST");
      break;
    case 403:
      str = getHead("HTTP/1.0 403 Forbidden", false, null, 0);
      str = str + BundleHandler.getString(WebServer.webBundleHandle, "FORBIDDEN");
      break;
    case 401:
    case 402:
    case 404:
    default:
      str = getHead("HTTP/1.0 404 Not Found", false, null, 0);
      str = str + BundleHandler.getString(WebServer.webBundleHandle, "NOT_FOUND");
    }
    try
    {
      BufferedOutputStream localBufferedOutputStream = new BufferedOutputStream(this.socket.getOutputStream());
      localBufferedOutputStream.write(str.getBytes("8859_1"));
      localBufferedOutputStream.flush();
      localBufferedOutputStream.close();
    }
    catch (Exception localException)
    {
      this.server.printError("processError: " + localException.toString());
      this.server.printStackTrace(localException);
    }
  }

  String getConnectionThreadName()
  {
    return "HSQLDB HTTP Connection @" + Integer.toString(hashCode(), 16);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.WebServerConnection
 * JD-Core Version:    0.6.0
 */