package org.hsqldb;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.resources.BundleHandler;

public class Trace
{
  public static boolean TRACE = false;
  public static boolean TRACESYSTEMOUT = false;
  public static final boolean STOP = false;
  public static final boolean DOASSERT = false;
  static String errPropsName = "sql-error-messages";
  static int bundleHandle = BundleHandler.getBundleHandle(errPropsName, null);
  public static final int DATABASE_ALREADY_IN_USE = 1;
  public static final int CONNECTION_IS_CLOSED = 2;
  public static final int CONNECTION_IS_BROKEN = 3;
  public static final int DATABASE_IS_SHUTDOWN = 4;
  public static final int COLUMN_COUNT_DOES_NOT_MATCH = 5;
  public static final int DIVISION_BY_ZERO = 6;
  public static final int INVALID_ESCAPE = 7;
  public static final int INTEGRITY_CONSTRAINT_VIOLATION = 8;
  public static final int VIOLATION_OF_UNIQUE_INDEX = 9;
  public static final int TRY_TO_INSERT_NULL = 10;
  public static final int UNEXPECTED_TOKEN = 11;
  public static final int UNEXPECTED_END_OF_COMMAND = 12;
  public static final int UNKNOWN_FUNCTION = 13;
  public static final int NEED_AGGREGATE = 14;
  public static final int SUM_OF_NON_NUMERIC = 15;
  public static final int WRONG_DATA_TYPE = 16;
  public static final int CARDINALITY_VIOLATION_NO_SUBCLASS = 17;
  public static final int SERIALIZATION_FAILURE = 18;
  public static final int TRANSFER_CORRUPTED = 19;
  public static final int FUNCTION_NOT_SUPPORTED = 20;
  public static final int TABLE_ALREADY_EXISTS = 21;
  public static final int TABLE_NOT_FOUND = 22;
  public static final int INDEX_ALREADY_EXISTS = 23;
  public static final int SECOND_PRIMARY_KEY = 24;
  public static final int DROP_PRIMARY_KEY = 25;
  public static final int INDEX_NOT_FOUND = 26;
  public static final int COLUMN_ALREADY_EXISTS = 27;
  public static final int COLUMN_NOT_FOUND = 28;
  public static final int FILE_IO_ERROR = 29;
  public static final int WRONG_DATABASE_FILE_VERSION = 30;
  public static final int DATABASE_IS_READONLY = 31;
  public static final int DATA_IS_READONLY = 32;
  public static final int ACCESS_IS_DENIED = 33;
  public static final int INPUTSTREAM_ERROR = 34;
  public static final int NO_DATA_IS_AVAILABLE = 35;
  public static final int USER_ALREADY_EXISTS = 36;
  public static final int USER_NOT_FOUND = 37;
  public static final int ASSERT_FAILED = 38;
  public static final int EXTERNAL_STOP = 39;
  public static final int GENERAL_ERROR = 40;
  public static final int WRONG_OUT_PARAMETER = 41;
  public static final int FUNCTION_NOT_FOUND = 42;
  public static final int TRIGGER_NOT_FOUND = 43;
  public static final int SAVEPOINT_NOT_FOUND = 44;
  public static final int LABEL_REQUIRED = 45;
  public static final int WRONG_DEFAULT_CLAUSE = 46;
  public static final int FOREIGN_KEY_NOT_ALLOWED = 47;
  public static final int UNKNOWN_DATA_SOURCE = 48;
  public static final int BAD_INDEX_CONSTRAINT_NAME = 49;
  public static final int DROP_FK_INDEX = 50;
  public static final int RESULTSET_FORWARD_ONLY = 51;
  public static final int VIEW_ALREADY_EXISTS = 52;
  public static final int VIEW_NOT_FOUND = 53;
  public static final int NOT_USED_54 = 54;
  public static final int NOT_A_TABLE = 55;
  public static final int SYSTEM_INDEX = 56;
  public static final int COLUMN_TYPE_MISMATCH = 57;
  public static final int BAD_ADD_COLUMN_DEFINITION = 58;
  public static final int DROP_SYSTEM_CONSTRAINT = 59;
  public static final int CONSTRAINT_ALREADY_EXISTS = 60;
  public static final int CONSTRAINT_NOT_FOUND = 61;
  public static final int INVALID_JDBC_ARGUMENT = 62;
  public static final int DATABASE_IS_MEMORY_ONLY = 63;
  public static final int OUTER_JOIN_CONDITION = 64;
  public static final int NUMERIC_VALUE_OUT_OF_RANGE = 65;
  public static final int MISSING_SOFTWARE_MODULE = 66;
  public static final int NOT_IN_AGGREGATE_OR_GROUP_BY = 67;
  public static final int INVALID_GROUP_BY = 68;
  public static final int INVALID_HAVING = 69;
  public static final int INVALID_ORDER_BY = 70;
  public static final int INVALID_ORDER_BY_IN_DISTINCT_SELECT = 71;
  public static final int OUT_OF_MEMORY = 72;
  public static final int OPERATION_NOT_SUPPORTED = 73;
  public static final int INVALID_IDENTIFIER = 74;
  public static final int TEXT_TABLE_SOURCE = 75;
  public static final int TEXT_FILE = 76;
  public static final int NOT_USED_77 = 77;
  public static final int ERROR_IN_SCRIPT_FILE = 78;
  public static final int NULL_IN_VALUE_LIST = 79;
  public static final int SOCKET_ERROR = 80;
  public static final int INVALID_CHARACTER_ENCODING = 81;
  public static final int NOT_USED_82 = 82;
  public static final int NOT_USED_83 = 83;
  public static final int NOT_USED_84 = 84;
  public static final int UNEXPECTED_EXCEPTION = 85;
  public static final int NOT_USED_86 = 86;
  public static final int NOT_USED_87 = 87;
  public static final int NOT_USED_88 = 88;
  public static final int NOT_USED_89 = 89;
  public static final int NOT_USED_90 = 90;
  public static final int NOT_USED_91 = 91;
  public static final int NOT_USED_92 = 92;
  public static final int NOT_USED_93 = 93;
  public static final int DATABASE_NOT_EXISTS = 94;
  public static final int INVALID_CONVERSION = 95;
  public static final int ERROR_IN_BINARY_SCRIPT_1 = 96;
  public static final int ERROR_IN_BINARY_SCRIPT_2 = 97;
  public static final int GENERAL_IO_ERROR = 98;
  public static final int EXPRESSION_NOT_SUPPORTED = 99;
  public static final int Constraint_violation = 100;
  public static final int Database_dropTable = 101;
  public static final int ERROR_IN_CONSTRAINT_COLUMN_LIST = 102;
  public static final int TABLE_HAS_NO_PRIMARY_KEY = 103;
  public static final int VIOLATION_OF_UNIQUE_CONSTRAINT = 104;
  public static final int NO_DEFAULT_VALUE_FOR_COLUMN = 105;
  public static final int NOT_A_CONDITION = 106;
  public static final int DatabaseManager_getDatabase = 107;
  public static final int NOT_USED_108 = 108;
  public static final int NOT_USED_109 = 109;
  public static final int NOT_USED_110 = 110;
  public static final int NOT_USED_111 = 111;
  public static final int NOT_USED_112 = 112;
  public static final int DatabaseScriptReader_readDDL = 113;
  public static final int DatabaseScriptReader_readExistingData = 114;
  public static final int Message_Pair = 115;
  public static final int LOAD_SAVE_PROPERTIES = 116;
  public static final int INVALID_TRANSACTION_STATE_NO_SUBCLASS = 117;
  public static final int JDBC_INVALID_BRI_SCOPE = 118;
  public static final int JDBC_NO_RESULT_SET_METADATA = 119;
  public static final int JDBC_NO_RESULT_SET = 120;
  public static final int MISSING_CLOSEBRACKET = 121;
  public static final int ITSNS_OVERWRITE = 122;
  public static final int COLUMN_IS_IN_INDEX = 123;
  public static final int STRING_DATA_TRUNCATION = 124;
  public static final int QUOTED_IDENTIFIER_REQUIRED = 125;
  public static final int STATEMENT_IS_CLOSED = 126;
  public static final int NOT_USED_127 = 127;
  public static final int NOT_USED_128 = 128;
  public static final int DATA_FILE_ERROR = 129;
  public static final int NOT_USED_130 = 130;
  public static final int HsqlDateTime_null_string = 131;
  public static final int NOT_USED_132 = 132;
  public static final int HsqlDateTime_null_date = 133;
  public static final int NOT_USED_134 = 134;
  public static final int HsqlProperties_load = 135;
  public static final int HsqlSocketFactorySecure_verify = 136;
  public static final int HsqlSocketFactorySecure_verify2 = 137;
  public static final int jdbcConnection_nativeSQL = 138;
  public static final int HsqlSocketFactorySecure_verify3 = 139;
  public static final int NOT_USED_140 = 140;
  public static final int NOT_USED_141 = 141;
  public static final int jdbcStatement_executeUpdate = 142;
  public static final int LockFile_checkHeartbeat = 143;
  public static final int LockFile_checkHeartbeat2 = 144;
  public static final int TEXT_STRING_HAS_NEWLINE = 145;
  public static final int Result_Result = 146;
  public static final int SERVER_NO_DATABASE = 147;
  public static final int Server_openServerSocket = 148;
  public static final int Server_openServerSocket2 = 149;
  public static final int TEXT_TABLE_HEADER = 150;
  public static final int NOT_USED_151 = 151;
  public static final int JDBC_PARAMETER_NOT_SET = 152;
  public static final int INVALID_LIMIT = 153;
  public static final int JDBC_STATEMENT_NOT_ROW_COUNT = 154;
  public static final int JDBC_STATEMENT_NOT_RESULTSET = 155;
  public static final int AMBIGUOUS_COLUMN_REFERENCE = 156;
  public static final int CHECK_CONSTRAINT_VIOLATION = 157;
  public static final int JDBC_RESULTSET_IS_CLOSED = 158;
  public static final int SINGLE_COLUMN_EXPECTED = 159;
  public static final int TOKEN_REQUIRED = 160;
  public static final int NOT_USED_161 = 161;
  public static final int NOT_USED_162 = 162;
  public static final int ORDER_LIMIT_REQUIRED = 163;
  public static final int TRIGGER_ALREADY_EXISTS = 164;
  public static final int ASSERT_DIRECT_EXEC_WITH_PARAM = 165;
  public static final int NOT_USED_166 = 166;
  public static final int Expression_compareValues = 167;
  public static final int INVALID_LIMIT_EXPRESSION = 168;
  public static final int INVALID_TOP_EXPRESSION = 169;
  public static final int SQL_CONSTRAINT_REQUIRED = 170;
  public static final int TableWorks_dropConstraint = 171;
  public static final int TEXT_TABLE_SOURCE_FILENAME = 172;
  public static final int TEXT_TABLE_SOURCE_VALUE_MISSING = 173;
  public static final int TEXT_TABLE_SOURCE_SEPARATOR = 174;
  public static final int UNSUPPORTED_PARAM_CLASS = 175;
  public static final int JDBC_NULL_STREAM = 176;
  public static final int INTEGRITY_CONSTRAINT_VIOLATION_NOPARENT = 177;
  public static final int NOT_USED_178 = 178;
  public static final int NOT_USED_179 = 179;
  public static final int QuotedTextDatabaseRowInput_getField = 180;
  public static final int QuotedTextDatabaseRowInput_getField2 = 181;
  public static final int TextDatabaseRowInput_getField = 182;
  public static final int TextDatabaseRowInput_getField2 = 183;
  public static final int TextDatabaseRowInput_getField3 = 184;
  public static final int Parser_ambiguous_between1 = 185;
  public static final int SEQUENCE_REFERENCED_BY_VIEW = 186;
  public static final int NOT_USED_187 = 187;
  public static final int TextCache_openning_file_error = 188;
  public static final int TextCache_closing_file_error = 189;
  public static final int TextCache_purging_file_error = 190;
  public static final int SEQUENCE_NOT_FOUND = 191;
  public static final int SEQUENCE_ALREADY_EXISTS = 192;
  public static final int TABLE_REFERENCED_CONSTRAINT = 193;
  public static final int TABLE_REFERENCED_VIEW = 194;
  public static final int NOT_USED_195 = 195;
  public static final int TEXT_SOURCE_EXISTS = 196;
  public static final int COLUMN_IS_REFERENCED = 197;
  public static final int FUNCTION_CALL_ERROR = 198;
  public static final int TRIGGERED_DATA_CHANGE = 199;
  public static final int INVALID_FUNCTION_ARGUMENT = 200;
  public static final int UNSUPPORTED_INTERNAL_OPERATION = 201;
  public static final int NOT_USED_202 = 202;
  public static final int INVALID_PREPARED_STATEMENT = 203;
  public static final int CREATE_TRIGGER_COMMAND_1 = 204;
  public static final int TRIGGER_FUNCTION_CLASS_NOT_FOUND = 205;
  public static final int NOT_USED_206 = 206;
  public static final int NOT_USED_207 = 207;
  public static final int INVALID_COLLATION_NAME_NO_SUBCLASS = 208;
  public static final int DataFileCache_makeRow = 209;
  public static final int DataFileCache_open = 210;
  public static final int DataFileCache_close = 211;
  public static final int Expression_resolveTypes1 = 212;
  public static final int Expression_resolveTypes2 = 213;
  public static final int Expression_resolveTypes3 = 214;
  public static final int Expression_resolveTypes4 = 215;
  public static final int UNRESOLVED_PARAMETER_TYPE = 216;
  public static final int Expression_resolveTypes6 = 217;
  public static final int Expression_resolveTypes7 = 218;
  public static final int Expression_resolveTypeForLike = 219;
  public static final int NOT_USED_220 = 220;
  public static final int Expression_resolveTypeForIn2 = 221;
  public static final int Session_execute = 222;
  public static final int NOT_USED_223 = 223;
  public static final int NOT_USED_224 = 224;
  public static final int DATA_FILE_IS_FULL = 225;
  public static final int THREE_PART_IDENTIFIER = 226;
  public static final int INVALID_SCHEMA_NAME_NO_SUBCLASS = 227;
  public static final int DEPENDENT_DATABASE_OBJECT_EXISTS = 228;
  public static final int NO_SUCH_ROLE_GRANT = 229;
  public static final int NO_SUCH_ROLE_REVOKE = 230;
  public static final int NONMOD_ACCOUNT = 231;
  public static final int NO_SUCH_GRANTEE = 232;
  public static final int MISSING_SYSAUTH = 233;
  public static final int MISSING_GRANTEE = 234;
  public static final int CHANGE_GRANTEE = 235;
  public static final int NULL_NAME = 236;
  public static final int ILLEGAL_ROLE_NAME = 237;
  public static final int ROLE_ALREADY_EXISTS = 238;
  public static final int NO_SUCH_ROLE = 239;
  public static final int MISSING_ROLEMANAGER = 240;
  public static final int GRANTEE_ALREADY_EXISTS = 241;
  public static final int MISSING_PUBLIC_GRANTEE = 242;
  public static final int NONMOD_GRANTEE = 243;
  public static final int CIRCULAR_GRANT = 244;
  public static final int ALREADY_HAVE_ROLE = 245;
  public static final int DONT_HAVE_ROLE = 246;
  public static final int NOT_USED_247 = 247;
  public static final int RETRIEVE_NEST_ROLE_FAIL = 248;
  public static final int NO_SUCH_RIGHT = 249;
  public static final int IN_SCHEMA_DEFINITION = 250;
  public static final int PRIMARY_KEY_NOT_ALLOWED = 251;
  public static final int COLUMN_IS_IN_CONSTRAINT = 252;
  public static final int COLUMN_SIZE_REQUIRED = 253;
  public static final int INVALID_SIZE_PRECISION = 254;
  public static final int CANNOT_CONNECT_TABLE = 255;
  public static final int LAST_ERROR_HANDLE = 256;
  static String MESSAGE_TAG = "$$";

  public static HsqlException error(int paramInt1, int paramInt2, Object[] paramArrayOfObject)
  {
    paramInt1 = Math.abs(paramInt1);
    String str1 = getMessage(paramInt1);
    String str2 = "S1000";
    if (str1.length() >= 5)
    {
      str2 = str1.substring(0, 5);
      str1 = str1.substring(6);
    }
    if (paramInt2 != 0)
      str1 = str1 + getMessage(Math.abs(paramInt2));
    StringBuffer localStringBuffer = new StringBuffer(str1.length() + 32);
    int i = 0;
    int j = str1.length();
    if (paramArrayOfObject != null)
      for (int k = 0; k < paramArrayOfObject.length; k++)
      {
        j = str1.indexOf(MESSAGE_TAG, i);
        if (j == -1)
          break;
        localStringBuffer.append(str1.substring(i, j));
        localStringBuffer.append(paramArrayOfObject[k] == null ? "null exception message" : paramArrayOfObject[k].toString());
        i = j + MESSAGE_TAG.length();
      }
    j = str1.length();
    localStringBuffer.append(str1.substring(i, j));
    return new HsqlException(localStringBuffer.toString(), str2, -paramInt1);
  }

  public static HsqlException error(int paramInt, Object[] paramArrayOfObject)
  {
    return error(paramInt, 0, paramArrayOfObject);
  }

  public static HsqlException error(int paramInt1, int paramInt2, String paramString)
  {
    return error(paramInt1, getMessage(paramInt2) + ' ' + paramString);
  }

  public static HsqlException error(int paramInt1, int paramInt2)
  {
    return error(paramInt1, getMessage(paramInt2));
  }

  public static HsqlException error(int paramInt, Object paramObject)
  {
    paramInt = Math.abs(paramInt);
    String str = getMessage(paramInt);
    if (paramObject != null)
      str = str + ": " + paramObject.toString();
    return new HsqlException(str.substring(6), str.substring(0, 5), -paramInt);
  }

  public static HsqlException error(Result paramResult)
  {
    return new HsqlException(paramResult);
  }

  static Result toResult(HsqlException paramHsqlException)
  {
    return new Result(paramHsqlException.getMessage(), paramHsqlException.getSQLState(), paramHsqlException.getErrorCode());
  }

  public static RuntimeException runtimeError(int paramInt, Object paramObject)
  {
    HsqlException localHsqlException = error(paramInt, paramObject);
    return new RuntimeException(localHsqlException.getMessage());
  }

  public static String getMessage(int paramInt)
  {
    return getMessage(paramInt, false, null);
  }

  public static String getMessage(int paramInt, boolean paramBoolean, Object[] paramArrayOfObject)
  {
    if (paramInt < 0)
      return "";
    String str1 = String.valueOf(paramInt);
    if (paramInt < 10)
      str1 = "00" + str1;
    else if (paramInt < 100)
      str1 = "0" + str1;
    String str2 = BundleHandler.getString(bundleHandle, str1);
    if (!paramBoolean)
      return str2;
    StringBuffer localStringBuffer = new StringBuffer(str2.length() + 32);
    int i = 0;
    int j = str2.length();
    if (paramArrayOfObject != null)
      for (int k = 0; k < paramArrayOfObject.length; k++)
      {
        j = str2.indexOf(MESSAGE_TAG, i);
        if (j == -1)
          break;
        localStringBuffer.append(str2.substring(i, j));
        localStringBuffer.append(paramArrayOfObject[k].toString());
        i = j + MESSAGE_TAG.length();
      }
    j = str2.length();
    localStringBuffer.append(str2.substring(i, j));
    return localStringBuffer.toString();
  }

  public static HsqlException error(int paramInt)
  {
    return error(paramInt, null);
  }

  public static void check(boolean paramBoolean, int paramInt)
    throws HsqlException
  {
    check(paramBoolean, paramInt, null, null, null, null);
  }

  public static void check(boolean paramBoolean, int paramInt, Object paramObject)
    throws HsqlException
  {
    if (!paramBoolean)
      throw error(paramInt, paramObject);
  }

  static void throwerror(int paramInt, Object paramObject)
    throws HsqlException
  {
    throw error(paramInt, paramObject);
  }

  public static void printSystemOut(String paramString)
  {
    if (TRACESYSTEMOUT)
      System.out.println(paramString);
  }

  public static void printSystemOut(String paramString, long paramLong)
  {
    if (TRACESYSTEMOUT)
    {
      System.out.print(paramString);
      System.out.println(paramLong);
    }
  }

  private static String getStackTrace()
  {
    HsqlByteArrayOutputStream localHsqlByteArrayOutputStream;
    try
    {
      Exception localException1 = new Exception();
      throw localException1;
    }
    catch (Exception localException2)
    {
      localHsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
      PrintWriter localPrintWriter = new PrintWriter(localHsqlByteArrayOutputStream, true);
      localException2.printStackTrace(localPrintWriter);
    }
    return localHsqlByteArrayOutputStream.toString();
  }

  static void check(boolean paramBoolean, int paramInt, String paramString1, String paramString2)
    throws HsqlException
  {
    check(paramBoolean, paramInt, paramString1, paramString2, null, null);
  }

  static void check(boolean paramBoolean, int paramInt, String paramString1, String paramString2, String paramString3)
    throws HsqlException
  {
    check(paramBoolean, paramInt, paramString1, paramString2, paramString3, null);
  }

  static void check(boolean paramBoolean, int paramInt, String paramString1, String paramString2, String paramString3, String paramString4)
    throws HsqlException
  {
    if (!paramBoolean)
    {
      String str = "";
      if (paramString1 != null)
        str = str + paramString1;
      if (paramString2 != null)
        str = str + paramString2;
      if (paramString3 != null)
        str = str + paramString3;
      if (paramString4 != null)
        str = str + paramString4;
      throw error(paramInt, str.length() > 0 ? str : null);
    }
  }

  static void doAssert(boolean paramBoolean)
    throws HsqlException
  {
    doAssert(paramBoolean, null);
  }

  static void doAssert(boolean paramBoolean, String paramString)
    throws HsqlException
  {
    if (!paramBoolean)
    {
      if (paramString == null)
        paramString = "";
      paramString = paramString + getStackTrace();
      throw error(38, paramString);
    }
  }

  static
  {
    try
    {
      TRACE = (TRACE) || (Boolean.getBoolean("hsqldb.trace"));
      TRACESYSTEMOUT = (TRACESYSTEMOUT) || (Boolean.getBoolean("hsqldb.tracesystemout"));
    }
    catch (Exception localException)
    {
    }
    if (!"LAST".equals(BundleHandler.getString(bundleHandle, String.valueOf(256))))
      throw new RuntimeException();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Trace
 * JD-Core Version:    0.6.0
 */