package org.hsqldb;

import java.math.BigDecimal;
import java.util.Locale;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;

public class Tokenizer
{
  private static final int NO_TYPE = 0;
  private static final int NAME = 1;
  private static final int LONG_NAME = 2;
  private static final int SPECIAL = 3;
  private static final int NUMBER = 4;
  private static final int FLOAT = 5;
  private static final int STRING = 6;
  private static final int LONG = 7;
  private static final int DECIMAL = 8;
  private static final int BOOLEAN = 9;
  private static final int DATE = 10;
  private static final int TIME = 11;
  private static final int TIMESTAMP = 12;
  private static final int NULL = 13;
  private static final int NAMED_PARAM = 14;
  private static final int QUOTED_IDENTIFIER = 15;
  private static final int REMARK_LINE = 16;
  private static final int REMARK = 17;
  private String sCommand;
  private int iLength;
  private int iIndex;
  private int tokenIndex;
  private int nextTokenIndex;
  private int beginIndex;
  private int iType;
  private String sToken;
  private int indexLongNameFirst = -1;
  private String sLongNameFirst = null;
  private int typeLongNameFirst;
  private boolean retainFirst = false;
  private boolean bWait;
  private boolean lastTokenQuotedID;
  static IntValueHashMap valueTokens = new IntValueHashMap();
  static BigDecimal LONG_MAX_VALUE_INCREMENT;

  public Tokenizer()
  {
  }

  public Tokenizer(String paramString)
  {
    this.sCommand = paramString;
    this.iLength = paramString.length();
    this.iIndex = 0;
  }

  public void reset(String paramString)
  {
    this.sCommand = paramString;
    this.iLength = paramString.length();
    this.iIndex = 0;
    this.tokenIndex = 0;
    this.nextTokenIndex = 0;
    this.beginIndex = 0;
    this.iType = 0;
    this.typeLongNameFirst = 0;
    this.sToken = null;
    this.indexLongNameFirst = -1;
    this.sLongNameFirst = null;
    this.bWait = false;
    this.lastTokenQuotedID = false;
    this.retainFirst = false;
  }

  void back()
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    this.nextTokenIndex = this.iIndex;
    this.iIndex = (this.indexLongNameFirst != -1 ? this.indexLongNameFirst : this.tokenIndex);
    this.bWait = true;
  }

  String getThis(String paramString)
    throws HsqlException
  {
    getToken();
    matchThis(paramString);
    return this.sToken;
  }

  void matchThis(String paramString)
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    if ((!this.sToken.equals(paramString)) || (this.iType == 15) || (this.iType == 2))
    {
      String str = this.iType == 2 ? this.sLongNameFirst : this.sToken;
      throw Trace.error(11, 160, new Object[] { str, paramString });
    }
  }

  void throwUnexpected()
    throws HsqlException
  {
    String str = this.iType == 2 ? this.sLongNameFirst : this.sToken;
    throw Trace.error(11, str);
  }

  public boolean isGetThis(String paramString)
    throws HsqlException
  {
    getToken();
    if ((this.iType != 15) && (this.iType != 2) && (this.sToken.equals(paramString)))
      return true;
    back();
    return false;
  }

  boolean wasValue()
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    switch (this.iType)
    {
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 13:
      return true;
    case 10:
    case 11:
    case 12:
    }
    return false;
  }

  boolean wasQuotedIdentifier()
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    return this.lastTokenQuotedID;
  }

  boolean wasFirstQuotedIdentifier()
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    return this.typeLongNameFirst == 15;
  }

  boolean wasLongName()
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    return this.iType == 2;
  }

  boolean wasSimpleName()
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    if ((this.iType == 15) && (this.sToken.length() != 0))
      return true;
    if (this.iType != 1)
      return false;
    return !Token.isKeyword(this.sToken);
  }

  boolean wasParameter()
    throws HsqlException
  {
    Trace.doAssert(!this.bWait, "Querying state when in Wait mode");
    return this.iType == 14;
  }

  boolean wasName()
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    if (this.iType == 15)
      return true;
    if ((this.iType != 1) && (this.iType != 2))
      return false;
    return !Token.isKeyword(this.sToken);
  }

  String getLongNamePre()
    throws HsqlException
  {
    return null;
  }

  String getLongNameFirst()
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    return this.sLongNameFirst;
  }

  boolean wasSimpleToken()
    throws HsqlException
  {
    return (this.iType != 15) && (this.iType != 2) && (this.iType != 6) && (this.iType != 14);
  }

  String getSimpleToken()
    throws HsqlException
  {
    getToken();
    if (!wasSimpleToken())
    {
      String str = this.iType == 2 ? this.sLongNameFirst : this.sToken;
      throw Trace.error(11, str);
    }
    return this.sToken;
  }

  public boolean wasThis(String paramString)
    throws HsqlException
  {
    return (this.sToken.equals(paramString)) && (this.iType != 15) && (this.iType != 2) && (this.iType != 6);
  }

  public String getName()
    throws HsqlException
  {
    getToken();
    if (!wasName())
      throw Trace.error(11, this.sToken);
    return this.sToken;
  }

  public String getSimpleName()
    throws HsqlException
  {
    getToken();
    if (!wasSimpleName())
    {
      String str = this.iType == 2 ? this.sLongNameFirst : this.sToken;
      throw Trace.error(11, str);
    }
    return this.sToken;
  }

  public String getString()
    throws HsqlException
  {
    getToken();
    return this.sToken;
  }

  int getInt()
    throws HsqlException
  {
    long l = getBigint();
    if ((l > 2147483647L) || (l < -2147483648L))
      throw Trace.error(16, Types.getTypeString(getType()));
    return (int)l;
  }

  long getBigint()
    throws HsqlException
  {
    int i = 0;
    getToken();
    if (this.sToken.equals("-"))
    {
      i = 1;
      getToken();
    }
    Object localObject = getAsValue();
    int j = getType();
    switch (j)
    {
    case -5:
    case 4:
      break;
    case 3:
      if ((i == 0) || (!LONG_MAX_VALUE_INCREMENT.equals(localObject)))
        break;
      return -9223372036854775808L;
    }
    throw Trace.error(16, Types.getTypeString(j));
    long l = ((Number)localObject).longValue();
    return i != 0 ? -l : l;
  }

  Object getInType(int paramInt)
    throws HsqlException
  {
    getToken();
    Object localObject = getAsValue();
    int i = getType();
    if (i != paramInt)
      throw Trace.error(16, Types.getTypeString(i));
    return localObject;
  }

  public int getType()
    throws HsqlException
  {
    if (this.bWait)
      Trace.doAssert(false, "Querying state when in Wait mode");
    switch (this.iType)
    {
    case 6:
      return 12;
    case 4:
      return 4;
    case 7:
      return -5;
    case 5:
      return 8;
    case 8:
      return 3;
    case 9:
      return 16;
    case 10:
      return 91;
    case 11:
      return 92;
    case 12:
      return 93;
    }
    return 0;
  }

  Object getAsValue()
    throws HsqlException
  {
    if (!wasValue())
      throw Trace.error(11, this.sToken);
    switch (this.iType)
    {
    case 13:
      return null;
    case 6:
      return this.sToken;
    case 7:
      return ValuePool.getLong(Long.parseLong(this.sToken));
    case 4:
      if (this.sToken.length() < 11)
        try
        {
          return ValuePool.getInt(Integer.parseInt(this.sToken));
        }
        catch (Exception localException1)
        {
        }
      if (this.sToken.length() < 20)
        try
        {
          this.iType = 7;
          return ValuePool.getLong(Long.parseLong(this.sToken));
        }
        catch (Exception localException2)
        {
        }
      this.iType = 8;
      return new BigDecimal(this.sToken);
    case 5:
      double d = JavaSystem.parseDouble(this.sToken);
      long l = Double.doubleToLongBits(d);
      return ValuePool.getDouble(l);
    case 8:
      return new BigDecimal(this.sToken);
    case 9:
      return this.sToken.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    case 10:
      return HsqlDateTime.dateValue(this.sToken);
    case 11:
      return HsqlDateTime.timeValue(this.sToken);
    case 12:
      return HsqlDateTime.timestampValue(this.sToken);
    }
    return this.sToken;
  }

  int getPosition()
  {
    return this.iIndex;
  }

  String getPart(int paramInt1, int paramInt2)
  {
    return this.sCommand.substring(paramInt1, paramInt2);
  }

  int getPartMarker()
  {
    return this.beginIndex;
  }

  void setPartMarker()
  {
    this.beginIndex = this.iIndex;
  }

  void setPartMarker(int paramInt)
  {
    this.beginIndex = paramInt;
  }

  String getLastPart()
  {
    return this.sCommand.substring(this.beginIndex, this.iIndex);
  }

  private void getToken()
    throws HsqlException
  {
    if (this.bWait)
    {
      this.bWait = false;
      this.iIndex = this.nextTokenIndex;
      return;
    }
    if (!this.retainFirst)
    {
      this.sLongNameFirst = null;
      this.indexLongNameFirst = -1;
      this.typeLongNameFirst = 0;
    }
    while ((this.iIndex < this.iLength) && (Character.isWhitespace(this.sCommand.charAt(this.iIndex))))
      this.iIndex += 1;
    this.sToken = "";
    this.tokenIndex = this.iIndex;
    if (this.iIndex >= this.iLength)
    {
      this.iType = 0;
      return;
    }
    char c = this.sCommand.charAt(this.iIndex);
    int i = 0;
    int j = 0;
    int k = 0;
    int m = 0;
    int n = 0;
    int i1 = 0;
    this.lastTokenQuotedID = false;
    if (Character.isJavaIdentifierStart(c))
    {
      this.iType = 1;
    }
    else if (Character.isDigit(c))
    {
      this.iType = 4;
      j = 1;
    }
    else
    {
      switch (c)
      {
      case '(':
        this.sToken = "(";
        this.iType = 3;
        this.iIndex += 1;
        return;
      case ')':
        this.sToken = ")";
        this.iType = 3;
        this.iIndex += 1;
        return;
      case ',':
        this.sToken = ",";
        this.iType = 3;
        this.iIndex += 1;
        return;
      case '*':
        this.sToken = "*";
        this.iType = 3;
        this.iIndex += 1;
        return;
      case '=':
        this.sToken = "=";
        this.iType = 3;
        this.iIndex += 1;
        return;
      case ';':
        this.sToken = ";";
        this.iType = 3;
        this.iIndex += 1;
        return;
      case '+':
        this.sToken = "+";
        this.iType = 3;
        this.iIndex += 1;
        return;
      case '%':
        this.sToken = "%";
        this.iType = 3;
        this.iIndex += 1;
        return;
      case '?':
        this.sToken = "?";
        this.iType = 3;
        this.iIndex += 1;
        return;
      case ':':
        Trace.check(++this.iIndex < this.iLength, 12);
        c = this.sCommand.charAt(this.iIndex);
        Trace.check(Character.isJavaIdentifierStart(c), 74, ":" + c);
        this.iType = 14;
        break;
      case '"':
        this.lastTokenQuotedID = true;
        this.iType = 15;
        this.iIndex += 1;
        this.sToken = getString('"');
        if (this.iIndex == this.sCommand.length())
          return;
        c = this.sCommand.charAt(this.iIndex);
        if (c == '.')
        {
          this.sLongNameFirst = this.sToken;
          this.indexLongNameFirst = this.tokenIndex;
          this.typeLongNameFirst = this.iType;
          this.iIndex += 1;
          if (this.retainFirst)
            throw Trace.error(226);
          this.retainFirst = true;
          getToken();
          this.retainFirst = false;
          this.iType = 2;
        }
        return;
      case '\'':
        this.iType = 6;
        this.iIndex += 1;
        this.sToken = getString('\'');
        return;
      case '!':
      case '-':
      case '/':
      case '<':
      case '>':
      case '|':
        i1 = c;
        this.iType = 3;
        break;
      case '.':
        this.iType = 8;
        i = 1;
        break;
      default:
        throw Trace.error(11, String.valueOf(c));
      }
    }
    int i2 = this.iIndex++;
    while (true)
    {
      if (this.iIndex >= this.iLength)
      {
        c = ' ';
        n = 1;
        Trace.check((this.iType != 6) && (this.iType != 15), 12);
      }
      else
      {
        c = this.sCommand.charAt(this.iIndex);
      }
      switch (this.iType)
      {
      case 1:
      case 14:
        if (Character.isJavaIdentifierPart(c))
          break;
        this.sToken = this.sCommand.substring(i2, this.iIndex).toUpperCase(Locale.ENGLISH);
        if (this.iType == 14)
          return;
        if (c == '.')
        {
          this.typeLongNameFirst = this.iType;
          this.sLongNameFirst = this.sToken;
          this.indexLongNameFirst = this.tokenIndex;
          this.iIndex += 1;
          if (this.retainFirst)
            throw Trace.error(226);
          this.retainFirst = true;
          getToken();
          this.retainFirst = false;
          this.iType = 2;
        }
        else if (c != '(')
        {
          int i3 = valueTokens.get(this.sToken, -1);
          if (i3 != -1)
            this.iType = i3;
        }
        return;
      case 6:
      case 15:
        break;
      case 17:
        if (n != 0)
        {
          this.iType = 0;
          return;
        }
        if (c != '*')
          break;
        this.iIndex += 1;
        if ((this.iIndex >= this.iLength) || (this.sCommand.charAt(this.iIndex) != '/'))
          break;
        this.iIndex += 1;
        getToken();
        return;
      case 16:
        if (n != 0)
        {
          this.iType = 0;
          return;
        }
        if ((c != '\r') && (c != '\n'))
          break;
        getToken();
        return;
      case 3:
        if ((c == '/') && (i1 == 47))
        {
          this.iType = 16;
        }
        else if ((c == '-') && (i1 == 45))
        {
          this.iType = 16;
        }
        else if ((c == '*') && (i1 == 47))
        {
          this.iType = 17;
        }
        else
        {
          if ((c == '>') || (c == '=') || (c == '|'))
            break;
          this.sToken = this.sCommand.substring(i2, this.iIndex);
          return;
        }
      case 4:
      case 5:
      case 8:
        if (Character.isDigit(c))
        {
          j = 1;
        }
        else if (c == '.')
        {
          this.iType = 8;
          if (i != 0)
            throw Trace.error(11, ".");
          i = 1;
        }
        else if ((c == 'E') || (c == 'e'))
        {
          if (k != 0)
            throw Trace.error(11, "E");
          this.iType = 5;
          m = 1;
          i = 1;
          k = 1;
        }
        else if ((c == '-') && (m != 0))
        {
          m = 0;
        }
        else if ((c == '+') && (m != 0))
        {
          m = 0;
        }
        else
        {
          m = 0;
          if (j == 0)
          {
            if ((i != 0) && (i2 == this.iIndex - 1))
            {
              this.sToken = ".";
              this.iType = 3;
              return;
            }
            throw Trace.error(11, String.valueOf(c));
          }
          this.sToken = this.sCommand.substring(i2, this.iIndex);
          return;
        }
      case 2:
      case 7:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      }
      this.iIndex += 1;
    }
  }

  private String getString(char paramChar)
    throws HsqlException
  {
    try
    {
      int i = this.iIndex;
      int j = 0;
      while (true)
      {
        i = this.sCommand.indexOf(paramChar, i);
        if (i < 0)
          throw Trace.error(12);
        if ((i >= this.iLength - 1) || (this.sCommand.charAt(i + 1) != paramChar))
          break;
        j = 1;
        i += 2;
      }
      char[] arrayOfChar = new char[i - this.iIndex];
      this.sCommand.getChars(this.iIndex, i, arrayOfChar, 0);
      int k = arrayOfChar.length;
      if (j != 0)
      {
        k = 0;
        int m = 0;
        while (m < arrayOfChar.length)
        {
          if (arrayOfChar[m] == paramChar)
            m++;
          arrayOfChar[k] = arrayOfChar[m];
          m++;
          k++;
        }
      }
      i++;
      this.iIndex = i;
      return new String(arrayOfChar, 0, k);
    }
    catch (HsqlException localHsqlException)
    {
      throw localHsqlException;
    }
    catch (Exception localException)
    {
      localException.toString();
    }
    return null;
  }

  int getLength()
  {
    return this.iLength;
  }

  static
  {
    valueTokens.put("NULL", 13);
    valueTokens.put("TRUE", 9);
    valueTokens.put("FALSE", 9);
    LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(9223372036854775807L).add(BigDecimal.valueOf(1L));
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Tokenizer
 * JD-Core Version:    0.6.0
 */