package org.hsqldb;

import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.Logger;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TextCache;

class TextTable extends Table
{
  private String dataSource = "";
  private boolean isReversed = false;
  private boolean isConnected = false;

  TextTable(Database paramDatabase, HsqlNameManager.HsqlName paramHsqlName, int paramInt)
    throws HsqlException
  {
    super(paramDatabase, paramHsqlName, paramInt);
  }

  private void onConnectError(Session paramSession)
  {
    if (this.cache != null)
      try
      {
        this.cache.close(false);
      }
      catch (HsqlException localHsqlException)
      {
      }
    this.cache = null;
    clearAllRows(paramSession);
  }

  public boolean isConnected()
  {
    return this.isConnected;
  }

  public void connect(Session paramSession)
    throws HsqlException
  {
    connect(paramSession, this.isReadOnly);
  }

  private void connect(Session paramSession, boolean paramBoolean)
    throws HsqlException
  {
    if ((this.dataSource.length() == 0) || (this.isConnected))
      return;
    try
    {
      this.cache = this.database.logger.openTextCache(this, this.dataSource, paramBoolean, this.isReversed);
      CachedRow localCachedRow = null;
      i = 0;
      if (((TextCache)this.cache).ignoreFirst)
        i += ((TextCache)this.cache).readHeaderLine();
      while (true)
      {
        localCachedRow = (CachedRow)this.rowStore.get(i);
        if (localCachedRow == null)
          break;
        i = localCachedRow.getPos() + localCachedRow.getStorageSize();
        localCachedRow.setNewNodes();
        insertFromTextSource(localCachedRow);
      }
    }
    catch (HsqlException localHsqlException)
    {
      i = this.cache == null ? 0 : ((TextCache)this.cache).getLineNumber();
      onConnectError(paramSession);
      throw Trace.error(76, new Object[] { new Integer(i), localHsqlException.getMessage() });
    }
    catch (RuntimeException localRuntimeException)
    {
      int i = this.cache == null ? 0 : ((TextCache)this.cache).getLineNumber();
      onConnectError(paramSession);
      throw Trace.error(76, new Object[] { new Integer(i), localRuntimeException.getClass().getName() + ": " + localRuntimeException.getMessage() });
    }
    this.isConnected = true;
    setIsReadOnly(paramBoolean);
  }

  public void disconnect(Session paramSession)
    throws HsqlException
  {
    this.database.logger.closeTextCache(this);
    this.cache = null;
    clearAllRows(paramSession);
    this.isConnected = false;
  }

  private void openCache(Session paramSession, String paramString, boolean paramBoolean1, boolean paramBoolean2)
    throws HsqlException
  {
    if (paramString == null)
      paramString = "";
    disconnect(paramSession);
    this.dataSource = paramString;
    this.isReversed = ((paramBoolean1) && (this.dataSource.length() > 0));
    connect(paramSession, paramBoolean2);
  }

  protected void setDataSource(Session paramSession, String paramString, boolean paramBoolean1, boolean paramBoolean2)
    throws HsqlException
  {
    if (getTableType() != 5)
      paramSession.checkAdmin();
    paramString = paramString.trim();
    if ((paramBoolean2) && (FileUtil.exists(paramString)))
      throw Trace.error(196, paramString);
    if ((paramBoolean1) || (paramBoolean1 != this.isReversed) || (!this.dataSource.equals(paramString)) || (!this.isConnected))
      openCache(paramSession, paramString, paramBoolean1, this.isReadOnly);
    if (this.isReversed)
      setIsReadOnly(true);
  }

  protected String getDataSource()
  {
    return this.dataSource;
  }

  protected boolean isDescDataSource()
  {
    return this.isReversed;
  }

  public void setHeader(String paramString)
    throws HsqlException
  {
    if ((this.cache != null) && (((TextCache)this.cache).ignoreFirst))
    {
      ((TextCache)this.cache).setHeader(paramString);
      return;
    }
    throw Trace.error(150);
  }

  public String getHeader()
  {
    String str = this.cache == null ? null : ((TextCache)this.cache).getHeader();
    return str == null ? null : StringConverter.toQuotedString(str, '"', true);
  }

  void checkDataReadOnly()
    throws HsqlException
  {
    if (this.dataSource.length() == 0)
      throw Trace.error(48);
    if (isDataReadOnly())
      throw Trace.error(32);
  }

  public boolean isDataReadOnly()
  {
    return (!isConnected()) || (super.isDataReadOnly());
  }

  void setDataReadOnly(boolean paramBoolean)
    throws HsqlException
  {
    if ((this.isReversed) && (!paramBoolean))
      throw Trace.error(32);
    openCache(null, this.dataSource, this.isReversed, paramBoolean);
    setIsReadOnly(paramBoolean);
  }

  boolean isIndexCached()
  {
    return false;
  }

  protected Table duplicate()
    throws HsqlException
  {
    return new TextTable(this.database, this.tableName, getTableType());
  }

  void drop()
    throws HsqlException
  {
    openCache(null, "", false, false);
  }

  void setIndexRoots(String paramString)
    throws HsqlException
  {
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.TextTable
 * JD-Core Version:    0.6.0
 */