package org.hsqldb;

import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;

class TableWorks
{
  private Table table;
  private Session session;

  TableWorks(Session paramSession, Table paramTable)
  {
    this.table = paramTable;
    this.session = paramSession;
  }

  Table getTable()
  {
    return this.table;
  }

  void createForeignKey(int[] paramArrayOfInt1, int[] paramArrayOfInt2, HsqlNameManager.HsqlName paramHsqlName, Table paramTable, int paramInt1, int paramInt2)
    throws HsqlException
  {
    this.table.database.schemaManager.checkConstraintExists(paramHsqlName.name, this.table.getSchemaName(), false);
    if (this.table.getConstraint(paramHsqlName.name) != null)
      throw Trace.error(60);
    if (this.table.getConstraintForColumns(paramTable, paramArrayOfInt2, paramArrayOfInt1) != null)
      throw Trace.error(60);
    if (paramTable.isTemp() != this.table.isTemp())
      throw Trace.error(47);
    int i = this.table == paramTable ? 1 : 0;
    int j = this.table.database.schemaManager.getTableIndex(this.table);
    boolean bool = (j != -1) && (j < this.table.database.schemaManager.getTableIndex(paramTable));
    Index localIndex1 = paramTable.getUniqueConstraintIndexForColumns(paramArrayOfInt2);
    if (localIndex1 == null)
      throw Trace.error(170, paramTable.getName().statementName);
    Constraint.checkReferencedRows(this.session, this.table, paramArrayOfInt1, localIndex1);
    HsqlNameManager.HsqlName localHsqlName1 = this.table.database.nameManager.newAutoName("IDX");
    Index localIndex2 = createIndex(paramArrayOfInt1, localHsqlName1, false, true, bool);
    HsqlNameManager.HsqlName localHsqlName2 = this.table.database.nameManager.newAutoName("REF", paramHsqlName.name);
    if (i != 0)
      paramTable = this.table;
    Constraint localConstraint = new Constraint(localHsqlName2, paramHsqlName, paramTable, this.table, paramArrayOfInt2, paramArrayOfInt1, localIndex1, localIndex2, paramInt1, paramInt2);
    this.table.addConstraint(localConstraint);
    paramTable.addConstraint(new Constraint(localHsqlName2, localConstraint));
    this.table.database.schemaManager.registerConstraintName(paramHsqlName.name, this.table.getName());
  }

  Index createIndex(int[] paramArrayOfInt, HsqlNameManager.HsqlName paramHsqlName, boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3)
    throws HsqlException
  {
    Index localIndex;
    if ((this.table.isEmpty(this.session)) || (this.table.isIndexingMutable()))
    {
      localIndex = this.table.createIndex(this.session, paramArrayOfInt, paramHsqlName, paramBoolean1, paramBoolean2, paramBoolean3);
      this.table.database.schemaManager.clearTempTables(this.session, this.table);
    }
    else
    {
      Table localTable = this.table.moveDefinition(null, null, -1, 0);
      localIndex = localTable.createIndexStructure(paramArrayOfInt, paramHsqlName, paramBoolean1, paramBoolean2, paramBoolean3);
      localTable.moveData(this.session, this.table, -1, 0);
      localTable.updateConstraintsTables(this.session, this.table, -1, 0);
      int i = this.table.database.schemaManager.getTableIndex(this.table);
      this.table.database.schemaManager.setTable(i, localTable);
      this.table = localTable;
    }
    this.table.database.schemaManager.clearTempTables(this.session, this.table);
    this.table.database.schemaManager.registerIndexName(localIndex.getName().name, this.table.getName());
    this.table.database.schemaManager.recompileViews(this.table);
    return localIndex;
  }

  void addPrimaryKey(int[] paramArrayOfInt, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    if (paramHsqlName == null)
      paramHsqlName = this.table.makeSysPKName();
    this.table.database.schemaManager.checkConstraintExists(paramHsqlName.name, this.table.getSchemaName(), false);
    addOrDropPrimaryKey(paramArrayOfInt, false);
    Constraint localConstraint = new Constraint(paramHsqlName, this.table, this.table.getPrimaryIndex(), 4);
    this.table.addConstraint(localConstraint);
    this.table.database.schemaManager.registerConstraintName(paramHsqlName.name, this.table.getName());
  }

  void addOrDropPrimaryKey(int[] paramArrayOfInt, boolean paramBoolean)
    throws HsqlException
  {
    if (paramArrayOfInt == null)
      this.table.checkDropIndex(this.table.getIndexes()[0].getName().name, null, true);
    Table localTable = this.table.moveDefinitionPK(paramArrayOfInt, paramBoolean);
    localTable.moveData(this.session, this.table, -1, 0);
    localTable.updateConstraintsTables(this.session, this.table, -1, 0);
    int i = this.table.database.schemaManager.getTableIndex(this.table);
    this.table.database.schemaManager.setTable(i, localTable);
    this.table = localTable;
    this.table.database.schemaManager.recompileViews(this.table);
  }

  void createUniqueConstraint(int[] paramArrayOfInt, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    this.table.database.schemaManager.checkConstraintExists(paramHsqlName.name, this.table.getSchemaName(), false);
    Constraint[] arrayOfConstraint = this.table.getConstraints();
    int i = 0;
    int j = arrayOfConstraint.length;
    while (i < j)
    {
      localConstraint = arrayOfConstraint[i];
      if ((localConstraint.isEquivalent(paramArrayOfInt, 2)) || (localConstraint.getName().name.equals(paramHsqlName.name)))
        throw Trace.error(60);
      i++;
    }
    HsqlNameManager.HsqlName localHsqlName = this.table.database.nameManager.newAutoName("IDX", paramHsqlName.name);
    Index localIndex = createIndex(paramArrayOfInt, localHsqlName, true, true, false);
    Constraint localConstraint = new Constraint(paramHsqlName, this.table, localIndex, 2);
    this.table.addConstraint(localConstraint);
    this.table.database.schemaManager.registerConstraintName(paramHsqlName.name, this.table.getName());
  }

  void createCheckConstraint(Constraint paramConstraint, HsqlNameManager.HsqlName paramHsqlName)
    throws HsqlException
  {
    this.table.database.schemaManager.checkConstraintExists(paramHsqlName.name, this.table.getSchemaName(), false);
    Expression localExpression = paramConstraint.core.check;
    localExpression.setLikeOptimised();
    Select localSelect = Expression.getCheckSelect(this.session, this.table, localExpression);
    Result localResult = localSelect.getResult(this.session, 1);
    paramConstraint.core.checkFilter = localSelect.tFilter[0];
    paramConstraint.core.mainTable = this.table;
    if (localResult.getSize() != 0)
      throw Trace.error(157);
    localExpression.getDDL();
    paramConstraint.core.checkFilter.setAsCheckFilter();
    this.table.addConstraint(paramConstraint);
    this.table.database.schemaManager.registerConstraintName(paramHsqlName.name, this.table.getName());
  }

  void dropIndex(String paramString)
    throws HsqlException
  {
    if (this.table.isIndexingMutable())
    {
      this.table.dropIndex(this.session, paramString);
    }
    else
    {
      int[] arrayOfInt = { this.table.getIndexIndex(paramString) };
      Table localTable = this.table.moveDefinition(arrayOfInt, null, -1, 0);
      localTable.moveData(this.session, this.table, -1, 0);
      localTable.updateConstraintsTables(this.session, this.table, -1, 0);
      int i = this.table.database.schemaManager.getTableIndex(this.table);
      this.table.database.schemaManager.setTable(i, localTable);
      this.table = localTable;
    }
    this.table.database.schemaManager.removeIndexName(paramString, this.table.getName());
    this.table.database.schemaManager.recompileViews(this.table);
  }

  void retypeColumn(Column paramColumn, int paramInt)
    throws HsqlException
  {
    if ((this.table.isText()) && (!this.table.isEmpty(this.session)))
      throw Trace.error(73);
    this.table.database.schemaManager.checkColumnIsInView(this.table, this.table.getColumn(paramInt).columnName.name);
    this.table.checkColumnInCheckConstraint(this.table.getColumn(paramInt).columnName.name);
    int[] arrayOfInt = null;
    Table localTable = this.table.moveDefinition(arrayOfInt, paramColumn, paramInt, 0);
    localTable.moveData(this.session, this.table, paramInt, 0);
    localTable.updateConstraintsTables(this.session, this.table, paramInt, 0);
    int i = this.table.database.schemaManager.getTableIndex(this.table);
    this.table.database.schemaManager.setTable(i, localTable);
    this.table = localTable;
    this.table.database.schemaManager.recompileViews(this.table);
  }

  void dropColumn(int paramInt)
    throws HsqlException
  {
    HsqlNameManager.HsqlName localHsqlName = null;
    if ((this.table.isText()) && (!this.table.isEmpty(this.session)))
      throw Trace.error(73);
    this.table.database.schemaManager.checkColumnIsInView(this.table, this.table.getColumn(paramInt).columnName.name);
    this.table.checkColumnInCheckConstraint(this.table.getColumn(paramInt).columnName.name);
    Table localTable = this.table;
    int[] arrayOfInt = null;
    String str = localTable.getColumn(paramInt).columnName.name;
    localTable.checkColumnInFKConstraint(paramInt);
    if ((this.table.getPrimaryKey().length == 1) && (this.table.getPrimaryKey()[0] == paramInt))
    {
      this.table.checkDropIndex(this.table.getIndex(0).getName().name, null, true);
      localHsqlName = this.table.constraintList[0].getName();
      localTable = this.table.moveDefinitionPK(null, false);
    }
    Constraint localConstraint = localTable.getUniqueConstraintForColumns(new int[] { paramInt });
    if (localConstraint != null)
    {
      Index localIndex = localConstraint.getMainIndex();
      arrayOfInt = new int[] { localTable.getIndexIndex(localIndex.getName().name) };
      localHsqlName = localConstraint.getName();
    }
    localTable = localTable.moveDefinition(arrayOfInt, null, paramInt, -1);
    localTable.moveData(this.session, this.table, paramInt, -1);
    localTable.updateConstraintsTables(this.session, this.table, paramInt, -1);
    int i = this.table.database.schemaManager.getTableIndex(this.table);
    this.table.database.schemaManager.setTable(i, localTable);
    this.table = localTable;
    this.table.database.schemaManager.recompileViews(this.table);
    if (localHsqlName != null)
    {
      this.table.removeConstraint(localHsqlName.name);
      this.table.database.schemaManager.removeConstraintName(localHsqlName.name, this.table.getName());
    }
  }

  void addColumn(Column paramColumn, int paramInt)
    throws HsqlException
  {
    if ((this.table.isText()) && (!this.table.isEmpty(this.session)))
      throw Trace.error(73);
    Table localTable = this.table;
    localTable = localTable.moveDefinition(null, paramColumn, paramInt, 1);
    if (paramColumn.isPrimaryKey())
      localTable = localTable.moveDefinitionPK(new int[] { paramInt }, true);
    localTable.moveData(this.session, this.table, paramInt, 1);
    localTable.updateConstraintsTables(this.session, this.table, paramInt, 1);
    int i = this.table.database.schemaManager.getTableIndex(this.table);
    this.table.database.schemaManager.setTable(i, localTable);
    this.table = localTable;
    this.table.database.schemaManager.recompileViews(this.table);
    if (paramColumn.isPrimaryKey())
    {
      HsqlNameManager.HsqlName localHsqlName = localTable.makeSysPKName();
      Constraint localConstraint = new Constraint(localHsqlName, this.table, this.table.getPrimaryIndex(), 4);
      this.table.addConstraint(localConstraint);
      this.table.database.schemaManager.registerConstraintName(localHsqlName.name, this.table.getName());
    }
  }

  void dropConstraint(String paramString)
    throws HsqlException
  {
    Constraint localConstraint = this.table.getConstraint(paramString);
    if (localConstraint == null)
      throw Trace.error(61, 171, new Object[] { paramString, this.table.getName().name });
    int i = localConstraint.getType();
    if (i == 1)
      throw Trace.error(59);
    if (i == 4)
    {
      addOrDropPrimaryKey(null, false);
      this.table.removeConstraint(paramString);
    }
    else if (i == 0)
    {
      dropFKConstraint(localConstraint);
    }
    else if (i == 2)
    {
      HashSet localHashSet = new HashSet();
      localHashSet.add(localConstraint);
      this.table.checkDropIndex(localConstraint.getMainIndex().getName().name, localHashSet, false);
      dropIndex(localConstraint.getMainIndex().getName().name);
      this.table.removeConstraint(paramString);
    }
    else if (i == 3)
    {
      this.table.removeConstraint(paramString);
    }
    this.table.database.schemaManager.removeConstraintName(paramString, this.table.getName());
  }

  void dropFKConstraint(Constraint paramConstraint)
    throws HsqlException
  {
    Index localIndex = paramConstraint.getRefIndex();
    dropIndex(localIndex.getName().name);
    Table localTable = paramConstraint.getMain();
    localTable.removeConstraint(paramConstraint.getPkName());
    this.table.removeConstraint(paramConstraint.getFkName());
  }

  void reTypeColumn(Column paramColumn1, Column paramColumn2)
    throws HsqlException
  {
    int i = 0;
    int j = paramColumn1.getType();
    int k = paramColumn2.getType();
    switch (k)
    {
    case -4:
    case -3:
    case -2:
    case 1111:
    case 2000:
      i = (k != j) && (!this.table.isEmpty(this.session)) ? 1 : 0;
    }
    switch (j)
    {
    case -4:
    case -3:
    case -2:
    case 1111:
    case 2000:
      i = (k != j) && (!this.table.isEmpty(this.session)) ? 1 : 0;
      break;
    case -6:
    case -5:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
      switch (k)
      {
      case 91:
      case 92:
      case 93:
        i = !this.table.isEmpty(this.session) ? 1 : 0;
      }
      break;
    case 91:
    case 92:
    case 93:
      switch (k)
      {
      case -6:
      case -5:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
        i = !this.table.isEmpty(this.session) ? 1 : 0;
      case -4:
      case -3:
      case -2:
      case -1:
      case 0:
      case 1:
      }
    }
    if (i != 0)
      throw Trace.error(95);
    int m = this.table.getColumnNr(paramColumn1.columnName.name);
    if (this.table.getPrimaryKey().length > 1)
    {
      if (paramColumn2.isIdentity())
        throw Trace.error(24);
      paramColumn2.setPrimaryKey(paramColumn1.isPrimaryKey());
      if (ArrayUtil.find(this.table.getPrimaryKey(), m) != -1)
        paramColumn2.setNullable(false);
    }
    else if (this.table.hasPrimaryKey())
    {
      if (paramColumn1.isPrimaryKey())
      {
        paramColumn2.setPrimaryKey(true);
        paramColumn2.setNullable(false);
      }
      else if (paramColumn2.isPrimaryKey())
      {
        throw Trace.error(24);
      }
    }
    else if (paramColumn2.isPrimaryKey())
    {
      throw Trace.error(251);
    }
    if ((k == j) && (paramColumn1.isNullable() == paramColumn2.isNullable()) && (paramColumn1.getScale() == paramColumn2.getScale()) && (paramColumn1.isIdentity() == paramColumn2.isIdentity()) && (paramColumn1.identityIncrement == paramColumn2.identityIncrement) && ((paramColumn1.getSize() == paramColumn2.getSize()) || ((paramColumn1.getSize() < paramColumn2.getSize()) && ((j == 12) || (j == 3) || (j == 2)))))
    {
      paramColumn1.setType(paramColumn2);
      paramColumn1.setDefaultExpression(paramColumn2.getDefaultExpression());
      this.table.setColumnTypeVars(m);
      this.table.resetDefaultsFlag();
      return;
    }
    this.table.database.schemaManager.checkColumnIsInView(this.table, this.table.getColumn(m).columnName.name);
    this.table.checkColumnInCheckConstraint(this.table.getColumn(m).columnName.name);
    this.table.checkColumnInFKConstraint(m);
    checkConvertColDataType(paramColumn1, paramColumn2);
    retypeColumn(paramColumn2, m);
  }

  void checkConvertColDataType(Column paramColumn1, Column paramColumn2)
    throws HsqlException
  {
    int i = this.table.getColumnNr(paramColumn1.columnName.name);
    RowIterator localRowIterator = this.table.getPrimaryIndex().firstRow(this.session);
    while (localRowIterator.hasNext())
    {
      Row localRow = localRowIterator.next();
      Object localObject = localRow.getData()[i];
      Column.convertObject(this.session, localObject, paramColumn2.getType(), paramColumn2.getSize(), paramColumn2.getScale());
    }
  }

  void setColNullability(Column paramColumn, boolean paramBoolean)
    throws HsqlException
  {
    int i = this.table.getColumnNr(paramColumn.columnName.name);
    if (paramBoolean)
    {
      if (paramColumn.isPrimaryKey())
        throw Trace.error(10);
      this.table.checkColumnInFKConstraint(i, 2);
    }
    else
    {
      RowIterator localRowIterator = this.table.getPrimaryIndex().firstRow(this.session);
      while (localRowIterator.hasNext())
      {
        Row localRow = localRowIterator.next();
        Object localObject = localRow.getData()[i];
        if (localObject != null)
          continue;
        throw Trace.error(10);
      }
    }
    paramColumn.setNullable(paramBoolean);
    this.table.setColumnTypeVars(i);
  }

  void setColDefaultExpression(int paramInt, Expression paramExpression)
    throws HsqlException
  {
    if (paramExpression == null)
      this.table.checkColumnInFKConstraint(paramInt, 4);
    this.table.setDefaultExpression(paramInt, paramExpression);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.TableWorks
 * JD-Core Version:    0.6.0
 */