package org.hsqldb;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

public class SessionManager
{
  int sessionIdCount = 1;
  private IntKeyHashMap sessionMap = new IntKeyHashMap();
  private Session sysSession;

  public SessionManager(Database paramDatabase)
  {
    User localUser = paramDatabase.getUserManager().getSysUser();
    this.sysSession = new Session(paramDatabase, localUser, false, false, 0);
  }

  public synchronized Session newSession(Database paramDatabase, User paramUser, boolean paramBoolean1, boolean paramBoolean2)
  {
    Session localSession = new Session(paramDatabase, paramUser, true, paramBoolean1, this.sessionIdCount);
    localSession.isProcessingLog = paramBoolean2;
    if ((!paramBoolean2) && (this.sessionMap.isEmpty()))
    {
      HsqlException[] arrayOfHsqlException = this.sysSession.getAndClearWarnings();
      for (int i = 0; i < arrayOfHsqlException.length; i++)
        localSession.addWarning(arrayOfHsqlException[i]);
    }
    this.sessionMap.put(this.sessionIdCount, localSession);
    this.sessionIdCount += 1;
    return localSession;
  }

  public Session getSysSession(String paramString, boolean paramBoolean)
    throws HsqlException
  {
    this.sysSession.currentSchema = this.sysSession.database.schemaManager.getSchemaHsqlName(paramString);
    this.sysSession.isProcessingScript = paramBoolean;
    this.sysSession.isProcessingLog = false;
    this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
    return this.sysSession;
  }

  public Session getSysSession()
  {
    this.sysSession.currentSchema = this.sysSession.database.schemaManager.defaultSchemaHsqlName;
    this.sysSession.isProcessingScript = false;
    this.sysSession.isProcessingLog = false;
    this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
    return this.sysSession;
  }

  public Session getSysSession(String paramString, User paramUser)
    throws HsqlException
  {
    this.sysSession.currentSchema = this.sysSession.database.schemaManager.getSchemaHsqlName(paramString);
    this.sysSession.isProcessingScript = false;
    this.sysSession.isProcessingLog = false;
    this.sysSession.setUser(paramUser);
    return this.sysSession;
  }

  public synchronized void closeAllSessions()
  {
    Session[] arrayOfSession = getAllSessions();
    for (int i = 0; i < arrayOfSession.length; i++)
      arrayOfSession[i].close();
  }

  synchronized void removeSession(Session paramSession)
  {
    this.sessionMap.remove(paramSession.getId());
  }

  synchronized void clearAll()
  {
    this.sessionMap.clear();
  }

  synchronized boolean isEmpty()
  {
    return this.sessionMap.isEmpty();
  }

  synchronized Session[] getVisibleSessions(Session paramSession)
  {
    return new Session[] { paramSession.isAdmin() ? getAllSessions() : paramSession };
  }

  synchronized Session getSession(int paramInt)
  {
    return (Session)this.sessionMap.get(paramInt);
  }

  public synchronized Session[] getAllSessions()
  {
    Session[] arrayOfSession = new Session[this.sessionMap.size()];
    Iterator localIterator = this.sessionMap.values().iterator();
    for (int i = 0; localIterator.hasNext(); i++)
      arrayOfSession[i] = ((Session)localIterator.next());
    return arrayOfSession;
  }

  public synchronized boolean isUserActive(String paramString)
  {
    Iterator localIterator = this.sessionMap.values().iterator();
    for (int i = 0; localIterator.hasNext(); i++)
    {
      Session localSession = (Session)localIterator.next();
      if (paramString.equals(localSession.getUser().getName()))
        return true;
    }
    return false;
  }

  public synchronized void removeSchemaReference(SchemaManager.Schema paramSchema)
  {
    Iterator localIterator = this.sessionMap.values().iterator();
    for (int i = 0; localIterator.hasNext(); i++)
    {
      Session localSession = (Session)localIterator.next();
      if (localSession.currentSchema != paramSchema.name)
        continue;
      localSession.resetSchema();
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.SessionManager
 * JD-Core Version:    0.6.0
 */