package org.hsqldb;

public abstract interface SessionInterface
{
  public static final int INFO_DATABASE = 0;
  public static final int INFO_USER = 1;
  public static final int INFO_SESSION_ID = 2;
  public static final int INFO_ISOLATION = 3;
  public static final int INFO_AUTOCOMMIT = 4;
  public static final int INFO_DATABASE_READONLY = 5;
  public static final int INFO_CONNECTION_READONLY = 6;
  public static final int TX_READ_UNCOMMITTED = 1;
  public static final int TX_READ_COMMITTED = 2;
  public static final int TX_REPEATABLE_READ = 4;
  public static final int TX_SERIALIZABLE = 8;

  public abstract Result execute(Result paramResult)
    throws HsqlException;

  public abstract void close();

  public abstract boolean isClosed();

  public abstract boolean isReadOnly()
    throws HsqlException;

  public abstract void setReadOnly(boolean paramBoolean)
    throws HsqlException;

  public abstract boolean isAutoCommit()
    throws HsqlException;

  public abstract void setAutoCommit(boolean paramBoolean)
    throws HsqlException;

  public abstract void setIsolation(int paramInt)
    throws HsqlException;

  public abstract int getIsolation()
    throws HsqlException;

  public abstract void startPhasedTransaction()
    throws HsqlException;

  public abstract void prepareCommit()
    throws HsqlException;

  public abstract void commit()
    throws HsqlException;

  public abstract void rollback()
    throws HsqlException;

  public abstract int getId();

  public abstract void resetSession()
    throws HsqlException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.SessionInterface
 * JD-Core Version:    0.6.0
 */