package org.hsqldb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Servlet extends HttpServlet
{
  private static final int BUFFER_SIZE = 256;
  private String dbType;
  private String dbPath;
  private String errorStr;
  private RowOutputBinary rowOut;
  private RowInputBinary rowIn;
  private int iQueries;
  private static long lModified = 0L;

  public void init(ServletConfig paramServletConfig)
  {
    try
    {
      super.init(paramServletConfig);
      this.rowOut = new RowOutputBinary(256);
      this.rowIn = new RowInputBinary(this.rowOut);
    }
    catch (ServletException localServletException)
    {
      log(localServletException.toString());
    }
    String str1 = getInitParameter("hsqldb.server.database");
    if (str1 == null)
      str1 = ".";
    String str2 = getInitParameter("hsqldb.server.use_web-inf_path");
    if ((!str1.equals(".")) && ("true".equalsIgnoreCase(str2)))
      str1 = getServletContext().getRealPath("/") + "WEB-INF" + str1;
    HsqlProperties localHsqlProperties = DatabaseURL.parseURL(str1, false);
    log("Database filename = " + str1);
    if (localHsqlProperties == null)
    {
      this.errorStr = "Bad Database name";
    }
    else
    {
      this.dbPath = localHsqlProperties.getProperty("database");
      this.dbType = localHsqlProperties.getProperty("connection_type");
      try
      {
        DatabaseManager.getDatabase(this.dbType, this.dbPath, localHsqlProperties);
      }
      catch (HsqlException localHsqlException)
      {
        this.errorStr = localHsqlException.getMessage();
      }
    }
    log(this.errorStr);
    log("Initialization completed.");
  }

  protected long getLastModified(HttpServletRequest paramHttpServletRequest)
  {
    return lModified++;
  }

  public void doGet(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse)
    throws IOException, ServletException
  {
    String str = paramHttpServletRequest.getQueryString();
    if ((str == null) || (str.length() == 0))
    {
      paramHttpServletResponse.setContentType("text/html");
      paramHttpServletResponse.setHeader("Pragma", "no-cache");
      PrintWriter localPrintWriter = paramHttpServletResponse.getWriter();
      localPrintWriter.println("<html><head><title>HSQL Database Engine Servlet</title>");
      localPrintWriter.println("</head><body><h1>HSQL Database Engine Servlet</h1>");
      localPrintWriter.println("The servlet is running.<p>");
      if (this.errorStr == null)
      {
        localPrintWriter.println("The database is also running.<p>");
        localPrintWriter.println("Database name: " + this.dbType + this.dbPath + "<p>");
        localPrintWriter.println("Queries processed: " + this.iQueries + "<p>");
      }
      else
      {
        localPrintWriter.println("<h2>The database is not running!</h2>");
        localPrintWriter.println("The error message is:<p>");
        localPrintWriter.println(this.errorStr);
      }
      localPrintWriter.println("</body></html>");
    }
  }

  public void doPost(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse)
    throws IOException, ServletException
  {
    synchronized (this)
    {
      DataInputStream localDataInputStream = null;
      ServletOutputStream localServletOutputStream = null;
      try
      {
        localDataInputStream = new DataInputStream(paramHttpServletRequest.getInputStream());
        Result localResult1 = Result.read(this.rowIn, localDataInputStream);
        Result localResult2;
        if (localResult1.mode == 65543)
        {
          try
          {
            Session localSession1 = DatabaseManager.newSession(this.dbType, this.dbPath, localResult1.getMainString(), localResult1.getSubString(), null);
            localResult2 = new Result(1);
            localResult2.sessionID = localSession1.getId();
          }
          catch (HsqlException localHsqlException2)
          {
            localResult2 = new Result(localHsqlException2, null);
          }
        }
        else
        {
          int i = localResult1.databaseID;
          int j = localResult1.sessionID;
          Session localSession2 = DatabaseManager.getSession(i, j);
          localResult2 = localSession2.execute(localResult1);
        }
        this.rowOut.reset();
        localResult2.write(this.rowOut);
        paramHttpServletResponse.setContentType("application/octet-stream");
        paramHttpServletResponse.setContentLength(this.rowOut.size());
        localServletOutputStream = paramHttpServletResponse.getOutputStream();
        localServletOutputStream.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
        this.iQueries += 1;
      }
      catch (HsqlException localHsqlException1)
      {
      }
      finally
      {
        if (localServletOutputStream != null)
          localServletOutputStream.close();
        if (localDataInputStream != null)
          localDataInputStream.close();
      }
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Servlet
 * JD-Core Version:    0.6.0
 */