package org.hsqldb;

import java.net.InetAddress;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

public final class ServerConfiguration
  implements ServerConstants
{
  public static int getDefaultPort(int paramInt, boolean paramBoolean)
  {
    switch (paramInt)
    {
    case 1:
      return paramBoolean ? 554 : 9001;
    case 0:
      return paramBoolean ? 443 : 80;
    case 2:
      return paramBoolean ? -1 : 9101;
    }
    return -1;
  }

  public static HsqlProperties getPropertiesFromFile(String paramString)
  {
    if (StringUtil.isEmpty(paramString))
      return null;
    HsqlProperties localHsqlProperties = new HsqlProperties(paramString);
    try
    {
      localHsqlProperties.load();
    }
    catch (Exception localException)
    {
    }
    return localHsqlProperties;
  }

  public static String[] listLocalInetAddressNames()
  {
    HashSet localHashSet = new HashSet();
    InetAddress localInetAddress;
    InetAddress[] arrayOfInetAddress;
    try
    {
      localInetAddress = InetAddress.getLocalHost();
      arrayOfInetAddress = InetAddress.getAllByName(localInetAddress.getHostAddress());
      for (int i = 0; i < arrayOfInetAddress.length; i++)
      {
        localHashSet.add(arrayOfInetAddress[i].getHostAddress());
        localHashSet.add(arrayOfInetAddress[i].getHostName());
      }
      arrayOfInetAddress = InetAddress.getAllByName(localInetAddress.getHostName());
      for (i = 0; i < arrayOfInetAddress.length; i++)
      {
        localHashSet.add(arrayOfInetAddress[i].getHostAddress());
        localHashSet.add(arrayOfInetAddress[i].getHostName());
      }
    }
    catch (Exception localException1)
    {
    }
    try
    {
      localInetAddress = InetAddress.getByName(null);
      arrayOfInetAddress = InetAddress.getAllByName(localInetAddress.getHostAddress());
      for (int j = 0; j < arrayOfInetAddress.length; j++)
      {
        localHashSet.add(arrayOfInetAddress[j].getHostAddress());
        localHashSet.add(arrayOfInetAddress[j].getHostName());
      }
      arrayOfInetAddress = InetAddress.getAllByName(localInetAddress.getHostName());
      for (j = 0; j < arrayOfInetAddress.length; j++)
      {
        localHashSet.add(arrayOfInetAddress[j].getHostAddress());
        localHashSet.add(arrayOfInetAddress[j].getHostName());
      }
    }
    catch (Exception localException2)
    {
    }
    try
    {
      localHashSet.add(InetAddress.getByName("loopback").getHostAddress());
      localHashSet.add(InetAddress.getByName("loopback").getHostName());
    }
    catch (Exception localException3)
    {
    }
    return (String[])localHashSet.toArray(new String[localHashSet.size()]);
  }

  public static HsqlProperties newDefaultProperties(int paramInt)
  {
    HsqlProperties localHsqlProperties = new HsqlProperties();
    localHsqlProperties.setProperty("server.restart_on_shutdown", false);
    localHsqlProperties.setProperty("server.address", "0.0.0.0");
    localHsqlProperties.setProperty("server.no_system_exit", true);
    boolean bool = false;
    try
    {
      bool = System.getProperty("javax.net.ssl.keyStore") != null;
    }
    catch (Exception localException)
    {
    }
    localHsqlProperties.setProperty("server.port", getDefaultPort(paramInt, bool));
    localHsqlProperties.setProperty("server.silent", true);
    localHsqlProperties.setProperty("server.tls", bool);
    localHsqlProperties.setProperty("server.trace", false);
    localHsqlProperties.setProperty("server.default_page", "index.html");
    localHsqlProperties.setProperty("server.root", ".");
    return localHsqlProperties;
  }

  public static void translateAddressProperty(HsqlProperties paramHsqlProperties)
  {
    if (paramHsqlProperties == null)
      return;
    String str = paramHsqlProperties.getProperty("server.address");
    if (StringUtil.isEmpty(str))
      paramHsqlProperties.setProperty("server.address", "0.0.0.0");
  }

  public static void translateDefaultDatabaseProperty(HsqlProperties paramHsqlProperties)
  {
    if (paramHsqlProperties == null)
      return;
    if (!paramHsqlProperties.isPropertyTrue("server.remote_open"))
      if (paramHsqlProperties.getProperty("server.database.0") == null)
      {
        String str = paramHsqlProperties.getProperty("server.database");
        if (str == null)
          str = "test";
        paramHsqlProperties.setProperty("server.database.0", str);
        paramHsqlProperties.setProperty("server.dbname.0", "");
      }
      else if (paramHsqlProperties.getProperty("server.dbname.0") == null)
      {
        paramHsqlProperties.setProperty("server.dbname.0", "");
      }
  }

  public static void translateDefaultNoSystemExitProperty(HsqlProperties paramHsqlProperties)
  {
    if (paramHsqlProperties == null)
      return;
    paramHsqlProperties.setPropertyIfNotExists("server.no_system_exit", "false");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.ServerConfiguration
 * JD-Core Version:    0.6.0
 */