package org.hsqldb;

import org.hsqldb.lib.HashMappedList;
import org.hsqldb.persist.Logger;

public class SequenceManager
{
  HashMappedList sequenceMap = new HashMappedList();

  void dropSequence(String paramString)
    throws HsqlException
  {
    boolean bool = this.sequenceMap.containsKey(paramString);
    Trace.check(bool, 191, paramString);
    this.sequenceMap.remove(paramString);
  }

  public NumberSequence getSequence(String paramString)
  {
    return (NumberSequence)this.sequenceMap.get(paramString);
  }

  NumberSequence createSequence(HsqlNameManager.HsqlName paramHsqlName, long paramLong1, long paramLong2, int paramInt)
    throws HsqlException
  {
    Trace.check(!this.sequenceMap.containsKey(paramHsqlName.name), 192);
    NumberSequence localNumberSequence = new NumberSequence(paramHsqlName, paramLong1, paramLong2, paramInt);
    this.sequenceMap.put(paramHsqlName.name, localNumberSequence);
    return localNumberSequence;
  }

  String logSequences(Session paramSession, Logger paramLogger)
    throws HsqlException
  {
    for (int i = 0; i < this.sequenceMap.size(); i++)
    {
      NumberSequence localNumberSequence = (NumberSequence)this.sequenceMap.get(i);
      if (!localNumberSequence.wasUsed())
        continue;
      paramLogger.writeSequenceStatement(paramSession, localNumberSequence);
      localNumberSequence.resetWasUsed();
    }
    return null;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.SequenceManager
 * JD-Core Version:    0.6.0
 */