package org.hsqldb;

import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;

class Select
{
  boolean isDistinctSelect;
  boolean isAggregated;
  private boolean isGrouped;
  private HashSet groupColumnNames;
  TableFilter[] tFilter;
  Expression limitCondition;
  Expression queryCondition;
  Expression havingCondition;
  Expression[] exprColumns;
  int iResultLen;
  int iGroupLen;
  int iHavingLen;
  int iOrderLen;
  int[] sortOrder;
  int[] sortDirection;
  boolean sortUnion;
  HsqlNameManager.HsqlName sIntoTable;
  int intoType;
  Select[] unionArray;
  int unionMaxDepth;
  Select unionSelect;
  int unionType;
  int unionDepth;
  static final int NOUNION = 0;
  static final int UNION = 1;
  static final int UNIONALL = 2;
  static final int INTERSECT = 3;
  static final int EXCEPT = 4;
  private boolean simpleLimit;
  Result.ResultMetaData resultMetaData;
  IntKeyHashMap asteriskPositions;
  boolean isResolved = false;

  HashMap getColumnAliases()
  {
    HashMap localHashMap = new HashMap();
    for (int i = 0; i < this.iResultLen; i++)
    {
      String str = this.exprColumns[i].getAlias();
      if (str == null)
        continue;
      localHashMap.put(str, this.exprColumns[i]);
    }
    return localHashMap;
  }

  void resolve(Session paramSession)
    throws HsqlException
  {
    resolveTables();
    resolveTypes(paramSession);
    setFilterConditions(paramSession);
  }

  private void resolveTables()
    throws HsqlException
  {
    for (int i = this.iResultLen; i < this.exprColumns.length; i++)
      if (this.exprColumns[i].getType() == 2)
      {
        if (this.exprColumns[i].joinedTableColumnIndex != -1)
          continue;
        j = this.exprColumns[i].isDescending();
        this.exprColumns[i] = this.exprColumns[i].getExpressionForAlias(this.exprColumns, this.iResultLen);
        if (j == 0)
          continue;
        this.exprColumns[i].setDescending();
      }
      else
      {
        this.exprColumns[i].replaceAliases(this.exprColumns, this.iResultLen);
      }
    if (this.queryCondition != null)
      this.queryCondition.replaceAliases(this.exprColumns, this.iResultLen);
    i = this.tFilter.length;
    for (int j = 0; j < i; j++)
      resolveTables(this.tFilter[j]);
  }

  void resolveUnionColumnTypes()
    throws HsqlException
  {
    if (this.unionSelect != null)
    {
      if (this.unionSelect.iResultLen != this.iResultLen)
        throw Trace.error(5);
      for (int i = 0; i < this.iResultLen; i++)
      {
        Expression localExpression = this.exprColumns[i];
        if (localExpression.isTypeEqual(this.unionSelect.exprColumns[i]))
          continue;
        this.unionSelect.exprColumns[i] = new Expression(this.unionSelect.exprColumns[i], localExpression.getDataType(), localExpression.getColumnSize(), localExpression.getColumnScale());
      }
    }
  }

  void resolveTypes(Session paramSession)
    throws HsqlException
  {
    int i = this.exprColumns.length;
    for (int j = 0; j < i; j++)
      this.exprColumns[j].resolveTypes(paramSession);
    if (this.queryCondition != null)
      this.queryCondition.resolveTypes(paramSession);
  }

  void resolveTablesUnion(TableFilter paramTableFilter)
    throws HsqlException
  {
    if (this.unionArray == null)
      resolveTables(paramTableFilter);
    else
      for (int i = 0; i < this.unionArray.length; i++)
        this.unionArray[i].resolveTables(paramTableFilter);
  }

  void resolveTables(TableFilter paramTableFilter)
    throws HsqlException
  {
    int i = this.exprColumns.length;
    for (int j = 0; j < i; j++)
      this.exprColumns[j].resolveTables(paramTableFilter);
    if (this.queryCondition != null)
      this.queryCondition.resolveTables(paramTableFilter);
  }

  private void setFilterConditions(Session paramSession)
    throws HsqlException
  {
    if (this.queryCondition == null)
      return;
    for (int i = 0; i < this.tFilter.length; i++)
      this.tFilter[i].setConditions(paramSession, this.queryCondition);
  }

  boolean checkResolved(boolean paramBoolean)
    throws HsqlException
  {
    int i = 1;
    int j = this.exprColumns.length;
    for (int k = 0; k < j; k++)
      i = (i != 0) && (this.exprColumns[k].checkResolved(paramBoolean)) ? 1 : 0;
    if (this.queryCondition != null)
      i = (i != 0) && (this.queryCondition.checkResolved(paramBoolean)) ? 1 : 0;
    if (this.havingCondition != null)
      i = (i != 0) && (this.havingCondition.checkResolved(paramBoolean)) ? 1 : 0;
    for (k = 0; k < this.tFilter.length; k++)
    {
      if (this.tFilter[k].filterIndex != null)
        continue;
      this.tFilter[k].filterIndex = this.tFilter[k].filterTable.getPrimaryIndex();
    }
    return i;
  }

  Object getValue(Session paramSession, int paramInt)
    throws HsqlException
  {
    resolve(paramSession);
    Result localResult = getResult(paramSession, 2);
    int i = localResult.getSize();
    int j = localResult.getColumnCount();
    if (j == 1)
    {
      if (i == 0)
        return null;
      if (i == 1)
      {
        localObject = localResult.rRoot.data[0];
        return localResult.metaData.colTypes[0] == paramInt ? localObject : Column.convertObject(localObject, paramInt);
      }
      throw Trace.error(17);
    }
    Object localObject = Trace.error(17);
    throw new HsqlInternalException((HsqlException)localObject);
  }

  void prepareResult(Session paramSession)
    throws HsqlException
  {
    resolveAll(paramSession, true);
    if (this.iGroupLen > 0)
    {
      this.isGrouped = true;
      this.groupColumnNames = new HashSet();
      for (i = this.iResultLen; i < this.iResultLen + this.iGroupLen; i++)
        this.exprColumns[i].collectAllColumnNames(this.groupColumnNames);
    }
    int i = this.exprColumns.length;
    this.resultMetaData = new Result.ResultMetaData(i);
    Result.ResultMetaData localResultMetaData = this.resultMetaData;
    int j = this.iResultLen;
    int k = j + this.iGroupLen;
    int m = k + this.iHavingLen;
    int n = m + this.iOrderLen;
    for (int i1 = 0; i1 < i; i1++)
    {
      Expression localExpression = this.exprColumns[i1];
      localResultMetaData.colTypes[i1] = localExpression.getDataType();
      localResultMetaData.colSizes[i1] = localExpression.getColumnSize();
      localResultMetaData.colScales[i1] = localExpression.getColumnScale();
      if (localExpression.isAggregate())
        this.isAggregated = true;
      if ((i1 >= j) && (i1 < k) && (!this.exprColumns[i1].canBeInGroupBy()))
        Trace.error(68, this.exprColumns[i1]);
      if ((i1 >= k) && (i1 < k + this.iHavingLen) && (!this.exprColumns[i1].isConditional()))
        Trace.error(69, this.exprColumns[i1]);
      if ((i1 >= m) && (i1 < n) && (!this.exprColumns[i1].canBeInOrderBy()))
        Trace.error(70, this.exprColumns[i1]);
      if (i1 >= this.iResultLen)
        continue;
      localResultMetaData.colLabels[i1] = localExpression.getAlias();
      localResultMetaData.isLabelQuoted[i1] = localExpression.isAliasQuoted();
      localResultMetaData.schemaNames[i1] = localExpression.getTableSchemaName();
      localResultMetaData.tableNames[i1] = localExpression.getTableName();
      localResultMetaData.colNames[i1] = localExpression.getColumnName();
      if (localResultMetaData.isTableColumn(i1))
      {
        localResultMetaData.colNullable[i1] = localExpression.nullability;
        localResultMetaData.isIdentity[i1] = localExpression.isIdentity;
        localResultMetaData.isWritable[i1] = localExpression.isWritable;
      }
      localResultMetaData.classNames[i1] = localExpression.getValueClassName();
    }
    checkAggregateOrGroupByColumns(0, this.iResultLen);
    checkAggregateOrGroupByColumns(k, m);
    checkAggregateOrGroupByOrderColumns(m, n);
    prepareSort();
    this.simpleLimit = ((!this.isDistinctSelect) && (!this.isGrouped) && (this.unionSelect == null) && (this.iOrderLen == 0));
  }

  void prepareUnions()
    throws HsqlException
  {
    int i = 0;
    Select localSelect = this;
    while (localSelect != null)
    {
      localSelect = localSelect.unionSelect;
      i++;
    }
    if (i == 1)
    {
      if (this.unionDepth != 0)
        throw Trace.error(121);
      return;
    }
    this.unionArray = new Select[i];
    i = 0;
    localSelect = this;
    while (localSelect != null)
    {
      this.unionArray[i] = localSelect;
      this.unionMaxDepth = (localSelect.unionDepth > this.unionMaxDepth ? localSelect.unionDepth : this.unionMaxDepth);
      localSelect = localSelect.unionSelect;
      i++;
    }
    if (this.unionArray[(this.unionArray.length - 1)].unionDepth != 0)
      throw Trace.error(121);
  }

  Result getResult(Session paramSession, int paramInt)
    throws HsqlException
  {
    Result localResult;
    if (this.unionArray == null)
    {
      localResult = getSingleResult(paramSession, paramInt);
    }
    else
    {
      localResult = getResultMain(paramSession);
      if (this.sortUnion)
      {
        sortResult(paramSession, localResult);
        localResult.trimResult(getLimitStart(paramSession), getLimitCount(paramSession, paramInt));
      }
    }
    localResult.setColumnCount(this.iResultLen);
    return localResult;
  }

  private Result getResultMain(Session paramSession)
    throws HsqlException
  {
    Result[] arrayOfResult = new Result[this.unionArray.length];
    for (int i = 0; i < this.unionArray.length; i++)
      arrayOfResult[i] = this.unionArray[i].getSingleResult(paramSession, 2147483647);
    for (i = this.unionMaxDepth; i >= 0; i--)
      for (int j = 0; j < 2; j++)
        for (int k = 0; k < this.unionArray.length - 1; k++)
        {
          if ((arrayOfResult[k] == null) || (this.unionArray[k].unionDepth < i) || ((j == 0) && (this.unionArray[k].unionType != 3)) || ((j == 1) && (this.unionArray[k].unionType == 3)))
            continue;
          for (int m = k + 1; (m < this.unionArray.length) && (arrayOfResult[m] == null); m++);
          if (m == this.unionArray.length)
            break;
          this.unionArray[k].mergeResults(paramSession, arrayOfResult[k], arrayOfResult[m]);
          arrayOfResult[m] = arrayOfResult[k];
          arrayOfResult[k] = null;
        }
    return arrayOfResult[(arrayOfResult.length - 1)];
  }

  private void mergeResults(Session paramSession, Result paramResult1, Result paramResult2)
    throws HsqlException
  {
    switch (this.unionType)
    {
    case 1:
      paramResult1.append(paramResult2);
      paramResult1.removeDuplicates(paramSession, this.iResultLen);
      break;
    case 2:
      paramResult1.append(paramResult2);
      break;
    case 3:
      paramResult1.removeDifferent(paramSession, paramResult2, this.iResultLen);
      break;
    case 4:
      paramResult1.removeSecond(paramSession, paramResult2, this.iResultLen);
    }
  }

  int getLimitStart(Session paramSession)
    throws HsqlException
  {
    if (this.limitCondition != null)
    {
      Integer localInteger = (Integer)this.limitCondition.getArg().getValue(paramSession);
      if (localInteger != null)
        return localInteger.intValue();
    }
    return 0;
  }

  int getLimitCount(Session paramSession, int paramInt)
    throws HsqlException
  {
    int i = 0;
    if (this.limitCondition != null)
    {
      Integer localInteger = (Integer)this.limitCondition.getArg2().getValue(paramSession);
      if (localInteger != null)
        i = localInteger.intValue();
    }
    if ((paramInt != 0) && ((i == 0) || (paramInt < i)))
      i = paramInt;
    return i;
  }

  int getMaxRowCount(Session paramSession, int paramInt)
    throws HsqlException
  {
    int i = getLimitStart(paramSession);
    int j = getLimitCount(paramSession, paramInt);
    if (!this.simpleLimit)
    {
      paramInt = 2147483647;
    }
    else
    {
      if (paramInt == 0)
        paramInt = j;
      if ((paramInt == 0) || (paramInt > 2147483647 - i))
        paramInt = 2147483647;
      else
        paramInt += i;
    }
    return paramInt;
  }

  private Result getSingleResult(Session paramSession, int paramInt)
    throws HsqlException
  {
    if (this.resultMetaData == null)
      prepareResult(paramSession);
    Result localResult = buildResult(paramSession, getMaxRowCount(paramSession, paramInt));
    if (this.isDistinctSelect)
      localResult.removeDuplicates(paramSession, this.iResultLen);
    if (!this.sortUnion)
    {
      sortResult(paramSession, localResult);
      localResult.trimResult(getLimitStart(paramSession), getLimitCount(paramSession, paramInt));
    }
    return localResult;
  }

  private void prepareSort()
  {
    if (this.iOrderLen == 0)
      return;
    this.sortOrder = new int[this.iOrderLen];
    this.sortDirection = new int[this.iOrderLen];
    int i = this.iResultLen + this.iGroupLen + this.iHavingLen;
    int j = i;
    for (int k = 0; k < this.iOrderLen; k++)
    {
      int m = j;
      if (this.exprColumns[j].joinedTableColumnIndex != -1)
        m = this.exprColumns[j].joinedTableColumnIndex;
      this.sortOrder[k] = m;
      this.sortDirection[k] = (this.exprColumns[j].isDescending() ? -1 : 1);
      j++;
    }
  }

  private void sortResult(Session paramSession, Result paramResult)
    throws HsqlException
  {
    if (this.iOrderLen == 0)
      return;
    paramResult.sortResult(paramSession, this.sortOrder, this.sortDirection);
  }

  private void checkAggregateOrGroupByColumns(int paramInt1, int paramInt2)
    throws HsqlException
  {
    if (paramInt1 < paramInt2)
    {
      HsqlArrayList localHsqlArrayList = new HsqlArrayList();
      for (int i = paramInt1; i < paramInt2; i++)
        this.exprColumns[i].collectInGroupByExpressions(localHsqlArrayList);
      i = 0;
      int j = localHsqlArrayList.size();
      while (i < j)
      {
        Expression localExpression = (Expression)localHsqlArrayList.get(i);
        if (!inAggregateOrGroupByClause(localExpression))
          throw Trace.error(67, localExpression);
        i++;
      }
    }
  }

  private void checkAggregateOrGroupByOrderColumns(int paramInt1, int paramInt2)
    throws HsqlException
  {
    checkAggregateOrGroupByColumns(paramInt1, paramInt2);
    if ((paramInt1 < paramInt2) && (this.isDistinctSelect))
    {
      HsqlArrayList localHsqlArrayList = new HsqlArrayList();
      for (int i = paramInt1; i < paramInt2; i++)
        this.exprColumns[i].collectInGroupByExpressions(localHsqlArrayList);
      i = 0;
      int j = localHsqlArrayList.size();
      while (i < j)
      {
        Expression localExpression = (Expression)localHsqlArrayList.get(i);
        if (!isSimilarIn(localExpression, 0, this.iResultLen))
          throw Trace.error(71, localExpression);
        i++;
      }
    }
  }

  private boolean inAggregateOrGroupByClause(Expression paramExpression)
  {
    if (this.isGrouped)
      return (isSimilarIn(paramExpression, this.iResultLen, this.iResultLen + this.iGroupLen)) || (allColumnsAreDefinedIn(paramExpression, this.groupColumnNames));
    if (this.isAggregated)
      return paramExpression.canBeInAggregate();
    return true;
  }

  private boolean isSimilarIn(Expression paramExpression, int paramInt1, int paramInt2)
  {
    for (int i = paramInt1; i < paramInt2; i++)
      if (paramExpression.similarTo(this.exprColumns[i]))
        return true;
    return false;
  }

  static boolean allColumnsAreDefinedIn(Expression paramExpression, HashSet paramHashSet)
  {
    HashSet localHashSet = new HashSet();
    paramExpression.collectAllColumnNames(localHashSet);
    if ((localHashSet.size() > 0) && (paramHashSet == null))
      return false;
    Iterator localIterator = localHashSet.iterator();
    while (localIterator.hasNext())
      if (!paramHashSet.contains(localIterator.next()))
        return false;
    return true;
  }

  private Result buildResult(Session paramSession, int paramInt)
    throws HsqlException
  {
    GroupedResult localGroupedResult = new GroupedResult(this, this.resultMetaData);
    int i = this.exprColumns.length;
    int j = this.tFilter.length;
    boolean[] arrayOfBoolean1 = new boolean[j];
    boolean[] arrayOfBoolean2 = new boolean[j];
    int k = 0;
    int m = (this.queryCondition == null) || (!this.queryCondition.isFixedConditional()) || (this.queryCondition.testCondition(paramSession)) ? 1 : 0;
    int n;
    int i1;
    while ((m != 0) && (k >= 0))
    {
      localObject = this.tFilter[k];
      if (arrayOfBoolean1[k] == 0)
      {
        n = ((TableFilter)localObject).findFirst(paramSession);
        int tmp159_158 = ((((TableFilter)localObject).isOuterJoin) && (n == 0) && (arrayOfBoolean2[k] == 0) && (!((TableFilter)localObject).nonJoinIsNull) && (((TableFilter)localObject).nextOuter(paramSession)) ? 1 : 0);
        i1 = tmp159_158;
        arrayOfBoolean2[k] = tmp159_158;
        arrayOfBoolean1[k] = n;
      }
      else
      {
        n = ((TableFilter)localObject).next(paramSession);
        int tmp236_235 = ((((TableFilter)localObject).isOuterJoin) && (n == 0) && (arrayOfBoolean1[k] == 0) && (arrayOfBoolean2[k] == 0) && (!((TableFilter)localObject).nonJoinIsNull) && (((TableFilter)localObject).nextOuter(paramSession)) ? 1 : 0);
        i1 = tmp236_235;
        arrayOfBoolean2[k] = tmp236_235;
        arrayOfBoolean1[k] = n;
      }
      if ((n == 0) && (i1 == 0))
      {
        k--;
        continue;
      }
      if (k < j - 1)
      {
        k++;
        continue;
      }
      while (arrayOfBoolean2[k] != 0)
        arrayOfBoolean2[(k--)] = false;
      if ((this.queryCondition != null) && (!this.queryCondition.testCondition(paramSession)))
        continue;
      try
      {
        Object[] arrayOfObject2 = new Object[i];
        for (int i2 = localGroupedResult.groupBegin; i2 < localGroupedResult.groupEnd; i2++)
          arrayOfObject2[i2] = this.exprColumns[i2].getValue(paramSession);
        arrayOfObject2 = localGroupedResult.getRow(arrayOfObject2);
        for (i2 = 0; i2 < localGroupedResult.groupBegin; i2++)
          arrayOfObject2[i2] = ((this.isAggregated) && (this.exprColumns[i2].isAggregate()) ? this.exprColumns[i2].updateAggregatingValue(paramSession, arrayOfObject2[i2]) : this.exprColumns[i2].getValue(paramSession));
        for (i2 = localGroupedResult.groupEnd; i2 < i; i2++)
          arrayOfObject2[i2] = ((this.isAggregated) && (this.exprColumns[i2].isAggregate()) ? this.exprColumns[i2].updateAggregatingValue(paramSession, arrayOfObject2[i2]) : this.exprColumns[i2].getValue(paramSession));
        localGroupedResult.addRow(arrayOfObject2);
        if (localGroupedResult.size() >= paramInt)
          break;
      }
      catch (HsqlInternalException localHsqlInternalException)
      {
      }
    }
    if ((this.isAggregated) && (!this.isGrouped) && (localGroupedResult.size() == 0))
    {
      localObject = new Object[i];
      for (n = 0; n < i; n++)
        localObject[n] = (this.exprColumns[n].isAggregate() ? null : this.exprColumns[n].getValue(paramSession));
      localGroupedResult.addRow(localObject);
    }
    Object localObject = localGroupedResult.iterator();
    while (((Iterator)localObject).hasNext())
    {
      Object[] arrayOfObject1 = (Object[])((Iterator)localObject).next();
      if (this.isAggregated)
        for (i1 = 0; i1 < i; i1++)
        {
          if (!this.exprColumns[i1].isAggregate())
            continue;
          arrayOfObject1[i1] = this.exprColumns[i1].getAggregatedValue(paramSession, arrayOfObject1[i1]);
        }
      if ((this.iHavingLen <= 0) || (Boolean.TRUE.equals(arrayOfObject1[(this.iResultLen + this.iGroupLen)])))
        continue;
      ((Iterator)localObject).remove();
    }
    return (Result)localGroupedResult.getResult();
  }

  public StringBuffer getDDL()
    throws HsqlException
  {
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append("SELECT").append(' ');
    for (int i = 0; i < this.iResultLen; i++)
    {
      localStringBuffer.append(this.exprColumns[i].getDDL());
      if (i >= this.iResultLen - 1)
        continue;
      localStringBuffer.append(',');
    }
    localStringBuffer.append("FROM");
    TableFilter localTableFilter;
    for (i = 0; i < this.tFilter.length; i++)
    {
      localTableFilter = this.tFilter[i];
      if ((i != 0) && (localTableFilter.isOuterJoin))
      {
        localStringBuffer.append("FROM").append(' ');
        localStringBuffer.append("JOIN").append(' ');
      }
      localStringBuffer.append(',');
    }
    localStringBuffer.append(' ').append("WHERE").append(' ');
    for (i = 0; i < this.tFilter.length; i++)
      localTableFilter = this.tFilter[i];
    localStringBuffer.append(' ').append("GROUP").append(' ');
    for (i = this.iResultLen; i < this.iResultLen + this.iGroupLen; i++)
    {
      localStringBuffer.append(this.exprColumns[i].getDDL());
      if (i >= this.iResultLen + this.iGroupLen - 1)
        continue;
      localStringBuffer.append(',');
    }
    localStringBuffer.append(' ').append("HAVING").append(' ');
    for (i = this.iResultLen + this.iGroupLen; i < this.iResultLen + this.iGroupLen + this.iHavingLen; i++)
    {
      localStringBuffer.append(this.exprColumns[i].getDDL());
      if (i >= this.iResultLen + this.iGroupLen - 1)
        continue;
      localStringBuffer.append(',');
    }
    if (this.unionSelect != null)
      switch (this.unionType)
      {
      case 4:
        localStringBuffer.append(' ').append("EXCEPT").append(' ');
        break;
      case 3:
        localStringBuffer.append(' ').append("INTERSECT").append(' ');
        break;
      case 1:
        localStringBuffer.append(' ').append("UNION").append(' ');
        break;
      case 2:
        localStringBuffer.append(' ').append("UNION").append(' ').append("ALL").append(' ');
      }
    i = this.iResultLen + this.iGroupLen;
    int j = i + this.iHavingLen;
    int k = j + this.iOrderLen;
    localStringBuffer.append(' ').append("ORDER").append("BY").append(' ');
    for (int m = j; m < k; m++)
    {
      localStringBuffer.append(this.exprColumns[m].getDDL());
      if (m >= this.iResultLen + this.iGroupLen - 1)
        continue;
      localStringBuffer.append(',');
    }
    return localStringBuffer;
  }

  boolean resolveAll(Session paramSession, boolean paramBoolean)
    throws HsqlException
  {
    if (this.isResolved)
      return true;
    resolve(paramSession);
    this.isResolved = checkResolved(paramBoolean);
    if (this.unionSelect != null)
    {
      if (this.unionSelect.iResultLen != this.iResultLen)
        throw Trace.error(5);
      for (int i = 0; i < this.iResultLen; i++)
      {
        Expression localExpression = this.exprColumns[i];
        if (localExpression.isTypeEqual(this.unionSelect.exprColumns[i]))
          continue;
        this.unionSelect.exprColumns[i] = new Expression(this.unionSelect.exprColumns[i], localExpression.getDataType(), localExpression.getColumnSize(), localExpression.getColumnScale());
      }
      this.isResolved &= this.unionSelect.resolveAll(paramSession, paramBoolean);
    }
    return this.isResolved;
  }

  boolean isResolved()
  {
    return this.isResolved;
  }

  public String describe(Session paramSession)
  {
    try
    {
      getResult(paramSession, 1);
    }
    catch (HsqlException localHsqlException)
    {
    }
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append(super.toString()).append("[\n");
    if (this.sIntoTable != null)
      localStringBuffer.append("into table=[").append(this.sIntoTable.name).append("]\n");
    if (this.limitCondition != null)
    {
      localStringBuffer.append("offset=[").append(this.limitCondition.getArg().describe(paramSession)).append("]\n");
      localStringBuffer.append("limit=[").append(this.limitCondition.getArg2().describe(paramSession)).append("]\n");
    }
    localStringBuffer.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
    localStringBuffer.append("isGrouped=[").append(this.isGrouped).append("]\n");
    localStringBuffer.append("isAggregated=[").append(this.isAggregated).append("]\n");
    localStringBuffer.append("columns=[");
    int i = this.exprColumns.length - this.iOrderLen;
    for (int j = 0; j < i; j++)
      localStringBuffer.append(this.exprColumns[j].describe(paramSession));
    localStringBuffer.append("\n]\n");
    localStringBuffer.append("tableFilters=[\n");
    for (j = 0; j < this.tFilter.length; j++)
    {
      localStringBuffer.append("[\n");
      localStringBuffer.append(this.tFilter[j].describe(paramSession));
      localStringBuffer.append("\n]");
    }
    localStringBuffer.append("]\n");
    String str = this.queryCondition == null ? "null" : this.queryCondition.describe(paramSession);
    localStringBuffer.append("eCondition=[").append(str).append("]\n");
    str = this.havingCondition == null ? "null" : this.havingCondition.describe(paramSession);
    localStringBuffer.append("havingCondition=[").append(str).append("]\n");
    localStringBuffer.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
    if (this.unionSelect != null)
    {
      switch (this.unionType)
      {
      case 4:
        localStringBuffer.append(" EXCEPT ");
        break;
      case 3:
        localStringBuffer.append(" INTERSECT ");
        break;
      case 1:
        localStringBuffer.append(" UNION ");
        break;
      case 2:
        localStringBuffer.append(" UNION ALL ");
        break;
      default:
        localStringBuffer.append(" UNKNOWN SET OPERATION ");
      }
      localStringBuffer.append("[\n").append(this.unionSelect.describe(paramSession)).append("]\n");
    }
    return localStringBuffer.toString();
  }

  Result describeResult()
  {
    Result localResult = new Result(3, this.iResultLen);
    Result.ResultMetaData localResultMetaData = localResult.metaData;
    for (int i = 0; i < this.iResultLen; i++)
    {
      Expression localExpression = this.exprColumns[i];
      localResultMetaData.colTypes[i] = localExpression.getDataType();
      localResultMetaData.colSizes[i] = localExpression.getColumnSize();
      localResultMetaData.colScales[i] = localExpression.getColumnScale();
      localResultMetaData.colLabels[i] = localExpression.getAlias();
      localResultMetaData.isLabelQuoted[i] = localExpression.isAliasQuoted();
      localResultMetaData.tableNames[i] = localExpression.getTableName();
      localResultMetaData.colNames[i] = localExpression.getColumnName();
      if (!localResultMetaData.isTableColumn(i))
        continue;
      localResultMetaData.colNullable[i] = localExpression.nullability;
      localResultMetaData.isIdentity[i] = localExpression.isIdentity;
      localResultMetaData.isWritable[i] = localExpression.isWritable;
    }
    return localResult;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Select
 * JD-Core Version:    0.6.0
 */