package org.hsqldb;

import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Iterator;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Result
{
  public Record rRoot;
  private Record rTail;
  private int size;
  private int significantColumns;
  public int mode;
  int databaseID;
  int sessionID;
  String mainString;
  String subString;
  String subSubString;
  private Throwable exception;
  int statementID;
  int updateCount;
  public ResultMetaData metaData;

  public Result(int paramInt)
  {
    this.mode = paramInt;
    if ((paramInt == 3) || (paramInt == 5) || (paramInt == 65548) || (paramInt == 6))
      this.metaData = new ResultMetaData();
  }

  Result(ResultMetaData paramResultMetaData)
  {
    this.mode = 3;
    this.significantColumns = paramResultMetaData.colTypes.length;
    this.metaData = paramResultMetaData;
  }

  Result(String paramString1, String paramString2, int paramInt)
  {
    this.mode = 2;
    this.mainString = paramString1;
    this.subString = paramString2;
    this.statementID = paramInt;
    this.subSubString = "";
  }

  Result(int paramInt1, int paramInt2)
  {
    this.metaData = new ResultMetaData();
    this.metaData.prepareData(paramInt2);
    if (paramInt1 == 5)
    {
      this.metaData.isParameterDescription = true;
      this.metaData.paramMode = new int[paramInt2];
    }
    this.mode = paramInt1;
    this.significantColumns = paramInt2;
  }

  public Result(int paramInt1, int[] paramArrayOfInt, int paramInt2)
  {
    this.mode = paramInt1;
    this.metaData = new ResultMetaData();
    this.metaData.colTypes = paramArrayOfInt;
    this.significantColumns = paramArrayOfInt.length;
    this.statementID = paramInt2;
  }

  Result(RowInputBinary paramRowInputBinary)
    throws HsqlException
  {
    try
    {
      this.mode = paramRowInputBinary.readIntData();
      if (this.mode == 0)
      {
        readMultiResult(paramRowInputBinary);
        return;
      }
      this.databaseID = paramRowInputBinary.readIntData();
      this.sessionID = paramRowInputBinary.readIntData();
      int i;
      int j;
      switch (this.mode)
      {
      case 7:
      case 10:
      case 65545:
      case 65610:
        break;
      case 65555:
        setStatementType(paramRowInputBinary.readIntData());
        this.mainString = paramRowInputBinary.readString();
        break;
      case 4:
      case 65552:
        this.statementID = paramRowInputBinary.readIntData();
        break;
      case 65547:
        this.updateCount = paramRowInputBinary.readIntData();
        this.statementID = paramRowInputBinary.readIntData();
        this.mainString = paramRowInputBinary.readString();
        break;
      case 2:
      case 65543:
        this.mainString = paramRowInputBinary.readString();
        this.subString = paramRowInputBinary.readString();
        this.subSubString = paramRowInputBinary.readString();
        this.statementID = paramRowInputBinary.readIntData();
        break;
      case 1:
        this.updateCount = paramRowInputBinary.readIntData();
        break;
      case 66541:
        i = paramRowInputBinary.readIntData();
        setEndTranType(i);
        switch (i)
        {
        case 2:
        case 4:
          this.mainString = paramRowInputBinary.readString();
        }
        break;
      case 6:
      case 8:
      case 9:
      case 65548:
        this.updateCount = paramRowInputBinary.readIntData();
        this.statementID = paramRowInputBinary.readIntData();
        i = paramRowInputBinary.readIntData();
        this.metaData = new ResultMetaData(i);
        this.significantColumns = i;
        for (j = 0; j < i; j++)
          this.metaData.colTypes[j] = paramRowInputBinary.readType();
        j = paramRowInputBinary.readIntData();
      case 3:
      case 5:
      case 66552:
      default:
        while (j-- > 0)
        {
          add(paramRowInputBinary.readData(this.metaData.colTypes));
          continue;
          this.metaData = new ResultMetaData(paramRowInputBinary, this.mode);
          this.significantColumns = this.metaData.colLabels.length;
          i = paramRowInputBinary.readIntData();
          while (i-- > 0)
          {
            add(paramRowInputBinary.readData(this.metaData.colTypes));
            continue;
            i = paramRowInputBinary.readIntData();
            setConnectionAttrType(i);
            switch (i)
            {
            case 10027:
              this.mainString = paramRowInputBinary.readString();
            }
            break;
            throw new HsqlException(Trace.getMessage(146, true, new Object[] { new Integer(this.mode) }), null, 0);
          }
        }
      }
    }
    catch (IOException localIOException)
    {
      throw Trace.error(19);
    }
  }

  static Result newSingleColumnResult(String paramString, int paramInt)
  {
    Result localResult = new Result(3, 1);
    localResult.metaData.colNames[0] = paramString;
    localResult.metaData.colLabels[0] = paramString;
    localResult.metaData.tableNames[0] = "";
    localResult.metaData.colTypes[0] = paramInt;
    return localResult;
  }

  static Result newPrepareResponse(int paramInt, Result paramResult1, Result paramResult2)
  {
    Result localResult1 = new Result(0);
    Result localResult2 = new Result(4);
    localResult2.statementID = paramInt;
    localResult1.add(new Object[] { localResult2 });
    localResult1.add(new Object[] { paramResult1 });
    localResult1.add(new Object[] { paramResult2 });
    return localResult1;
  }

  static Result newParameterDescriptionResult(int paramInt)
  {
    Result localResult = new Result(5, paramInt);
    localResult.metaData.isParameterDescription = true;
    localResult.metaData.paramMode = new int[paramInt];
    return localResult;
  }

  public static Result newFreeStmtRequest(int paramInt)
  {
    Result localResult = new Result(65552);
    localResult.statementID = paramInt;
    return localResult;
  }

  static Result newExecuteDirectRequest(String paramString)
  {
    Result localResult = new Result(65547);
    localResult.setMainString(paramString);
    return localResult;
  }

  public static Result newReleaseSavepointRequest(String paramString)
  {
    Result localResult = new Result(66541);
    localResult.setMainString(paramString);
    localResult.setEndTranType(4);
    return localResult;
  }

  public static Result newRollbackToSavepointRequest(String paramString)
  {
    Result localResult = new Result(66541);
    localResult.setMainString(paramString);
    localResult.setEndTranType(2);
    return localResult;
  }

  public static Result newSetSavepointRequest(String paramString)
  {
    Result localResult = new Result(66552);
    localResult.setConnectionAttrType(10027);
    localResult.setMainString(paramString);
    return localResult;
  }

  public int getSize()
  {
    return this.size;
  }

  void setColumnCount(int paramInt)
  {
    this.significantColumns = paramInt;
  }

  public int getColumnCount()
  {
    return this.significantColumns;
  }

  void append(Result paramResult)
  {
    if (paramResult.rRoot == null)
      return;
    if (this.rRoot == null)
      this.rRoot = paramResult.rRoot;
    else
      this.rTail.next = paramResult.rRoot;
    this.rTail = paramResult.rTail;
    this.size += paramResult.size;
  }

  void addAll(Result paramResult)
  {
    if (paramResult == null)
      return;
    for (Record localRecord = paramResult.rRoot; localRecord != null; localRecord = localRecord.next)
      add(localRecord.data);
  }

  public void clear()
  {
    this.rRoot = null;
    this.rTail = null;
    this.size = 0;
  }

  public boolean isEmpty()
  {
    return this.rRoot == null;
  }

  void setRows(Result paramResult)
  {
    if (paramResult == null)
    {
      this.rRoot = null;
      this.rTail = null;
      this.size = 0;
    }
    else
    {
      this.rRoot = paramResult.rRoot;
      this.rTail = paramResult.rTail;
      this.size = paramResult.size;
    }
  }

  public void add(Object[] paramArrayOfObject)
  {
    Record localRecord = new Record();
    localRecord.data = paramArrayOfObject;
    if (this.rRoot == null)
      this.rRoot = localRecord;
    else
      this.rTail.next = localRecord;
    this.rTail = localRecord;
    this.size += 1;
  }

  void trimResult(int paramInt1, int paramInt2)
  {
    Record localRecord = this.rRoot;
    if (localRecord == null)
      return;
    if (paramInt1 >= this.size)
    {
      this.size = 0;
      this.rRoot = (this.rTail = null);
      return;
    }
    this.size -= paramInt1;
    for (int i = 0; i < paramInt1; i++)
    {
      localRecord = localRecord.next;
      if (localRecord != null)
        continue;
      this.size = 0;
      this.rRoot = (this.rTail = localRecord);
      return;
    }
    this.rRoot = localRecord;
    if ((paramInt2 == 0) || (paramInt2 >= this.size))
      return;
    for (i = 1; i < paramInt2; i++)
    {
      localRecord = localRecord.next;
      if (localRecord == null)
        return;
    }
    this.size = paramInt2;
    localRecord.next = null;
    this.rTail = localRecord;
  }

  void removeDuplicates(Session paramSession)
    throws HsqlException
  {
    removeDuplicates(paramSession, this.significantColumns);
  }

  void removeDuplicates(Session paramSession, int paramInt)
    throws HsqlException
  {
    if (this.rRoot == null)
      return;
    int[] arrayOfInt1 = new int[paramInt];
    int[] arrayOfInt2 = new int[paramInt];
    for (int i = 0; i < paramInt; i++)
    {
      arrayOfInt1[i] = i;
      arrayOfInt2[i] = 1;
    }
    sortResult(paramSession, arrayOfInt1, arrayOfInt2);
    Object localObject = this.rRoot;
    while (true)
    {
      Record localRecord = ((Record)localObject).next;
      if (localRecord == null)
        break;
      if (compareRecord(paramSession, ((Record)localObject).data, localRecord.data, paramInt) == 0)
      {
        ((Record)localObject).next = localRecord.next;
        this.size -= 1;
        continue;
      }
      localObject = localRecord;
    }
    this.rTail = ((Record)localObject);
  }

  void removeSecond(Session paramSession, Result paramResult, int paramInt)
    throws HsqlException
  {
    removeDuplicates(paramSession, paramInt);
    paramResult.removeDuplicates(paramSession, paramInt);
    Record localRecord1 = this.rRoot;
    Record localRecord2 = this.rRoot;
    int i = 1;
    Record localRecord3 = paramResult.rRoot;
    int j = 0;
    while ((localRecord1 != null) && (localRecord3 != null))
    {
      j = compareRecord(paramSession, localRecord1.data, localRecord3.data, paramInt);
      if (j == 0)
      {
        if (i != 0)
          this.rRoot = (localRecord2 = localRecord1.next);
        else
          localRecord2.next = localRecord1.next;
        localRecord1 = localRecord1.next;
        this.size -= 1;
        continue;
      }
      if (j > 0)
      {
        localRecord3 = localRecord3.next;
        continue;
      }
      localRecord2 = localRecord1;
      i = 0;
      localRecord1 = localRecord1.next;
    }
    while (localRecord1 != null)
    {
      localRecord2 = localRecord1;
      localRecord1 = localRecord1.next;
    }
    this.rTail = localRecord2;
  }

  void removeDifferent(Session paramSession, Result paramResult, int paramInt)
    throws HsqlException
  {
    removeDuplicates(paramSession, paramInt);
    paramResult.removeDuplicates(paramSession, paramInt);
    Record localRecord1 = this.rRoot;
    Record localRecord2 = this.rRoot;
    int i = 1;
    Record localRecord3 = paramResult.rRoot;
    int j = 0;
    this.size = 0;
    while ((localRecord1 != null) && (localRecord3 != null))
    {
      j = compareRecord(paramSession, localRecord1.data, localRecord3.data, paramInt);
      if (j == 0)
      {
        if (i != 0)
          this.rRoot = localRecord1;
        else
          localRecord2.next = localRecord1;
        i = 0;
        localRecord2 = localRecord1;
        localRecord1 = localRecord1.next;
        localRecord3 = localRecord3.next;
        this.size += 1;
        continue;
      }
      if (j > 0)
      {
        localRecord3 = localRecord3.next;
        continue;
      }
      localRecord1 = localRecord1.next;
    }
    if (i != 0)
    {
      this.rRoot = null;
      localRecord2 = null;
    }
    else
    {
      localRecord2.next = null;
    }
    this.rTail = localRecord2;
  }

  void sortResult(Session paramSession, int[] paramArrayOfInt1, int[] paramArrayOfInt2)
    throws HsqlException
  {
    if ((this.rRoot == null) || (this.rRoot.next == null))
      return;
    Record[] arrayOfRecord1 = new Record[2];
    Record[] arrayOfRecord2 = new Record[2];
    int i = 0;
    Object localObject = this.rRoot;
    while (localObject != null)
    {
      Record localRecord3 = ((Record)localObject).next;
      ((Record)localObject).next = arrayOfRecord1[i];
      arrayOfRecord1[i] = localObject;
      localObject = localRecord3;
      i ^= 1;
    }
    int j = 1;
    while (arrayOfRecord1[1] != null)
    {
      Record localRecord1 = arrayOfRecord1[0];
      Record localRecord2 = arrayOfRecord1[1];
       tmp120_119 = (arrayOfRecord2[0] =  = arrayOfRecord2[1] =  = null);
      arrayOfRecord1[1] = tmp120_119;
      arrayOfRecord1[0] = tmp120_119;
      i = 0;
      while (localRecord1 != null)
      {
        int k = j;
        int m = j;
        while (true)
        {
          if ((k == 0) || (localRecord1 == null))
          {
            if ((m == 0) || (localRecord2 == null))
              break;
            localObject = localRecord2;
            localRecord2 = localRecord2.next;
            m--;
          }
          else if ((m == 0) || (localRecord2 == null))
          {
            localObject = localRecord1;
            localRecord1 = localRecord1.next;
            k--;
          }
          else if (compareRecord(paramSession, localRecord1.data, localRecord2.data, paramArrayOfInt1, paramArrayOfInt2) > 0)
          {
            localObject = localRecord2;
            localRecord2 = localRecord2.next;
            m--;
          }
          else
          {
            localObject = localRecord1;
            localRecord1 = localRecord1.next;
            k--;
          }
          if (arrayOfRecord1[i] == null)
            arrayOfRecord1[i] = localObject;
          else
            arrayOfRecord2[i].next = ((Record)localObject);
          arrayOfRecord2[i] = localObject;
          ((Record)localObject).next = null;
        }
        i ^= 1;
      }
      j <<= 1;
    }
    this.rRoot = arrayOfRecord1[0];
    this.rTail = arrayOfRecord2[0];
  }

  private int compareRecord(Session paramSession, Object[] paramArrayOfObject1, Object[] paramArrayOfObject2, int[] paramArrayOfInt1, int[] paramArrayOfInt2)
    throws HsqlException
  {
    int i = Column.compare(paramSession.database.collation, paramArrayOfObject1[paramArrayOfInt1[0]], paramArrayOfObject2[paramArrayOfInt1[0]], this.metaData.colTypes[paramArrayOfInt1[0]]);
    if (i == 0)
      for (int j = 1; j < paramArrayOfInt1.length; j++)
      {
        i = Column.compare(paramSession.database.collation, paramArrayOfObject1[paramArrayOfInt1[j]], paramArrayOfObject2[paramArrayOfInt1[j]], this.metaData.colTypes[paramArrayOfInt1[j]]);
        if (i != 0)
          return i * paramArrayOfInt2[j];
      }
    return i * paramArrayOfInt2[0];
  }

  private int compareRecord(Session paramSession, Object[] paramArrayOfObject1, Object[] paramArrayOfObject2, int paramInt)
    throws HsqlException
  {
    for (int i = 0; i < paramInt; i++)
    {
      int j = Column.compare(paramSession.database.collation, paramArrayOfObject1[i], paramArrayOfObject2[i], this.metaData.colTypes[i]);
      if (j != 0)
        return j;
    }
    return 0;
  }

  static Result newSessionAttributesResult()
  {
    Result localResult = new Result(3, 7);
    localResult.metaData.colNames = (localResult.metaData.colLabels = localResult.metaData.tableNames = new String[] { "", "", "", "", "", "", "" });
    localResult.metaData.colTypes = new int[] { 12, 12, 4, 4, 16, 16, 16 };
    return localResult;
  }

  void write(RowOutputBinary paramRowOutputBinary)
    throws IOException, HsqlException
  {
    if (this.mode == 0)
    {
      writeMulti(paramRowOutputBinary);
      return;
    }
    int i = paramRowOutputBinary.size();
    paramRowOutputBinary.writeSize(0);
    paramRowOutputBinary.writeIntData(this.mode);
    paramRowOutputBinary.writeIntData(this.databaseID);
    paramRowOutputBinary.writeIntData(this.sessionID);
    int j;
    Record localRecord2;
    switch (this.mode)
    {
    case 7:
    case 10:
    case 65545:
    case 65610:
      break;
    case 65555:
      paramRowOutputBinary.writeIntData(getStatementType());
      paramRowOutputBinary.writeString(this.mainString);
      break;
    case 4:
    case 65552:
      paramRowOutputBinary.writeIntData(this.statementID);
      break;
    case 65547:
      paramRowOutputBinary.writeIntData(this.updateCount);
      paramRowOutputBinary.writeIntData(this.statementID);
      paramRowOutputBinary.writeString(this.mainString);
      break;
    case 2:
    case 65543:
      paramRowOutputBinary.writeString(this.mainString);
      paramRowOutputBinary.writeString(this.subString);
      paramRowOutputBinary.writeString(this.subSubString);
      paramRowOutputBinary.writeIntData(this.statementID);
      break;
    case 1:
      paramRowOutputBinary.writeIntData(this.updateCount);
      break;
    case 66541:
      j = getEndTranType();
      paramRowOutputBinary.writeIntData(j);
      switch (j)
      {
      case 2:
      case 4:
        paramRowOutputBinary.writeString(this.mainString);
      }
      break;
    case 6:
    case 8:
    case 9:
    case 65548:
      paramRowOutputBinary.writeIntData(this.updateCount);
      paramRowOutputBinary.writeIntData(this.statementID);
      j = this.significantColumns;
      paramRowOutputBinary.writeIntData(j);
      for (int m = 0; m < j; m++)
        paramRowOutputBinary.writeType(this.metaData.colTypes[m]);
      paramRowOutputBinary.writeIntData(this.size);
      localRecord2 = this.rRoot;
    case 3:
    case 5:
    case 66552:
    default:
      while (localRecord2 != null)
      {
        paramRowOutputBinary.writeData(j, this.metaData.colTypes, localRecord2.data, null, null);
        localRecord2 = localRecord2.next;
        continue;
        this.metaData.write(paramRowOutputBinary, this.significantColumns);
        paramRowOutputBinary.writeIntData(this.size);
        Record localRecord1 = this.rRoot;
        while (localRecord1 != null)
        {
          paramRowOutputBinary.writeData(this.significantColumns, this.metaData.colTypes, localRecord1.data, null, null);
          localRecord1 = localRecord1.next;
          continue;
          int k = getConnectionAttrType();
          paramRowOutputBinary.writeIntData(k);
          switch (k)
          {
          case 10027:
            paramRowOutputBinary.writeString(this.mainString);
          }
          break;
          throw new HsqlException(Trace.getMessage(146, true, new Object[] { new Integer(this.mode) }), null, 0);
        }
      }
    }
    paramRowOutputBinary.writeIntData(paramRowOutputBinary.size(), i);
  }

  void readMultiResult(RowInputBinary paramRowInputBinary)
    throws HsqlException, IOException
  {
    this.mode = 0;
    this.databaseID = paramRowInputBinary.readIntData();
    this.sessionID = paramRowInputBinary.readIntData();
    int i = paramRowInputBinary.readIntData();
    for (int j = 0; j < i; j++)
    {
      paramRowInputBinary.readIntData();
      add(new Object[] { new Result(paramRowInputBinary) });
    }
  }

  private void writeMulti(RowOutputBinary paramRowOutputBinary)
    throws IOException, HsqlException
  {
    int i = paramRowOutputBinary.size();
    paramRowOutputBinary.writeSize(0);
    paramRowOutputBinary.writeIntData(this.mode);
    paramRowOutputBinary.writeIntData(this.databaseID);
    paramRowOutputBinary.writeIntData(this.sessionID);
    paramRowOutputBinary.writeIntData(this.size);
    for (Record localRecord = this.rRoot; localRecord != null; localRecord = localRecord.next)
      ((Result)localRecord.data[0]).write(paramRowOutputBinary);
    paramRowOutputBinary.writeIntData(paramRowOutputBinary.size(), i);
  }

  public static void write(Result paramResult, RowOutputBinary paramRowOutputBinary, OutputStream paramOutputStream)
    throws IOException, HsqlException
  {
    paramRowOutputBinary.reset();
    paramResult.write(paramRowOutputBinary);
    paramOutputStream.write(paramRowOutputBinary.getOutputStream().getBuffer(), 0, paramRowOutputBinary.getOutputStream().size());
    paramOutputStream.flush();
  }

  public static Result read(RowInputBinary paramRowInputBinary, DataInput paramDataInput)
    throws IOException, HsqlException
  {
    int i = paramDataInput.readInt();
    paramRowInputBinary.resetRow(0, i);
    byte[] arrayOfByte = paramRowInputBinary.getBuffer();
    int j = 4;
    paramDataInput.readFully(arrayOfByte, j, i - j);
    return new Result(paramRowInputBinary);
  }

  public Result(Throwable paramThrowable, String paramString)
  {
    this.mode = 2;
    this.exception = paramThrowable;
    if ((paramThrowable instanceof HsqlException))
    {
      HsqlException localHsqlException = (HsqlException)paramThrowable;
      this.subString = localHsqlException.getSQLState();
      this.mainString = localHsqlException.getMessage();
      if (paramString != null)
        this.mainString = (this.mainString + " in statement [" + paramString + "]");
      this.statementID = localHsqlException.getErrorCode();
    }
    else if ((paramThrowable instanceof OutOfMemoryError))
    {
      System.gc();
      this.subString = "S1000";
      this.mainString = "out of memory";
      this.statementID = 72;
    }
    else
    {
      this.subString = "S1000";
      this.mainString = (Trace.getMessage(40) + " " + paramThrowable);
      if (paramString != null)
        this.mainString = (this.mainString + " in statement [" + paramString + "]");
      this.statementID = 40;
    }
    this.subSubString = "";
  }

  public Throwable getException()
  {
    return this.exception;
  }

  public int getStatementID()
  {
    return this.statementID;
  }

  void setStatementID(int paramInt)
  {
    this.statementID = paramInt;
  }

  public String getMainString()
  {
    return this.mainString;
  }

  public void setMainString(String paramString)
  {
    this.mainString = paramString;
  }

  public String getSubString()
  {
    return this.subString;
  }

  public void setMaxRows(int paramInt)
  {
    this.updateCount = paramInt;
  }

  public int getUpdateCount()
  {
    return this.updateCount;
  }

  int getConnectionAttrType()
  {
    return this.updateCount;
  }

  void setConnectionAttrType(int paramInt)
  {
    this.updateCount = paramInt;
  }

  int getEndTranType()
  {
    return this.updateCount;
  }

  void setEndTranType(int paramInt)
  {
    this.updateCount = paramInt;
  }

  public int[] getUpdateCounts()
  {
    return this.metaData.colTypes;
  }

  Object[] getParameterData()
  {
    return this.rRoot == null ? null : this.rRoot.data;
  }

  public void setParameterData(Object[] paramArrayOfObject)
  {
    if (this.rRoot == null)
      this.rRoot = new Record();
    this.rRoot.data = paramArrayOfObject;
    this.rRoot.next = null;
    this.rTail = this.rRoot;
    this.size = 1;
  }

  public void setResultType(int paramInt)
  {
    this.mode = paramInt;
  }

  public void setStatementType(int paramInt)
  {
    this.updateCount = paramInt;
  }

  public int getStatementType()
  {
    return this.updateCount;
  }

  public int getType()
  {
    return this.mode;
  }

  public boolean isData()
  {
    return this.mode == 3;
  }

  public boolean isError()
  {
    return this.mode == 2;
  }

  public boolean isUpdateCount()
  {
    return this.mode == 1;
  }

  public Iterator iterator()
  {
    return new ResultIterator(null);
  }

  private class ResultIterator
    implements Iterator
  {
    boolean removed;
    int counter;
    Record current;
    Record last;
    private final Result this$0;

    private ResultIterator()
    {
      this.this$0 = this$1;
      this.current = this.this$0.rRoot;
    }

    public boolean hasNext()
    {
      return this.counter < this.this$0.size;
    }

    public Object next()
    {
      if (hasNext())
      {
        this.removed = false;
        if (this.counter != 0)
        {
          this.last = this.current;
          this.current = this.current.next;
        }
        this.counter += 1;
        return this.current.data;
      }
      throw new NoSuchElementException();
    }

    public int nextInt()
    {
      throw new NoSuchElementException();
    }

    public long nextLong()
    {
      throw new NoSuchElementException();
    }

    public void remove()
    {
      if ((this.counter <= this.this$0.size) && (this.counter != 0) && (!this.removed))
      {
        this.removed = true;
        if (this.current == this.this$0.rTail)
          Result.access$302(this.this$0, this.last);
        if (this.current == this.this$0.rRoot)
        {
          this.current = (this.this$0.rRoot = this.this$0.rRoot.next);
        }
        else
        {
          this.current = this.last;
          this.last = null;
          this.current.next = this.current.next.next;
        }
        Result.access$210(this.this$0);
        this.counter -= 1;
        return;
      }
      throw new NoSuchElementException();
    }

    ResultIterator(Result.1 arg2)
    {
      this();
    }
  }

  public static class ResultMetaData
  {
    public String[] colLabels;
    public String[] tableNames;
    public String[] colNames;
    public boolean[] isLabelQuoted;
    public int[] colTypes;
    public int[] colSizes;
    public int[] colScales;
    public String[] catalogNames;
    public String[] schemaNames;
    public int[] colNullable;
    public boolean[] isIdentity;
    public boolean[] isWritable;
    public int[] paramMode;
    public String[] classNames;
    boolean isParameterDescription;

    ResultMetaData()
    {
    }

    ResultMetaData(int paramInt)
    {
      prepareData(paramInt);
    }

    private void prepareData(int paramInt)
    {
      this.colLabels = new String[paramInt];
      this.tableNames = new String[paramInt];
      this.colNames = new String[paramInt];
      this.isLabelQuoted = new boolean[paramInt];
      this.colTypes = new int[paramInt];
      this.colSizes = new int[paramInt];
      this.colScales = new int[paramInt];
      this.catalogNames = new String[paramInt];
      this.schemaNames = new String[paramInt];
      this.colNullable = new int[paramInt];
      this.isIdentity = new boolean[paramInt];
      this.isWritable = new boolean[paramInt];
      this.classNames = new String[paramInt];
    }

    public int[] getParameterTypes()
    {
      return this.colTypes;
    }

    boolean isTableColumn(int paramInt)
    {
      return (this.tableNames[paramInt] != null) && (this.tableNames[paramInt].length() > 0) && (this.colNames[paramInt] != null) && (this.colNames[paramInt].length() > 0);
    }

    private void decodeTableColumnAttrs(int paramInt1, int paramInt2)
    {
      this.colNullable[paramInt2] = (paramInt1 & 0xF);
      this.isIdentity[paramInt2] = ((paramInt1 & 0x10) != 0 ? 1 : false);
      this.isWritable[paramInt2] = ((paramInt1 & 0x20) != 0 ? 1 : false);
    }

    private void writeTableColumnAttrs(RowOutputBinary paramRowOutputBinary, int paramInt)
      throws IOException, HsqlException
    {
      paramRowOutputBinary.writeIntData(encodeTableColumnAttrs(paramInt));
      paramRowOutputBinary.writeString(this.catalogNames[paramInt] == null ? "" : this.catalogNames[paramInt]);
      paramRowOutputBinary.writeString(this.schemaNames[paramInt] == null ? "" : this.schemaNames[paramInt]);
    }

    private int encodeTableColumnAttrs(int paramInt)
    {
      int i = this.colNullable[paramInt];
      if (this.isIdentity[paramInt] != 0)
        i |= 16;
      if (this.isWritable[paramInt] != 0)
        i |= 32;
      return i;
    }

    private void readTableColumnAttrs(RowInputBinary paramRowInputBinary, int paramInt)
      throws IOException, HsqlException
    {
      decodeTableColumnAttrs(paramRowInputBinary.readIntData(), paramInt);
      this.catalogNames[paramInt] = paramRowInputBinary.readString();
      this.schemaNames[paramInt] = paramRowInputBinary.readString();
    }

    ResultMetaData(RowInputBinary paramRowInputBinary, int paramInt)
      throws HsqlException, IOException
    {
      int i = paramRowInputBinary.readIntData();
      prepareData(i);
      if (paramInt == 5)
      {
        this.isParameterDescription = true;
        this.paramMode = new int[i];
      }
      for (int j = 0; j < i; j++)
      {
        this.colTypes[j] = paramRowInputBinary.readType();
        this.colSizes[j] = paramRowInputBinary.readIntData();
        this.colScales[j] = paramRowInputBinary.readIntData();
        this.colLabels[j] = paramRowInputBinary.readString();
        this.tableNames[j] = paramRowInputBinary.readString();
        this.colNames[j] = paramRowInputBinary.readString();
        this.classNames[j] = paramRowInputBinary.readString();
        if (isTableColumn(j))
          readTableColumnAttrs(paramRowInputBinary, j);
        if (paramInt != 5)
          continue;
        this.paramMode[j] = paramRowInputBinary.readIntData();
      }
    }

    void write(RowOutputBinary paramRowOutputBinary, int paramInt)
      throws HsqlException, IOException
    {
      paramRowOutputBinary.writeIntData(paramInt);
      for (int i = 0; i < paramInt; i++)
      {
        paramRowOutputBinary.writeType(this.colTypes[i]);
        paramRowOutputBinary.writeIntData(this.colSizes[i]);
        paramRowOutputBinary.writeIntData(this.colScales[i]);
        paramRowOutputBinary.writeString(this.colLabels[i] == null ? "" : this.colLabels[i]);
        paramRowOutputBinary.writeString(this.tableNames[i] == null ? "" : this.tableNames[i]);
        paramRowOutputBinary.writeString(this.colNames[i] == null ? "" : this.colNames[i]);
        paramRowOutputBinary.writeString(this.classNames[i] == null ? "" : this.classNames[i]);
        if (isTableColumn(i))
          writeTableColumnAttrs(paramRowOutputBinary, i);
        if (!this.isParameterDescription)
          continue;
        paramRowOutputBinary.writeIntData(this.paramMode[i]);
      }
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Result
 * JD-Core Version:    0.6.0
 */