package org.hsqldb;

import java.io.IOException;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

abstract class Node
{
  static final int NO_POS = -1;
  int iBalance;
  Node nNext;

  static final Node newNode(Row paramRow, int paramInt, Table paramTable)
  {
    switch (paramTable.getIndexType())
    {
    case 0:
      return new MemoryNode(paramRow);
    case 2:
      return new PointerNode((CachedRow)paramRow, paramInt);
    case 1:
    }
    return new DiskNode((CachedRow)paramRow, paramInt);
  }

  static final Node newNode(Row paramRow, RowInputInterface paramRowInputInterface, int paramInt, Table paramTable)
    throws IOException, HsqlException
  {
    switch (paramTable.getIndexType())
    {
    case 0:
      return new MemoryNode(paramRow);
    case 2:
      return new PointerNode((CachedRow)paramRow, paramInt);
    case 1:
    }
    return new DiskNode((CachedRow)paramRow, paramRowInputInterface, paramInt);
  }

  abstract void delete();

  abstract int getKey();

  abstract Row getRow()
    throws HsqlException;

  abstract boolean isLeft(Node paramNode)
    throws HsqlException;

  abstract boolean isRight(Node paramNode)
    throws HsqlException;

  abstract Node getLeft()
    throws HsqlException;

  abstract void setLeft(Node paramNode)
    throws HsqlException;

  abstract Node getRight()
    throws HsqlException;

  abstract void setRight(Node paramNode)
    throws HsqlException;

  abstract Node getParent()
    throws HsqlException;

  abstract void setParent(Node paramNode)
    throws HsqlException;

  final int getBalance()
    throws HsqlException
  {
    return this.iBalance;
  }

  abstract void setBalance(int paramInt)
    throws HsqlException;

  abstract boolean isRoot();

  abstract boolean isFromLeft()
    throws HsqlException;

  abstract Object[] getData()
    throws HsqlException;

  abstract boolean equals(Node paramNode);

  Node getUpdatedNode()
    throws HsqlException
  {
    return this;
  }

  abstract void write(RowOutputInterface paramRowOutputInterface)
    throws IOException;

  boolean isDeleted()
  {
    return this.iBalance == -2;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Node
 * JD-Core Version:    0.6.0
 */