package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.store.ValuePool;

public class HSQLClientConnection
  implements SessionInterface
{
  static final int BUFFER_SIZE = 4096;
  final byte[] mainBuffer = new byte[4096];
  private boolean isClosed;
  private Socket socket;
  protected OutputStream dataOutput;
  protected DataInputStream dataInput;
  protected RowOutputBinary rowOut;
  protected RowInputBinary rowIn;
  private Result resultOut;
  private int sessionID;
  private boolean isReadOnly = false;
  private boolean isAutoCommit = true;
  String host;
  int port;
  String path;
  String database;
  boolean isTLS;
  int databaseID;

  public HSQLClientConnection(String paramString1, int paramInt, String paramString2, String paramString3, boolean paramBoolean, String paramString4, String paramString5)
    throws HsqlException
  {
    this.host = paramString1;
    this.port = paramInt;
    this.path = paramString2;
    this.database = paramString3;
    this.isTLS = paramBoolean;
    initStructures();
    Result localResult1 = new Result(65543);
    localResult1.mainString = paramString4;
    localResult1.subString = paramString5;
    localResult1.subSubString = paramString3;
    initConnection(paramString1, paramInt, paramBoolean);
    Result localResult2 = execute(localResult1);
    if (localResult2.isError())
      throw Trace.error(localResult2);
    this.sessionID = localResult2.sessionID;
    this.databaseID = localResult2.databaseID;
  }

  private void initStructures()
  {
    this.rowOut = new RowOutputBinary(this.mainBuffer);
    this.rowIn = new RowInputBinary(this.rowOut);
    this.resultOut = Result.newSessionAttributesResult();
    this.resultOut.add(new Object[7]);
  }

  protected void initConnection(String paramString, int paramInt, boolean paramBoolean)
    throws HsqlException
  {
    openConnection(paramString, paramInt, paramBoolean);
  }

  protected void openConnection(String paramString, int paramInt, boolean paramBoolean)
    throws HsqlException
  {
    try
    {
      this.socket = HsqlSocketFactory.getInstance(paramBoolean).createSocket(paramString, paramInt);
      this.dataOutput = new BufferedOutputStream(this.socket.getOutputStream());
      this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
    }
    catch (Exception localException)
    {
      throw Trace.error(80);
    }
  }

  protected void closeConnection()
  {
    try
    {
      if (this.socket != null)
        this.socket.close();
    }
    catch (Exception localException)
    {
    }
    this.socket = null;
  }

  public synchronized Result execute(Result paramResult)
    throws HsqlException
  {
    try
    {
      paramResult.sessionID = this.sessionID;
      paramResult.databaseID = this.databaseID;
      write(paramResult);
      return read();
    }
    catch (Throwable localThrowable)
    {
    }
    throw Trace.error(3, localThrowable.toString());
  }

  public void close()
  {
    if (this.isClosed)
      return;
    this.isClosed = true;
    try
    {
      this.resultOut.setResultType(65545);
      execute(this.resultOut);
    }
    catch (Exception localException1)
    {
    }
    try
    {
      closeConnection();
    }
    catch (Exception localException2)
    {
    }
  }

  private Object getAttribute(int paramInt)
    throws HsqlException
  {
    this.resultOut.setResultType(7);
    Result localResult = execute(this.resultOut);
    if (localResult.isError())
      throw Trace.error(localResult);
    return localResult.rRoot.data[paramInt];
  }

  private void setAttribute(Object paramObject, int paramInt)
    throws HsqlException
  {
    this.resultOut.setResultType(6);
    ArrayUtil.fillArray(this.resultOut.rRoot.data, null);
    this.resultOut.rRoot.data[paramInt] = paramObject;
    Result localResult = execute(this.resultOut);
    if (localResult.isError())
      throw Trace.error(localResult);
  }

  public boolean isReadOnly()
    throws HsqlException
  {
    Object localObject = getAttribute(6);
    this.isReadOnly = ((Boolean)localObject).booleanValue();
    return this.isReadOnly;
  }

  public void setReadOnly(boolean paramBoolean)
    throws HsqlException
  {
    if (paramBoolean != this.isReadOnly)
    {
      setAttribute(paramBoolean ? Boolean.TRUE : Boolean.FALSE, 6);
      this.isReadOnly = paramBoolean;
    }
  }

  public boolean isAutoCommit()
    throws HsqlException
  {
    Object localObject = getAttribute(4);
    this.isAutoCommit = ((Boolean)localObject).booleanValue();
    return this.isAutoCommit;
  }

  public void setAutoCommit(boolean paramBoolean)
    throws HsqlException
  {
    if (paramBoolean != this.isAutoCommit)
    {
      setAttribute(paramBoolean ? Boolean.TRUE : Boolean.FALSE, 4);
      this.isAutoCommit = paramBoolean;
    }
  }

  public void setIsolation(int paramInt)
    throws HsqlException
  {
    setAttribute(ValuePool.getInt(paramInt), 3);
  }

  public int getIsolation()
    throws HsqlException
  {
    Object localObject = getAttribute(3);
    return ((Integer)localObject).intValue();
  }

  public boolean isClosed()
  {
    return this.isClosed;
  }

  public Session getSession()
  {
    return null;
  }

  public void startPhasedTransaction()
    throws HsqlException
  {
  }

  public void prepareCommit()
    throws HsqlException
  {
    this.resultOut.setResultType(66541);
    this.resultOut.updateCount = 11;
    this.resultOut.setMainString("");
    execute(this.resultOut);
  }

  public void commit()
    throws HsqlException
  {
    this.resultOut.setResultType(66541);
    this.resultOut.updateCount = 0;
    this.resultOut.setMainString("");
    execute(this.resultOut);
  }

  public void rollback()
    throws HsqlException
  {
    this.resultOut.setResultType(66541);
    this.resultOut.updateCount = 1;
    this.resultOut.setMainString("");
    execute(this.resultOut);
  }

  public int getId()
  {
    return this.sessionID;
  }

  public void resetSession()
    throws HsqlException
  {
    Result localResult1 = new Result(10);
    Result localResult2 = execute(localResult1);
    if (localResult2.isError())
    {
      this.isClosed = true;
      closeConnection();
      throw Trace.error(localResult2);
    }
    this.sessionID = localResult2.sessionID;
    this.databaseID = localResult2.databaseID;
  }

  protected void write(Result paramResult)
    throws IOException, HsqlException
  {
    Result.write(paramResult, this.rowOut, this.dataOutput);
  }

  protected Result read()
    throws IOException, HsqlException
  {
    Result localResult = Result.read(this.rowIn, this.dataInput);
    this.rowOut.setBuffer(this.mainBuffer);
    this.rowIn.resetRow(this.mainBuffer.length);
    return localResult;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.HSQLClientConnection
 * JD-Core Version:    0.6.0
 */