package org.hsqldb;

import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;

class GroupedResult
{
  private Result result;
  int groupBegin;
  int groupEnd;
  private final boolean isGrouped;
  private final boolean isAggregated;
  private HashSet groups;
  private ResultGroup currGroup;

  GroupedResult(Select paramSelect, Result.ResultMetaData paramResultMetaData)
  {
    this.result = new Result(paramResultMetaData);
    this.groupBegin = paramSelect.iResultLen;
    this.groupEnd = (this.groupBegin + paramSelect.iGroupLen);
    this.isGrouped = (this.groupBegin != this.groupEnd);
    this.isAggregated = paramSelect.isAggregated;
    if (this.isGrouped)
      this.groups = new HashSet();
  }

  Object[] getRow(Object[] paramArrayOfObject)
  {
    if (this.isGrouped)
    {
      ResultGroup localResultGroup1 = new ResultGroup(paramArrayOfObject, null);
      ResultGroup localResultGroup2 = (ResultGroup)this.groups.get(localResultGroup1);
      if (localResultGroup2 != null)
        ArrayUtil.copyArray(localResultGroup2.row, paramArrayOfObject, paramArrayOfObject.length);
    }
    else if ((this.isAggregated) && (this.currGroup != null))
    {
      ArrayUtil.copyArray(this.currGroup.row, paramArrayOfObject, paramArrayOfObject.length);
    }
    return paramArrayOfObject;
  }

  void addRow(Object[] paramArrayOfObject)
  {
    if (this.isGrouped)
    {
      ResultGroup localResultGroup = new ResultGroup(paramArrayOfObject, null);
      this.currGroup = ((ResultGroup)this.groups.get(localResultGroup));
      if (this.currGroup == null)
      {
        this.currGroup = localResultGroup;
        this.groups.add(this.currGroup);
        this.result.add(paramArrayOfObject);
      }
      else
      {
        System.arraycopy(paramArrayOfObject, 0, this.currGroup.row, 0, paramArrayOfObject.length);
      }
    }
    else if (this.isAggregated)
    {
      if (this.currGroup == null)
      {
        this.currGroup = new ResultGroup(paramArrayOfObject, null);
        this.result.add(paramArrayOfObject);
      }
      else
      {
        System.arraycopy(paramArrayOfObject, 0, this.currGroup.row, 0, paramArrayOfObject.length);
      }
    }
    else
    {
      this.result.add(paramArrayOfObject);
    }
  }

  int size()
  {
    return this.result.getSize();
  }

  Iterator iterator()
  {
    return this.result.iterator();
  }

  Result getResult()
  {
    return this.result;
  }

  class ResultGroup
  {
    Object[] row;
    int hashCode;
    private final GroupedResult this$0;

    private ResultGroup(Object[] arg2)
    {
      this.this$0 = this$1;
      Object localObject;
      this.row = localObject;
      this.hashCode = 0;
      for (int i = this$1.groupBegin; i < this$1.groupEnd; i++)
      {
        if (localObject[i] == null)
          continue;
        this.hashCode += localObject[i].hashCode();
      }
    }

    public int hashCode()
    {
      return this.hashCode;
    }

    public boolean equals(Object paramObject)
    {
      if (paramObject == this)
        return true;
      if ((paramObject == null) || (!(paramObject instanceof ResultGroup)))
        return false;
      ResultGroup localResultGroup = (ResultGroup)paramObject;
      for (int i = this.this$0.groupBegin; i < this.this$0.groupEnd; i++)
        if (!equals(this.row[i], localResultGroup.row[i]))
          return false;
      return true;
    }

    private boolean equals(Object paramObject1, Object paramObject2)
    {
      return paramObject1 == null ? false : paramObject2 == null ? true : paramObject1.equals(paramObject2);
    }

    ResultGroup(Object[] param1, GroupedResult.1 arg3)
    {
      this(param1);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.GroupedResult
 * JD-Core Version:    0.6.0
 */