package org.hsqldb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

class Function
{
  private String sFunction;
  private Method mMethod;
  private String returnClassName;
  private Class[] aArgClasses;
  private int iReturnType;
  private int iArgCount;
  private int iSqlArgCount;
  private int iSqlArgStart;
  private int[] iArgType;
  private boolean[] bArgNullable;
  Expression[] eArg;
  private boolean bConnection;
  private static HashMap methodCache = new HashMap();
  private int fID;
  String name;
  boolean isSimple;
  boolean hasAggregate;

  Function(String paramString1, String paramString2, boolean paramBoolean)
    throws HsqlException
  {
    this.name = paramString1;
    this.isSimple = paramBoolean;
    this.sFunction = paramString2;
    this.fID = Library.functionID(paramString2);
    int i = paramString2.lastIndexOf('.');
    Trace.check(i != -1, 11, paramString2);
    String str = paramString2.substring(0, i);
    this.mMethod = ((Method)methodCache.get(paramString2));
    Class localClass;
    Object localObject2;
    if (this.mMethod == null)
    {
      localObject1 = paramString2.substring(i + 1);
      localClass = null;
      try
      {
        localClass = Class.forName(str);
      }
      catch (Exception localException)
      {
        throw Trace.error(42, 115, new Object[] { str, localException });
      }
      localObject2 = localClass.getMethods();
      for (i = 0; i < localObject2.length; i++)
      {
        Object localObject3 = localObject2[i];
        if ((!localObject3.getName().equals(localObject1)) || (!Modifier.isStatic(localObject3.getModifiers())))
          continue;
        this.mMethod = localObject3;
        break;
      }
      Trace.check(this.mMethod != null, 13, localObject1);
      methodCache.put(paramString2, this.mMethod);
    }
    Object localObject1 = this.mMethod.getReturnType();
    if (localObject1.equals(Result.class))
      this.iReturnType = 1111;
    else
      this.iReturnType = Types.getParameterTypeNr((Class)localObject1);
    this.returnClassName = Types.getFunctionReturnClassName(((Class)localObject1).getName());
    this.aArgClasses = this.mMethod.getParameterTypes();
    this.iArgCount = this.aArgClasses.length;
    this.iArgType = new int[this.iArgCount];
    this.bArgNullable = new boolean[this.iArgCount];
    for (i = 0; i < this.aArgClasses.length; i++)
    {
      localClass = this.aArgClasses[i];
      localObject2 = localClass.getName();
      if ((i == 0) && (localClass.equals(Connection.class)))
      {
        this.bConnection = true;
      }
      else
      {
        this.iArgType[i] = Types.getParameterTypeNr(localClass);
        this.bArgNullable[i] = (!localClass.isPrimitive() ? 1 : false);
      }
    }
    this.iSqlArgCount = this.iArgCount;
    if (this.bConnection)
    {
      this.iSqlArgCount -= 1;
      this.iSqlArgStart = 1;
    }
    else
    {
      this.iSqlArgStart = 0;
    }
    this.eArg = new Expression[this.iArgCount];
  }

  Object getValue(Session paramSession)
    throws HsqlException
  {
    switch (this.fID)
    {
    case 10:
      return paramSession.getCurrentTime();
    case 9:
      return paramSession.getCurrentDate();
    case 11:
      return paramSession.getDatabase().getPath();
    case 19:
      return paramSession.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
    case 27:
      return paramSession.getLastIdentity();
    case 30:
      return paramSession.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
    case 29:
      return paramSession.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
    case 31:
      return paramSession.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
    case 42:
      return paramSession.getCurrentTimestamp();
    case 64:
      return paramSession.getUsername();
    }
    Object[] arrayOfObject = getArguments(paramSession);
    if (arrayOfObject == null)
      return null;
    return getValue(paramSession, arrayOfObject);
  }

  Object getValue(Session paramSession, Object[] paramArrayOfObject)
    throws HsqlException
  {
    if (this.bConnection)
      paramArrayOfObject[0] = paramSession.getInternalConnection();
    try
    {
      Object localObject = this.fID >= 0 ? Library.invoke(this.fID, paramArrayOfObject) : this.mMethod.invoke(null, paramArrayOfObject);
      return Column.convertObject(localObject, this.iReturnType);
    }
    catch (InvocationTargetException localInvocationTargetException)
    {
      Throwable localThrowable = localInvocationTargetException.getTargetException();
      String str = this.sFunction + " : " + localThrowable.toString();
      throw Trace.error(198, str);
    }
    catch (IllegalAccessException localIllegalAccessException)
    {
    }
    throw Trace.error(198);
  }

  private Object[] getArguments(Session paramSession)
    throws HsqlException
  {
    int i = this.bConnection ? 1 : 0;
    Object[] arrayOfObject = new Object[this.iArgCount];
    while (i < this.iArgCount)
    {
      Expression localExpression = this.eArg[i];
      Object localObject = null;
      if (localExpression != null)
        localObject = localExpression.getValue(paramSession, this.iArgType[i]);
      if ((localObject == null) && (this.bArgNullable[i] == 0))
        return null;
      if ((localObject instanceof JavaObject))
        localObject = ((JavaObject)localObject).getObject();
      else if ((localObject instanceof Binary))
        localObject = ((Binary)localObject).getBytes();
      arrayOfObject[i] = localObject;
      i++;
    }
    return (Object)arrayOfObject;
  }

  private Object[] getNotNull(Object[] paramArrayOfObject)
    throws HsqlException
  {
    for (int i = this.bConnection ? 1 : 0; i < this.iArgCount; i++)
    {
      Object localObject = paramArrayOfObject[i];
      if ((localObject == null) && (this.bArgNullable[i] == 0))
        return null;
    }
    return paramArrayOfObject;
  }

  void collectInGroupByExpressions(HsqlArrayList paramHsqlArrayList)
  {
    for (int i = 0; i < this.iArgCount; i++)
    {
      Expression localExpression = this.eArg[i];
      if (localExpression == null)
        continue;
      localExpression.collectInGroupByExpressions(paramHsqlArrayList);
    }
  }

  Object getAggregatedValue(Session paramSession, Object paramObject)
    throws HsqlException
  {
    Object[] arrayOfObject = (Object[])paramObject;
    if (arrayOfObject == null)
      arrayOfObject = new Object[this.iArgCount];
    for (int i = 0; i < this.iArgCount; i++)
    {
      Expression localExpression = this.eArg[i];
      if (this.eArg[i] == null)
        continue;
      if (this.eArg[i].isAggregate())
        arrayOfObject[i] = Column.convertObject(localExpression.getAggregatedValue(paramSession, arrayOfObject[i]), this.iArgType[i]);
      else
        arrayOfObject[i] = localExpression.getValue(paramSession, this.iArgType[i]);
    }
    arrayOfObject = getNotNull(arrayOfObject);
    if (arrayOfObject == null)
      return null;
    return getValue(paramSession, arrayOfObject);
  }

  Object updateAggregatingValue(Session paramSession, Object paramObject)
    throws HsqlException
  {
    Object[] arrayOfObject = (Object[])paramObject;
    if (arrayOfObject == null)
      arrayOfObject = new Object[this.iArgCount];
    for (int i = 0; i < this.iArgCount; i++)
    {
      Expression localExpression = this.eArg[i];
      if (this.eArg[i] == null)
        continue;
      arrayOfObject[i] = localExpression.updateAggregatingValue(paramSession, arrayOfObject[i]);
    }
    return arrayOfObject;
  }

  int getArgCount()
  {
    return this.iSqlArgCount;
  }

  void replaceAliases(Expression[] paramArrayOfExpression, int paramInt)
    throws HsqlException
  {
    for (int i = this.iSqlArgStart; i < this.iArgCount; i++)
    {
      Expression localExpression = this.eArg[i];
      if (localExpression == null)
        continue;
      if (localExpression.exprType == 2)
        this.eArg[i] = localExpression.getExpressionForAlias(paramArrayOfExpression, paramInt);
      else
        localExpression.replaceAliases(paramArrayOfExpression, paramInt);
    }
  }

  void checkTables(HsqlArrayList paramHsqlArrayList)
    throws HsqlException
  {
    for (int i = this.iSqlArgStart; i < this.iArgCount; i++)
    {
      Expression localExpression = this.eArg[i];
      if (localExpression == null)
        continue;
      localExpression.checkTables(paramHsqlArrayList);
    }
  }

  void resolveTables(TableFilter paramTableFilter)
    throws HsqlException
  {
    for (int i = this.iSqlArgStart; i < this.iArgCount; i++)
    {
      Expression localExpression = this.eArg[i];
      if (localExpression == null)
        continue;
      localExpression.resolveTables(paramTableFilter);
    }
  }

  void resolveType(Session paramSession)
    throws HsqlException
  {
    for (int i = this.iSqlArgStart; i < this.iArgCount; i++)
    {
      Expression localExpression = this.eArg[i];
      if (localExpression == null)
        continue;
      if (localExpression.isParam())
      {
        localExpression.setDataType(this.iArgType[i]);
        localExpression.nullability = getArgNullability(i);
        localExpression.valueClassName = getArgClass(i).getName();
      }
      else
      {
        localExpression.resolveTypes(paramSession);
      }
    }
  }

  boolean checkResolved(boolean paramBoolean)
    throws HsqlException
  {
    int i = 1;
    for (int j = this.iSqlArgStart; j < this.iArgCount; j++)
    {
      if (this.eArg[j] == null)
        continue;
      i = (i != 0) && (this.eArg[j].checkResolved(paramBoolean)) ? 1 : 0;
    }
    return i;
  }

  int getArgType(int paramInt)
  {
    return this.iArgType[paramInt];
  }

  int getReturnType()
  {
    return this.iReturnType;
  }

  void setArgument(int paramInt, Expression paramExpression)
  {
    if (this.bConnection)
      paramInt++;
    this.eArg[paramInt] = paramExpression;
    this.hasAggregate = ((this.hasAggregate) || ((paramExpression != null) && (paramExpression.isAggregate())));
  }

  String getDLL()
    throws HsqlException
  {
    StringBuffer localStringBuffer = new StringBuffer();
    String str1 = this.name;
    if (this.isSimple)
      return this.name;
    if ("TRIM".equals(this.name))
    {
      localStringBuffer.append(this.name).append('(');
      boolean bool1 = this.eArg[2].testCondition(null);
      boolean bool2 = this.eArg[3].testCondition(null);
      if ((bool1) && (bool2))
        localStringBuffer.append("BOTH");
      else
        localStringBuffer.append(bool1 ? "LEADING" : "TRAILING");
      localStringBuffer.append(' ');
      String str2 = (String)this.eArg[1].getValue(null);
      localStringBuffer.append(Column.createSQLString(str2)).append(' ');
      localStringBuffer.append("FROM").append(' ');
      localStringBuffer.append(this.eArg[0].getDDL()).append(')');
      return localStringBuffer.toString();
    }
    if (this.sFunction.equals(this.name))
      str1 = StringConverter.toQuotedString(this.name, '"', true);
    localStringBuffer.append(str1).append('(');
    for (int i = this.iSqlArgStart; i < this.eArg.length; i++)
    {
      localStringBuffer.append(this.eArg[i].getDDL());
      if (i >= this.eArg.length - 1)
        continue;
      localStringBuffer.append(',');
    }
    localStringBuffer.append(')');
    return localStringBuffer.toString();
  }

  public String describe(Session paramSession)
  {
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append(super.toString()).append("=[\n");
    localStringBuffer.append(this.sFunction).append("(");
    for (int i = this.iSqlArgStart; i < this.eArg.length; i++)
      localStringBuffer.append("[").append(this.eArg[i].describe(paramSession)).append("]");
    localStringBuffer.append(") returns ").append(Types.getTypeString(getReturnType()));
    localStringBuffer.append("]\n");
    return localStringBuffer.toString();
  }

  String getReturnClassName()
  {
    return this.returnClassName;
  }

  Class getArgClass(int paramInt)
  {
    return this.aArgClasses[paramInt];
  }

  int getArgNullability(int paramInt)
  {
    return this.bArgNullable[paramInt] != 0 ? 1 : 0;
  }

  Method getMethod()
  {
    return this.mMethod;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Function
 * JD-Core Version:    0.6.0
 */