package org.hsqldb;

import java.io.IOException;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

class DiskNode extends Node
{
  protected Row rData;
  private int iLeft = -1;
  private int iRight = -1;
  private int iParent = -1;
  private int iId;
  static final int SIZE_IN_BYTE = 16;

  DiskNode(CachedRow paramCachedRow, RowInputInterface paramRowInputInterface, int paramInt)
    throws IOException, HsqlException
  {
    this.iId = paramInt;
    this.rData = paramCachedRow;
    this.iBalance = paramRowInputInterface.readIntData();
    this.iLeft = paramRowInputInterface.readIntData();
    if (this.iLeft <= 0)
      this.iLeft = -1;
    this.iRight = paramRowInputInterface.readIntData();
    if (this.iRight <= 0)
      this.iRight = -1;
    this.iParent = paramRowInputInterface.readIntData();
    if (this.iParent <= 0)
      this.iParent = -1;
  }

  DiskNode(CachedRow paramCachedRow, int paramInt)
  {
    this.iId = paramInt;
    this.rData = paramCachedRow;
  }

  void delete()
  {
    this.rData = null;
    this.iBalance = -2;
  }

  int getKey()
  {
    if (this.rData != null)
      return ((CachedRow)this.rData).iPos;
    return -1;
  }

  Row getRow()
    throws HsqlException
  {
    return this.rData;
  }

  private Node findNode(int paramInt)
    throws HsqlException
  {
    Node localNode = null;
    CachedRow localCachedRow = ((CachedRow)this.rData).getTable().getRow(paramInt);
    if (localCachedRow != null)
      localNode = localCachedRow.getNode(this.iId);
    return localNode;
  }

  boolean isLeft(Node paramNode)
    throws HsqlException
  {
    if (paramNode == null)
      return this.iLeft == -1;
    return this.iLeft == ((DiskNode)paramNode).getKey();
  }

  boolean isRight(Node paramNode)
    throws HsqlException
  {
    if (paramNode == null)
      return this.iRight == -1;
    return this.iRight == ((DiskNode)paramNode).getKey();
  }

  Node getLeft()
    throws HsqlException
  {
    if (this.iLeft == -1)
      return null;
    return findNode(this.iLeft);
  }

  Node getRight()
    throws HsqlException
  {
    if (this.iRight == -1)
      return null;
    return findNode(this.iRight);
  }

  Node getParent()
    throws HsqlException
  {
    if (this.iParent == -1)
      return null;
    return findNode(this.iParent);
  }

  boolean isRoot()
  {
    return this.iParent == -1;
  }

  boolean isFromLeft()
    throws HsqlException
  {
    if (isRoot())
      return true;
    DiskNode localDiskNode = (DiskNode)getParent();
    return getKey() == localDiskNode.iLeft;
  }

  Object[] getData()
    throws HsqlException
  {
    return this.rData.getData();
  }

  void setParent(Node paramNode)
    throws HsqlException
  {
    ((CachedRow)this.rData).setChanged();
    this.iParent = (paramNode == null ? -1 : paramNode.getKey());
  }

  void setBalance(int paramInt)
    throws HsqlException
  {
    if (this.iBalance != paramInt)
    {
      ((CachedRow)this.rData).setChanged();
      this.iBalance = paramInt;
    }
  }

  void setLeft(Node paramNode)
    throws HsqlException
  {
    ((CachedRow)this.rData).setChanged();
    this.iLeft = (paramNode == null ? -1 : paramNode.getKey());
  }

  void setRight(Node paramNode)
    throws HsqlException
  {
    ((CachedRow)this.rData).setChanged();
    this.iRight = (paramNode == null ? -1 : paramNode.getKey());
  }

  boolean equals(Node paramNode)
  {
    return (this == paramNode) || ((paramNode != null) && (getKey() == ((DiskNode)paramNode).getKey()));
  }

  void write(RowOutputInterface paramRowOutputInterface)
    throws IOException
  {
    paramRowOutputInterface.writeIntData(this.iBalance);
    paramRowOutputInterface.writeIntData(this.iLeft == -1 ? 0 : this.iLeft);
    paramRowOutputInterface.writeIntData(this.iRight == -1 ? 0 : this.iRight);
    paramRowOutputInterface.writeIntData(this.iParent == -1 ? 0 : this.iParent);
  }

  Node getUpdatedNode()
    throws HsqlException
  {
    Row localRow = this.rData.getUpdatedRow();
    return localRow == null ? null : localRow.getNode(this.iId);
  }

  void writeTranslate(RowOutputInterface paramRowOutputInterface, IntLookup paramIntLookup)
  {
    paramRowOutputInterface.writeIntData(this.iBalance);
    writeTranslatePointer(this.iLeft, paramRowOutputInterface, paramIntLookup);
    writeTranslatePointer(this.iRight, paramRowOutputInterface, paramIntLookup);
    writeTranslatePointer(this.iParent, paramRowOutputInterface, paramIntLookup);
  }

  private void writeTranslatePointer(int paramInt, RowOutputInterface paramRowOutputInterface, IntLookup paramIntLookup)
  {
    int i = 0;
    if (paramInt != -1)
      i = paramIntLookup.lookupFirstEqual(paramInt);
    paramRowOutputInterface.writeIntData(i);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DiskNode
 * JD-Core Version:    0.6.0
 */