package org.hsqldb;

import java.util.Locale;
import org.hsqldb.persist.HsqlProperties;

public class DatabaseURL
{
  static final String S_DOT = ".";
  public static final String S_MEM = "mem:";
  public static final String S_FILE = "file:";
  public static final String S_RES = "res:";
  public static final String S_ALIAS = "alias:";
  public static final String S_HSQL = "hsql://";
  public static final String S_HSQLS = "hsqls://";
  public static final String S_HTTP = "http://";
  public static final String S_HTTPS = "https://";
  public static final String S_URL_PREFIX = "jdbc:hsqldb:";

  public static boolean isFileBasedDatabaseType(String paramString)
  {
    return (paramString == "file:") || (paramString == "res:");
  }

  public static boolean isInProcessDatabaseType(String paramString)
  {
    return (paramString == "file:") || (paramString == "res:") || (paramString == "mem:");
  }

  public static HsqlProperties parseURL(String paramString, boolean paramBoolean)
  {
    String str1 = paramString.toLowerCase(Locale.ENGLISH);
    HsqlProperties localHsqlProperties1 = new HsqlProperties();
    HsqlProperties localHsqlProperties2 = null;
    String str2 = null;
    int i = 0;
    if (paramBoolean)
      if (str1.startsWith("jdbc:hsqldb:"))
        i = "jdbc:hsqldb:".length();
      else
        return localHsqlProperties1;
    String str3 = null;
    int j = 0;
    int k = 0;
    localHsqlProperties1.setProperty("url", paramString);
    int m = paramString.indexOf(';', i);
    if (m < 0)
    {
      m = paramString.length();
    }
    else
    {
      str2 = str1.substring(m + 1, str1.length());
      localHsqlProperties2 = HsqlProperties.delimitedArgPairsToProps(str2, "=", ";", null);
      localHsqlProperties1.addProperties(localHsqlProperties2);
    }
    if ((m == i + 1) && (str1.startsWith(".", i)))
    {
      str3 = ".";
    }
    else if (str1.startsWith("mem:", i))
    {
      str3 = "mem:";
    }
    else if (str1.startsWith("file:", i))
    {
      str3 = "file:";
    }
    else if (str1.startsWith("res:", i))
    {
      str3 = "res:";
    }
    else if (str1.startsWith("alias:", i))
    {
      str3 = "alias:";
    }
    else if (str1.startsWith("hsql://", i))
    {
      str3 = "hsql://";
      j = 9001;
      k = 1;
    }
    else if (str1.startsWith("hsqls://", i))
    {
      str3 = "hsqls://";
      j = 554;
      k = 1;
    }
    else if (str1.startsWith("http://", i))
    {
      str3 = "http://";
      j = 80;
      k = 1;
    }
    else if (str1.startsWith("https://", i))
    {
      str3 = "https://";
      j = 443;
      k = 1;
    }
    if (str3 == null)
      str3 = "file:";
    else if (str3 == ".")
      str3 = "mem:";
    else
      i += str3.length();
    localHsqlProperties1.setProperty("connection_type", str3);
    String str5;
    if (k != 0)
    {
      int n = paramString.indexOf('/', i);
      if ((n < i) || (n > m))
        n = m;
      int i1 = paramString.indexOf(':', i);
      if ((i1 < i) || (i1 > n))
        i1 = n;
      else
        try
        {
          j = Integer.parseInt(paramString.substring(i1 + 1, n));
        }
        catch (NumberFormatException localNumberFormatException)
        {
          return null;
        }
      String str4 = str1.substring(i, i1);
      int i2 = paramString.lastIndexOf('/', m);
      String str6;
      if (i2 < i)
      {
        str6 = "/";
        str5 = "";
      }
      else if (i2 == n)
      {
        str6 = "/";
        str5 = str1.substring(i2 + 1, m);
      }
      else
      {
        str6 = paramString.substring(n, i2);
        str5 = str1.substring(i2 + 1, m);
      }
      localHsqlProperties1.setProperty("port", j);
      localHsqlProperties1.setProperty("host", str4);
      localHsqlProperties1.setProperty("path", str6);
      if (localHsqlProperties2 != null)
      {
        String str7 = localHsqlProperties2.getProperty("filepath");
        if ((str7 != null) && (str5.length() != 0))
          str5 = str5 + ";" + str7;
      }
    }
    else
    {
      if ((str3 == "mem:") || (str3 == "res:"))
      {
        str5 = str1.substring(i, m).toLowerCase();
        if ((str3 == "res:") && (str5.indexOf('/') != 0))
          str5 = '/' + str5;
      }
      else
      {
        str5 = paramString.substring(i, m);
      }
      if (str5.length() == 0)
        return null;
    }
    localHsqlProperties1.setProperty("database", str5);
    return localHsqlProperties1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DatabaseURL
 * JD-Core Version:    0.6.0
 */