package org.hsqldb;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.Logger;

public class DatabaseScript
{
  public static Result getScript(Database paramDatabase, boolean paramBoolean)
  {
    Result localResult = Result.newSingleColumnResult("COMMAND", 12);
    localResult.metaData.tableNames[0] = "SYSTEM_SCRIPT";
    String str1;
    if (paramDatabase.collation.name != null)
    {
      str1 = StringConverter.toQuotedString(paramDatabase.collation.name, '"', true);
      addRow(localResult, "SET DATABASE COLLATION " + str1);
    }
    Iterator localIterator = paramDatabase.getGranteeManager().getRoleNames().iterator();
    while (localIterator.hasNext())
    {
      str1 = (String)localIterator.next();
      if ("DBA".equals(str1))
        continue;
      addRow(localResult, "CREATE ROLE " + str1);
    }
    HashMap localHashMap1 = paramDatabase.getAliasMap();
    HashMap localHashMap2 = Library.getAliasMap();
    localIterator = localHashMap1.keySet().iterator();
    String str4;
    while (localIterator.hasNext())
    {
      String str2 = (String)localIterator.next();
      String str3 = (String)localHashMap1.get(str2);
      str4 = (String)localHashMap2.get(str2);
      if ((str4 != null) && (str4.equals(str3)))
        continue;
      StringBuffer localStringBuffer = new StringBuffer(64);
      localStringBuffer.append("CREATE").append(' ').append("ALIAS").append(' ');
      localStringBuffer.append(str2);
      localStringBuffer.append(" FOR \"");
      localStringBuffer.append(str3);
      localStringBuffer.append('"');
      addRow(localResult, localStringBuffer.toString());
    }
    addSchemaStatements(paramDatabase, localResult, paramBoolean);
    addRightsStatements(paramDatabase, localResult);
    if (paramDatabase.logger.hasLog())
    {
      int i = paramDatabase.logger.getWriteDelay();
      int j = i < 1000 ? 1 : 0;
      if (j != 0)
      {
        if ((i != 0) && (i < 20))
          i = 20;
      }
      else
        i /= 1000;
      str4 = "SET WRITE_DELAY " + i + (j != 0 ? " MILLIS" : "");
      addRow(localResult, str4);
    }
    return localResult;
  }

  static void addSchemaStatements(Database paramDatabase, Result paramResult, boolean paramBoolean)
  {
    Iterator localIterator = paramDatabase.schemaManager.userSchemaNameIterator();
    while (localIterator.hasNext())
    {
      String str = (String)localIterator.next();
      HsqlNameManager.HsqlName localHsqlName = paramDatabase.schemaManager.toSchemaHsqlName(str);
      HashMappedList localHashMappedList = paramDatabase.schemaManager.getTables(localHsqlName.name);
      HsqlArrayList localHsqlArrayList1 = new HsqlArrayList();
      Object localObject1 = getSchemaCreateDDL(paramDatabase, localHsqlName);
      addRow(paramResult, (String)localObject1);
      localObject1 = paramDatabase.schemaManager.sequenceIterator(localHsqlName.name);
      while (((Iterator)localObject1).hasNext())
      {
        NumberSequence localNumberSequence = (NumberSequence)((Iterator)localObject1).next();
        StringBuffer localStringBuffer = new StringBuffer(128);
        localStringBuffer.append("CREATE").append(' ');
        localStringBuffer.append("SEQUENCE").append(' ');
        localStringBuffer.append(localNumberSequence.getName().statementName).append(' ');
        localStringBuffer.append("AS").append(' ');
        localStringBuffer.append(Types.getTypeString(localNumberSequence.getType())).append(' ');
        localStringBuffer.append("START").append(' ');
        localStringBuffer.append("WITH").append(' ');
        localStringBuffer.append(localNumberSequence.peek()).append(' ');
        if (localNumberSequence.getIncrement() != 1L)
        {
          localStringBuffer.append("INCREMENT").append(' ');
          localStringBuffer.append("BY").append(' ');
          localStringBuffer.append(localNumberSequence.getIncrement()).append(' ');
        }
        addRow(paramResult, localStringBuffer.toString());
      }
      int i = 0;
      int j = localHashMappedList.size();
      Object localObject2;
      Object localObject3;
      Object localObject5;
      int i1;
      Object localObject4;
      int n;
      while (i < j)
      {
        localObject2 = (Table)localHashMappedList.get(i);
        if (!((Table)localObject2).isView())
        {
          localObject3 = new StringBuffer(128);
          getTableDDL(paramDatabase, (Table)localObject2, i, localHsqlArrayList1, false, (StringBuffer)localObject3);
          addRow(paramResult, ((StringBuffer)localObject3).toString());
          for (int m = 1; m < ((Table)localObject2).getIndexCount(); m++)
          {
            localObject5 = ((Table)localObject2).getIndex(m);
            if (HsqlNameManager.HsqlName.isReservedName(((Index)localObject5).getName().name))
              continue;
            localObject3 = new StringBuffer(64);
            ((StringBuffer)localObject3).append("CREATE").append(' ');
            if (((Index)localObject5).isUnique())
              ((StringBuffer)localObject3).append("UNIQUE").append(' ');
            ((StringBuffer)localObject3).append("INDEX").append(' ');
            ((StringBuffer)localObject3).append(((Index)localObject5).getName().statementName);
            ((StringBuffer)localObject3).append(' ').append("ON").append(' ');
            ((StringBuffer)localObject3).append(((Table)localObject2).getName().statementName);
            int[] arrayOfInt = ((Index)localObject5).getColumns();
            i1 = ((Index)localObject5).getVisibleColumns();
            getColumnList((Table)localObject2, arrayOfInt, i1, (StringBuffer)localObject3);
            addRow(paramResult, ((StringBuffer)localObject3).toString());
          }
          if ((((Table)localObject2).isText()) && (((Table)localObject2).isConnected()) && (((Table)localObject2).isDataReadOnly()))
          {
            localObject3 = new StringBuffer(64);
            ((StringBuffer)localObject3).append("SET").append(' ').append("TABLE").append(' ');
            ((StringBuffer)localObject3).append(((Table)localObject2).getName().statementName);
            ((StringBuffer)localObject3).append(' ').append("READONLY").append(' ').append("TRUE");
            addRow(paramResult, ((StringBuffer)localObject3).toString());
          }
          localObject4 = getDataSource((Table)localObject2);
          if (localObject4 != null)
            addRow(paramResult, (String)localObject4);
          localObject5 = getDataSourceHeader((Table)localObject2);
          if ((!paramBoolean) && (localObject5 != null))
            addRow(paramResult, (String)localObject5);
          n = 12;
          for (i1 = 0; i1 < n; i1++)
          {
            HsqlArrayList localHsqlArrayList2 = localObject2.triggerLists[i1];
            if (localHsqlArrayList2 == null)
              continue;
            int i2 = localHsqlArrayList2.size();
            for (int i3 = 0; i3 < i2; i3++)
            {
              localObject3 = ((TriggerDef)localHsqlArrayList2.get(i3)).getDDL();
              addRow(paramResult, ((StringBuffer)localObject3).toString());
            }
          }
        }
        i++;
      }
      i = 0;
      j = localHsqlArrayList1.size();
      while (i < j)
      {
        localObject2 = (Constraint)localHsqlArrayList1.get(i);
        localObject3 = new StringBuffer(128);
        ((StringBuffer)localObject3).append("ALTER").append(' ').append("TABLE").append(' ');
        ((StringBuffer)localObject3).append(((Constraint)localObject2).getRef().getName().statementName);
        ((StringBuffer)localObject3).append(' ').append("ADD").append(' ');
        getFKStatement((Constraint)localObject2, (StringBuffer)localObject3);
        addRow(paramResult, ((StringBuffer)localObject3).toString());
        i++;
      }
      Session localSession = paramDatabase.sessionManager.getSysSession();
      j = 0;
      int k = localHashMappedList.size();
      while (j < k)
      {
        localObject3 = (Table)localHashMappedList.get(j);
        if ((paramBoolean) && (((Table)localObject3).isIndexCached()) && (!((Table)localObject3).isEmpty(localSession)))
          addRow(paramResult, getIndexRootsDDL((Table)localHashMappedList.get(j)));
        j++;
      }
      j = 0;
      k = localHashMappedList.size();
      while (j < k)
      {
        localObject3 = (Table)localHashMappedList.get(j);
        if (!((Table)localObject3).isTemp())
        {
          localObject4 = getIdentityUpdateDDL((Table)localObject3);
          addRow(paramResult, (String)localObject4);
        }
        j++;
      }
      j = 0;
      k = localHashMappedList.size();
      while (j < k)
      {
        localObject3 = (Table)localHashMappedList.get(j);
        if (((Table)localObject3).isView())
        {
          localObject4 = (View)localHashMappedList.get(j);
          localObject5 = new StringBuffer(128);
          ((StringBuffer)localObject5).append("CREATE").append(' ').append("VIEW").append(' ');
          ((StringBuffer)localObject5).append(((View)localObject4).getName().statementName).append(' ').append('(');
          n = ((View)localObject4).getColumnCount();
          for (i1 = 0; i1 < n; i1++)
          {
            ((StringBuffer)localObject5).append(((View)localObject4).getColumn(i1).columnName.statementName);
            if (i1 >= n - 1)
              continue;
            ((StringBuffer)localObject5).append(',');
          }
          ((StringBuffer)localObject5).append(')').append(' ').append("AS").append(' ');
          ((StringBuffer)localObject5).append(((View)localObject4).getStatement());
          addRow(paramResult, ((StringBuffer)localObject5).toString());
        }
        j++;
      }
    }
  }

  static String getIdentityUpdateDDL(Table paramTable)
  {
    if (paramTable.identityColumn == -1)
      return "";
    String str1 = paramTable.getName().statementName;
    String str2 = paramTable.getColumn(paramTable.identityColumn).columnName.statementName;
    long l = paramTable.identitySequence.peek();
    StringBuffer localStringBuffer = new StringBuffer(128);
    localStringBuffer.append("ALTER").append(' ').append("TABLE").append(' ').append(str1).append(' ').append("ALTER").append(' ').append("COLUMN").append(' ').append(str2).append(' ').append("RESTART").append(' ').append("WITH").append(' ').append(l);
    return localStringBuffer.toString();
  }

  static String getIndexRootsDDL(Table paramTable)
  {
    StringBuffer localStringBuffer = new StringBuffer(128);
    localStringBuffer.append("SET").append(' ').append("TABLE").append(' ');
    localStringBuffer.append(paramTable.getName().statementName);
    localStringBuffer.append(' ').append("INDEX").append('\'');
    localStringBuffer.append(paramTable.getIndexRoots());
    localStringBuffer.append('\'');
    return localStringBuffer.toString();
  }

  static String getSchemaCreateDDL(Database paramDatabase, HsqlNameManager.HsqlName paramHsqlName)
  {
    StringBuffer localStringBuffer = new StringBuffer(128);
    localStringBuffer.append("CREATE").append(' ');
    localStringBuffer.append("SCHEMA").append(' ');
    localStringBuffer.append(paramHsqlName.statementName).append(' ');
    localStringBuffer.append("AUTHORIZATION").append(' ');
    localStringBuffer.append("DBA");
    return localStringBuffer.toString();
  }

  static void getTableDDL(Database paramDatabase, Table paramTable, int paramInt, HsqlArrayList paramHsqlArrayList, boolean paramBoolean, StringBuffer paramStringBuffer)
  {
    paramStringBuffer.append("CREATE").append(' ');
    if (paramTable.isTemp)
    {
      paramStringBuffer.append("GLOBAL").append(' ');
      paramStringBuffer.append("TEMPORARY").append(' ');
    }
    if (paramTable.isText())
      paramStringBuffer.append("TEXT").append(' ');
    else if (paramTable.isCached())
      paramStringBuffer.append("CACHED").append(' ');
    else
      paramStringBuffer.append("MEMORY").append(' ');
    paramStringBuffer.append("TABLE").append(' ');
    if (paramBoolean)
      paramStringBuffer.append(paramTable.getName().schema.statementName).append('.');
    paramStringBuffer.append(paramTable.getName().statementName);
    paramStringBuffer.append('(');
    int i = paramTable.getColumnCount();
    int[] arrayOfInt1 = paramTable.getPrimaryKey();
    HsqlNameManager.HsqlName localHsqlName = null;
    Constraint localConstraint = paramTable.getPrimaryConstraint();
    if ((localConstraint != null) && (!localConstraint.getName().isReservedName()))
      localHsqlName = localConstraint.getName();
    Object localObject1;
    Object localObject2;
    for (int j = 0; j < i; j++)
    {
      Column localColumn = paramTable.getColumn(j);
      String str = localColumn.columnName.statementName;
      paramStringBuffer.append(str);
      paramStringBuffer.append(' ');
      localObject1 = Types.getTypeString(localColumn.getType());
      paramStringBuffer.append((String)localObject1);
      int n = 0;
      if (localColumn.getType() == 93)
      {
        if (localColumn.getSize() != 6)
          n = 1;
      }
      else
        n = localColumn.getSize() > 0 ? 1 : 0;
      if (n != 0)
      {
        paramStringBuffer.append('(');
        paramStringBuffer.append(localColumn.getSize());
        if (localColumn.getScale() > 0)
        {
          paramStringBuffer.append(',');
          paramStringBuffer.append(localColumn.getScale());
        }
        paramStringBuffer.append(')');
      }
      localObject2 = localColumn.getDefaultDDL();
      if (localObject2 != null)
      {
        paramStringBuffer.append(' ').append("DEFAULT").append(' ');
        paramStringBuffer.append((String)localObject2);
      }
      if (j == paramTable.getIdentityColumn())
      {
        paramStringBuffer.append(" GENERATED BY DEFAULT AS IDENTITY(START WITH ");
        paramStringBuffer.append(localColumn.identityStart);
        if (localColumn.identityIncrement != 1L)
        {
          paramStringBuffer.append(",").append("INCREMENT").append(' ').append("BY").append(' ');
          paramStringBuffer.append(localColumn.identityIncrement);
        }
        paramStringBuffer.append(")");
      }
      if (!localColumn.isNullable())
        paramStringBuffer.append(' ').append("NOT").append(' ').append("NULL");
      if ((arrayOfInt1.length == 1) && (j == arrayOfInt1[0]) && (localHsqlName == null))
        paramStringBuffer.append(' ').append("PRIMARY").append(' ').append("KEY");
      if (j >= i - 1)
        continue;
      paramStringBuffer.append(',');
    }
    if ((arrayOfInt1.length > 1) || ((arrayOfInt1.length == 1) && (localHsqlName != null)))
    {
      paramStringBuffer.append(',');
      if (localHsqlName != null)
      {
        paramStringBuffer.append("CONSTRAINT").append(' ');
        paramStringBuffer.append(localHsqlName.statementName).append(' ');
      }
      paramStringBuffer.append("PRIMARY").append(' ').append("KEY");
      getColumnList(paramTable, arrayOfInt1, arrayOfInt1.length, paramStringBuffer);
    }
    Constraint[] arrayOfConstraint = paramTable.getConstraints();
    int k = 0;
    int m = arrayOfConstraint.length;
    while (k < m)
    {
      localObject1 = arrayOfConstraint[k];
      switch (((Constraint)localObject1).getType())
      {
      case 2:
        paramStringBuffer.append(',').append("CONSTRAINT").append(' ');
        paramStringBuffer.append(((Constraint)localObject1).getName().statementName);
        paramStringBuffer.append(' ').append("UNIQUE");
        int[] arrayOfInt2 = ((Constraint)localObject1).getMainColumns();
        getColumnList(((Constraint)localObject1).getMain(), arrayOfInt2, arrayOfInt2.length, paramStringBuffer);
        break;
      case 0:
        localObject2 = ((Constraint)localObject1).getMain();
        int i1 = paramDatabase.schemaManager.getTableIndex((Table)localObject2);
        if (i1 > paramInt)
        {
          paramHsqlArrayList.add(localObject1);
        }
        else
        {
          paramStringBuffer.append(',');
          getFKStatement((Constraint)localObject1, paramStringBuffer);
        }
        break;
      case 3:
        try
        {
          paramStringBuffer.append(',').append("CONSTRAINT").append(' ');
          paramStringBuffer.append(((Constraint)localObject1).getName().statementName);
          paramStringBuffer.append(' ').append("CHECK").append('(');
          paramStringBuffer.append(((Constraint)localObject1).core.check.getDDL());
          paramStringBuffer.append(')');
        }
        catch (HsqlException localHsqlException)
        {
        }
      case 1:
      }
      k++;
    }
    paramStringBuffer.append(')');
    if (paramTable.onCommitPreserve)
    {
      paramStringBuffer.append(' ').append("ON").append(' ');
      paramStringBuffer.append("COMMIT").append(' ').append("PRESERVE");
      paramStringBuffer.append(' ').append("ROWS");
    }
  }

  static String getDataSource(Table paramTable)
  {
    String str = paramTable.getDataSource();
    if (str == null)
      return null;
    boolean bool = paramTable.isDescDataSource();
    StringBuffer localStringBuffer = new StringBuffer(128);
    localStringBuffer.append("SET").append(' ').append("TABLE").append(' ');
    localStringBuffer.append(paramTable.getName().statementName);
    localStringBuffer.append(' ').append("SOURCE").append(' ').append('"');
    localStringBuffer.append(str);
    localStringBuffer.append('"');
    if (bool)
      localStringBuffer.append(' ').append("DESC");
    return localStringBuffer.toString();
  }

  static String getDataSourceHeader(Table paramTable)
  {
    String str = paramTable.getHeader();
    if (str == null)
      return null;
    StringBuffer localStringBuffer = new StringBuffer(128);
    localStringBuffer.append("SET").append(' ').append("TABLE").append(' ');
    localStringBuffer.append(paramTable.getName().statementName);
    localStringBuffer.append(' ').append("SOURCE").append(' ');
    localStringBuffer.append("HEADER").append(' ');
    localStringBuffer.append(str);
    return localStringBuffer.toString();
  }

  private static void getColumnList(Table paramTable, int[] paramArrayOfInt, int paramInt, StringBuffer paramStringBuffer)
  {
    paramStringBuffer.append('(');
    for (int i = 0; i < paramInt; i++)
    {
      paramStringBuffer.append(paramTable.getColumn(paramArrayOfInt[i]).columnName.statementName);
      if (i >= paramInt - 1)
        continue;
      paramStringBuffer.append(',');
    }
    paramStringBuffer.append(')');
  }

  private static void getFKStatement(Constraint paramConstraint, StringBuffer paramStringBuffer)
  {
    paramStringBuffer.append("CONSTRAINT").append(' ');
    paramStringBuffer.append(paramConstraint.getName().statementName);
    paramStringBuffer.append(' ').append("FOREIGN").append(' ').append("KEY");
    int[] arrayOfInt = paramConstraint.getRefColumns();
    getColumnList(paramConstraint.getRef(), arrayOfInt, arrayOfInt.length, paramStringBuffer);
    paramStringBuffer.append(' ').append("REFERENCES").append(' ');
    paramStringBuffer.append(paramConstraint.getMain().getName().statementName);
    arrayOfInt = paramConstraint.getMainColumns();
    getColumnList(paramConstraint.getMain(), arrayOfInt, arrayOfInt.length, paramStringBuffer);
    if (paramConstraint.getDeleteAction() != 3)
    {
      paramStringBuffer.append(' ').append("ON").append(' ').append("DELETE").append(' ');
      paramStringBuffer.append(getFKAction(paramConstraint.getDeleteAction()));
    }
    if (paramConstraint.getUpdateAction() != 3)
    {
      paramStringBuffer.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
      paramStringBuffer.append(getFKAction(paramConstraint.getUpdateAction()));
    }
  }

  private static String getFKAction(int paramInt)
  {
    switch (paramInt)
    {
    case 0:
      return "CASCADE";
    case 4:
      return "SET DEFAULT";
    case 2:
      return "SET NULL";
    case 1:
    case 3:
    }
    return "NO ACTION";
  }

  private static void addRow(Result paramResult, String paramString)
  {
    if ((paramString == null) || (paramString.length() == 0))
      return;
    String[] arrayOfString = new String[1];
    arrayOfString[0] = paramString;
    paramResult.add(arrayOfString);
  }

  private static void addRightsStatements(Database paramDatabase, Result paramResult)
  {
    HashMappedList localHashMappedList = paramDatabase.getUserManager().getUsers();
    Iterator localIterator1 = localHashMappedList.values().iterator();
    GranteeManager localGranteeManager = paramDatabase.getGranteeManager();
    Iterator localIterator2 = localGranteeManager.getGrantees().iterator();
    Object localObject1;
    String str1;
    while (localIterator1.hasNext())
    {
      localObject1 = (User)localIterator1.next();
      str1 = ((User)localObject1).getName();
      if (str1.equals("PUBLIC"))
        continue;
      addRow(paramResult, ((User)localObject1).getCreateUserDDL());
    }
    while (localIterator2.hasNext())
    {
      localObject1 = (Grantee)localIterator2.next();
      str1 = ((Grantee)localObject1).getName();
      if ((str1.equals("_SYSTEM")) || (str1.equals("DBA")))
        continue;
      String str2 = ((Grantee)localObject1).allRolesString();
      if (str2 != null)
        addRow(paramResult, "GRANT " + str2 + " TO " + str1);
      IntValueHashMap localIntValueHashMap = ((Grantee)localObject1).getRights();
      if (localIntValueHashMap == null)
        continue;
      Iterator localIterator3 = localIntValueHashMap.keySet().iterator();
      while (localIterator3.hasNext())
      {
        Object localObject2 = localIterator3.next();
        int i = localIntValueHashMap.get(localObject2, 0);
        StringBuffer localStringBuffer = new StringBuffer(64);
        localStringBuffer.append("GRANT").append(' ');
        localStringBuffer.append(GranteeManager.getRightsList(i));
        localStringBuffer.append(' ').append("ON").append(' ');
        if ((localObject2 instanceof String))
        {
          if ((localObject2.equals("java.lang.Math")) || (localObject2.equals("org.hsqldb.Library")))
            continue;
          localStringBuffer.append("CLASS \"");
          localStringBuffer.append((String)localObject2);
          localStringBuffer.append('"');
        }
        else
        {
          HsqlNameManager.HsqlName localHsqlName = (HsqlNameManager.HsqlName)localObject2;
          Table localTable = paramDatabase.schemaManager.findUserTable(null, localHsqlName.name, localHsqlName.schema.name);
          if (localTable == null)
            continue;
          localStringBuffer.append(localHsqlName.schema.statementName).append('.').append(localHsqlName.statementName);
        }
        localStringBuffer.append(' ').append("TO").append(' ');
        localStringBuffer.append(((Grantee)localObject1).getName());
        addRow(paramResult, localStringBuffer.toString());
      }
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DatabaseScript
 * JD-Core Version:    0.6.0
 */