package org.hsqldb;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;

final class DIProcedureInfo
{
  static final String conClsName = "java.sql.Connection";
  static final int procedureResultUnknown = 0;
  static final int procedureNoResult = 1;
  static final int procedureReturnsResult = 2;
  static final int procedureColumnUnknown = 0;
  static final int procedureColumnIn = 1;
  static final int procedureColumnInOut = 2;
  static final int procedureColumnResult = 3;
  static final int procedureColumnOut = 4;
  static final int procedureColumnReturn = 5;
  static final int procedureNoNulls = 0;
  static final int procedureNullable = 1;
  static final int procedureNullableUnknown = 2;
  private Class clazz;
  private Class[] colClasses;
  private int[] colTypes;
  private int colOffset;
  private int colCount;
  private boolean colsResolved;
  private String fqn;
  private String specificName;
  private int hnd_remarks;
  private Method method;
  private String sig;
  private DINameSpace nameSpace;
  private final HashMap typeMap = new HashMap();

  public DIProcedureInfo(DINameSpace paramDINameSpace)
    throws HsqlException
  {
    setNameSpace(paramDINameSpace);
  }

  private int colOffset()
  {
    if (!this.colsResolved)
      resolveCols();
    return this.colOffset;
  }

  HsqlArrayList getAliases()
  {
    return (HsqlArrayList)this.nameSpace.getInverseAliasMap().get(getFQN());
  }

  Class getColClass(int paramInt)
  {
    return this.colClasses[(paramInt + colOffset())];
  }

  int getColCount()
  {
    if (!this.colsResolved)
      resolveCols();
    return this.colCount;
  }

  Integer getColDataType(int paramInt)
  {
    return ValuePool.getInt(getColTypeCode(paramInt));
  }

  Integer getColLen(int paramInt)
  {
    int j = getColTypeCode(paramInt);
    int i;
    switch (j)
    {
    case -4:
    case -3:
    case -2:
      i = 2147483647;
      break;
    case -5:
    case 6:
    case 8:
    case 91:
    case 92:
      i = 8;
      break;
    case 93:
      i = 12;
      break;
    case 4:
    case 7:
      i = 4;
      break;
    case 5:
      i = 2;
      break;
    case -6:
    case 16:
      i = 1;
      break;
    default:
      i = 0;
    }
    return i == 0 ? null : ValuePool.getInt(i);
  }

  String getColName(int paramInt)
  {
    return "@p" + (paramInt + colOffset());
  }

  Integer getColNullability(int paramInt)
  {
    int i = getColClass(paramInt).isPrimitive() ? 0 : 1;
    return ValuePool.getInt(i);
  }

  String getColRemark(int paramInt)
  {
    StringBuffer localStringBuffer = new StringBuffer(getSignature());
    String str = '@' + (paramInt + colOffset());
    return BundleHandler.getString(this.hnd_remarks, str);
  }

  int getColSequence(int paramInt)
  {
    return paramInt + colOffset() == 0 ? this.colCount : paramInt;
  }

  int getColTypeCode(int paramInt)
  {
    paramInt += colOffset();
    return this.colTypes[paramInt];
  }

  Integer getColUsage(int paramInt)
  {
    switch (paramInt + colOffset())
    {
    case 0:
      return ValuePool.getInt(3);
    }
    return ValuePool.getInt(1);
  }

  Class getDeclaringClass()
  {
    return this.clazz;
  }

  String getFQN()
  {
    if (this.fqn == null)
    {
      StringBuffer localStringBuffer = new StringBuffer();
      this.fqn = (this.clazz.getName() + '.' + this.method.getName());
    }
    return this.fqn;
  }

  String getSpecificName()
  {
    if (this.specificName == null)
      this.specificName = (this.clazz.getName() + "." + getSignature());
    return this.specificName;
  }

  Integer getInputParmCount()
  {
    return ValuePool.getInt(this.method.getParameterTypes().length);
  }

  Method getMethod()
  {
    return this.method;
  }

  String getOrigin(String paramString)
  {
    return (this.nameSpace.isBuiltin(this.clazz) ? "BUILTIN " : "USER DEFINED ") + paramString;
  }

  Integer getOutputParmCount()
  {
    return ValuePool.getInt(0);
  }

  String getRemark()
  {
    return BundleHandler.getString(this.hnd_remarks, getSignature());
  }

  Integer getResultSetCount()
  {
    return this.method.getReturnType() == Void.TYPE ? ValuePool.getInt(0) : ValuePool.getInt(1);
  }

  Integer getResultType(String paramString)
  {
    int i = this.method.getReturnType() == Void.TYPE ? 1 : !"ROUTINE".equals(paramString) ? 0 : 2;
    return ValuePool.getInt(i);
  }

  String getSignature()
  {
    if (this.sig == null)
      this.sig = DINameSpace.getSignature(this.method);
    return this.sig;
  }

  static String getMethodSpecificName(Method paramMethod)
  {
    return paramMethod.getDeclaringClass().getName() + '.' + DINameSpace.getSignature(paramMethod);
  }

  DINameSpace getNameSpace()
  {
    return this.nameSpace;
  }

  void setNameSpace(DINameSpace paramDINameSpace)
    throws HsqlException
  {
    this.nameSpace = paramDINameSpace;
    Class localClass;
    try
    {
      localClass = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcArray");
      this.typeMap.put(localClass, ValuePool.getInt(2003));
    }
    catch (Exception localException1)
    {
    }
    Integer localInteger = ValuePool.getInt(-5);
    this.typeMap.put(Long.TYPE, localInteger);
    this.typeMap.put(Long.class, localInteger);
    localInteger = ValuePool.getInt(16);
    this.typeMap.put(Boolean.TYPE, localInteger);
    this.typeMap.put(Boolean.class, localInteger);
    localInteger = ValuePool.getInt(2004);
    try
    {
      localClass = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcBlob");
      this.typeMap.put(localClass, localInteger);
    }
    catch (Exception localException2)
    {
    }
    localInteger = ValuePool.getInt(1);
    this.typeMap.put(Character.TYPE, localInteger);
    this.typeMap.put(Character.class, localInteger);
    this.typeMap.put(new Character[0].getClass(), localInteger);
    this.typeMap.put(new char[0].getClass(), localInteger);
    localInteger = ValuePool.getInt(2005);
    try
    {
      localClass = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcClob");
      this.typeMap.put(localClass, localInteger);
    }
    catch (Exception localException3)
    {
    }
    localInteger = ValuePool.getInt(70);
    this.typeMap.put(URL.class, localInteger);
    localInteger = ValuePool.getInt(91);
    this.typeMap.put(java.util.Date.class, localInteger);
    this.typeMap.put(java.sql.Date.class, localInteger);
    localInteger = ValuePool.getInt(3);
    try
    {
      localClass = this.nameSpace.classForName("java.math.BigDecimal");
      this.typeMap.put(localClass, localInteger);
    }
    catch (Exception localException4)
    {
    }
    try
    {
      localClass = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcDistinct");
      this.typeMap.put(localClass, ValuePool.getInt(2001));
    }
    catch (Exception localException5)
    {
    }
    localInteger = ValuePool.getInt(8);
    this.typeMap.put(Double.TYPE, localInteger);
    this.typeMap.put(Double.class, localInteger);
    localInteger = ValuePool.getInt(6);
    this.typeMap.put(Float.TYPE, localInteger);
    this.typeMap.put(Float.class, localInteger);
    localInteger = ValuePool.getInt(4);
    this.typeMap.put(Integer.TYPE, localInteger);
    this.typeMap.put(Integer.class, localInteger);
    localInteger = ValuePool.getInt(2000);
    this.typeMap.put(Object.class, localInteger);
    localInteger = ValuePool.getInt(-4);
    this.typeMap.put(new byte[0].getClass(), localInteger);
    this.typeMap.put(Binary.class, localInteger);
    localInteger = ValuePool.getInt(-1);
    this.typeMap.put(String.class, localInteger);
    localInteger = ValuePool.getInt(0);
    this.typeMap.put(Void.TYPE, localInteger);
    this.typeMap.put(Void.class, localInteger);
    localInteger = ValuePool.getInt(2006);
    try
    {
      localClass = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcRef");
      this.typeMap.put(localClass, localInteger);
    }
    catch (Exception localException6)
    {
    }
    localInteger = ValuePool.getInt(5);
    this.typeMap.put(Short.TYPE, localInteger);
    this.typeMap.put(Short.class, localInteger);
    localInteger = ValuePool.getInt(2002);
    try
    {
      localClass = this.nameSpace.classForName("org.hsqldb.jdbc.jdbcStruct");
      this.typeMap.put(localClass, localInteger);
    }
    catch (Exception localException7)
    {
    }
    localInteger = ValuePool.getInt(92);
    this.typeMap.put(Time.class, localInteger);
    localInteger = ValuePool.getInt(93);
    this.typeMap.put(Timestamp.class, localInteger);
    localInteger = ValuePool.getInt(-6);
    this.typeMap.put(Byte.TYPE, localInteger);
    this.typeMap.put(Byte.class, localInteger);
    localInteger = ValuePool.getInt(137);
    try
    {
      localClass = this.nameSpace.classForName("org.w3c.dom.Document");
      this.typeMap.put(localClass, localInteger);
      localClass = this.nameSpace.classForName("org.w3c.dom.DocumentFragment");
      this.typeMap.put(localClass, localInteger);
    }
    catch (Exception localException8)
    {
    }
  }

  private void resolveCols()
  {
    Class localClass1 = this.method.getReturnType();
    Class[] arrayOfClass = this.method.getParameterTypes();
    int i = arrayOfClass.length;
    int k = (i > 0) && (arrayOfClass[0].getName().equals("java.sql.Connection")) ? 1 : 0;
    int j = 1 + i - (k != 0 ? 1 : 0);
    this.colClasses = new Class[j];
    this.colTypes = new int[j];
    this.colClasses[0] = localClass1;
    this.colTypes[0] = typeForClass(localClass1);
    int m = k != 0 ? 1 : 0;
    for (int n = 1; m < i; n++)
    {
      Class localClass2 = arrayOfClass[m];
      this.colClasses[n] = localClass2;
      this.colTypes[n] = typeForClass(localClass2);
      m++;
    }
    this.colOffset = (localClass1 == Void.TYPE ? 1 : 0);
    this.colCount = (j - this.colOffset);
  }

  void setMethod(Method paramMethod)
  {
    this.method = paramMethod;
    this.clazz = this.method.getDeclaringClass();
    this.fqn = null;
    this.specificName = null;
    this.sig = null;
    this.colsResolved = false;
    String str = this.clazz.getName().replace('.', '_');
    this.hnd_remarks = BundleHandler.getBundleHandle(str, null);
  }

  int typeForClass(Class paramClass)
  {
    Integer localInteger = (Integer)this.typeMap.get(paramClass);
    if (localInteger != null)
      return localInteger.intValue();
    if ((paramClass.isArray()) && (!paramClass.getComponentType().isArray()))
      return 2003;
    Class localClass;
    try
    {
      localClass = Class.forName("java.sql.Array");
      if (localClass.isAssignableFrom(paramClass))
        return 2003;
    }
    catch (Exception localException1)
    {
    }
    if (Number.class.isAssignableFrom(paramClass))
      return 2;
    try
    {
      localClass = Class.forName("java.sql.Timestamp");
      if (localClass.isAssignableFrom(paramClass))
        return 93;
    }
    catch (Exception localException2)
    {
    }
    try
    {
      localClass = Class.forName("java.sql.Time");
      if (localClass.isAssignableFrom(paramClass))
        return 93;
    }
    catch (Exception localException3)
    {
    }
    try
    {
      localClass = Class.forName("java.sql.Date");
      if (localClass.isAssignableFrom(paramClass))
        return 91;
    }
    catch (Exception localException4)
    {
    }
    try
    {
      localClass = Class.forName("java.sql.Blob");
      if (localClass.isAssignableFrom(paramClass))
        return 2004;
    }
    catch (Exception localException5)
    {
    }
    try
    {
      localClass = Class.forName("java.sql.Clob");
      if (localClass.isAssignableFrom(paramClass))
        return 2005;
    }
    catch (Exception localException6)
    {
    }
    try
    {
      localClass = Class.forName("java.sql.Ref");
      if (localClass.isAssignableFrom(paramClass))
        return 2006;
    }
    catch (Exception localException7)
    {
    }
    try
    {
      localClass = Class.forName("java.sql.Struct");
      if (localClass.isAssignableFrom(paramClass))
        return 2002;
    }
    catch (Exception localException8)
    {
    }
    if (Binary.class.isAssignableFrom(paramClass))
      return -4;
    try
    {
      localClass = Class.forName("java.lang.CharSequence");
      if (localClass.isAssignableFrom(paramClass))
        return -1;
    }
    catch (Exception localException9)
    {
    }
    if (Serializable.class.isAssignableFrom(paramClass))
      return 1111;
    return 2000;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DIProcedureInfo
 * JD-Core Version:    0.6.0
 */