package org.hsqldb;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.persist.HsqlDatabaseProperties;

final class DINameSpace
{
  private Database database;
  private String catalogName;
  private static HashSet builtin = new HashSet();

  public DINameSpace(Database paramDatabase)
    throws HsqlException
  {
    try
    {
      this.database = paramDatabase;
      this.catalogName = paramDatabase.getURI();
    }
    catch (Exception localException)
    {
      Trace.throwerror(40, localException.toString());
    }
  }

  Class classForMethodFQN(String paramString)
  {
    try
    {
      return classForName(paramString.substring(0, paramString.lastIndexOf('.')));
    }
    catch (Exception localException)
    {
    }
    return null;
  }

  Class classForName(String paramString)
    throws ClassNotFoundException
  {
    try
    {
      if (this.database.classLoader == null)
        return Class.forName(paramString);
      if (paramString != null)
        return this.database.classLoader.loadClass(paramString);
      throw new ClassNotFoundException();
    }
    catch (NoClassDefFoundError localNoClassDefFoundError)
    {
    }
    throw new ClassNotFoundException(localNoClassDefFoundError.toString());
  }

  Iterator iterateCatalogNames()
    throws HsqlException
  {
    return isReportCatalogs() ? new WrapperIterator(this.catalogName) : new WrapperIterator();
  }

  String getCatalogName(Object paramObject)
  {
    return isReportCatalogs() ? this.catalogName : null;
  }

  HashMap getInverseAliasMap()
  {
    HashMap localHashMap1 = this.database.getAliasMap();
    HashMap localHashMap2 = new HashMap();
    Iterator localIterator = localHashMap1.keySet().iterator();
    while (localIterator.hasNext())
    {
      Object localObject1 = localIterator.next();
      Object localObject2 = localHashMap1.get(localObject1);
      HsqlArrayList localHsqlArrayList = (HsqlArrayList)localHashMap2.get(localObject2);
      if (localHsqlArrayList == null)
      {
        localHsqlArrayList = new HsqlArrayList();
        localHashMap2.put(localObject2, localHsqlArrayList);
      }
      localHsqlArrayList.add(localObject1);
    }
    return localHashMap2;
  }

  static String getMethodFQN(Method paramMethod)
  {
    return paramMethod.getDeclaringClass().getName() + '.' + paramMethod.getName();
  }

  static String getMethodSpecificName(Method paramMethod)
  {
    return paramMethod.getDeclaringClass().getName() + '.' + getSignature(paramMethod);
  }

  static String getSignature(Method paramMethod)
  {
    StringBuffer localStringBuffer = new StringBuffer();
    Class[] arrayOfClass = paramMethod.getParameterTypes();
    int i = arrayOfClass.length;
    int j = i - 1;
    localStringBuffer.append(paramMethod.getName()).append('(');
    for (int k = 0; k < i; k++)
    {
      localStringBuffer.append(arrayOfClass[k].getName());
      if (k >= j)
        continue;
      localStringBuffer.append(',');
    }
    localStringBuffer.append(')');
    String str = localStringBuffer.toString();
    return str;
  }

  String getSchemaName(Object paramObject)
  {
    return "PUBLIC";
  }

  void addBuiltinToSet(HashSet paramHashSet)
  {
    paramHashSet.addAll(builtin.toArray(new String[builtin.size()]));
  }

  boolean isBuiltin(Class paramClass)
  {
    return paramClass == null ? false : builtin.contains(paramClass.getName());
  }

  boolean isBuiltin(String paramString)
  {
    return paramString == null ? false : builtin.contains(paramString);
  }

  Iterator iterateRoutineMethods(String paramString, boolean paramBoolean)
    throws HsqlException
  {
    Class localClass;
    try
    {
      localClass = classForName(paramString);
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      return new WrapperIterator();
    }
    Object localObject = paramBoolean ? getInverseAliasMap() : null;
    Method[] arrayOfMethod;
    try
    {
      arrayOfMethod = localClass.getDeclaredMethods();
    }
    catch (Exception localException)
    {
      arrayOfMethod = localClass.getMethods();
    }
    HsqlArrayList localHsqlArrayList = new HsqlArrayList(arrayOfMethod.length);
    for (int j = 0; j < arrayOfMethod.length; j++)
    {
      Method localMethod = arrayOfMethod[j];
      int i = localMethod.getModifiers();
      if ((!Modifier.isPublic(i)) || (!Modifier.isStatic(i)))
        continue;
      Object[] arrayOfObject = { localMethod, null, "ROUTINE" };
      if (paramBoolean)
        arrayOfObject[1] = localObject.get(getMethodFQN(localMethod));
      localHsqlArrayList.add(arrayOfObject);
    }
    return localHsqlArrayList.iterator();
  }

  Iterator iterateAccessibleTriggerClassNames(User paramUser)
    throws HsqlException
  {
    HashSet localHashSet = new HashSet();
    Iterator localIterator1 = this.database.schemaManager.userSchemaNameIterator();
    label21: if (localIterator1.hasNext())
    {
      String str = (String)localIterator1.next();
      Iterator localIterator2 = this.database.schemaManager.tablesIterator(str);
      while (true)
      {
        if (!localIterator2.hasNext())
          break label21;
        Table localTable = (Table)localIterator2.next();
        if (!paramUser.isAccessible(localTable.getName()))
          break;
        HsqlArrayList[] arrayOfHsqlArrayList = localTable.triggerLists;
        if (arrayOfHsqlArrayList == null)
          break;
        for (int j = 0; j < arrayOfHsqlArrayList.length; j++)
        {
          HsqlArrayList localHsqlArrayList = arrayOfHsqlArrayList[j];
          if (localHsqlArrayList == null)
            continue;
          int i = localHsqlArrayList.size();
          for (int k = 0; k < i; k++)
          {
            TriggerDef localTriggerDef = (TriggerDef)localHsqlArrayList.get(k);
            if ((localTriggerDef == null) || (!localTriggerDef.valid) || (localTriggerDef.trigger == null) || (!paramUser.isAccessible(localTable.getName(), TriggerDef.indexToRight(k))))
              continue;
            localHashSet.add(localTriggerDef.trigger.getClass().getName());
          }
        }
      }
    }
    return localHashSet.iterator();
  }

  Iterator iterateAllAccessibleMethods(Session paramSession, boolean paramBoolean)
    throws HsqlException
  {
    WrapperIterator localWrapperIterator = new WrapperIterator();
    HashSet localHashSet = paramSession.getUser().getGrantedClassNames(true);
    addBuiltinToSet(localHashSet);
    Iterator localIterator1 = localHashSet.iterator();
    while (localIterator1.hasNext())
    {
      String str = (String)localIterator1.next();
      Iterator localIterator2 = iterateRoutineMethods(str, paramBoolean);
      localWrapperIterator = new WrapperIterator(localWrapperIterator, localIterator2);
    }
    return localWrapperIterator;
  }

  Session[] listVisibleSessions(Session paramSession)
  {
    return this.database.sessionManager.getVisibleSessions(paramSession);
  }

  boolean isReportCatalogs()
  {
    return this.database.getProperties().isPropertyTrue("hsqldb.catalogs");
  }

  static
  {
    builtin.add("org.hsqldb.Library");
    builtin.add("java.lang.Math");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DINameSpace
 * JD-Core Version:    0.6.0
 */