package org.hsqldb;

import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.java.JavaSystem;

final class CompiledStatementExecutor
{
  private Session session;
  private Result updateResult;
  private static Result emptyZeroResult = new Result(1);
  private static Result updateOneResult = new Result(1);

  CompiledStatementExecutor(Session paramSession)
  {
    this.session = paramSession;
    this.updateResult = new Result(1);
  }

  Result execute(CompiledStatement paramCompiledStatement, Object[] paramArrayOfObject)
  {
    Result localResult = null;
    JavaSystem.gc();
    for (int i = 0; i < paramCompiledStatement.parameters.length; i++)
      paramCompiledStatement.parameters[i].bind(paramArrayOfObject[i]);
    try
    {
      paramCompiledStatement.materializeSubQueries(this.session);
      localResult = executeImpl(paramCompiledStatement);
    }
    catch (Throwable localThrowable)
    {
      localResult = new Result(localThrowable, paramCompiledStatement.sql);
    }
    paramCompiledStatement.dematerializeSubQueries(this.session);
    if (localResult == null)
      localResult = emptyZeroResult;
    return localResult;
  }

  private Result executeImpl(CompiledStatement paramCompiledStatement)
    throws HsqlException
  {
    switch (paramCompiledStatement.type)
    {
    case 5:
      return executeSelectStatement(paramCompiledStatement);
    case 2:
      return executeInsertSelectStatement(paramCompiledStatement);
    case 1:
      return executeInsertValuesStatement(paramCompiledStatement);
    case 3:
      return executeUpdateStatement(paramCompiledStatement);
    case 4:
      return executeDeleteStatement(paramCompiledStatement);
    case 7:
      return executeCallStatement(paramCompiledStatement);
    case 9:
      return executeDDLStatement(paramCompiledStatement);
    case 6:
    case 8:
    }
    throw Trace.runtimeError(201, "CompiledStatementExecutor.executeImpl()");
  }

  private Result executeCallStatement(CompiledStatement paramCompiledStatement)
    throws HsqlException
  {
    Expression localExpression = paramCompiledStatement.expression;
    Object localObject = localExpression.getValue(this.session);
    if ((localObject instanceof Result))
      return (Result)localObject;
    if ((localObject instanceof jdbcResultSet))
      return ((jdbcResultSet)localObject).rResult;
    Result localResult = Result.newSingleColumnResult("@p0", localExpression.getDataType());
    Object[] arrayOfObject = new Object[1];
    arrayOfObject[0] = localObject;
    localResult.metaData.classNames[0] = localExpression.getValueClassName();
    localResult.add(arrayOfObject);
    return localResult;
  }

  private Result executeDeleteStatement(CompiledStatement paramCompiledStatement)
    throws HsqlException
  {
    Table localTable = paramCompiledStatement.targetTable;
    TableFilter localTableFilter = paramCompiledStatement.targetFilter;
    int i = 0;
    if (localTableFilter.findFirst(this.session))
    {
      Expression localExpression = paramCompiledStatement.condition;
      HsqlArrayList localHsqlArrayList = new HsqlArrayList();
      do
      {
        if ((localExpression != null) && (!localExpression.testCondition(this.session)))
          continue;
        localHsqlArrayList.add(localTableFilter.currentRow);
      }
      while (localTableFilter.next(this.session));
      i = localTable.delete(this.session, localHsqlArrayList);
    }
    this.updateResult.updateCount = i;
    return this.updateResult;
  }

  private Result executeInsertSelectStatement(CompiledStatement paramCompiledStatement)
    throws HsqlException
  {
    Table localTable = paramCompiledStatement.targetTable;
    Select localSelect = paramCompiledStatement.select;
    int[] arrayOfInt1 = localTable.getColumnTypes();
    Result localResult = localSelect.getResult(this.session, 2147483647);
    Record localRecord = localResult.rRoot;
    int[] arrayOfInt2 = paramCompiledStatement.columnMap;
    boolean[] arrayOfBoolean = paramCompiledStatement.checkColumns;
    int i = arrayOfInt2.length;
    int k = 0;
    this.session.beginNestedTransaction();
    int j;
    try
    {
      while (localRecord != null)
      {
        Object[] arrayOfObject = localTable.getNewRowData(this.session, arrayOfBoolean);
        for (int m = 0; m < i; m++)
        {
          int n = arrayOfInt2[m];
          if (arrayOfInt1[n] != localResult.metaData.colTypes[m])
            arrayOfObject[n] = Column.convertObject(localRecord.data[m], arrayOfInt1[n]);
          else
            arrayOfObject[n] = localRecord.data[m];
        }
        localRecord.data = arrayOfObject;
        localRecord = localRecord.next;
      }
      j = localTable.insert(this.session, localResult);
      k = 1;
    }
    finally
    {
      this.session.endNestedTransaction(k == 0);
    }
    this.updateResult.updateCount = j;
    return this.updateResult;
  }

  private Result executeInsertValuesStatement(CompiledStatement paramCompiledStatement)
    throws HsqlException
  {
    Table localTable = paramCompiledStatement.targetTable;
    Object[] arrayOfObject = localTable.getNewRowData(this.session, paramCompiledStatement.checkColumns);
    int[] arrayOfInt1 = paramCompiledStatement.columnMap;
    Expression[] arrayOfExpression = paramCompiledStatement.columnValues;
    int[] arrayOfInt2 = localTable.getColumnTypes();
    int j = arrayOfExpression.length;
    for (int k = 0; k < j; k++)
    {
      Expression localExpression = arrayOfExpression[k];
      int i = arrayOfInt1[k];
      arrayOfObject[i] = localExpression.getValue(this.session, arrayOfInt2[i]);
    }
    localTable.insert(this.session, arrayOfObject);
    return updateOneResult;
  }

  private Result executeSelectStatement(CompiledStatement paramCompiledStatement)
    throws HsqlException
  {
    Select localSelect = paramCompiledStatement.select;
    Result localResult;
    if (localSelect.sIntoTable != null)
    {
      this.session.checkDDLWrite();
      int i = this.session.database.schemaManager.findUserTable(this.session, localSelect.sIntoTable.name, localSelect.sIntoTable.schema.name) != null ? 1 : 0;
      if (i != 0)
        throw Trace.error(21, localSelect.sIntoTable.name);
      localResult = localSelect.getResult(this.session, 2147483647);
      localResult = this.session.dbCommandInterpreter.processSelectInto(localResult, localSelect.sIntoTable, localSelect.intoType);
      this.session.getDatabase().setMetaDirty(false);
    }
    else
    {
      localResult = localSelect.getResult(this.session, this.session.getMaxRows());
    }
    return localResult;
  }

  private Result executeUpdateStatement(CompiledStatement paramCompiledStatement)
    throws HsqlException
  {
    Table localTable = paramCompiledStatement.targetTable;
    TableFilter localTableFilter = paramCompiledStatement.targetFilter;
    int i = 0;
    if (localTableFilter.findFirst(this.session))
    {
      int[] arrayOfInt1 = paramCompiledStatement.columnMap;
      Expression[] arrayOfExpression = paramCompiledStatement.columnValues;
      Expression localExpression = paramCompiledStatement.condition;
      int j = arrayOfExpression.length;
      HashMappedList localHashMappedList = new HashMappedList();
      int k = localTable.getColumnCount();
      int[] arrayOfInt2 = localTable.getColumnTypes();
      int m = 0;
      do
      {
        if ((localExpression != null) && (!localExpression.testCondition(this.session)))
          continue;
        try
        {
          Row localRow = localTableFilter.currentRow;
          Object[] arrayOfObject = localTable.getEmptyRowData();
          System.arraycopy(localRow.getData(), 0, arrayOfObject, 0, k);
          for (int n = 0; n < j; n++)
          {
            int i1 = arrayOfInt1[n];
            arrayOfObject[i1] = arrayOfExpression[n].getValue(this.session, arrayOfInt2[i1]);
          }
          localHashMappedList.add(localRow, arrayOfObject);
        }
        catch (HsqlInternalException localHsqlInternalException)
        {
        }
      }
      while (localTableFilter.next(this.session));
      this.session.beginNestedTransaction();
      try
      {
        i = localTable.update(this.session, localHashMappedList, arrayOfInt1);
        m = 1;
      }
      finally
      {
        this.session.endNestedTransaction(m == 0);
      }
    }
    this.updateResult.updateCount = i;
    return this.updateResult;
  }

  private Result executeDDLStatement(CompiledStatement paramCompiledStatement)
    throws HsqlException
  {
    return this.session.sqlExecuteDirectNoPreChecks(paramCompiledStatement.sql);
  }

  static
  {
    updateOneResult.updateCount = 1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.CompiledStatementExecutor
 * JD-Core Version:    0.6.0
 */