package org.hsqldb;

final class CompiledStatement
{
  static final String PCOL_PREFIX = "@p";
  static final String RETURN_COLUMN_NAME = "@p0";
  static final int UNKNOWN = 0;
  static final int INSERT_VALUES = 1;
  static final int INSERT_SELECT = 2;
  static final int UPDATE = 3;
  static final int DELETE = 4;
  static final int SELECT = 5;
  static final int SELECT_INTO = 6;
  static final int CALL = 7;
  static final int DML = 7;
  static final int DQL = 8;
  static final int DDL = 9;
  int id;
  boolean isValid = true;
  Table targetTable;
  TableFilter targetFilter;
  Expression condition;
  int[] columnMap;
  Expression[] columnValues;
  boolean[] checkColumns;
  Expression expression;
  Select select;
  Expression[] parameters;
  int[] paramTypes;
  SubQuery[] subqueries;
  int type;
  String sql;
  final HsqlNameManager.HsqlName schemaHsqlName;
  private static final Result updateCountResult = new Result(1);

  CompiledStatement(HsqlNameManager.HsqlName paramHsqlName)
  {
    this.parameters = new Expression[0];
    this.paramTypes = new int[0];
    this.subqueries = new SubQuery[0];
    this.type = 9;
    this.schemaHsqlName = paramHsqlName;
  }

  CompiledStatement(Session paramSession, Database paramDatabase, HsqlNameManager.HsqlName paramHsqlName, TableFilter paramTableFilter, Expression paramExpression, SubQuery[] paramArrayOfSubQuery, Expression[] paramArrayOfExpression)
    throws HsqlException
  {
    this.schemaHsqlName = paramHsqlName;
    this.targetFilter = paramTableFilter;
    this.targetTable = paramTableFilter.filterTable;
    if (paramExpression != null)
    {
      this.condition = new Expression(paramExpression);
      this.condition.resolveTables(paramTableFilter);
      this.condition.resolveTypes(paramSession);
      paramTableFilter.setConditions(paramSession, this.condition);
    }
    setParameters(paramArrayOfExpression);
    setSubqueries(paramArrayOfSubQuery);
    this.type = 4;
  }

  CompiledStatement(Session paramSession, Database paramDatabase, HsqlNameManager.HsqlName paramHsqlName, TableFilter paramTableFilter, int[] paramArrayOfInt, Expression[] paramArrayOfExpression1, Expression paramExpression, SubQuery[] paramArrayOfSubQuery, Expression[] paramArrayOfExpression2)
    throws HsqlException
  {
    this.schemaHsqlName = paramHsqlName;
    this.targetFilter = paramTableFilter;
    this.targetTable = paramTableFilter.filterTable;
    this.columnMap = paramArrayOfInt;
    this.columnValues = paramArrayOfExpression1;
    for (int i = 0; i < paramArrayOfExpression1.length; i++)
    {
      Expression localExpression = paramArrayOfExpression1[i];
      if (localExpression.isParam())
      {
        localExpression.setTableColumnAttributes(this.targetTable, paramArrayOfInt[i]);
      }
      else
      {
        localExpression.resolveTables(paramTableFilter);
        localExpression.resolveTypes(paramSession);
      }
    }
    if (paramExpression != null)
    {
      this.condition = new Expression(paramExpression);
      this.condition.resolveTables(paramTableFilter);
      this.condition.resolveTypes(paramSession);
      paramTableFilter.setConditions(paramSession, this.condition);
    }
    setParameters(paramArrayOfExpression2);
    setSubqueries(paramArrayOfSubQuery);
    this.type = 3;
  }

  CompiledStatement(HsqlNameManager.HsqlName paramHsqlName, Table paramTable, int[] paramArrayOfInt, Expression[] paramArrayOfExpression1, boolean[] paramArrayOfBoolean, SubQuery[] paramArrayOfSubQuery, Expression[] paramArrayOfExpression2)
    throws HsqlException
  {
    this.schemaHsqlName = paramHsqlName;
    this.targetTable = paramTable;
    this.columnMap = paramArrayOfInt;
    this.checkColumns = paramArrayOfBoolean;
    this.columnValues = paramArrayOfExpression1;
    for (int i = 0; i < paramArrayOfExpression1.length; i++)
    {
      Expression localExpression = paramArrayOfExpression1[i];
      if (!localExpression.isParam())
        continue;
      localExpression.setTableColumnAttributes(paramTable, paramArrayOfInt[i]);
    }
    setParameters(paramArrayOfExpression2);
    setSubqueries(paramArrayOfSubQuery);
    this.type = 1;
  }

  CompiledStatement(Session paramSession, Database paramDatabase, HsqlNameManager.HsqlName paramHsqlName, Table paramTable, int[] paramArrayOfInt, boolean[] paramArrayOfBoolean, Select paramSelect, SubQuery[] paramArrayOfSubQuery, Expression[] paramArrayOfExpression)
    throws HsqlException
  {
    this.schemaHsqlName = paramHsqlName;
    this.targetTable = paramTable;
    this.columnMap = paramArrayOfInt;
    this.checkColumns = paramArrayOfBoolean;
    this.select = paramSelect;
    resolveInsertParameterTypes();
    paramSelect.prepareResult(paramSession);
    setParameters(paramArrayOfExpression);
    setSubqueries(paramArrayOfSubQuery);
    this.type = 2;
  }

  CompiledStatement(Session paramSession, Database paramDatabase, HsqlNameManager.HsqlName paramHsqlName, Select paramSelect, SubQuery[] paramArrayOfSubQuery, Expression[] paramArrayOfExpression)
    throws HsqlException
  {
    this.schemaHsqlName = paramHsqlName;
    this.select = paramSelect;
    for (int i = 0; i < paramSelect.iResultLen; i++)
    {
      Expression localExpression = paramSelect.exprColumns[i];
      if (localExpression.getDataType() != 0)
        continue;
      localExpression.setDataType(12);
    }
    paramSelect.prepareResult(paramSession);
    setParameters(paramArrayOfExpression);
    setSubqueries(paramArrayOfSubQuery);
    this.type = 5;
  }

  CompiledStatement(Session paramSession, Database paramDatabase, HsqlNameManager.HsqlName paramHsqlName, Expression paramExpression, SubQuery[] paramArrayOfSubQuery, Expression[] paramArrayOfExpression)
    throws HsqlException
  {
    this.schemaHsqlName = paramHsqlName;
    this.expression = paramExpression;
    paramExpression.resolveTypes(paramSession);
    paramExpression.paramMode = 4;
    setParameters(paramArrayOfExpression);
    setSubqueries(paramArrayOfSubQuery);
    this.type = 7;
  }

  private void resolveInsertParameterTypes()
  {
    for (int i = 0; i < this.select.iResultLen; i++)
    {
      Expression localExpression = this.select.exprColumns[i];
      if (localExpression.getDataType() != 0)
        continue;
      Column localColumn = this.targetTable.getColumn(this.columnMap[i]);
      localExpression.setDataType(localColumn.getType());
    }
  }

  private void setParameters(Expression[] paramArrayOfExpression)
  {
    this.parameters = paramArrayOfExpression;
    int[] arrayOfInt = new int[this.parameters.length];
    for (int i = 0; i < this.parameters.length; i++)
      arrayOfInt[i] = this.parameters[i].getDataType();
    this.paramTypes = arrayOfInt;
  }

  private void setSubqueries(SubQuery[] paramArrayOfSubQuery)
  {
    this.subqueries = paramArrayOfSubQuery;
  }

  void materializeSubQueries(Session paramSession)
    throws HsqlException
  {
    for (int i = 0; i < this.subqueries.length; i++)
    {
      SubQuery localSubQuery = this.subqueries[i];
      if ((localSubQuery.isMaterialised) || (!localSubQuery.isResolved))
        continue;
      localSubQuery.populateTable(paramSession);
      localSubQuery.isMaterialised = true;
    }
  }

  void dematerializeSubQueries(Session paramSession)
  {
    if (this.subqueries == null)
      return;
    for (int i = 0; i < this.subqueries.length; i++)
    {
      this.subqueries[i].table.clearAllRows(paramSession);
      this.subqueries[i].isMaterialised = false;
    }
  }

  void clearVariables()
  {
    this.isValid = false;
    this.targetTable = null;
    this.targetFilter = null;
    this.condition = null;
    this.columnMap = null;
    this.columnValues = null;
    this.checkColumns = null;
    this.expression = null;
    this.select = null;
    this.parameters = null;
    this.paramTypes = null;
    this.subqueries = null;
  }

  boolean canExecute(Session paramSession)
    throws HsqlException
  {
    int i;
    switch (this.type)
    {
    case 5:
    case 7:
      i = 0;
    case 2:
    case 4:
    case 1:
    case 3:
      while (i < this.select.tFilter.length)
      {
        HsqlNameManager.HsqlName localHsqlName = this.select.tFilter[i].filterTable.getName();
        paramSession.check(localHsqlName, 1);
        i++;
        continue;
        break;
        paramSession.check(this.targetTable.getName(), 2);
        break;
        paramSession.check(this.targetTable.getName(), 4);
        break;
        paramSession.check(this.targetTable.getName(), 8);
      }
    case 6:
    case 8:
    case 9:
    }
    return true;
  }

  void checkTableWriteAccess(Session paramSession, Table paramTable)
    throws HsqlException
  {
    paramSession.checkReadWrite();
    if (paramTable.isView())
      throw Trace.error(55, paramTable.getName().name);
    paramTable.checkDataReadOnly();
  }

  Result describeResult()
  {
    switch (this.type)
    {
    case 7:
      Expression localExpression = this.expression;
      Result localResult = Result.newSingleColumnResult("@p0", localExpression.getDataType());
      localResult.metaData.classNames[0] = localExpression.getValueClassName();
      return localResult;
    case 5:
      return this.select.sIntoTable == null ? this.select.describeResult() : updateCountResult;
    case 1:
    case 2:
    case 3:
    case 4:
    case 9:
      return updateCountResult;
    case 6:
    case 8:
    }
    return new Result(Trace.runtimeError(201, "CompiledStatement.describeResult()"), null);
  }

  Result describeParameters()
  {
    int i = this.parameters.length;
    int j = 0;
    Result localResult = Result.newParameterDescriptionResult(i);
    for (int m = 0; m < this.parameters.length; m++)
    {
      Expression localExpression = this.parameters[m];
      int k = m + j;
      localResult.metaData.colNames[k] = ("@p" + (m + 1));
      localResult.metaData.classNames[k] = localExpression.getValueClassName();
      localResult.metaData.colTypes[k] = localExpression.getDataType();
      localResult.metaData.colSizes[k] = localExpression.getColumnSize();
      localResult.metaData.colScales[k] = localExpression.getColumnScale();
      localResult.metaData.colNullable[k] = localExpression.nullability;
      localResult.metaData.isIdentity[k] = localExpression.isIdentity;
      localResult.metaData.paramMode[k] = localExpression.paramMode;
    }
    return localResult;
  }

  public String describe(Session paramSession)
  {
    try
    {
      return describeImpl(paramSession);
    }
    catch (Exception localException)
    {
    }
    return localException.toString();
  }

  private String describeImpl(Session paramSession)
    throws Exception
  {
    StringBuffer localStringBuffer = new StringBuffer();
    switch (this.type)
    {
    case 5:
      localStringBuffer.append(this.select.describe(paramSession));
      appendParms(localStringBuffer).append('\n');
      appendSubqueries(localStringBuffer);
      return localStringBuffer.toString();
    case 1:
      localStringBuffer.append("INSERT VALUES");
      localStringBuffer.append('[').append('\n');
      appendColumns(localStringBuffer).append('\n');
      appendTable(localStringBuffer).append('\n');
      appendParms(localStringBuffer).append('\n');
      appendSubqueries(localStringBuffer).append(']');
      return localStringBuffer.toString();
    case 2:
      localStringBuffer.append("INSERT SELECT");
      localStringBuffer.append('[').append('\n');
      appendColumns(localStringBuffer).append('\n');
      appendTable(localStringBuffer).append('\n');
      localStringBuffer.append(this.select.describe(paramSession)).append('\n');
      appendParms(localStringBuffer).append('\n');
      appendSubqueries(localStringBuffer).append(']');
      return localStringBuffer.toString();
    case 3:
      localStringBuffer.append("UPDATE");
      localStringBuffer.append('[').append('\n');
      appendColumns(localStringBuffer).append('\n');
      appendTable(localStringBuffer).append('\n');
      appendCondition(paramSession, localStringBuffer);
      localStringBuffer.append(this.targetFilter.describe(paramSession)).append('\n');
      appendParms(localStringBuffer).append('\n');
      appendSubqueries(localStringBuffer).append(']');
      return localStringBuffer.toString();
    case 4:
      localStringBuffer.append("DELETE");
      localStringBuffer.append('[').append('\n');
      appendTable(localStringBuffer).append('\n');
      appendCondition(paramSession, localStringBuffer);
      localStringBuffer.append(this.targetFilter.describe(paramSession)).append('\n');
      appendParms(localStringBuffer).append('\n');
      appendSubqueries(localStringBuffer).append(']');
      return localStringBuffer.toString();
    case 7:
      localStringBuffer.append("CALL");
      localStringBuffer.append('[');
      localStringBuffer.append(this.expression.describe(paramSession)).append('\n');
      appendParms(localStringBuffer).append('\n');
      appendSubqueries(localStringBuffer).append(']');
      return localStringBuffer.toString();
    case 6:
    }
    return "UNKNOWN";
  }

  private StringBuffer appendSubqueries(StringBuffer paramStringBuffer)
  {
    paramStringBuffer.append("SUBQUERIES[");
    for (int i = 0; i < this.subqueries.length; i++)
    {
      paramStringBuffer.append("\n[level=").append(this.subqueries[i].level).append('\n').append("hasParams=").append(this.subqueries[i].hasParams).append('\n');
      if (this.subqueries[i].select != null)
        paramStringBuffer.append("org.hsqldb.Select@").append(Integer.toHexString(this.subqueries[i].select.hashCode()));
      paramStringBuffer.append("]");
    }
    paramStringBuffer.append(']');
    return paramStringBuffer;
  }

  private StringBuffer appendTable(StringBuffer paramStringBuffer)
  {
    paramStringBuffer.append("TABLE[").append(this.targetTable.getName().name).append(']');
    return paramStringBuffer;
  }

  private StringBuffer appendColumns(StringBuffer paramStringBuffer)
  {
    paramStringBuffer.append("COLUMNS=[");
    for (int i = 0; i < this.columnMap.length; i++)
      paramStringBuffer.append('\n').append(this.columnMap[i]).append(':').append(' ').append(this.targetTable.getColumn(this.columnMap[i]).columnName.name).append('[').append(this.columnValues[i]).append(']');
    paramStringBuffer.append(']');
    return paramStringBuffer;
  }

  private StringBuffer appendParms(StringBuffer paramStringBuffer)
  {
    paramStringBuffer.append("PARAMETERS=[");
    for (int i = 0; i < this.parameters.length; i++)
      paramStringBuffer.append('\n').append('@').append(i).append('[').append(this.parameters[i]).append(']');
    paramStringBuffer.append(']');
    return paramStringBuffer;
  }

  private StringBuffer appendCondition(Session paramSession, StringBuffer paramStringBuffer)
  {
    return this.condition == null ? paramStringBuffer.append("CONDITION[]\n") : paramStringBuffer.append("CONDITION[").append(this.condition.describe(paramSession)).append("]\n");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.CompiledStatement
 * JD-Core Version:    0.6.0
 */