package org.hsqldb;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class Column
{
  public HsqlNameManager.HsqlName columnName;
  private int colType;
  private int colSize;
  private int colScale;
  private boolean isNullable;
  private boolean isIdentity;
  private boolean isPrimaryKey;
  private Expression defaultExpression;
  long identityStart;
  long identityIncrement;
  static final BigInteger MAX_LONG = BigInteger.valueOf(9223372036854775807L);
  static final BigInteger MIN_LONG = BigInteger.valueOf(-9223372036854775808L);
  static final BigInteger MAX_INT = BigInteger.valueOf(2147483647L);
  static final BigInteger MIN_INT = BigInteger.valueOf(-2147483648L);
  static final BigDecimal BIG_DECIMAL_0 = new BigDecimal(0.0D);
  static final BigDecimal BIG_DECIMAL_1 = new BigDecimal(1.0D);
  static int[] tenPower = { 1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000 };

  Column(HsqlNameManager.HsqlName paramHsqlName, boolean paramBoolean1, int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean2, Expression paramExpression)
    throws HsqlException
  {
    this.columnName = paramHsqlName;
    this.isNullable = paramBoolean1;
    this.colType = paramInt1;
    this.colSize = paramInt2;
    this.colScale = paramInt3;
    this.isPrimaryKey = paramBoolean2;
    this.defaultExpression = paramExpression;
  }

  void setIdentity(boolean paramBoolean, long paramLong1, long paramLong2)
    throws HsqlException
  {
    this.isIdentity = paramBoolean;
    this.identityStart = paramLong1;
    this.identityIncrement = paramLong2;
    if ((this.isIdentity) && (this.colType == 4) && ((this.identityStart > 2147483647L) || (this.identityIncrement > 2147483647L)))
      throw Trace.error(65, this.columnName.statementName);
  }

  private Column()
  {
  }

  Column duplicate(boolean paramBoolean)
    throws HsqlException
  {
    Column localColumn = new Column();
    localColumn.columnName = this.columnName;
    localColumn.isNullable = this.isNullable;
    localColumn.colType = this.colType;
    localColumn.colSize = this.colSize;
    localColumn.colScale = this.colScale;
    localColumn.defaultExpression = this.defaultExpression;
    if (paramBoolean)
      localColumn.setIdentity(this.isIdentity, this.identityStart, this.identityIncrement);
    return localColumn;
  }

  void setType(Column paramColumn)
  {
    this.isNullable = paramColumn.isNullable;
    this.colType = paramColumn.colType;
    this.colSize = paramColumn.colSize;
    this.colScale = paramColumn.colScale;
  }

  boolean isIdentity()
  {
    return this.isIdentity;
  }

  boolean isNullable()
  {
    return this.isNullable;
  }

  void setNullable(boolean paramBoolean)
  {
    this.isNullable = paramBoolean;
  }

  public boolean isPrimaryKey()
  {
    return this.isPrimaryKey;
  }

  void setPrimaryKey(boolean paramBoolean)
  {
    this.isPrimaryKey = paramBoolean;
  }

  Object getDefaultValue(Session paramSession)
    throws HsqlException
  {
    return this.defaultExpression == null ? null : this.defaultExpression.getValue(paramSession, this.colType);
  }

  String getDefaultDDL()
  {
    String str = null;
    try
    {
      str = this.defaultExpression == null ? null : this.defaultExpression.getDDL();
    }
    catch (HsqlException localHsqlException)
    {
    }
    return str;
  }

  Expression getDefaultExpression()
  {
    return this.defaultExpression;
  }

  void setDefaultExpression(Expression paramExpression)
  {
    this.defaultExpression = paramExpression;
  }

  int getType()
  {
    return this.colType;
  }

  int getDIType()
  {
    return this.colType == 100 ? 12 : this.colType;
  }

  int getDITypeSub()
  {
    if (this.colType == 100)
      return 4;
    return 1;
  }

  int getSize()
  {
    return this.colSize;
  }

  int getScale()
  {
    return this.colScale;
  }

  static Object add(Object paramObject1, Object paramObject2, int paramInt)
    throws HsqlException
  {
    if ((paramObject1 == null) || (paramObject2 == null))
      return null;
    switch (paramInt)
    {
    case 0:
      return null;
    case 6:
    case 7:
    case 8:
      double d1 = ((Number)paramObject1).doubleValue();
      double d2 = ((Number)paramObject2).doubleValue();
      return ValuePool.getDouble(Double.doubleToLongBits(d1 + d2));
    case -1:
    case 1:
    case 12:
    case 100:
      return (String)paramObject1 + (String)paramObject2;
    case 2:
    case 3:
      BigDecimal localBigDecimal1 = (BigDecimal)paramObject1;
      BigDecimal localBigDecimal2 = (BigDecimal)paramObject2;
      return localBigDecimal1.add(localBigDecimal2);
    case -6:
    case 4:
    case 5:
      int i = ((Number)paramObject1).intValue();
      int j = ((Number)paramObject2).intValue();
      return ValuePool.getInt(i + j);
    case -5:
      long l1 = ((Number)paramObject1).longValue();
      long l2 = ((Number)paramObject2).longValue();
      return ValuePool.getLong(l1 + l2);
    }
    throw Trace.error(20, Types.getTypeString(paramInt));
  }

  static Object concat(Object paramObject1, Object paramObject2)
    throws HsqlException
  {
    if ((paramObject1 == null) || (paramObject2 == null))
      return null;
    return paramObject1.toString() + paramObject2.toString();
  }

  static Object negate(Object paramObject, int paramInt)
    throws HsqlException
  {
    if (paramObject == null)
      return null;
    switch (paramInt)
    {
    case 0:
      return null;
    case 6:
    case 7:
    case 8:
      double d = -((Number)paramObject).doubleValue();
      return ValuePool.getDouble(Double.doubleToLongBits(d));
    case 2:
    case 3:
      return ((BigDecimal)paramObject).negate();
    case -6:
    case 4:
    case 5:
      return ValuePool.getInt(-((Number)paramObject).intValue());
    case -5:
      return ValuePool.getLong(-((Number)paramObject).longValue());
    case -4:
    case -3:
    case -2:
    case -1:
    case 1:
    }
    throw Trace.error(20, Types.getTypeString(paramInt));
  }

  static Object multiply(Object paramObject1, Object paramObject2, int paramInt)
    throws HsqlException
  {
    if ((paramObject1 == null) || (paramObject2 == null))
      return null;
    if ((!(paramObject1 instanceof Number)) || (!(paramObject2 instanceof Number)))
    {
      paramObject1 = convertObject(paramObject1, paramInt);
      paramObject2 = convertObject(paramObject2, paramInt);
    }
    switch (paramInt)
    {
    case 0:
      return null;
    case 6:
    case 7:
    case 8:
      double d1 = ((Number)paramObject1).doubleValue();
      double d2 = ((Number)paramObject2).doubleValue();
      return ValuePool.getDouble(Double.doubleToLongBits(d1 * d2));
    case 2:
    case 3:
      BigDecimal localBigDecimal1 = (BigDecimal)paramObject1;
      BigDecimal localBigDecimal2 = (BigDecimal)paramObject2;
      return localBigDecimal1.multiply(localBigDecimal2);
    case -6:
    case 4:
    case 5:
      int i = ((Number)paramObject1).intValue();
      int j = ((Number)paramObject2).intValue();
      return ValuePool.getInt(i * j);
    case -5:
      long l1 = ((Number)paramObject1).longValue();
      long l2 = ((Number)paramObject2).longValue();
      return ValuePool.getLong(l1 * l2);
    case -4:
    case -3:
    case -2:
    case -1:
    case 1:
    }
    throw Trace.error(20, Types.getTypeString(paramInt));
  }

  static Object divide(Object paramObject1, Object paramObject2, int paramInt)
    throws HsqlException
  {
    if ((paramObject1 == null) || (paramObject2 == null))
      return null;
    switch (paramInt)
    {
    case 0:
      return null;
    case 6:
    case 7:
    case 8:
      double d1 = ((Number)paramObject1).doubleValue();
      double d2 = ((Number)paramObject2).doubleValue();
      return ValuePool.getDouble(Double.doubleToLongBits(d1 / d2));
    case 2:
    case 3:
      BigDecimal localBigDecimal1 = (BigDecimal)paramObject1;
      BigDecimal localBigDecimal2 = (BigDecimal)paramObject2;
      int k = localBigDecimal1.scale() > localBigDecimal2.scale() ? localBigDecimal1.scale() : localBigDecimal2.scale();
      return localBigDecimal2.signum() == 0 ? null : localBigDecimal1.divide(localBigDecimal2, k, 5);
    case -6:
    case 4:
    case 5:
      int i = ((Number)paramObject1).intValue();
      int j = ((Number)paramObject2).intValue();
      if (j == 0)
        throw Trace.error(6);
      return ValuePool.getInt(i / j);
    case -5:
      long l1 = ((Number)paramObject1).longValue();
      long l2 = ((Number)paramObject2).longValue();
      return l2 == 0L ? null : ValuePool.getLong(l1 / l2);
    case -4:
    case -3:
    case -2:
    case -1:
    case 1:
    }
    throw Trace.error(20, Types.getTypeString(paramInt));
  }

  static Object subtract(Object paramObject1, Object paramObject2, int paramInt)
    throws HsqlException
  {
    if ((paramObject1 == null) || (paramObject2 == null))
      return null;
    switch (paramInt)
    {
    case 0:
      return null;
    case 6:
    case 7:
    case 8:
      double d1 = ((Number)paramObject1).doubleValue();
      double d2 = ((Number)paramObject2).doubleValue();
      return ValuePool.getDouble(Double.doubleToLongBits(d1 - d2));
    case 2:
    case 3:
      BigDecimal localBigDecimal1 = (BigDecimal)paramObject1;
      BigDecimal localBigDecimal2 = (BigDecimal)paramObject2;
      return localBigDecimal1.subtract(localBigDecimal2);
    case -6:
    case 4:
    case 5:
      int i = ((Number)paramObject1).intValue();
      int j = ((Number)paramObject2).intValue();
      return ValuePool.getInt(i - j);
    case -5:
      long l1 = ((Number)paramObject1).longValue();
      long l2 = ((Number)paramObject2).longValue();
      return ValuePool.getLong(l1 - l2);
    case -4:
    case -3:
    case -2:
    case -1:
    case 1:
    }
    throw Trace.error(20, Types.getTypeString(paramInt));
  }

  static int compare(Collation paramCollation, Object paramObject1, Object paramObject2, int paramInt)
  {
    int i = 0;
    if (paramObject1 == paramObject2)
      return 0;
    if (paramObject1 == null)
      return -1;
    if (paramObject2 == null)
      return 1;
    switch (paramInt)
    {
    case 0:
      return 0;
    case -1:
    case 12:
      return paramCollation.compare((String)paramObject1, (String)paramObject2);
    case 1:
      return paramCollation.compare(Library.rtrim((String)paramObject1), Library.rtrim((String)paramObject2));
    case 100:
      return paramCollation.compareIgnoreCase((String)paramObject1, (String)paramObject2);
    case -6:
    case 4:
    case 5:
      int j = ((Number)paramObject1).intValue();
      int k = ((Number)paramObject2).intValue();
      return k > j ? -1 : j > k ? 1 : 0;
    case -5:
      long l1 = ((Number)paramObject1).longValue();
      long l2 = ((Number)paramObject2).longValue();
      return l2 > l1 ? -1 : l1 > l2 ? 1 : 0;
    case 6:
    case 7:
    case 8:
      double d1 = ((Number)paramObject1).doubleValue();
      double d2 = ((Number)paramObject2).doubleValue();
      return d2 > d1 ? -1 : d1 > d2 ? 1 : 0;
    case 2:
    case 3:
      i = ((BigDecimal)paramObject1).compareTo((BigDecimal)paramObject2);
      break;
    case 91:
      return HsqlDateTime.compare((Date)paramObject1, (Date)paramObject2);
    case 92:
      return HsqlDateTime.compare((Time)paramObject1, (Time)paramObject2);
    case 93:
      return HsqlDateTime.compare((Timestamp)paramObject1, (Timestamp)paramObject2);
    case 16:
      boolean bool1 = ((Boolean)paramObject1).booleanValue();
      boolean bool2 = ((Boolean)paramObject2).booleanValue();
      return bool2 ? -1 : bool1 == bool2 ? 0 : 1;
    case -4:
    case -3:
    case -2:
      if ((!(paramObject1 instanceof Binary)) || (!(paramObject2 instanceof Binary)))
        break;
      i = compareTo(((Binary)paramObject1).getBytes(), ((Binary)paramObject2).getBytes());
      break;
    case 1111:
      return 0;
    }
    return i < 0 ? -1 : i == 0 ? 0 : 1;
  }

  public static Object convertObject(Object paramObject, int paramInt)
    throws HsqlException
  {
    try
    {
      if (paramObject == null)
        return null;
      long l3;
      switch (paramInt)
      {
      case 0:
        return null;
      case -6:
        int i;
        if ((paramObject instanceof String))
        {
          paramObject = Library.trim((String)paramObject, " ", true, true);
          i = Integer.parseInt((String)paramObject);
          paramObject = ValuePool.getInt(i);
        }
        if ((paramObject instanceof Integer))
        {
          i = ((Number)paramObject).intValue();
          if ((127 < i) || (i < -128))
            throw Trace.error(65);
          return paramObject;
        }
        if ((paramObject instanceof Long))
        {
          long l1 = ((Number)paramObject).longValue();
          if ((127L < l1) || (l1 < -128L))
            throw Trace.error(65);
          return ValuePool.getInt(((Number)paramObject).intValue());
        }
        if ((paramObject instanceof Byte))
          return ValuePool.getInt(((Number)paramObject).intValue());
        if ((paramObject instanceof Number))
          return convertObject(convertToInt(paramObject), paramInt);
        if (!(paramObject instanceof Boolean))
          break;
        return ((Boolean)paramObject).booleanValue() ? ValuePool.getInt(1) : ValuePool.getInt(0);
      case 5:
        int j;
        if ((paramObject instanceof String))
        {
          paramObject = Library.trim((String)paramObject, " ", true, true);
          j = Integer.parseInt((String)paramObject);
          paramObject = ValuePool.getInt(j);
        }
        if ((paramObject instanceof Integer))
        {
          j = ((Number)paramObject).intValue();
          if ((32767 < j) || (j < -32768))
            throw Trace.error(65);
          return paramObject;
        }
        if ((paramObject instanceof Long))
        {
          long l2 = ((Number)paramObject).longValue();
          if ((32767L < l2) || (l2 < -32768L))
            throw Trace.error(65);
          return ValuePool.getInt(((Number)paramObject).intValue());
        }
        if (((paramObject instanceof Byte)) || ((paramObject instanceof Short)))
          return ValuePool.getInt(((Number)paramObject).intValue());
        if ((paramObject instanceof Number))
          return convertObject(convertToInt(paramObject), paramInt);
        if (!(paramObject instanceof Boolean))
          break;
        return ((Boolean)paramObject).booleanValue() ? ValuePool.getInt(1) : ValuePool.getInt(0);
      case 4:
        if ((paramObject instanceof Integer))
          return paramObject;
        if ((paramObject instanceof String))
        {
          paramObject = Library.trim((String)paramObject, " ", true, true);
          int k = Integer.parseInt((String)paramObject);
          return ValuePool.getInt(k);
        }
        if ((paramObject instanceof Long))
        {
          l3 = ((Number)paramObject).longValue();
          if ((2147483647L < l3) || (l3 < -2147483648L))
            throw Trace.error(65);
          return ValuePool.getInt(((Number)paramObject).intValue());
        }
        if (((paramObject instanceof Byte)) || ((paramObject instanceof Short)))
          return ValuePool.getInt(((Number)paramObject).intValue());
        if ((paramObject instanceof Number))
          return convertToInt(paramObject);
        if (!(paramObject instanceof Boolean))
          break;
        return ((Boolean)paramObject).booleanValue() ? ValuePool.getInt(1) : ValuePool.getInt(0);
      case -5:
        if ((paramObject instanceof Long))
          return paramObject;
        if ((paramObject instanceof String))
        {
          paramObject = Library.trim((String)paramObject, " ", true, true);
          l3 = Long.parseLong((String)paramObject);
          return ValuePool.getLong(l3);
        }
        if ((paramObject instanceof Integer))
          return ValuePool.getLong(((Integer)paramObject).longValue());
        if (((paramObject instanceof Byte)) || ((paramObject instanceof Short)))
          return ValuePool.getLong(((Number)paramObject).intValue());
        if ((paramObject instanceof Number))
          return convertToLong(paramObject);
        if (!(paramObject instanceof Boolean))
          break;
        return ((Boolean)paramObject).booleanValue() ? ValuePool.getLong(1L) : ValuePool.getLong(0L);
      case 6:
      case 7:
      case 8:
        if ((paramObject instanceof Double))
          return paramObject;
        if ((paramObject instanceof String))
        {
          paramObject = Library.trim((String)paramObject, " ", true, true);
          double d = JavaSystem.parseDouble((String)paramObject);
          long l4 = Double.doubleToLongBits(d);
          return ValuePool.getDouble(l4);
        }
        if ((paramObject instanceof Number))
          return convertToDouble(paramObject);
        if (!(paramObject instanceof Boolean))
          break;
        return ((Boolean)paramObject).booleanValue() ? ValuePool.getDouble(1L) : ValuePool.getDouble(0L);
      case 2:
      case 3:
        if ((paramObject instanceof BigDecimal))
          return paramObject;
        if ((paramObject instanceof Long))
          return BigDecimal.valueOf(((Long)paramObject).longValue());
        if (!(paramObject instanceof Boolean))
          break;
        return ((Boolean)paramObject).booleanValue() ? BIG_DECIMAL_1 : BIG_DECIMAL_0;
      case 16:
        if ((paramObject instanceof Boolean))
          return (Boolean)paramObject;
        if ((paramObject instanceof String))
        {
          paramObject = Library.trim((String)paramObject, " ", true, true);
          return ((String)paramObject).equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
        }
        if ((paramObject instanceof Integer))
          return ((Integer)paramObject).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        if ((paramObject instanceof Long))
          return ((Long)paramObject).longValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        if ((paramObject instanceof Double))
          return ((Double)paramObject).doubleValue() == 0.0D ? Boolean.FALSE : Boolean.TRUE;
        if ((paramObject instanceof BigDecimal))
          return ((BigDecimal)paramObject).equals(BIG_DECIMAL_0) ? Boolean.FALSE : Boolean.TRUE;
        throw Trace.error(16);
      case -1:
      case 1:
      case 12:
      case 100:
        if ((paramObject instanceof String))
          return paramObject;
        if ((paramObject instanceof Time))
          return HsqlDateTime.getTimeString((Time)paramObject, null);
        if ((paramObject instanceof Timestamp))
          return HsqlDateTime.getTimestampString((Timestamp)paramObject, null);
        if ((paramObject instanceof Date))
          return HsqlDateTime.getDateString((Date)paramObject, null);
        if (!(paramObject instanceof byte[]))
          break;
        return StringConverter.byteToHex((byte[])paramObject);
      case 92:
        if ((paramObject instanceof Time))
          return HsqlDateTime.getNormalisedTime((Time)paramObject);
        if ((paramObject instanceof Timestamp))
          return HsqlDateTime.getNormalisedTime((Timestamp)paramObject);
        if ((paramObject instanceof String))
          return HsqlDateTime.timeValue((String)paramObject);
        if (!(paramObject instanceof Date))
          break;
        throw Trace.error(95, Types.getTypeString(paramInt));
      case 93:
        if ((paramObject instanceof Timestamp))
          return paramObject;
        if ((paramObject instanceof Time))
          return HsqlDateTime.getNormalisedTimestamp((Time)paramObject);
        if ((paramObject instanceof Date))
          return HsqlDateTime.getNormalisedTimestamp((Date)paramObject);
        if (!(paramObject instanceof String))
          break;
        return HsqlDateTime.timestampValue((String)paramObject);
      case 91:
        if ((paramObject instanceof Date))
          return HsqlDateTime.getNormalisedDate((Date)paramObject);
        if ((paramObject instanceof Timestamp))
          return HsqlDateTime.getNormalisedDate((Timestamp)paramObject);
        if ((paramObject instanceof String))
          return HsqlDateTime.dateValue((String)paramObject);
        if (!(paramObject instanceof Time))
          break;
        throw Trace.error(95, Types.getTypeString(paramInt));
      case -4:
      case -3:
      case -2:
        if ((paramObject instanceof Binary))
          return paramObject;
        if ((paramObject instanceof byte[]))
          return new Binary((byte[])paramObject, false);
        if ((paramObject instanceof String))
          return new Binary(StringConverter.hexToByte((String)paramObject), false);
        throw Trace.error(95, Types.getTypeString(paramInt));
      case 1111:
        if ((paramObject instanceof JavaObject))
          return paramObject;
        if ((paramObject instanceof String))
          return new JavaObject(StringConverter.hexToByte((String)paramObject));
        if ((paramObject instanceof Binary))
          return new JavaObject(((Binary)paramObject).getBytes());
        return new JavaObject((Serializable)paramObject);
      }
      if ((paramObject instanceof JavaObject))
      {
        paramObject = ((JavaObject)paramObject).getObject();
        return convertObject(paramObject, paramInt);
      }
      return convertString(paramObject.toString(), paramInt);
    }
    catch (HsqlException localHsqlException)
    {
      throw localHsqlException;
    }
    catch (Exception localException)
    {
    }
    throw Trace.error(16, localException.toString());
  }

  private static Object convertString(String paramString, int paramInt)
    throws HsqlException
  {
    switch (paramInt)
    {
    case -6:
    case 5:
      return convertObject(paramString, paramInt);
    case 4:
      int i = Integer.parseInt(paramString);
      return ValuePool.getInt(i);
    case -5:
      return ValuePool.getLong(Long.parseLong(paramString));
    case 6:
    case 7:
    case 8:
      double d = JavaSystem.parseDouble(paramString);
      long l = Double.doubleToLongBits(d);
      return ValuePool.getDouble(l);
    case -1:
    case 1:
    case 12:
    case 100:
      return paramString;
    case 91:
      return HsqlDateTime.dateValue(paramString);
    case 92:
      return HsqlDateTime.timeValue(paramString);
    case 93:
      return HsqlDateTime.timestampValue(paramString);
    case 2:
    case 3:
      paramString = Library.trim(paramString, " ", true, true);
      return new BigDecimal(paramString);
    case 16:
      return paramString.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    case -4:
    case -3:
    case -2:
    case 1111:
    }
    throw Trace.error(95, Types.getTypeString(paramInt));
  }

  static String createSQLString(Object paramObject, int paramInt)
    throws HsqlException
  {
    if (paramObject == null)
      return "NULL";
    switch (paramInt)
    {
    case 0:
      return "NULL";
    case 6:
    case 7:
    case 8:
      return createSQLString(((Number)paramObject).doubleValue());
    case 91:
    case 92:
    case 93:
      return StringConverter.toQuotedString(paramObject.toString(), '\'', false);
    case -4:
    case -3:
    case -2:
      if (!(paramObject instanceof Binary))
        throw Trace.error(95);
      return StringConverter.toQuotedString(StringConverter.byteToHex(((Binary)paramObject).getBytes()), '\'', false);
    case 1111:
      if (!(paramObject instanceof JavaObject))
        throw Trace.error(18);
      return StringConverter.toQuotedString(StringConverter.byteToHex(((JavaObject)paramObject).getBytes()), '\'', false);
    case -1:
    case 1:
    case 12:
    case 100:
      return createSQLString((String)paramObject);
    }
    return paramObject.toString();
  }

  public static String createSQLString(double paramDouble)
  {
    if (paramDouble == (-1.0D / 0.0D))
      return "-1E0/0";
    if (paramDouble == (1.0D / 0.0D))
      return "1E0/0";
    if (Double.isNaN(paramDouble))
      return "0E0/0E0";
    String str = Double.toString(paramDouble);
    if (str.indexOf('E') < 0)
      str = str.concat("E0");
    return str;
  }

  public static String createSQLString(String paramString)
  {
    if (paramString == null)
      return "NULL";
    return StringConverter.toQuotedString(paramString, '\'', true);
  }

  public static Object convertObject(Session paramSession, Object paramObject, int paramInt1, int paramInt2, int paramInt3)
    throws HsqlException
  {
    if (paramObject == null)
      return paramObject;
    if (paramInt2 == 0)
      return convertObject(paramObject, paramInt1);
    boolean bool = true;
    switch (paramInt1)
    {
    case -1:
    case 100:
      paramInt1 = 12;
    case 1:
    case 12:
      if ((paramObject instanceof String))
        bool = false;
      else
        paramObject = convertObject(paramObject, 12);
      return enforceSize(paramObject, paramInt1, paramInt2, paramInt3, bool);
    case 2:
    case 3:
      if (!(paramObject instanceof BigDecimal))
        paramObject = convertObject(paramObject, paramInt1);
      return enforceSize(paramObject, paramInt1, paramInt2, paramInt3, true);
    case 93:
      if ((paramObject instanceof Time))
      {
        long l = paramSession.currentDate.getTime() + ((Time)paramObject).getTime();
        paramObject = HsqlDateTime.getTimestamp(l);
      }
      if (!(paramObject instanceof Timestamp))
        break;
      return enforceSize(paramObject, paramInt1, paramInt2, paramInt3, false);
    }
    return convertObject(paramObject, paramInt1);
  }

  static Object enforceSize(Object paramObject, int paramInt1, int paramInt2, int paramInt3, boolean paramBoolean)
    throws HsqlException
  {
    if (paramObject == null)
      return paramObject;
    if ((paramInt2 == 0) && (paramInt1 != 93))
      return paramObject;
    switch (paramInt1)
    {
    case 1:
      return checkChar((String)paramObject, paramInt2, paramBoolean);
    case 12:
    case 100:
      return checkVarchar((String)paramObject, paramInt2, paramBoolean);
    case 2:
    case 3:
      BigDecimal localBigDecimal = (BigDecimal)paramObject;
      localBigDecimal = localBigDecimal.setScale(paramInt3, 5);
      BigInteger localBigInteger = JavaSystem.getUnscaledValue(localBigDecimal);
      int i = localBigInteger.signum() == -1 ? 1 : 0;
      if (localBigInteger.toString().length() - i > paramInt2)
        throw Trace.error(124);
      return localBigDecimal;
    case 93:
      if (paramInt2 == 6)
        return paramObject;
      Timestamp localTimestamp = (Timestamp)paramObject;
      int j = localTimestamp.getNanos();
      int k = tenPower[paramInt2];
      int m = j / k * k;
      localTimestamp.setNanos(m);
      return localTimestamp;
    }
    return paramObject;
  }

  static String checkVarchar(String paramString, int paramInt, boolean paramBoolean)
    throws HsqlException
  {
    int i = paramString.length();
    if (i > paramInt)
    {
      if (paramBoolean)
        throw Trace.error(124);
      return paramString.substring(0, paramInt);
    }
    return paramString;
  }

  static String checkChar(String paramString, int paramInt, boolean paramBoolean)
    throws HsqlException
  {
    int i = paramString.length();
    if (i == paramInt)
      return paramString;
    if (i > paramInt)
    {
      if (paramBoolean)
        throw Trace.error(124);
      return paramString.substring(0, paramInt);
    }
    char[] arrayOfChar = new char[paramInt];
    paramString.getChars(0, i, arrayOfChar, 0);
    for (int j = i; j < paramInt; j++)
      arrayOfChar[j] = ' ';
    return new String(arrayOfChar);
  }

  static Integer convertToInt(Object paramObject)
    throws HsqlException
  {
    if ((paramObject instanceof BigDecimal))
    {
      BigInteger localBigInteger = ((BigDecimal)paramObject).toBigInteger();
      if ((localBigInteger.compareTo(MAX_INT) > 0) || (localBigInteger.compareTo(MIN_INT) < 0))
        throw Trace.error(65);
      return ValuePool.getInt(localBigInteger.intValue());
    }
    if (((paramObject instanceof Double)) || ((paramObject instanceof Float)))
    {
      double d = ((Number)paramObject).doubleValue();
      if ((Double.isNaN(d)) || (d >= 2147483648.0D) || (d <= -2147483649.0D))
        throw Trace.error(65);
      return ValuePool.getInt((int)d);
    }
    throw Trace.error(95);
  }

  static Long convertToLong(Object paramObject)
    throws HsqlException
  {
    if ((paramObject instanceof BigDecimal))
    {
      BigInteger localBigInteger = ((BigDecimal)paramObject).toBigInteger();
      if ((localBigInteger.compareTo(MAX_LONG) > 0) || (localBigInteger.compareTo(MIN_LONG) < 0))
        throw Trace.error(65);
      return ValuePool.getLong(localBigInteger.longValue());
    }
    if (((paramObject instanceof Double)) || ((paramObject instanceof Float)))
    {
      double d = ((Number)paramObject).doubleValue();
      if ((Double.isNaN(d)) || (d >= 9.223372036854776E+18D) || (d <= -9.223372036854776E+18D))
        throw Trace.error(65);
      return ValuePool.getLong(()d);
    }
    throw Trace.error(95);
  }

  static Double convertToDouble(Object paramObject)
    throws HsqlException
  {
    double d;
    if ((paramObject instanceof BigDecimal))
    {
      BigDecimal localBigDecimal1 = (BigDecimal)paramObject;
      d = localBigDecimal1.doubleValue();
      int i = localBigDecimal1.signum();
      BigDecimal localBigDecimal2 = new BigDecimal(d + i);
      if (localBigDecimal2.compareTo(localBigDecimal1) != i)
        throw Trace.error(65);
    }
    else
    {
      d = ((Number)paramObject).doubleValue();
    }
    return ValuePool.getDouble(Double.doubleToLongBits(d));
  }

  static int getCombinedNumberType(int paramInt1, int paramInt2, int paramInt3)
  {
    int i = getNumTypeWidth(paramInt1);
    int j = getNumTypeWidth(paramInt2);
    if ((i == 16) || (j == 16))
      return 8;
    switch (paramInt3)
    {
    case 14:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 70:
      return i > j ? paramInt1 : paramInt2;
    }
    int k = i + j;
    if (k <= 4)
      return 4;
    if (k <= 8)
      return -5;
    return 2;
  }

  static int getNumTypeWidth(int paramInt)
  {
    switch (paramInt)
    {
    case -6:
      return 1;
    case 5:
      return 2;
    case 4:
      return 4;
    case -5:
      return 8;
    case 6:
    case 7:
    case 8:
      return 16;
    case 2:
    case 3:
      return 32;
    case -4:
    case -3:
    case -2:
    case -1:
    case 0:
    case 1:
    }
    return 32;
  }

  static int compareToTypeRange(Object paramObject, int paramInt)
  {
    if (!(paramObject instanceof Number))
      return 0;
    if (((paramObject instanceof Integer)) || ((paramObject instanceof Long)))
    {
      long l = ((Number)paramObject).longValue();
      int i;
      int j;
      switch (paramInt)
      {
      case -6:
        i = -128;
        j = 127;
        break;
      case 5:
        i = -32768;
        j = 32767;
        break;
      case 4:
        i = -2147483648;
        j = 2147483647;
        break;
      case -5:
      case -4:
      case -3:
      case -2:
      case -1:
      case 0:
      case 1:
      case 2:
      case 3:
      default:
        return 0;
      }
      if (j < l)
        return 1;
      if (l < i)
        return -1;
      return 0;
    }
    try
    {
      paramObject = convertToLong(paramObject);
      return compareToTypeRange(paramObject, paramInt);
    }
    catch (HsqlException localHsqlException)
    {
      if (localHsqlException.getErrorCode() == -65)
      {
        if ((paramObject instanceof BigDecimal))
          return ((BigDecimal)paramObject).signum();
        if ((paramObject instanceof Double))
          return ((Double)paramObject).doubleValue() > 0.0D ? 1 : -1;
      }
    }
    return 0;
  }

  public static byte[] hexToByteArray(String paramString)
    throws HsqlException
  {
    try
    {
      return StringConverter.hexToByte(paramString);
    }
    catch (IOException localIOException)
    {
    }
    throw Trace.error(81);
  }

  static int compareTo(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
  {
    int i = paramArrayOfByte1.length;
    int j = paramArrayOfByte2.length;
    for (int k = 0; ; k++)
    {
      int m = 0;
      int n = 0;
      if (k < i)
        m = paramArrayOfByte1[k] & 0xFF;
      else if (k >= j)
        return 0;
      if (k < j)
        n = paramArrayOfByte2[k] & 0xFF;
      if (m > n)
        return 1;
      if (n > m)
        return -1;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Column
 * JD-Core Version:    0.6.0
 */